/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.ontology.utils;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SmallMap
extends AbstractMap
implements Serializable {
    private Object[] mappings = null;
    private int numMappings = 0;

    public SmallMap() {
    }

    public SmallMap(int size) {
        this.mappings = new Object[size * 2];
    }

    public SmallMap(Map m) {
        this(m.size());
        for (Map.Entry me : m.entrySet()) {
            this.put(me.getKey(), me.getValue());
        }
    }

    @Override
    public Object get(Object key) {
        int keyHash = key.hashCode();
        for (int i = 0; i < this.numMappings * 2; i += 2) {
            if (keyHash != this.mappings[i].hashCode() || !key.equals(this.mappings[i])) continue;
            return this.mappings[i + 1];
        }
        return null;
    }

    @Override
    public Object put(Object key, Object value) {
        int keyHash = key.hashCode();
        for (int i = 0; i < this.numMappings * 2; i += 2) {
            if (keyHash != this.mappings[i].hashCode() || !key.equals(this.mappings[i])) continue;
            Object oldValue = this.mappings[i + 1];
            this.mappings[i + 1] = value;
            return oldValue;
        }
        int newPos = this.numMappings * 2;
        int oldLength = 0;
        if (this.mappings != null) {
            oldLength = this.mappings.length;
        }
        if (newPos + 1 >= oldLength) {
            Object[] newMappings = new Object[oldLength + 6];
            if (oldLength > 0) {
                System.arraycopy(this.mappings, 0, newMappings, 0, this.mappings.length);
            }
            this.mappings = newMappings;
        }
        this.mappings[newPos] = key;
        this.mappings[newPos + 1] = value;
        ++this.numMappings;
        return null;
    }

    @Override
    public Set keySet() {
        return new KeySet();
    }

    @Override
    public Set entrySet() {
        return new EntrySet();
    }

    @Override
    public int size() {
        return this.numMappings;
    }

    @Override
    public boolean containsKey(Object key) {
        int keyHash = key.hashCode();
        for (int i = 0; i < this.numMappings * 2; i += 2) {
            if (keyHash != this.mappings[i].hashCode() || !key.equals(this.mappings[i])) continue;
            return true;
        }
        return false;
    }

    private void removeMapping(int num) {
        if (num < this.numMappings) {
            System.arraycopy(this.mappings, num * 2, this.mappings, (num - 1) * 2, (this.numMappings - num) * 2);
        }
        this.mappings[this.numMappings * 2 - 1] = null;
        this.mappings[this.numMappings * 2 - 2] = null;
        --this.numMappings;
    }

    private class MapEntry
    implements Map.Entry {
        private int offset;

        private MapEntry(int offset) {
            this.offset = offset;
        }

        public Object getKey() {
            return SmallMap.this.mappings[this.offset];
        }

        public Object getValue() {
            return SmallMap.this.mappings[this.offset + 1];
        }

        public Object setValue(Object v) {
            Object oldValue = SmallMap.this.mappings[this.offset + 1];
            ((SmallMap)SmallMap.this).mappings[this.offset + 1] = v;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry mo = (Map.Entry)o;
            return (this.getKey() == null ? mo.getKey() == null : this.getKey().equals(mo.getKey())) && (this.getValue() == null ? mo.getValue() == null : this.getValue().equals(mo.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }

    private class EntryIterator
    implements Iterator {
        int pos = 0;

        private EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < SmallMap.this.numMappings;
        }

        public Object next() {
            if (this.pos >= SmallMap.this.numMappings) {
                throw new NoSuchElementException();
            }
            int offset = this.pos * 2;
            ++this.pos;
            return new MapEntry(offset);
        }

        @Override
        public void remove() {
            SmallMap.this.removeMapping(this.pos);
            --this.pos;
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return SmallMap.this.numMappings;
        }
    }

    private class KeyIterator
    implements Iterator {
        int pos = 0;

        private KeyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < SmallMap.this.numMappings;
        }

        public Object next() {
            if (this.pos >= SmallMap.this.numMappings) {
                throw new NoSuchElementException();
            }
            int offset = this.pos * 2;
            ++this.pos;
            return SmallMap.this.mappings[offset];
        }

        @Override
        public void remove() {
            SmallMap.this.removeMapping(this.pos);
            --this.pos;
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return SmallMap.this.numMappings;
        }
    }
}

