/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.graphics.ColorOrGradient;
import java.util.ArrayList;
import java.util.HashSet;

public class GraphicColors {
    private final ArrayList<ColorInformation> m_colorInformationList = new ArrayList();

    public void addColorInformation(HashSet<Long> ids, ColorOrGradient colorDefinition) {
        ColorInformation colorInformation = new ColorInformation(ids, colorDefinition);
        this.m_colorInformationList.add(colorInformation);
    }

    public void clear() {
        this.m_colorInformationList.clear();
    }

    public ColorOrGradient getColorDefinition(Long id) {
        int nb = this.m_colorInformationList.size();
        for (int i = 0; i < nb; ++i) {
            ColorOrGradient c = this.m_colorInformationList.get(i).getColorDefinition(id);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    private class ColorInformation {
        private HashSet<Long> m_ids;
        private ColorOrGradient m_colorDefinition;

        public ColorInformation(HashSet<Long> ids, ColorOrGradient colorDefinition) {
            this.m_ids = ids;
        }

        public ColorOrGradient getColorDefinition(Long id) {
            if (this.m_ids == null || this.m_ids.contains(id)) {
                return this.m_colorDefinition;
            }
            return null;
        }
    }
}

