/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics.cursor;

import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.MoveableInterface;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;

public abstract class AbstractCursor
implements MoveableInterface {
    public static final Color DEFAULT_CURSOR_COLOR = new Color(160, 82, 45);
    public static final BasicStroke LINE1_STROKE = new BasicStroke(1.0f);
    public static final BasicStroke LINE2_STROKE = new BasicStroke(2.0f);
    protected static final int INSIDE_TOLERANCE = 2;
    protected BasePlotPanel m_plotPanel;
    protected double m_value;
    protected boolean m_snapToData = false;
    protected boolean m_selected = false;
    protected ArrayList<ActionListener> m_actionListenerList = null;
    protected int m_actionEventId = 0;
    protected Double m_minValue = null;
    protected Double m_maxValue = null;
    protected boolean m_selectable = true;
    protected int m_integerDigits = -1;
    protected int m_fractionalDigits = -1;
    protected DecimalFormat m_df = null;
    protected Color m_color = DEFAULT_CURSOR_COLOR;
    protected BasicStroke m_stroke = LINE1_STROKE;

    public AbstractCursor(BasePlotPanel plotPanel) {
        this.m_plotPanel = plotPanel;
    }

    public void setColor(Color c) {
        this.m_color = c;
    }

    public Color getColor() {
        return this.m_color;
    }

    public void setStroke(BasicStroke s) {
        this.m_stroke = s;
    }

    public BasicStroke getStroke() {
        return this.m_stroke;
    }

    public double getValue() {
        return this.m_value;
    }

    public String getFormattedValue() {
        if (this.m_df != null) {
            double multForRounding = Math.pow(10.0, this.m_fractionalDigits);
            double xDisplay = (double)StrictMath.round(this.m_value * multForRounding) / multForRounding;
            return this.m_df.format(xDisplay);
        }
        return String.valueOf(this.m_value);
    }

    public int getIntegerDigits() {
        return this.m_integerDigits;
    }

    public int getFractionalDigits() {
        return this.m_fractionalDigits;
    }

    public DecimalFormat getDecimalFormat() {
        return this.m_df;
    }

    public void setFormat(int integerDigits, int fractionalDigits, DecimalFormat df) {
        this.m_integerDigits = integerDigits;
        this.m_fractionalDigits = fractionalDigits;
        this.m_df = df;
    }

    public void setMinValue(Double minValue) {
        this.m_minValue = minValue;
    }

    public void setMaxValue(Double maxValue) {
        this.m_maxValue = maxValue;
    }

    public void setSelectable(boolean s) {
        this.m_selectable = s;
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.m_actionListenerList == null) {
            this.m_actionListenerList = new ArrayList();
        }
        this.m_actionListenerList.add(actionListener);
    }

    public boolean isSnapToData() {
        return this.m_snapToData;
    }

    public boolean toggleSnapToData() {
        this.m_snapToData = !this.m_snapToData;
        return this.m_snapToData;
    }

    @Override
    public void setSelected(boolean s, boolean isCtrlOrShiftDown) {
        this.m_selected = s;
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public abstract void paint(Graphics2D var1);
}

