/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics.marker;

import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.XAxis;
import fr.proline.studio.graphics.YAxis;
import fr.proline.studio.graphics.marker.AbstractMarker;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class LineMarker
extends AbstractMarker {
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    private double m_value;
    private int m_orientation;
    private Color m_markerColor;
    private static final float[] dash1 = new float[]{2.0f};
    private static final BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);

    public LineMarker(BasePlotPanel plotPanel, double value, int orientation) {
        this(plotPanel, value, orientation, Color.black, true);
    }

    public LineMarker(BasePlotPanel plotPanel, double value, int orientation, Color markerColor, boolean visible) {
        super(plotPanel);
        this.m_value = value;
        this.m_orientation = orientation;
        this.m_markerColor = markerColor;
        this.setVisible(visible);
    }

    public LineMarker(BasePlotPanel plotPanel, double value, Color markerColor) {
        this(plotPanel, value, 1, markerColor, true);
    }

    public double getValue() {
        return this.m_value;
    }

    public void setValue(double m_value) {
        this.m_value = m_value;
    }

    @Override
    public void paint(Graphics2D g) {
        if (!this.isVisible()) {
            return;
        }
        Stroke prevStroke = g.getStroke();
        g.setStroke(dashed);
        XAxis xAxis = this.m_plotPanel.getXAxis();
        YAxis yAxis = this.m_plotPanel.getYAxis();
        if (this.m_orientation == 0) {
            int y = yAxis.valueToPixel(this.m_value);
            int x1 = xAxis.valueToPixel(xAxis.getMinValue());
            int x2 = xAxis.valueToPixel(xAxis.getMaxValue());
            g.setColor(this.m_markerColor);
            g.drawLine(x1, y, x2, y);
        } else if (this.m_orientation == 1) {
            int x = xAxis.valueToPixel(this.m_value);
            int y1 = yAxis.valueToPixel(yAxis.getMinValue());
            int y2 = yAxis.valueToPixel(yAxis.getMaxValue());
            g.setColor(this.m_markerColor);
            g.drawLine(x, y1, x, y2);
        }
        g.setStroke(prevStroke);
    }
}

