/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics.measurement;

import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.PlotBaseAbstract;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.graphics.XAxis;
import fr.proline.studio.graphics.YAxis;
import fr.proline.studio.graphics.cursor.VerticalCursor;
import fr.proline.studio.graphics.marker.LabelMarker;
import fr.proline.studio.graphics.marker.WaveformAreaMarker;
import fr.proline.studio.graphics.marker.XDeltaMarker;
import fr.proline.studio.graphics.marker.coordinates.DataCoordinates;
import fr.proline.studio.graphics.measurement.AbstractMeasurement;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class DeltaXMeasurement
extends AbstractMeasurement {
    private VerticalCursor m_verticalCursor1;
    private VerticalCursor m_verticalCursor2;
    private XDeltaMarker m_horizontalDeltaMarker;
    private LabelMarker m_resultLabelMarker;
    protected WaveformAreaMarker m_waveformAreaMarker = null;
    protected PlotBaseAbstract m_plot;
    private AlgorithmMeasurement m_algorithm;

    public DeltaXMeasurement(PlotBaseAbstract plot) {
        this.m_plot = plot;
    }

    public final void setAlgorithm(AlgorithmMeasurement algorithm) {
        this.m_algorithm = algorithm;
    }

    @Override
    public void applyMeasurement(int x, int y) {
        BasePlotPanel basePlotPanel = this.m_plot.getBasePlotPanel();
        XAxis xAxis = basePlotPanel.getXAxis();
        double minX = xAxis.getMinValue();
        double maxX = xAxis.getMaxValue();
        double xCenter = xAxis.pixelToValue(x);
        double x1 = xCenter - (maxX - minX) / 10.0;
        double x2 = xCenter + (maxX - minX) / 10.0;
        if (x1 < minX) {
            x2 += minX - x1;
            x1 = minX;
        }
        if (x2 > maxX) {
            x1 -= x2 - maxX;
            x2 = maxX;
        }
        YAxis yAxis = basePlotPanel.getYAxis();
        final double minY = yAxis.getMinValue();
        final double maxY = yAxis.getMaxValue();
        String res = this.m_algorithm.calculate(this.m_plot, x1, x2);
        this.m_verticalCursor1 = new VerticalCursor(basePlotPanel, x1);
        this.m_verticalCursor2 = new VerticalCursor(basePlotPanel, x2);
        this.m_horizontalDeltaMarker = new XDeltaMarker(basePlotPanel, x1, x2, (maxY - minY) / 2.0);
        if (this.m_plot instanceof PlotLinear) {
            this.m_waveformAreaMarker = new WaveformAreaMarker(basePlotPanel, (PlotLinear)this.m_plot, new Color(196, 196, 196, 128), x1, x2);
        }
        this.m_resultLabelMarker = new LabelMarker(basePlotPanel, new DataCoordinates((x1 + x2) / 2.0, (maxY - minY) / 2.0), res, 2, 3);
        this.m_plot.addCursor(this.m_verticalCursor1);
        this.m_plot.addCursor(this.m_verticalCursor2);
        if (this.m_waveformAreaMarker != null) {
            this.m_plot.addMarker(this.m_waveformAreaMarker);
        }
        this.m_plot.addMarker(this.m_horizontalDeltaMarker);
        this.m_plot.addMarker(this.m_resultLabelMarker);
        ActionListener widthModificationListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double x2;
                double x1 = DeltaXMeasurement.this.m_verticalCursor1.getValue();
                if (x1 > (x2 = DeltaXMeasurement.this.m_verticalCursor2.getValue())) {
                    double tmp = x2;
                    x2 = x1;
                    x1 = tmp;
                }
                String res = DeltaXMeasurement.this.m_algorithm.calculate(DeltaXMeasurement.this.m_plot, x1, x2);
                DeltaXMeasurement.this.m_resultLabelMarker.setLabel(res);
                DataCoordinates coordinates = (DataCoordinates)DeltaXMeasurement.this.m_resultLabelMarker.getCoordinates();
                coordinates.setDataCoordinates((x1 + x2) / 2.0, (maxY - minY) / 2.0);
                DeltaXMeasurement.this.m_horizontalDeltaMarker.set(x1, x2);
                if (DeltaXMeasurement.this.m_waveformAreaMarker != null) {
                    DeltaXMeasurement.this.m_waveformAreaMarker.set(x1, x2);
                }
            }
        };
        this.m_verticalCursor1.addActionListener(widthModificationListener);
        this.m_verticalCursor2.addActionListener(widthModificationListener);
    }

    @Override
    public String getName() {
        return this.m_algorithm.getName();
    }

    @Override
    public AbstractMeasurement.MeasurementType getMeasurementType() {
        return AbstractMeasurement.MeasurementType.X_AXIS_POPUP;
    }

    @Override
    public boolean canApply() {
        XAxis axisX = this.m_plot.getBasePlotPanel().getXAxis();
        if (axisX == null) {
            return false;
        }
        return !axisX.isEnum() && !axisX.isLog();
    }

    public static abstract class AlgorithmMeasurement {
        public abstract String getName();

        public abstract String calculate(PlotBaseAbstract var1, double var2, double var4);
    }
}

