/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.search;

import fr.proline.studio.filter.Filter;
import fr.proline.studio.search.ApplySearchInterface;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class AdvancedSearchFloatingPanel
extends JPanel {
    private Filter[] m_filters = null;
    private JToggleButton m_srcButton = null;
    private ApplySearchInterface m_search = null;
    private JButton m_searchButton;
    private JComboBox m_columnComboBox;
    private final JPanel m_searchOptionPanel = new JPanel(new GridBagLayout());

    public AdvancedSearchFloatingPanel(ApplySearchInterface search) {
        this(search, "*", "<html>Search is based on wildcards:<br>  '*' : can replace all characters<br>  '?' : can replace one character<br><br>Use 'FOO*' to search a string starting with FOO. </html>");
    }

    public AdvancedSearchFloatingPanel(ApplySearchInterface search, String defaultSearchValue, String defaultTooltip) {
        this.m_search = search;
        this.setBorder(BorderFactory.createLineBorder(Color.darkGray, 1, true));
        this.setOpaque(true);
        this.setLayout(new FlowLayout());
        JButton closeButton = new JButton(IconManager.getIcon(IconManager.IconType.CROSS_SMALL7));
        closeButton.setMargin(new Insets(0, 0, 0, 0));
        closeButton.setFocusPainted(false);
        closeButton.setContentAreaFilled(false);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedSearchFloatingPanel.this.setVisible(false);
                if (AdvancedSearchFloatingPanel.this.m_srcButton != null) {
                    AdvancedSearchFloatingPanel.this.m_srcButton.setSelected(false);
                }
            }
        });
        this.m_columnComboBox = new JComboBox();
        this.m_searchButton = new JButton(IconManager.getIcon(IconManager.IconType.SEARCH_ARROW));
        this.m_searchButton.setMargin(new Insets(1, 1, 1, 1));
        this.m_searchButton.setFocusPainted(false);
        this.m_searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Filter f = (Filter)AdvancedSearchFloatingPanel.this.m_columnComboBox.getSelectedItem();
                f.setDefined(true);
                boolean hasChanged = f.registerValues();
                AdvancedSearchFloatingPanel.this.m_search.doSearch(f, hasChanged);
            }
        });
        this.add(closeButton);
        this.add(this.m_columnComboBox);
        this.add(this.m_searchOptionPanel);
        this.add(this.m_searchButton);
        Dimension d = this.getPreferredSize();
        this.setBounds(0, 0, (int)d.getWidth(), (int)d.getHeight());
        MouseAdapter dragGestureAdapter = new MouseAdapter(){
            int dX;
            int dY;

            @Override
            public void mouseDragged(MouseEvent e) {
                int parentY;
                Component panel = e.getComponent();
                int newX = e.getLocationOnScreen().x - this.dX;
                int newY = e.getLocationOnScreen().y - this.dY;
                Container parentComponent = panel.getParent();
                int parentX = parentComponent.getX();
                if (newX < parentX) {
                    newX = parentX;
                }
                if (newY < (parentY = parentComponent.getY())) {
                    newY = parentY;
                }
                int parentWidth = parentComponent.getWidth();
                if (newX + panel.getWidth() > parentWidth - parentX) {
                    newX = parentWidth - parentX - panel.getWidth();
                }
                int parentHeight = parentComponent.getHeight();
                if (newY + panel.getHeight() > parentHeight - parentY) {
                    newY = parentHeight - parentY - panel.getHeight();
                }
                panel.setLocation(newX, newY);
                this.dX = e.getLocationOnScreen().x - panel.getX();
                this.dY = e.getLocationOnScreen().y - panel.getY();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JPanel panel = (JPanel)e.getComponent();
                panel.setCursor(Cursor.getPredefinedCursor(13));
                this.dX = e.getLocationOnScreen().x - panel.getX();
                this.dY = e.getLocationOnScreen().y - panel.getY();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JPanel panel = (JPanel)e.getComponent();
                panel.setCursor(null);
            }
        };
        this.addMouseMotionListener(dragGestureAdapter);
        this.addMouseListener(dragGestureAdapter);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ArrayList<JTextField> list = new ArrayList<JTextField>();
                AdvancedSearchFloatingPanel.this.getJTextFields(AdvancedSearchFloatingPanel.this.m_searchOptionPanel, list);
                ((JTextField)list.get(0)).requestFocusInWindow();
            }
        });
        this.setVisible(false);
    }

    public void setFilers(Filter[] filters) {
        this.m_filters = filters;
        this.initPrefilterSelectedPanel();
    }

    public boolean hasFilters() {
        return this.m_filters != null;
    }

    public void initPrefilterSelectedPanel() {
        this.m_searchOptionPanel.removeAll();
        this.m_columnComboBox.removeAllItems();
        for (Filter f : this.m_filters) {
            this.m_columnComboBox.addItem(f);
        }
        Filter f = (Filter)this.m_columnComboBox.getSelectedItem();
        this.modifySearchOptionPanel(f, true);
        this.m_columnComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Filter f = (Filter)AdvancedSearchFloatingPanel.this.m_columnComboBox.getSelectedItem();
                f.setDefined(true);
                AdvancedSearchFloatingPanel.this.modifySearchOptionPanel(f, false);
            }
        });
    }

    private void modifySearchOptionPanel(Filter f, boolean firstTime) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridy = 0;
        this.m_searchOptionPanel.removeAll();
        c.gridx = 0;
        f.createComponents(this.m_searchOptionPanel, c);
        this.addListener(this.m_searchOptionPanel);
        this.revalidate();
        Dimension d = this.getPreferredSize();
        if (firstTime) {
            this.setBounds(0, 0, (int)d.getWidth(), (int)d.getHeight());
        } else {
            this.setBounds(this.getX(), this.getY(), (int)d.getWidth(), (int)d.getHeight());
        }
    }

    private void addListener(Container container) {
        ArrayList<JTextField> textFields = new ArrayList<JTextField>();
        this.getJTextFields(container, textFields);
        for (final JTextField tf : textFields) {
            tf.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdvancedSearchFloatingPanel.this.m_searchButton.doClick();
                }
            });
            tf.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (!e.isTemporary()) {
                        if (tf.getText() != null && tf.getText().endsWith("*")) {
                            tf.select(0, tf.getText().length() - 1);
                        } else {
                            tf.selectAll();
                        }
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            });
        }
    }

    private void getJTextFields(Container container, List<JTextField> list) {
        for (Component c : container.getComponents()) {
            if (c instanceof JTextField) {
                list.add((JTextField)c);
                continue;
            }
            if (!(c instanceof Container)) continue;
            this.getJTextFields((Container)c, list);
        }
    }

    public void setToggleButton(JToggleButton srcButton) {
        this.m_srcButton = srcButton;
    }

    public void enableSearch(boolean enable) {
        if (this.m_srcButton != null) {
            this.m_searchButton.setEnabled(enable);
        }
    }
}

