/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.table.renderer;

import fr.proline.studio.table.DataGroup;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class PropertiesRenderer
extends DefaultTableCellRenderer {
    private final boolean m_nonOkRenderer;
    private static final Color COLOR_DIFFERENT = new Color(253, 241, 184);
    private JTable m_table = null;

    public PropertiesRenderer(boolean nonOkRenderer) {
        this.m_nonOkRenderer = nonOkRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        DataGroup.GroupObject groupObject = (DataGroup.GroupObject)value;
        DataGroup dataGroup = groupObject == null ? null : groupObject.m_group;
        String valueString = groupObject == null ? "" : groupObject.m_valueRendering;
        super.getTableCellRendererComponent(table, valueString, isSelected, hasFocus, row, column);
        this.setHorizontalAlignment(4);
        this.m_table = table;
        if (!isSelected) {
            if (this.m_nonOkRenderer) {
                this.setBackground(COLOR_DIFFERENT);
                this.setForeground(Color.black);
            } else if (column == 0) {
                if (groupObject.m_coloredRow) {
                    this.setBackground(dataGroup.getGroupColor(row));
                    this.setForeground(Color.white);
                } else {
                    this.setBackground(UIManager.getColor("Table.background"));
                    this.setForeground(UIManager.getColor("Table.foreground"));
                }
            } else {
                this.setBackground(UIManager.getColor("Table.background"));
                this.setForeground(UIManager.getColor("Table.foreground"));
            }
        } else {
            this.setBackground(UIManager.getColor("Table.selectionBackground"));
            this.setForeground(UIManager.getColor("Table.selectionForeground"));
        }
        return this;
    }

    public JTable getTable() {
        return this.m_table;
    }
}

