/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.msfiles.MgfExportSettings;
import fr.proline.studio.msfiles.MgfExportTask;
import fr.proline.studio.msfiles.MsListener;
import fr.proline.studio.msfiles.MsListenerParameter;
import fr.proline.studio.msfiles.MzdbEncodingVerificationTask;
import fr.proline.studio.msfiles.MzdbIntegrityVerificationTask;
import java.io.File;
import java.util.ArrayList;

public class MgfExporter
implements Runnable {
    private final File m_file;
    private MsListener m_msListener;
    private final MgfExportSettings m_mgfExportSettings;

    public MgfExporter(File file, MgfExportSettings exportSettings) {
        this.m_file = file;
        this.m_mgfExportSettings = exportSettings;
    }

    public void addMsListener(MsListener listener) {
        this.m_msListener = listener;
    }

    @Override
    public void run() {
        this.verifyEncoding();
    }

    private void verifyIntegrityAndExport() {
        AbstractDatabaseCallback verificationCallback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return false;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (success) {
                    AbstractDatabaseCallback exportMgfCallback = new AbstractDatabaseCallback(){

                        public boolean mustBeCalledInAWT() {
                            return false;
                        }

                        public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                            ArrayList<MsListenerParameter> list = new ArrayList<MsListenerParameter>();
                            list.add(new MsListenerParameter(MgfExporter.this.m_file, success));
                            MgfExporter.this.m_msListener.exportPerformed(list);
                        }
                    };
                    MgfExportTask exportMgfTask = new MgfExportTask(exportMgfCallback, MgfExporter.this.m_file, MgfExporter.this.m_mgfExportSettings);
                    AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)exportMgfTask);
                }
            }
        };
        MzdbIntegrityVerificationTask verificationTask = new MzdbIntegrityVerificationTask(verificationCallback, this.m_file);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)verificationTask);
    }

    private void verifyEncoding() {
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (success) {
                    MgfExporter.this.verifyIntegrityAndExport();
                }
            }
        };
        MzdbEncodingVerificationTask encodingVerificationTask = new MzdbEncodingVerificationTask(callback, this.m_file);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)encodingVerificationTask);
    }
}

