/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import java.io.File;
import org.slf4j.LoggerFactory;

public class MzdbIntegrityVerificationTask
extends AbstractDatabaseTask {
    private final File m_file;
    private boolean m_valid;

    public MzdbIntegrityVerificationTask(AbstractDatabaseCallback callback, File file) {
        super(callback, new TaskInfo("Verify integrity of " + file.getAbsolutePath(), false, "Mzdb Verification", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_file = file;
    }

    public boolean fetchData() {
        if (!this.isValid(this.m_file)) {
            this.m_taskError = new TaskError("mzDB file verification error", "File is corrupted.");
            return false;
        }
        return true;
    }

    public boolean needToFetch() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(File file) {
        try {
            this.m_valid = true;
            try (MzDbReader reader = null;){
                long ms2SpectrumId;
                double[] mzList;
                reader = new MzDbReader(file, true);
                SpectrumHeader[] ms2Headers = reader.getMs2SpectrumHeaders();
                SpectrumHeader[] ms1Headers = reader.getMs1SpectrumHeaders();
                if (ms1Headers == null || ms1Headers.length < 1) {
                    this.m_valid = false;
                } else {
                    long ms1SpectrumId = ms1Headers[0].getSpectrumId();
                    if (ms1SpectrumId != 0L) {
                        Spectrum ms1RawSpectrum = reader.getSpectrum(ms1SpectrumId);
                        if (ms1RawSpectrum != null) {
                            SpectrumData ms1SpectrumData = ms1RawSpectrum.getData();
                            if (ms1SpectrumData != null) {
                                mzList = ms1SpectrumData.getMzList();
                                if (mzList == null || mzList.length < 1) {
                                    this.m_valid = false;
                                }
                            } else {
                                this.m_valid = false;
                            }
                        } else {
                            this.m_valid = false;
                        }
                    }
                }
                if (ms2Headers != null && ms2Headers.length > 0 && (ms2SpectrumId = ms2Headers[0].getSpectrumId()) != 0L) {
                    Spectrum ms2RawSpectrum = reader.getSpectrum(ms2SpectrumId);
                    if (ms2RawSpectrum != null) {
                        SpectrumData ms2SpectrumData = ms2RawSpectrum.getData();
                        if (ms2SpectrumData != null) {
                            mzList = ms2SpectrumData.getMzList();
                            if (mzList == null || mzList.length < 1) {
                                this.m_valid = false;
                            }
                        } else {
                            this.m_valid = false;
                        }
                    } else {
                        this.m_valid = false;
                    }
                }
            }
        }
        catch (Throwable t) {
            LoggerFactory.getLogger((String)"ProlineStudio.DAM").debug("Unexpected exception in mzdb verification task", t);
            this.m_valid = false;
        }
        return this.m_valid;
    }
}

