/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.proline.studio.Exceptions;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.msfiles.ConversionSettings;
import fr.proline.studio.msfiles.FileUtility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class RawConversionTask
extends AbstractDatabaseTask {
    private final File m_file;
    private Process m_process = null;
    private ConversionSettings m_settings;

    public RawConversionTask(AbstractDatabaseCallback callback, File file, ConversionSettings settings) {
        super(callback, new TaskInfo("Convert .raw file " + file.getAbsolutePath(), false, "Generic Task", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_file = file;
        this.m_settings = settings;
    }

    public boolean fetchData() {
        try {
            String suffix = null;
            if (this.m_file.getAbsolutePath().endsWith(".RAW")) {
                suffix = ".RAW";
            } else if (this.m_file.getAbsolutePath().endsWith(".raw")) {
                suffix = ".raw";
            } else if (this.m_file.getAbsolutePath().endsWith(".WIFF")) {
                suffix = ".WIFF";
            } else if (this.m_file.getAbsolutePath().endsWith(".wiff")) {
                suffix = ".wiff";
            }
            ArrayList<String> commandParams = new ArrayList<String>();
            commandParams.add(this.m_settings.getConverterPath());
            commandParams.add("-i");
            commandParams.add(this.m_file.getAbsolutePath());
            commandParams.add("-o");
            commandParams.add(this.m_settings.getOutputPath() + File.separator + this.m_file.getName().substring(0, this.m_file.getName().lastIndexOf(suffix)) + ".mzdb");
            if (this.m_settings.isVersion1_1()) {
                commandParams.add("-n");
            }
            this.m_process = new ProcessBuilder(commandParams).start();
        }
        catch (IOException ex) {
            if (this.m_process != null && this.m_process.isAlive()) {
                this.m_process.destroy();
            }
            this.m_taskError = new TaskError("Raw Conversion Error", "An IOException was encountered.");
            return false;
        }
        while (this.m_process != null && this.m_process.isAlive()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (this.m_process.exitValue() == 0) {
            if (this.m_settings.getDeleteRaw()) {
                FileUtility.deleteFile(this.m_file);
            }
        } else {
            if (this.m_process != null && this.m_process.isAlive()) {
                this.m_process.destroy();
            }
            this.m_taskError = new TaskError("Raw Conversion Error", "Process abnormal exit.");
            return false;
        }
        return true;
    }

    public boolean needToFetch() {
        return true;
    }
}

