/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.msfiles.ConversionSettings;
import fr.proline.studio.msfiles.MsListener;
import fr.proline.studio.msfiles.MsListenerConverterParameter;
import fr.proline.studio.msfiles.RawConversionTask;
import fr.proline.studio.rsmexplorer.MzdbFilesTopPanel;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.SwingUtilities;

public class RawConverter
implements Runnable {
    private final File m_file;
    private MsListener m_msListener;
    private final ConversionSettings m_settings;

    public RawConverter(File file, ConversionSettings settings) {
        this.m_file = file;
        this.m_settings = settings;
    }

    @Override
    public void run() {
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return false;
            }

            public void run(final boolean success, long taskId, SubTask subTask, boolean finished) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        File f = null;
                        if (RawConverter.this.m_file.getName().contains(".raw")) {
                            f = new File(RawConverter.this.m_settings.getOutputPath() + File.separator + RawConverter.this.m_file.getName().substring(0, RawConverter.this.m_file.getName().lastIndexOf(".raw")) + ".mzdb");
                        } else if (RawConverter.this.m_file.getName().contains(".RAW")) {
                            f = new File(RawConverter.this.m_settings.getOutputPath() + File.separator + RawConverter.this.m_file.getName().substring(0, RawConverter.this.m_file.getName().lastIndexOf(".RAW")) + ".mzdb");
                        } else if (RawConverter.this.m_file.getName().contains(".wiff")) {
                            f = new File(RawConverter.this.m_settings.getOutputPath() + File.separator + RawConverter.this.m_file.getName().substring(0, RawConverter.this.m_file.getName().lastIndexOf(".wiff")) + ".mzdb");
                        } else if (RawConverter.this.m_file.getName().contains(".WIFF")) {
                            f = new File(RawConverter.this.m_settings.getOutputPath() + File.separator + RawConverter.this.m_file.getName().substring(0, RawConverter.this.m_file.getName().lastIndexOf(".WIFF")) + ".mzdb");
                        }
                        if (success) {
                            if (RawConverter.this.m_msListener != null && f != null && f.exists()) {
                                ArrayList<MsListenerConverterParameter> list = new ArrayList<MsListenerConverterParameter>();
                                list.add(new MsListenerConverterParameter(f, true, RawConverter.this.m_settings));
                                RawConverter.this.m_msListener.conversionPerformed(list);
                            }
                            if (RawConverter.this.m_settings.getDeleteRaw()) {
                                try {
                                    Files.delete(RawConverter.this.m_file.toPath());
                                    HashSet<String> directories = new HashSet<String>();
                                    File outputDirectory = new File(RawConverter.this.m_file.getParentFile().getAbsolutePath());
                                    while (outputDirectory.getParentFile() != null) {
                                        directories.add(outputDirectory.getAbsolutePath());
                                        outputDirectory = outputDirectory.getParentFile();
                                    }
                                    MzdbFilesTopPanel.getExplorer().getLocalFileSystemView().expandMultipleTreePath(directories);
                                    MzdbFilesTopPanel.getExplorer().getLocalFileSystemView().updateTree();
                                }
                                catch (NoSuchFileException directories) {
                                }
                                catch (DirectoryNotEmptyException directories) {
                                }
                                catch (IOException directories) {}
                            }
                        } else if (RawConverter.this.m_msListener != null) {
                            ArrayList<MsListenerConverterParameter> list = new ArrayList<MsListenerConverterParameter>();
                            list.add(new MsListenerConverterParameter(f, false, RawConverter.this.m_settings));
                            RawConverter.this.m_msListener.conversionPerformed(list);
                        }
                    }
                });
            }
        };
        RawConversionTask task = new RawConversionTask(callback, this.m_file, this.m_settings);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
    }

    public void addMsListener(MsListener listener) {
        this.m_msListener = listener;
    }
}

