/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptide;
import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.DatabaseDatasetPTMsTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.data.ptm.PTMCluster;
import fr.proline.studio.dam.tasks.data.ptm.PTMDataset;
import fr.proline.studio.dam.tasks.data.ptm.PTMDatasetPair;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadLcMSTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadXicMasterQuantTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.DataBoxViewerManager;
import fr.proline.studio.rsmexplorer.gui.PTMClustersPanel;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.types.XicMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBoxPTMClusters
extends AbstractDataBox {
    private final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer.ptm");
    private final boolean m_loadSitesAsClusters;
    private boolean m_isAnnotatedData;
    private long logStartTime;
    private PTMDatasetPair m_ptmDatasetPair;
    private DDataset m_datasetSet;
    private ResultSummary m_rsm;
    private QuantChannelInfo m_quantChannelInfo;
    private DDatasetType.QuantitationMethodInfo m_quantMethodInfo;
    private boolean m_shouldBeSaved = false;
    private boolean m_loadPepMatchOnGoing = false;

    public DataBoxPTMClusters() {
        this(false, false);
    }

    public DataBoxPTMClusters(boolean viewSitesAsClusters) {
        this(viewSitesAsClusters, false);
    }

    public DataBoxPTMClusters(boolean viewSitesAsClusters, boolean isAnnotatedData) {
        super(viewSitesAsClusters ? AbstractDataBox.DataboxType.DataBoxPTMSiteAsClusters : AbstractDataBox.DataboxType.DataBoxPTMClusters, AbstractDataBox.DataboxStyle.STYLE_RSM);
        this.m_loadSitesAsClusters = viewSitesAsClusters;
        this.m_isAnnotatedData = isAnnotatedData;
        this.m_quantMethodInfo = DDatasetType.QuantitationMethodInfo.NONE;
        this.setDataBoxInfo();
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(PTMDataset.class);
        inParameter.addParameter(DDataset.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(ResultSummary.class);
        outParameter.addParameter(PTMPeptideInstance.class, ParameterSubtypeEnum.LEAF_PTMPeptideInstance);
        outParameter.addParameter(PTMPeptideInstance.class, ParameterSubtypeEnum.PARENT_PTMPeptideInstance);
        outParameter.addParameter(PTMDataset.class);
        outParameter.addParameter(PTMDatasetPair.class);
        outParameter.addParameter(DDatasetType.QuantitationMethodInfo.class);
        outParameter.addParameter(DProteinMatch.class);
        outParameter.addParameter(DPeptideMatch.class);
        outParameter.addParameter(PTMCluster.class, ParameterSubtypeEnum.LIST_DATA);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        outParameter.addParameter(CrossSelectionInterface.class);
        this.registerOutParameter(outParameter);
    }

    private boolean isQuantResult() {
        return this.m_quantMethodInfo.equals((Object)DDatasetType.QuantitationMethodInfo.FEATURES_EXTRACTION) || this.m_quantMethodInfo.equals((Object)DDatasetType.QuantitationMethodInfo.ISOBARIC_TAGGING);
    }

    public void setQuantitationMethodInfo(DDatasetType.QuantitationMethodInfo quantMethodInfo) {
        this.m_quantMethodInfo = quantMethodInfo;
        this.setDataBoxInfo();
    }

    private void setDataBoxInfo() {
        String prefix;
        boolean isQuant = this.isQuantResult();
        this.m_style = isQuant ? AbstractDataBox.DataboxStyle.STYLE_XIC : AbstractDataBox.DataboxStyle.STYLE_RSM;
        String string = prefix = isQuant ? "Quant. " : "";
        this.m_typeName = prefix + (this.m_loadSitesAsClusters ? (this.m_isAnnotatedData ? "Annotated PTMs Sites" : "Dataset PTMs Sites") : (this.m_isAnnotatedData ? "Annotated PTMs Clusters" : "Dataset PTMs Clusters"));
        this.m_description = prefix + "Clusters of Modification Sites of a Dataset";
        if (isQuant) {
            this.registerXicOutParameter();
        }
    }

    private void registerXicOutParameter() {
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DMasterQuantProteinSet.class);
        outParameter.addParameter(DProteinSet.class);
        outParameter.addParameter(QuantChannelInfo.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public Long getRsetId() {
        if (this.m_ptmDatasetPair == null) {
            return null;
        }
        return this.m_datasetSet.getResultSetId();
    }

    @Override
    public Long getRsmId() {
        if (this.m_ptmDatasetPair == null) {
            return null;
        }
        return this.m_datasetSet.getResultSummaryId();
    }

    @Override
    public void createPanel() {
        PTMClustersPanel p = new PTMClustersPanel(!this.m_loadSitesAsClusters);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataMustBeRecalculated(Long rsetId, Long rsmId, Class dataType, ArrayList modificationsList, byte reason) {
        if (!this.isDataOfInterest(rsetId, rsmId, dataType) || !dataType.equals(PTMCluster.class)) {
            return;
        }
        DataBoxViewerManager.REASON_MODIF reasonModif = DataBoxViewerManager.REASON_MODIF.getReasonModifFor(reason);
        if (reasonModif == null) {
            return;
        }
        switch (reasonModif) {
            case REASON_PTMCLUSTER_MODIFIED: {
                this.m_shouldBeSaved = true;
                break;
            }
            case REASON_PTMDATASET_SAVED: {
                this.m_isAnnotatedData = true;
                this.m_shouldBeSaved = false;
                break;
            }
            case REASON_PTMCLUSTER_MERGED: 
            case REASON_PEPTIDE_SUPPRESSED: {
                this.m_shouldBeSaved = true;
                this.addDataChanged(PTMPeptideInstance.class, null);
                this.propagateDataChanged();
            }
        }
        this.m_ptmDatasetPair.setShouldSavePTMDataset(this.m_shouldBeSaved);
    }

    @Override
    public boolean isClosable() {
        return !this.m_shouldBeSaved;
    }

    @Override
    public String getClosingWarningMessage() {
        if (this.m_shouldBeSaved) {
            return "Annotated PTM Dataset has not been saved....";
        }
        return "";
    }

    @Override
    public void dataChanged() {
        this.linkCache((TransientDataInterface)this.m_rsm);
        final int loadingId = this.setLoading();
        final long logStartTimelocal = System.currentTimeMillis();
        final ArrayList ptmDSSet = new ArrayList();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                DataBoxPTMClusters.this.m_logger.debug("DataBoxPTMClusters : **** dataChanged Callback task " + taskId + ", success " + success + ", finished " + finished + "; with subtask : " + (subTask != null) + ". Duration: " + (System.currentTimeMillis() - logStartTimelocal) + " TimeMillis");
                if (success) {
                    if (subTask == null) {
                        DataBoxPTMClusters.this.m_ptmDatasetPair = (PTMDatasetPair)ptmDSSet.get(0);
                        String version = DataBoxPTMClusters.this.m_ptmDatasetPair.getClusterPTMDataset().getModelVersion();
                        if (version == null || !version.equals("2.0")) {
                            String msg = " Modification clusters/sites result was obtained with an older version. N/CTerm display may be incorrect. \n You may have to relaunch the \"Identification Modification Sites\" process.";
                            JOptionPane.showMessageDialog((JPanel)((Object)DataBoxPTMClusters.this.getDataBoxPanelInterface()), msg, "Older PTM Dataset version", 2);
                        }
                        DataBoxPTMClusters.this.getDataBoxPanelInterface().addSingleValue(DataBoxPTMClusters.this.m_ptmDatasetPair);
                        DataBoxPTMClusters.this.m_shouldBeSaved = false;
                        DataBoxPTMClusters.this.m_loadPepMatchOnGoing = true;
                        ((PTMClustersPanel)DataBoxPTMClusters.this.getDataBoxPanelInterface()).setData(taskId, (ArrayList)DataBoxPTMClusters.this.getPTMDatasetToView().getPTMClusters(), finished);
                        DataBoxPTMClusters.this.loadPeptideMatches();
                    } else {
                        ((PTMClustersPanel)DataBoxPTMClusters.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                    }
                } else {
                    DataBoxPTMClusters.this.displayLoadError(taskId, finished);
                }
                if (finished) {
                    DataBoxPTMClusters.this.setLoaded(loadingId);
                    DataBoxPTMClusters.this.unregisterTask(taskId);
                    if (DataBoxPTMClusters.this.m_isAnnotatedData) {
                        DatabaseDataManager.getDatabaseDataManager().addLoadedAnnotatedPTMDatasetSet((PTMDatasetPair)ptmDSSet.get(0));
                    } else {
                        DatabaseDataManager.getDatabaseDataManager().addLoadedPTMDatasetSet((PTMDatasetPair)ptmDSSet.get(0));
                    }
                    DataBoxPTMClusters.this.m_logger.debug("DataBoxPTMClusters : **** dataChanged Task " + taskId + " DONE. Should propagate changes. Duration: " + (System.currentTimeMillis() - logStartTimelocal) + " TimeMillis");
                    DataBoxPTMClusters.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataBoxPTMClusters.this.propagateDataChanged();
                }
            }
        };
        DatabaseDatasetPTMsTask task = new DatabaseDatasetPTMsTask(callback);
        task.initLoadPTMDataset(Long.valueOf(this.getProjectId()), this.m_datasetSet, ptmDSSet, this.m_isAnnotatedData);
        this.m_logger.trace("DataBoxPTMClusters : **** dataChanged Register task DatabasePTMsTask.initLoadPTMDataset. ID= " + task.getId());
        this.registerTask((AbstractDatabaseTask)task);
    }

    private void displayLoadError(long taskId, boolean isFinished) {
        TaskInfo ti = this.getTaskInfo(taskId);
        TaskError taskError = ti.getTaskError();
        if (taskError != null) {
            if ("PTM Cluster Loading Error".equals(taskError.getErrorTitle())) {
                JOptionPane.showMessageDialog((JPanel)((Object)this.getDataBoxPanelInterface()), "To display Modification Sites or Modification Clusters, you must run \"Identify Modification Sites\" beforehand.", taskError.getErrorTitle(), 2);
            } else {
                JOptionPane.showMessageDialog((JPanel)((Object)this.getDataBoxPanelInterface()), taskError.getErrorText(), "PTM Cluster Loading Error", 0);
            }
        }
        ((PTMClustersPanel)this.getDataBoxPanelInterface()).setData(taskId, null, isFinished);
    }

    private void loadPeptideMatches() {
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                DataBoxPTMClusters.this.m_logger.debug("DataBoxPTMClusters : **** loadPeptideMatches Callback task " + taskId + ", success " + success + ", finished " + finished + "; with subtask : " + subTask + ". Duration: " + (System.currentTimeMillis() - DataBoxPTMClusters.this.logStartTime) + " TimeMillis");
                if (!success) {
                    DataBoxPTMClusters.this.displayLoadError(taskId, finished);
                }
                if (finished) {
                    DataBoxPTMClusters.this.m_loadPepMatchOnGoing = false;
                    DataBoxPTMClusters.this.m_logger.debug(" DataBoxPTMClusters : **** loadPeptideMatches Task " + taskId + " DONE. Should propagate changes or get Xic DATA ");
                    DataBoxPTMClusters.this.m_ptmDatasetPair.updateParentPTMPeptideInstanceClusters();
                    DataBoxPTMClusters.this.unregisterTask(taskId);
                    if (DataBoxPTMClusters.this.isQuantResult()) {
                        DataBoxPTMClusters.this.loadXicData(loadingId);
                    } else {
                        DataBoxPTMClusters.this.setLoaded(loadingId);
                        ((PTMClustersPanel)DataBoxPTMClusters.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                        DataBoxPTMClusters.this.addDataChanged(PTMPeptideInstance.class, null);
                        DataBoxPTMClusters.this.addDataChanged(ExtendedTableModelInterface.class);
                        DataBoxPTMClusters.this.propagateDataChanged();
                    }
                    DataBoxPTMClusters.this.unregisterTask(taskId);
                }
            }
        };
        DatabaseDatasetPTMsTask task = new DatabaseDatasetPTMsTask(callback);
        ArrayList allSites = new ArrayList(this.m_ptmDatasetPair.getClusterPTMDataset().getPTMSites());
        allSites.addAll(this.m_ptmDatasetPair.getSitePTMDataset().getPTMSites());
        task.initFillPTMSites(this.getProjectId(), this.m_ptmDatasetPair, allSites);
        this.logStartTime = System.currentTimeMillis();
        this.m_logger.trace("DataBoxPTMClusters : **** loadPeptideMatches Register task DatabasePTMsTask.initFillPTMSites. ID= " + task.getId());
        this.registerTask((AbstractDatabaseTask)task);
    }

    private void loadXicData(final int loadingId) {
        final ArrayList masterQuantProteinSetList = new ArrayList();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                DataBoxPTMClusters.this.m_logger.debug("DataBoxPTMClusters : **** loadXicData Callback task " + taskId + ", success " + success + ", finished " + finished + "; with subtask : " + subTask + "; found " + masterQuantProteinSetList.size() + " mqPrS Duration: " + (System.currentTimeMillis() - DataBoxPTMClusters.this.logStartTime) + " TimeMillis");
                if (subTask == null) {
                    DataBoxPTMClusters.this.m_quantChannelInfo = new QuantChannelInfo(DataBoxPTMClusters.this.m_datasetSet);
                    DataBoxPTMClusters.this.getDataBoxPanelInterface().addSingleValue(DataBoxPTMClusters.this.m_quantChannelInfo);
                    AbstractDatabaseCallback mapCallback = new AbstractDatabaseCallback(){

                        public boolean mustBeCalledInAWT() {
                            return true;
                        }

                        public void run(boolean success, long task2Id, SubTask subTask, boolean finished) {
                            DataBoxPTMClusters.this.m_logger.trace("**** +++ END task " + task2Id + " if finished ? " + finished);
                            if (finished) {
                                DataBoxPTMClusters.this.unregisterTask(task2Id);
                            }
                        }
                    };
                    DatabaseLoadLcMSTask taskMap = new DatabaseLoadLcMSTask(mapCallback);
                    taskMap.initLoadAlignmentForXic(DataBoxPTMClusters.this.getProjectId(), DataBoxPTMClusters.this.m_datasetSet);
                    DataBoxPTMClusters.this.m_logger.trace("DataBoxPTMClusters loadXicData **** +++ Register task DatabaseLoadLcMSTask.initLoadAlignmentForXic " + taskMap.getId());
                    DataBoxPTMClusters.this.registerTask((AbstractDatabaseTask)taskMap);
                }
                if (finished) {
                    DataBoxPTMClusters.this.m_logger.debug(" DataBoxPTMClusters : **** loadXicData Task " + taskId + " DONE.+ loadProteinMatchMapping + propagate and set Loaded");
                    DataBoxPTMClusters.this.setLoaded(loadingId);
                    Map<Long, Long> typicalProteinMatchIdByProteinMatchId = DataBoxPTMClusters.this.loadProteinMatchMapping();
                    DataBoxPTMClusters.this.m_ptmDatasetPair.getClusterPTMDataset().setQuantProteinSets(masterQuantProteinSetList, typicalProteinMatchIdByProteinMatchId);
                    DataBoxPTMClusters.this.m_ptmDatasetPair.getSitePTMDataset().setQuantProteinSets(masterQuantProteinSetList, typicalProteinMatchIdByProteinMatchId);
                    DataBoxPTMClusters.this.unregisterTask(taskId);
                    ArrayList<PTMCluster> allClusters = new ArrayList<PTMCluster>(DataBoxPTMClusters.this.m_ptmDatasetPair.getClusterPTMDataset().getPTMClusters());
                    allClusters.addAll(DataBoxPTMClusters.this.m_ptmDatasetPair.getSitePTMDataset().getPTMClusters());
                    DataBoxPTMClusters.this.startLoadingMasterQuantPeptides(allClusters);
                    DataBoxPTMClusters.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataBoxPTMClusters.this.propagateDataChanged();
                }
            }
        };
        DatabaseLoadXicMasterQuantTask task = new DatabaseLoadXicMasterQuantTask(callback);
        task.initLoadProteinSets(this.getProjectId(), this.m_datasetSet, masterQuantProteinSetList);
        this.logStartTime = System.currentTimeMillis();
        this.m_logger.trace("DataBoxPTMClusters : **** loadXicData Register task XicMasterQuantTask - initLoadProteinSets. ID = " + task.getId());
        this.registerTask((AbstractDatabaseTask)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, Long> loadProteinMatchMapping() {
        HashMap<Long, Long> typicalProteinMatchIdByProteinMatchId = new HashMap<Long, Long>();
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.getProjectId()).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            long start = System.currentTimeMillis();
            Query proteinMatchQuery = entityManagerMSI.createQuery("SELECT pspmi.proteinMatch.id, pspmi.proteinSet.representativeProteinMatchId FROM ProteinSetProteinMatchItem pspmi WHERE pspmi.resultSummary.id=:rsmId");
            proteinMatchQuery.setParameter("rsmId", (Object)this.m_datasetSet.getResultSummaryId());
            for (Object[] cur : proteinMatchQuery.getResultList()) {
                Long proteinMatchId = (Long)cur[0];
                Long typicalProteinMatchId = (Long)cur[1];
                typicalProteinMatchIdByProteinMatchId.put(proteinMatchId, typicalProteinMatchId);
            }
            this.m_logger.trace("Protein match ids map retrieve {} entries in {} ms", (Object)typicalProteinMatchIdByProteinMatchId.size(), (Object)(System.currentTimeMillis() - start));
            entityManagerMSI.getTransaction().commit();
        }
        return typicalProteinMatchIdByProteinMatchId;
    }

    private void startLoadingMasterQuantPeptides(final List<PTMCluster> proteinPTMClusters) {
        final ArrayList masterQuantPeptideList = new ArrayList();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                DataBoxPTMClusters.this.m_logger.trace("DataBoxPTMClusters : ***  startLoadingMasterQuantPeptides Callback task " + taskId + " finish " + finished);
                if (finished) {
                    DataBoxPTMClusters.this.unregisterTask(taskId);
                    Map<Long, DMasterQuantPeptide> mqPepByPepInstId = masterQuantPeptideList.stream().collect(Collectors.toMap(DMasterQuantPeptide::getPeptideInstanceId, x -> x));
                    DataBoxPTMClusters.this.m_logger.debug("DataBoxPTMClusters : **** startLoadingMasterQuantPeptides  FINISH.");
                    for (PTMCluster currentCluster : proteinPTMClusters) {
                        currentCluster.setRepresentativeMQPepMatch(DataBoxPTMClusters.this.getPTMDatasetToView().getRepresentativeMQPeptideForCluster(currentCluster, mqPepByPepInstId));
                    }
                    ((PTMClustersPanel)DataBoxPTMClusters.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
            }
        };
        DatabaseLoadXicMasterQuantTask task = new DatabaseLoadXicMasterQuantTask(callback);
        List<Long> parentPepInstanceIds = proteinPTMClusters.stream().flatMap(cluster -> cluster.getParentPeptideInstances().stream()).map(DPeptideInstance::getId).distinct().collect(Collectors.toList());
        this.m_logger.debug("DataBoxPTMClusters : **** startLoadingMasterQuantPeptides initLoadPeptides. Loading {} peptideInstances XIC data", (Object)parentPepInstanceIds.size());
        task.initLoadPeptides(this.getProjectId(), this.m_datasetSet, parentPepInstanceIds.toArray(new Long[0]), masterQuantPeptideList, true);
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null) {
            if (parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
                PTMCluster cluster2;
                if (parameterType.equals(ResultSummary.class)) {
                    return this.m_rsm;
                }
                if (parameterType.equals(DProteinMatch.class) && (cluster2 = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedProteinPTMCluster()) != null) {
                    return cluster2.getProteinMatch();
                }
                if (parameterType.equals(DPeptideMatch.class) && (cluster2 = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedProteinPTMCluster()) != null) {
                    return cluster2.getRepresentativePepMatch();
                }
                if (parameterType.equals(PTMDataset.class)) {
                    return this.getPTMDatasetToView();
                }
                if (parameterType.equals(DDataset.class)) {
                    return this.m_datasetSet;
                }
                if (parameterType.equals(PTMDatasetPair.class)) {
                    return this.m_ptmDatasetPair;
                }
                if (parameterType.equals(DMasterQuantProteinSet.class) && this.isQuantResult() && (cluster2 = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedProteinPTMCluster()) != null) {
                    return cluster2.getMasterQuantProteinSet();
                }
                if (parameterType.equals(DProteinSet.class) && this.isQuantResult() && (cluster2 = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedProteinPTMCluster()) != null && cluster2.getMasterQuantProteinSet() != null) {
                    return cluster2.getMasterQuantProteinSet().getProteinSet();
                }
                if (parameterType.equals(QuantChannelInfo.class) && this.isQuantResult()) {
                    return this.m_quantChannelInfo;
                }
                if (parameterType.equals(ExtendedTableModelInterface.class)) {
                    return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
                }
                if (parameterType.equals(CrossSelectionInterface.class)) {
                    return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
                }
                if (parameterType.equals(XicMode.class) && this.m_datasetSet.isQuantitation()) {
                    return new XicMode(true);
                }
                if (parameterType.equals(DDatasetType.QuantitationMethodInfo.class)) {
                    return this.m_quantMethodInfo;
                }
            }
            if (parameterSubtype == ParameterSubtypeEnum.LIST_DATA && parameterType.equals(PTMCluster.class)) {
                return ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedPTMClusters();
            }
            if (parameterType.equals(PTMPeptideInstance.class) && (parameterSubtype.equals((Object)ParameterSubtypeEnum.PARENT_PTMPeptideInstance) || parameterSubtype.equals((Object)ParameterSubtypeEnum.LEAF_PTMPeptideInstance))) {
                if (this.m_loadPepMatchOnGoing) {
                    return null;
                }
                boolean parentPTMPeptideInstance = parameterSubtype.equals((Object)ParameterSubtypeEnum.PARENT_PTMPeptideInstance);
                List<PTMCluster> clusters = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedPTMClusters();
                ArrayList ptmPeptideInstances = new ArrayList();
                if (!clusters.isEmpty()) {
                    Collections.sort(clusters);
                    Long protMatchId = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedProteinPTMCluster().getProteinMatch().getId();
                    clusters.stream().filter(cluster -> protMatchId.equals(cluster.getProteinMatch().getId())).forEach(cluster -> ptmPeptideInstances.addAll(parentPTMPeptideInstance ? cluster.getParentPTMPeptideInstances() : cluster.getLeafPTMPeptideInstances()));
                }
                return ptmPeptideInstances;
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    private PTMDataset getPTMDatasetToView() {
        if (this.m_loadSitesAsClusters) {
            return this.m_ptmDatasetPair.getSitePTMDataset();
        }
        return this.m_ptmDatasetPair.getClusterPTMDataset();
    }

    @Override
    public void setEntryData(final Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        if (data instanceof DDataset) {
            this.m_datasetSet = (DDataset)data;
            PTMDatasetPair pTMDatasetPair = this.m_ptmDatasetPair = this.m_isAnnotatedData ? DatabaseDataManager.getDatabaseDataManager().getAnnotatedPTMDatasetSetForDS(Long.valueOf(this.m_datasetSet.getId())) : DatabaseDataManager.getDatabaseDataManager().getPTMDatasetSetForDS(Long.valueOf(this.m_datasetSet.getId()));
            if (this.m_ptmDatasetPair == null) {
                if (this.m_datasetSet.getResultSummary() == null) {
                    AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                        public boolean mustBeCalledInAWT() {
                            return true;
                        }

                        public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                            DataBoxPTMClusters.this.m_rsm = ((DDataset)data).getResultSummary();
                            DataBoxPTMClusters.this.dataChanged();
                        }
                    };
                    DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
                    task.initLoadRsetAndRsm((DDataset)data);
                    AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
                } else {
                    this.m_rsm = ((DDataset)data).getResultSummary();
                    this.dataChanged();
                }
            } else {
                this.m_rsm = this.m_datasetSet.getResultSummary();
                this.getDataBoxPanelInterface().addSingleValue(this.m_ptmDatasetPair);
                if (this.m_ptmDatasetPair.shouldSavePTMDataset()) {
                    this.m_shouldBeSaved = true;
                }
                if (this.isQuantResult()) {
                    boolean allDataLoaded = this.getPTMDatasetToView().isQuantDataLoaded();
                    if (allDataLoaded) {
                        this.m_quantChannelInfo = new QuantChannelInfo(this.m_datasetSet);
                        this.getDataBoxPanelInterface().addSingleValue(this.m_quantChannelInfo);
                        ((PTMClustersPanel)this.getDataBoxPanelInterface()).setData(-1L, (ArrayList)this.getPTMDatasetToView().getPTMClusters(), false);
                        ((PTMClustersPanel)this.getDataBoxPanelInterface()).dataUpdated(null, true);
                    } else {
                        int loadingId = this.setLoading();
                        this.loadXicData(loadingId);
                    }
                } else {
                    ((PTMClustersPanel)this.getDataBoxPanelInterface()).setData(-1L, (ArrayList)this.getPTMDatasetToView().getPTMClusters(), false);
                    ((PTMClustersPanel)this.getDataBoxPanelInterface()).dataUpdated(null, true);
                }
            }
        } else if (data instanceof PTMDataset) {
            PTMDatasetPair pTMDatasetPair = this.m_ptmDatasetPair = this.m_isAnnotatedData ? DatabaseDataManager.getDatabaseDataManager().getAnnotatedPTMDatasetSetForDS(Long.valueOf(((PTMDataset)data).getDataset().getId())) : DatabaseDataManager.getDatabaseDataManager().getPTMDatasetSetForDS(Long.valueOf(((PTMDataset)data).getDataset().getId()));
            if (this.m_ptmDatasetPair == null || !this.m_ptmDatasetPair.getClusterPTMDataset().equals(data) && !this.m_ptmDatasetPair.getSitePTMDataset().equals(data)) {
                throw new IllegalArgumentException("Invalid specified PTMDataset.");
            }
            this.getDataBoxPanelInterface().addSingleValue(this.m_ptmDatasetPair);
            this.m_datasetSet = this.m_ptmDatasetPair.getDataset();
            this.m_rsm = this.m_datasetSet.getResultSummary();
            if (this.isQuantResult()) {
                boolean allDataLoaded = this.getPTMDatasetToView().isQuantDataLoaded();
                if (allDataLoaded) {
                    this.m_quantChannelInfo = new QuantChannelInfo(this.m_datasetSet);
                    this.getDataBoxPanelInterface().addSingleValue(this.m_quantChannelInfo);
                    ((PTMClustersPanel)this.getDataBoxPanelInterface()).setData(-1L, (ArrayList)((PTMDataset)data).getPTMClusters(), false);
                    ((PTMClustersPanel)this.getDataBoxPanelInterface()).dataUpdated(null, true);
                } else {
                    int loadingId = this.setLoading();
                    this.loadXicData(loadingId);
                }
            } else {
                ((PTMClustersPanel)this.getDataBoxPanelInterface()).setData(-1L, (ArrayList)((PTMDataset)data).getPTMClusters(), false);
                ((PTMClustersPanel)this.getDataBoxPanelInterface()).dataUpdated(null, true);
            }
        } else {
            throw new IllegalArgumentException("Unsupported type " + data.getClass() + ": DDataset or PTMDataset expected.");
        }
    }

    @Override
    public Class[] getDataboxNavigationOutParameterClasses() {
        if (this.isQuantResult()) {
            return new Class[]{DProteinMatch.class, PTMDatasetPair.class, DMasterQuantProteinSet.class};
        }
        return new Class[]{DProteinMatch.class, PTMDatasetPair.class};
    }

    @Override
    public String getDataboxNavigationDisplayValue() {
        List<PTMCluster> selectedCl = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedPTMClusters();
        if (selectedCl == null || selectedCl.isEmpty()) {
            return null;
        }
        DProteinMatch p = selectedCl.get(0).getProteinMatch();
        int nbrPM = selectedCl.stream().collect(Collectors.groupingBy(PTMCluster::getProteinMatch)).size();
        if (nbrPM > 1) {
            return p.getAccession() + "+ " + (nbrPM - 1);
        }
        return p.getAccession();
    }
}

