/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseLoadPeptideMatchTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.PeptideMatchPanel;

public class DataboxRsetPeptidesOfProtein
extends AbstractDataBox {
    private long m_proteinMatchCurId = -1L;
    private boolean m_mergedData;
    private Long m_previousTaskId = null;

    public DataboxRsetPeptidesOfProtein() {
        this(false);
    }

    public DataboxRsetPeptidesOfProtein(boolean mergedData) {
        super(AbstractDataBox.DataboxType.DataboxRsetPeptidesOfProtein, AbstractDataBox.DataboxStyle.STYLE_RSET);
        this.m_mergedData = mergedData;
        this.m_typeName = "Peptides";
        this.m_description = "All Peptides of a Protein Match";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(DProteinMatch.class);
        inParameter.addParameter(ResultSet.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DPeptideMatch.class);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        PeptideMatchPanel p = new PeptideMatchPanel(false, this.m_mergedData, false, false, false);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        final DProteinMatch proteinMatch = (DProteinMatch)this.getData(DProteinMatch.class);
        ResultSet rset = (ResultSet)this.getData(ResultSet.class);
        if (proteinMatch == null) {
            ((PeptideMatchPanel)this.getDataBoxPanelInterface()).setData(-1L, null, null, true);
            this.m_proteinMatchCurId = -1L;
            return;
        }
        if (this.m_proteinMatchCurId != -1L && proteinMatch.getId() == this.m_proteinMatchCurId) {
            return;
        }
        this.m_proteinMatchCurId = proteinMatch.getId();
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (subTask == null) {
                    DPeptideMatch[] peptideMatchArray = proteinMatch.getPeptideMatches();
                    long[] peptideMatchIdArray = proteinMatch.getPeptideMatchesId();
                    ((PeptideMatchPanel)DataboxRsetPeptidesOfProtein.this.getDataBoxPanelInterface()).setData(taskId, peptideMatchArray, peptideMatchIdArray, finished);
                } else {
                    ((PeptideMatchPanel)DataboxRsetPeptidesOfProtein.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                DataboxRsetPeptidesOfProtein.this.setLoaded(loadingId);
                if (finished) {
                    DataboxRsetPeptidesOfProtein.this.unregisterTask(taskId);
                    DataboxRsetPeptidesOfProtein.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataboxRsetPeptidesOfProtein.this.propagateDataChanged();
                }
            }
        };
        DatabaseLoadPeptideMatchTask task = new DatabaseLoadPeptideMatchTask(callback, this.getProjectId(), rset, proteinMatch);
        Long taskId = task.getId();
        if (this.m_previousTaskId != null) {
            AccessDatabaseThread.getAccessDatabaseThread().abortTask(this.m_previousTaskId);
        }
        this.m_previousTaskId = taskId;
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(DPeptideMatch.class)) {
                return ((PeptideMatchPanel)this.getDataBoxPanelInterface()).getSelectedPeptideMatch();
            }
            if (parameterType.equals(ExtendedTableModelInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
            }
            if (parameterType.equals(CrossSelectionInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public Class[] getDataboxNavigationOutParameterClasses() {
        return new Class[]{DPeptideMatch.class};
    }

    @Override
    public String getDataboxNavigationDisplayValue() {
        Peptide peptide;
        DPeptideMatch p = (DPeptideMatch)this.getData(DPeptideMatch.class);
        if (p != null && (peptide = p.getPeptide()) != null) {
            return peptide.getSequence();
        }
        return null;
    }
}

