/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern.xic;

import fr.proline.core.orm.msi.dto.DMasterQuantPeptide;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DMasterQuantitationChannel;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadXicMasterQuantTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelPeptideMatchPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataboxPSMOfMasterQuantPeptide
extends AbstractDataBox {
    private DDataset m_dataset;
    private DMasterQuantPeptide m_masterQuantPeptide;
    private DQuantitationChannel[] quantitationChannelArray = null;
    private Map<Long, List<Long>> m_peptideMatchIdListPerQC;
    private List<DPeptideMatch> m_peptideMatchList;
    private QuantChannelInfo m_quantChannelInfo;

    public DataboxPSMOfMasterQuantPeptide() {
        super(AbstractDataBox.DataboxType.DataboxPSMOfMasterQuantPeptide, AbstractDataBox.DataboxStyle.STYLE_XIC);
        this.m_typeName = "PSM of Quanti. Peptide";
        this.m_description = "All PSM of a Quanti. Peptide";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(DMasterQuantPeptide.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DPeptideMatch.class);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        QuantChannelPeptideMatchPanel p = new QuantChannelPeptideMatchPanel();
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        this.m_masterQuantPeptide = (DMasterQuantPeptide)this.getData(DMasterQuantPeptide.class);
        this.m_dataset = (DDataset)this.getData(DDataset.class);
        this.m_quantChannelInfo = (QuantChannelInfo)this.getData(QuantChannelInfo.class);
        if (this.m_masterQuantPeptide == null) {
            ((QuantChannelPeptideMatchPanel)this.getDataBoxPanelInterface()).setData(-1L, null, this.m_quantChannelInfo, null, null, true);
            return;
        }
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                List listQuantChannel = new ArrayList();
                if (DataboxPSMOfMasterQuantPeptide.this.m_dataset.getMasterQuantitationChannels() != null && !DataboxPSMOfMasterQuantPeptide.this.m_dataset.getMasterQuantitationChannels().isEmpty()) {
                    DMasterQuantitationChannel masterChannel = (DMasterQuantitationChannel)DataboxPSMOfMasterQuantPeptide.this.m_dataset.getMasterQuantitationChannels().get(0);
                    listQuantChannel = masterChannel.getQuantitationChannels();
                }
                DataboxPSMOfMasterQuantPeptide.this.quantitationChannelArray = new DQuantitationChannel[listQuantChannel.size()];
                listQuantChannel.toArray(DataboxPSMOfMasterQuantPeptide.this.quantitationChannelArray);
                if (subTask == null) {
                    ((QuantChannelPeptideMatchPanel)DataboxPSMOfMasterQuantPeptide.this.getDataBoxPanelInterface()).setData(taskId, DataboxPSMOfMasterQuantPeptide.this.quantitationChannelArray, DataboxPSMOfMasterQuantPeptide.this.m_quantChannelInfo, DataboxPSMOfMasterQuantPeptide.this.m_peptideMatchList, DataboxPSMOfMasterQuantPeptide.this.m_peptideMatchIdListPerQC, finished);
                } else {
                    ((QuantChannelPeptideMatchPanel)DataboxPSMOfMasterQuantPeptide.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                DataboxPSMOfMasterQuantPeptide.this.setLoaded(loadingId);
                if (finished) {
                    DataboxPSMOfMasterQuantPeptide.this.unregisterTask(taskId);
                    DataboxPSMOfMasterQuantPeptide.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataboxPSMOfMasterQuantPeptide.this.propagateDataChanged();
                }
            }
        };
        this.m_peptideMatchList = new ArrayList<DPeptideMatch>();
        this.m_peptideMatchIdListPerQC = new HashMap<Long, List<Long>>();
        DatabaseLoadXicMasterQuantTask task = new DatabaseLoadXicMasterQuantTask(callback);
        task.initLoadPSMForPeptide(this.getProjectId(), this.m_dataset, this.m_masterQuantPeptide, this.m_peptideMatchList, this.m_peptideMatchIdListPerQC);
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(DPeptideMatch.class)) {
                return ((QuantChannelPeptideMatchPanel)this.getDataBoxPanelInterface()).getSelectedPSM();
            }
            if (parameterType.equals(ExtendedTableModelInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
            }
            if (parameterType.equals(CrossSelectionInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }
}

