/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern.xic;

import fr.proline.core.orm.msi.MasterQuantReporterIon;
import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadXicMasterQuantTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.rsmexplorer.gui.xic.QuantPepMatchReporterIonPanel;
import fr.proline.studio.rsmexplorer.gui.xic.XicPeptideIonPanel;
import java.util.ArrayList;
import java.util.List;

public class DataboxXicReporterIon
extends AbstractDataBox {
    private DDataset m_dataset;
    private DMasterQuantPeptideIon m_masterQuantPeptideIon;
    private List<MasterQuantReporterIon> m_masterQuantRepIonsList;
    private QuantChannelInfo m_quantChannelInfo;
    private DDatasetType.QuantitationMethodInfo m_quantMethodInfo;

    public DataboxXicReporterIon() {
        super(AbstractDataBox.DataboxType.DataboxXicReporterIon, AbstractDataBox.DataboxStyle.STYLE_XIC);
        this.m_typeName = "Quanti. PSMs";
        this.m_description = "All Quanti. PSMs of [Quanti. or Peptide Ion]";
        this.m_quantMethodInfo = DDatasetType.QuantitationMethodInfo.ISOBARIC_TAGGING;
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(DDataset.class, ParameterSubtypeEnum.SINGLE_DATA, false);
        inParameter.addParameter(QuantChannelInfo.class, ParameterSubtypeEnum.SINGLE_DATA, false);
        inParameter.addParameter(DMasterQuantPeptideIon.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(ResultSummary.class);
        outParameter.addParameter(DDataset.class);
        outParameter.addParameter(DMasterQuantPeptideIon.class);
        outParameter.addParameter(QuantChannelInfo.class);
        outParameter.addParameter(DPeptideMatch.class);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        outParameter.addParameter(DPeptideMatch.class);
        outParameter.addParameter(DDatasetType.QuantitationMethodInfo.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        QuantPepMatchReporterIonPanel p = new QuantPepMatchReporterIonPanel();
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
        this.getDataBoxPanelInterface().addSingleValue(this.m_quantMethodInfo);
    }

    @Override
    public void dataChanged() {
        final boolean allReporterIons = this.m_previousDataBox == null;
        DMasterQuantPeptideIon oldPSMquant = this.m_masterQuantPeptideIon;
        if (!allReporterIons) {
            this.m_masterQuantPeptideIon = (DMasterQuantPeptideIon)this.m_previousDataBox.getData(DMasterQuantPeptideIon.class);
            this.m_dataset = (DDataset)this.m_previousDataBox.getData(DDataset.class);
            this.m_quantChannelInfo = (QuantChannelInfo)this.m_previousDataBox.getData(QuantChannelInfo.class);
            if (this.m_masterQuantPeptideIon == null || this.m_masterQuantPeptideIon.equals(oldPSMquant)) {
                return;
            }
            this.m_quantMethodInfo = (DDatasetType.QuantitationMethodInfo)this.m_previousDataBox.getData(DDatasetType.QuantitationMethodInfo.class);
        }
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (DataboxXicReporterIon.this.m_dataset != null) {
                    DataboxXicReporterIon.this.linkCache((TransientDataInterface)DataboxXicReporterIon.this.m_dataset.getResultSummary());
                }
                if (subTask == null) {
                    if (allReporterIons) {
                        DataboxXicReporterIon.this.m_quantChannelInfo = new QuantChannelInfo(DataboxXicReporterIon.this.m_dataset);
                    }
                    ((QuantPepMatchReporterIonPanel)DataboxXicReporterIon.this.getDataBoxPanelInterface()).setData(taskId, DataboxXicReporterIon.this.m_quantChannelInfo.getQuantChannels(), DataboxXicReporterIon.this.m_masterQuantRepIonsList, DataboxXicReporterIon.this.m_quantMethodInfo, finished);
                } else {
                    ((QuantPepMatchReporterIonPanel)DataboxXicReporterIon.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                DataboxXicReporterIon.this.setLoaded(loadingId);
                if (finished) {
                    DataboxXicReporterIon.this.unregisterTask(taskId);
                    DataboxXicReporterIon.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataboxXicReporterIon.this.propagateDataChanged();
                }
            }
        };
        this.m_masterQuantRepIonsList = new ArrayList<MasterQuantReporterIon>();
        DatabaseLoadXicMasterQuantTask task = new DatabaseLoadXicMasterQuantTask(callback);
        if (allReporterIons) {
            task.initLoadReporterIons(this.getProjectId(), this.m_dataset, this.m_masterQuantRepIonsList);
        } else {
            task.initLoadReporterIons(this.getProjectId(), this.m_dataset, this.m_masterQuantPeptideIon, this.m_masterQuantRepIonsList);
        }
        this.registerTask((AbstractDatabaseTask)task);
    }

    public void setQuantitationMethodInfo(DDatasetType.QuantitationMethodInfo quantMethodInfo) {
        this.m_quantMethodInfo = quantMethodInfo;
        AbstractDataBox.DataboxStyle databoxStyle = this.m_style = this.m_quantMethodInfo.equals((Object)DDatasetType.QuantitationMethodInfo.SPECTRAL_COUNTING) ? AbstractDataBox.DataboxStyle.STYLE_SC : AbstractDataBox.DataboxStyle.STYLE_XIC;
        if (this.getDataBoxPanelInterface() != null) {
            this.getDataBoxPanelInterface().addSingleValue(this.m_quantMethodInfo);
        }
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        this.m_dataset = (DDataset)data;
        this.dataChanged();
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(ResultSummary.class)) {
                return this.m_dataset.getResultSummary();
            }
            if (parameterType.equals(MasterQuantReporterIon.class)) {
                return ((XicPeptideIonPanel)this.getDataBoxPanelInterface()).getSelectedMasterQuantPeptideIon();
            }
            if (parameterType.equals(QuantChannelInfo.class) && this.m_quantChannelInfo != null) {
                return this.m_quantChannelInfo;
            }
            if (parameterType.equals(DDatasetType.QuantitationMethodInfo.class) && this.m_quantMethodInfo != null) {
                return this.m_quantMethodInfo;
            }
            if (parameterType.equals(DPeptideMatch.class)) {
                DPeptideInstance pi;
                if (this.m_masterQuantPeptideIon != null && (pi = this.m_masterQuantPeptideIon.getPeptideInstance()) == null) {
                    return null;
                }
                return null;
            }
            if (parameterType.equals(DDataset.class)) {
                return this.m_dataset;
            }
            if (parameterType.equals(ExtendedTableModelInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
            }
            if (parameterType.equals(CrossSelectionInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public String getFullName() {
        if (this.m_dataset == null) {
            return super.getFullName();
        }
        return this.m_dataset.getName() + " " + this.getTypeName();
    }

    @Override
    public Class[] getDataboxNavigationOutParameterClasses() {
        Class[] classList = new Class[]{DMasterQuantPeptideIon.class, DPeptideMatch.class};
        return classList;
    }

    @Override
    public String getDataboxNavigationDisplayValue() {
        Peptide peptide;
        DPeptideInstance peptideInstance;
        DMasterQuantPeptideIon peptideIon = (DMasterQuantPeptideIon)this.getData(DMasterQuantPeptideIon.class);
        if (peptideIon != null && (peptideInstance = peptideIon.getPeptideInstance()) != null && (peptide = peptideInstance.getPeptide()) != null) {
            return peptide.getSequence();
        }
        return null;
    }
}

