/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer;

import fr.proline.studio.JavaVersion;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.taskinfo.TaskInfoManager;
import fr.proline.studio.dock.AbstractDockFrame;
import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.dock.container.DocContainerMinimizeZone;
import fr.proline.studio.dock.container.DockComponent;
import fr.proline.studio.dock.container.DockContainer;
import fr.proline.studio.dock.container.DockContainerMulti;
import fr.proline.studio.dock.container.DockContainerRoot;
import fr.proline.studio.dock.container.DockContainerSplit;
import fr.proline.studio.dock.container.DockContainerTab;
import fr.proline.studio.dock.container.DockException;
import fr.proline.studio.dock.container.DockPosition;
import fr.proline.studio.dock.gui.InfoLabel;
import fr.proline.studio.dpm.ServerConnectionManager;
import fr.proline.studio.dpm.task.util.JMSConnectionManager;
import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.rserver.RServerManager;
import fr.proline.studio.rsmexplorer.MzdbFilesTopPanel;
import fr.proline.studio.rsmexplorer.RSMExplorerTopPanel;
import fr.proline.studio.rsmexplorer.TaskLogTopPanel;
import fr.proline.studio.rsmexplorer.actions.AboutAction;
import fr.proline.studio.rsmexplorer.actions.AdminAction;
import fr.proline.studio.rsmexplorer.actions.ChangePasswordAction;
import fr.proline.studio.rsmexplorer.actions.CloseAllDataWindows;
import fr.proline.studio.rsmexplorer.actions.ConnectAction;
import fr.proline.studio.rsmexplorer.actions.DataAnalyzerAction;
import fr.proline.studio.rsmexplorer.actions.DisplayWindow;
import fr.proline.studio.rsmexplorer.actions.ExitAction;
import fr.proline.studio.rsmexplorer.actions.HelpAction;
import fr.proline.studio.rsmexplorer.actions.HelpHowToAction;
import fr.proline.studio.rsmexplorer.actions.HelpProlineAction;
import fr.proline.studio.rsmexplorer.actions.MemoryAction;
import fr.proline.studio.rsmexplorer.actions.ResetWindowsAction;
import fr.proline.studio.rsmexplorer.actions.SettingsAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.ServerConnectionDialog;
import fr.proline.studio.utils.IconManager;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class MainFrame
extends AbstractDockFrame
implements WindowListener {
    private static MainFrame m_singleton = null;
    private DockContainerRoot m_containerRoot = null;
    private DocContainerMinimizeZone m_dockContainerMinimizeZone = null;
    private DockContainerSplit m_mainContainerSplit = null;

    public static MainFrame getInstance() {
        if (m_singleton == null) {
            m_singleton = new MainFrame();
        }
        return m_singleton;
    }

    private MainFrame() {
        super("Proline Studio " + (JavaVersion.isMileStoneVersion() ? JavaVersion.getMilestoneProductVersion() : JavaVersion.getProductVersion()));
        this.setSize(1000, 800);
        this.setIconImage(IconManager.getImage((IconManager.IconType)IconManager.IconType.FRAME_ICON));
        this.setDefaultCloseOperation(0);
        JMenuBar menuBar = this.createMenu();
        this.setJMenuBar(menuBar);
        this.m_containerRoot = new DockContainerRoot();
        try {
            DockContainerTab propertiesAreaTab = new DockContainerTab();
            propertiesAreaTab.setZoneArea("PROPERTIES_AREA");
            DockComponent propertiesComponent = new DockComponent((AbstractTopPanel)RSMExplorerTopPanel.getSingleton(), 2);
            propertiesAreaTab.add(propertiesComponent);
            DockComponent mzdbComponent = new DockComponent((AbstractTopPanel)MzdbFilesTopPanel.getSingleton(), 2);
            propertiesAreaTab.add(mzdbComponent);
            propertiesComponent.toFront();
            this.m_dockContainerMinimizeZone = new DocContainerMinimizeZone();
            this.m_dockContainerMinimizeZone.set((DockContainerMulti)propertiesAreaTab);
            DockContainerTab windowAreaTab = new DockContainerTab();
            windowAreaTab.setZoneArea("WINDOWS_AREA");
            DockComponent logComponent = new DockComponent((AbstractTopPanel)TaskLogTopPanel.getSingleton(), 1);
            windowAreaTab.add(logComponent);
            this.m_mainContainerSplit = new DockContainerSplit();
            this.m_mainContainerSplit.add(true, (DockContainerMulti)this.m_dockContainerMinimizeZone, (DockContainerMulti)windowAreaTab);
            this.m_mainContainerSplit.setCanRemoveChildren(false);
            this.m_containerRoot.add((DockContainer)this.m_mainContainerSplit, new DockPosition(-1));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JSplitPane)MainFrame.this.m_mainContainerSplit.getComponent()).setDividerLocation(300);
                }
            });
        }
        catch (DockException e) {
            System.err.println(e.getMessage());
        }
        this.getContentPane().add(this.m_containerRoot.getMainPanel());
        this.m_containerRoot.getMemoryPanel().setActionListener((ActionListener)new MemoryAction());
        this.addWindowListener(this);
        WindowManager.getDefault().setMainWindow((AbstractDockFrame)this);
    }

    public void alert(InfoLabel.INFO_LEVEL level, String message, Throwable t) {
        this.m_containerRoot.getInfoLabel().setInfo(level, message, t);
    }

    public void alert(InfoLabel.INFO_LEVEL level, Throwable t) {
        this.m_containerRoot.getInfoLabel().setInfo(level, t);
    }

    public void addLog() {
        DockComponent logComponent = new DockComponent((AbstractTopPanel)TaskLogTopPanel.getSingleton(), 1);
        DockContainerTab windowAreaTab = (DockContainerTab)this.m_mainContainerSplit.searchZoneArea("WINDOWS_AREA");
        windowAreaTab.add(logComponent);
    }

    private JMenuBar createMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        menuBar.add(fileMenu);
        JMenuItem menuItem = new JMenuItem(new AdminAction());
        menuItem.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        fileMenu.add(menuItem);
        menuItem = new JMenuItem(ConnectAction.getAction());
        fileMenu.add(menuItem);
        menuItem = new JMenuItem(new ChangePasswordAction());
        fileMenu.add(menuItem);
        menuItem = new JMenuItem(new SettingsAction());
        fileMenu.add(menuItem);
        fileMenu.addSeparator();
        menuItem = new JMenuItem(new ExitAction());
        fileMenu.add(menuItem);
        JMenu windowMenu = new JMenu("Window");
        windowMenu.setMnemonic(87);
        menuBar.add(windowMenu);
        menuItem = new JMenuItem(new DisplayWindow("Projects", RSMExplorerTopPanel.getSingleton()));
        windowMenu.add(menuItem);
        menuItem = new JMenuItem(new DisplayWindow("Ms Files", MzdbFilesTopPanel.getSingleton()));
        windowMenu.add(menuItem);
        menuItem = new JMenuItem(new DisplayWindow("Logs", TaskLogTopPanel.getSingleton()));
        windowMenu.add(menuItem);
        menuItem = new JMenuItem(new DataAnalyzerAction());
        windowMenu.add(menuItem);
        windowMenu.addSeparator();
        menuItem = new JMenuItem(new MemoryAction());
        windowMenu.add(menuItem);
        windowMenu.addSeparator();
        menuItem = new JMenuItem(new ResetWindowsAction());
        windowMenu.add(menuItem);
        menuItem = new JMenuItem(new CloseAllDataWindows());
        windowMenu.add(menuItem);
        JMenu helpMenu = new JMenu("Help");
        menuBar.add(helpMenu);
        menuItem = new JMenuItem(new HelpAction());
        helpMenu.add(menuItem);
        menuItem = new JMenuItem(new HelpHowToAction());
        helpMenu.add(menuItem);
        menuItem = new JMenuItem(new HelpProlineAction());
        helpMenu.add(menuItem);
        helpMenu.addSeparator();
        menuItem = new JMenuItem(new AboutAction());
        helpMenu.add(menuItem);
        return menuBar;
    }

    public void closeWindow(AbstractTopPanel topPanel) {
        DockContainer container = this.m_containerRoot.search(topPanel.getTopPanelIdentifierKey());
        if (container != null) {
            ((DockContainerTab)((DockComponent)container).getParent()).remove(container);
        }
    }

    public void displayWindow(AbstractTopPanel topPanel) {
        DockContainer searchedContainer = this.m_containerRoot.search(topPanel.getTopPanelIdentifierKey());
        if (searchedContainer != null) {
            if (((DockComponent)searchedContainer).canMinimize()) {
                ((DockComponent)searchedContainer).maximize();
            } else {
                searchedContainer.toFront();
            }
        } else {
            DockContainerTab windowAreaTab = (DockContainerTab)this.m_mainContainerSplit.searchZoneArea("WINDOWS_AREA");
            DockComponent component = new DockComponent(topPanel, 1);
            windowAreaTab.add(component);
        }
    }

    public void resetWindows() {
        DockContainerMulti windowsArea = this.m_mainContainerSplit.getRightContainer();
        boolean logsFound = windowsArea.search(TaskLogTopPanel.getSingleton().getTopPanelIdentifierKey()) != null;
        ArrayList componentsList = new ArrayList();
        windowsArea.findAllDockComponents(componentsList);
        for (Object c : componentsList) {
            ((DockContainerTab)c.getParent()).remove((DockContainer)c);
        }
        if (!logsFound) {
            MainFrame f = (MainFrame)WindowManager.getDefault().getMainWindow();
            f.displayWindow(TaskLogTopPanel.getSingleton());
        }
        DockContainerTab windowAreaTab = (DockContainerTab)this.m_mainContainerSplit.searchZoneArea("WINDOWS_AREA");
        for (Object c : componentsList) {
            windowAreaTab.add((DockComponent)c);
        }
        componentsList.clear();
        this.m_dockContainerMinimizeZone.findAllDockComponents(componentsList);
        for (Object c : componentsList) {
            c.maximize();
        }
        for (Object c : componentsList) {
            ((DockContainerTab)c.getParent()).remove((DockContainer)c);
        }
        DockContainerTab propertiesAreaTab = (DockContainerTab)this.m_mainContainerSplit.searchZoneArea("PROPERTIES_AREA");
        for (DockComponent c : componentsList) {
            propertiesAreaTab.add(c);
        }
        DockContainerMulti propertiesArea = this.m_mainContainerSplit.getLeftContainer();
        DockContainer projectsContainer = propertiesArea.search(RSMExplorerTopPanel.getSingleton().getTopPanelIdentifierKey());
        projectsContainer.toFront();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((JSplitPane)MainFrame.this.m_mainContainerSplit.getComponent()).setDividerLocation(300);
            }
        });
    }

    public void closeDataWindows() {
        DockContainerMulti windowsArea = this.m_mainContainerSplit.getRightContainer();
        DockContainer logContainer = windowsArea.search(TaskLogTopPanel.getSingleton().getTopPanelIdentifierKey());
        ArrayList componentsList = new ArrayList();
        windowsArea.findAllDockComponents(componentsList);
        for (DockComponent c : componentsList) {
            if (logContainer != null && logContainer.equals(c)) continue;
            ((DockContainerTab)c.getParent()).remove((DockContainer)c);
            if (!(c.getComponent() instanceof AbstractTopPanel)) continue;
            ((AbstractTopPanel)c.getComponent()).componentClosed();
        }
    }

    public boolean isDisplayed(String windowKey) {
        DockContainer searchedContainer = this.m_containerRoot.search(windowKey);
        return searchedContainer != null;
    }

    public void toFront(String windowKey) {
        DockContainer searchedContainer = this.m_containerRoot.search(windowKey);
        if (searchedContainer != null) {
            searchedContainer.toFront();
        }
    }

    public HashSet<AbstractTopPanel> getTopPanels() {
        HashSet<AbstractTopPanel> set = new HashSet<AbstractTopPanel>();
        this.m_containerRoot.getTopPanels(set);
        return set;
    }

    public void exit() {
        if (TaskInfoManager.getTaskInfoManager().askBeforeExitingApp()) {
            InfoDialog exitDialog = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.WARNING, "Warning", "You should not exit. Important tasks are being done.\nAre you sure you want to exit ?", true);
            exitDialog.setButtonName(0, "Yes");
            exitDialog.setButtonName(1, "No");
            exitDialog.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
            exitDialog.setVisible(true);
            if (exitDialog.getButtonClicked() == 1) {
                return;
            }
        }
        HashSet<AbstractTopPanel> topPanels = this.getTopPanels();
        for (AbstractTopPanel topPanel : topPanels) {
            if (!topPanel.warnBeforeClosing()) continue;
            InfoDialog exitDialog = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.WARNING, "Warning", "You should not exit. A window need an action : " + topPanel.getWarnClosingMessage() + "\nAre you sure you want to exit ?", false);
            exitDialog.setButtonName(0, "Yes");
            exitDialog.setButtonName(1, "No");
            exitDialog.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
            exitDialog.setVisible(true);
            if (exitDialog.getButtonClicked() != 1) continue;
            return;
        }
        RServerManager.getRServerManager().stopRProcess();
        JMSConnectionManager.getJMSConnectionManager().closeConnection();
        System.exit(0);
    }

    @Override
    public void windowOpened(WindowEvent e) {
        Thread t = new Thread(){

            @Override
            public void run() {
                ServerConnectionManager serverConnectionMgr = ServerConnectionManager.getServerConnectionManager();
                while (serverConnectionMgr.isConnectionAsked()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (serverConnectionMgr.isNotConnected() || serverConnectionMgr.isConnectionFailed()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ServerConnectionDialog serverConnectionDialog = ServerConnectionDialog.getDialog((Window)WindowManager.getDefault().getMainWindow());
                            serverConnectionDialog.centerToScreen();
                            serverConnectionDialog.setVisible(true);
                            ServerConnectionManager serciceConnectionMgr = ServerConnectionManager.getServerConnectionManager();
                            if (serciceConnectionMgr.isConnectionDone()) {
                                ProjectExplorerPanel.getProjectExplorerPanel().startLoadingProjects();
                            }
                        }
                    });
                } else if (serverConnectionMgr.isConnectionDone()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProjectExplorerPanel.getProjectExplorerPanel().startLoadingProjects();
                        }
                    });
                }
            }
        };
        t.start();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.exit();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

