/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.DownloadProcessedFileTask;
import fr.proline.studio.dpm.task.jms.ExportDatasetTask;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.dialog.exporter.Export2MzIdentMLDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import java.awt.Window;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportMzIdentMLAction
extends AbstractRSMAction {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");

    public ExportMzIdentMLAction(AbstractTree tree) {
        super("MzIdentML...", tree);
    }

    @Override
    public void actionPerformed(final AbstractNode[] selectedNodes, int x, int y) {
        final Export2MzIdentMLDialog mzIdentDialog = new Export2MzIdentMLDialog((Window)WindowManager.getDefault().getMainWindow(), selectedNodes.length > 1);
        DefaultDialog.ProgressTask task = new DefaultDialog.ProgressTask(){

            public int getMinValue() {
                return 0;
            }

            public int getMaxValue() {
                return 100;
            }

            protected Object doInBackground() throws Exception {
                final AbstractJMSCallback downloadCallback = new AbstractJMSCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success) {
                        if (success) {
                            this.setProgress(100);
                        } else {
                            this.setProgress(100);
                        }
                    }
                };
                final ArrayList _filePath = new ArrayList();
                final ArrayList _jmsNodeId = new ArrayList();
                AbstractJMSCallback exportCallback = new AbstractJMSCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success) {
                        if (success) {
                            Object fileName = mzIdentDialog.getFileName();
                            if (_filePath.size() == 1) {
                                if (!((String)fileName).toLowerCase().endsWith(".mzid")) {
                                    fileName = (String)fileName + ".mzid";
                                }
                                DownloadProcessedFileTask task = new DownloadProcessedFileTask(downloadCallback, (String)fileName, (String)_filePath.get(0), (String)_jmsNodeId.get(0));
                                AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
                            } else {
                                int nb = 0;
                                ArrayList prevName = new ArrayList();
                                for (String fp : _filePath) {
                                    Object fn = FilenameUtils.getBaseName((String)fp);
                                    Object dirName = mzIdentDialog.getFileName();
                                    if (!((String)dirName).endsWith("\\")) {
                                        dirName = (String)dirName + "\\";
                                    }
                                    m_logger.debug(" STEP 1 NEXT EXPORTED FILE " + nb + " => " + (String)fn);
                                    Long dsId = ExportMzIdentMLAction.this.getDatasetId((String)fn);
                                    String dsName = ExportMzIdentMLAction.this.getDatasetName(dsId, selectedNodes);
                                    fn = (String)dirName + dsName + "_" + dsId.toString() + "_" + nb + ".mzid";
                                    m_logger.debug(" STEP 2 NEXT EXPORTED FILE " + nb + " => " + (String)fn);
                                    DownloadProcessedFileTask task = new DownloadProcessedFileTask(downloadCallback, (String)fn, fp, (String)_jmsNodeId.get(nb));
                                    ++nb;
                                    AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
                                }
                            }
                        } else {
                            this.setProgress(100);
                        }
                    }
                };
                ArrayList<DDataset> dsets = new ArrayList<DDataset>();
                for (AbstractNode node : selectedNodes) {
                    dsets.add(((DataSetNode)node).getDataset());
                }
                ExportDatasetTask task = new ExportDatasetTask(exportCallback, dsets, null, _filePath, _jmsNodeId, ExportDatasetTask.ExporterFormat.MZIDENTML, mzIdentDialog.getExportParams());
                AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
                return null;
            }
        };
        mzIdentDialog.setTask(task);
        mzIdentDialog.setLocation(x, y);
        mzIdentDialog.setVisible(true);
    }

    private String getDatasetName(Long dsId, AbstractNode[] selectedNodes) {
        for (AbstractNode node : selectedNodes) {
            if (((DataSetNode)node).getDataset().getId() != dsId.longValue()) continue;
            return ((DataSetNode)node).getDataset().getName();
        }
        return "";
    }

    private Long getDatasetId(String fileName) {
        Long dsId = -1L;
        int id0 = fileName.indexOf("-");
        int id1 = fileName.lastIndexOf("_");
        if (id0 > -1 && id1 > -1 && id0 < id1) {
            String dsIdStr = fileName.substring(id0 + 1, id1);
            try {
                dsId = Long.parseLong(dsIdStr);
            }
            catch (NumberFormatException e) {
                dsId = -1L;
            }
        }
        return dsId;
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes < 1) {
            this.setEnabled(false);
            return;
        }
        for (AbstractNode node : selectedNodes) {
            AbstractNode.NodeTypes nodeType = node.getType();
            if (nodeType != AbstractNode.NodeTypes.DATA_SET && node.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) {
                this.setEnabled(false);
                return;
            }
            if (node.isChanging()) {
                this.setEnabled(false);
                return;
            }
            DataSetNode datasetNode = (DataSetNode)node;
            if (datasetNode.hasResultSummary()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

