/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Aggregation;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.FileUploadTask;
import fr.proline.studio.dpm.task.jms.ImportMaxQuantTask;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.ImportMaxQuantResultDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdProjectIdentificationNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import fr.proline.studio.rsmexplorer.tree.quantitation.QuantitationTree;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;

public class ImportMaxQuantResultJMSAction
extends AbstractRSMAction {
    public ImportMaxQuantResultJMSAction(AbstractTree tree) {
        super("Import MaxQuant Result...", tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        AbstractNode n = selectedNodes[0];
        ImportMaxQuantResultDialog dialog = ImportMaxQuantResultDialog.getDialog((Window)WindowManager.getDefault().getMainWindow());
        dialog.setLocation(x, y);
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            File f;
            int i;
            File[] filePaths = dialog.getFilePaths();
            long instrumentId = dialog.getInstrumentId();
            String accessionRegexp = dialog.getAccessionRegexp();
            Boolean importQuantitation = dialog.getImportQuantitation();
            Project project = null;
            DDataset parentDataset = null;
            boolean isParentAProject = false;
            if (n.getType() == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION) {
                IdProjectIdentificationNode projectNode = (IdProjectIdentificationNode)n;
                project = projectNode.getProject();
                isParentAProject = true;
            } else if (n.getType() == AbstractNode.NodeTypes.DATA_SET) {
                DataSetNode dataSetNode = (DataSetNode)n;
                project = dataSetNode.getDataset().getProject();
                parentDataset = dataSetNode.getDataset();
            }
            ArrayList<DataSetNode> allIdentificationNodes = new ArrayList<DataSetNode>();
            ArrayList<String> allDatasetNames = new ArrayList<String>();
            DefaultTreeModel treeModel = (DefaultTreeModel)IdentificationTree.getCurrentTree().getModel();
            int nbFiles = filePaths.length;
            for (i = 0; i < nbFiles; ++i) {
                f = filePaths[i];
                String datasetName = f.getName();
                int indexOfDot = datasetName.lastIndexOf(46);
                if (indexOfDot != -1) {
                    datasetName = datasetName.substring(0, indexOfDot);
                }
                allDatasetNames.add(datasetName);
                DataSetData identificationData = DataSetData.createTemporaryAggregate((String)datasetName);
                DataSetNode identificationNode = new DataSetNode((AbstractData)identificationData);
                identificationNode.setIsChanging(true);
                allIdentificationNodes.add(identificationNode);
                if (isParentAProject) {
                    treeModel.insertNodeInto(identificationNode, n, n.getChildCount() - 1);
                    continue;
                }
                treeModel.insertNodeInto(identificationNode, n, n.getChildCount());
            }
            for (i = 0; i < nbFiles; ++i) {
                f = filePaths[i];
                this.uploadAndImport(f.getPath(), project, (DataSetNode)allIdentificationNodes.get(i), parentDataset, (String)allDatasetNames.get(i), treeModel, instrumentId, accessionRegexp, importQuantitation);
            }
        }
    }

    private void uploadAndImport(String filePath, final Project project, final DataSetNode identificationNode, final DDataset parentDataset, final String datasetName, final DefaultTreeModel treeModel, final long instrumentId, final String accessionRegexp, final Boolean importQuantitation) {
        final String[] result = new String[1];
        AbstractJMSCallback callback = new AbstractJMSCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success) {
                if (success) {
                    ImportMaxQuantResultJMSAction.this.startImport(project, identificationNode, parentDataset, datasetName, result[0], treeModel, instrumentId, accessionRegexp, importQuantitation);
                } else {
                    treeModel.removeNodeFromParent(identificationNode);
                }
            }
        };
        FileUploadTask task = new FileUploadTask(callback, filePath, result);
        AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
    }

    private void startImport(final Project project, final DataSetNode identificationNode, final DDataset parentDataset, final String datasetName, String canonicalPath, final DefaultTreeModel treeModel, long instrumentId, String accessionRegexp, Boolean importQuantitation) {
        final Object[] _results = new Object[ImportMaxQuantTask.RESULTS_SIZE];
        AbstractJMSCallback callback = new AbstractJMSCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success) {
                if (success) {
                    Map rsmIdByRsId = _results[ImportMaxQuantTask.RESULT_SUMMARY_IDS_MAP] == null ? null : (Map)_results[ImportMaxQuantTask.RESULT_SUMMARY_IDS_MAP];
                    ImportMaxQuantResultJMSAction.this.createDataset(identificationNode, project, parentDataset, datasetName, treeModel, (List)_results[ImportMaxQuantTask.RESULT_SET_IDS_LIST], rsmIdByRsId, this.getTaskInfo());
                    Long quantDatasetId = (Long)_results[ImportMaxQuantTask.QUANTITATION_DATASET_ID];
                    if (quantDatasetId != null) {
                        ImportMaxQuantResultJMSAction.this.createQuantDataset(quantDatasetId);
                    }
                    if (_results[ImportMaxQuantTask.WARNING_MESSAGES] != null && !_results[ImportMaxQuantTask.WARNING_MESSAGES].toString().isEmpty()) {
                        JOptionPane.showMessageDialog(IdentificationTree.getCurrentTree(), _results[ImportMaxQuantTask.WARNING_MESSAGES].toString(), "Warning", 0);
                    }
                } else {
                    treeModel.removeNodeFromParent(identificationNode);
                }
            }
        };
        ImportMaxQuantTask task = new ImportMaxQuantTask(callback, canonicalPath, instrumentId, accessionRegexp, importQuantitation, project.getId(), _results);
        AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes != 1) {
            this.setEnabled(false);
            return;
        }
        AbstractNode node = selectedNodes[0];
        if (node.isChanging()) {
            this.setEnabled(false);
            return;
        }
        if (node.getType() == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION) {
            this.setEnabled(true);
            return;
        }
        if (node.getType() == AbstractNode.NodeTypes.DATA_SET) {
            DataSetNode dataSetNode = (DataSetNode)node;
            this.setEnabled(!dataSetNode.hasResultSet() && !dataSetNode.hasResultSummary());
            return;
        }
        this.setEnabled(false);
    }

    private void createQuantDataset(Long quantDatasetId) {
        QuantitationTree tree = QuantitationTree.getCurrentTree();
        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        DataSetData quantitationData = DataSetData.createTemporaryQuantitation((String)"running import ...");
        DataSetNode quantitationNode = new DataSetNode((AbstractData)quantitationData);
        quantitationNode.setIsChanging(true);
        AbstractNode rootNode = (AbstractNode)treeModel.getRoot();
        treeModel.insertNodeInto(quantitationNode, rootNode, rootNode.getChildCount() - 1);
        tree.expandNodeIfNeeded(rootNode);
        QuantitationTree.getCurrentTree().loadDataSet(quantDatasetId, quantitationNode);
    }

    private void createDataset(final DataSetNode identificationNode, final Project project, DDataset parentDataset, String name, final DefaultTreeModel treeModel, final List resultSetIds, final Map<String, Long> rsmIdByRsId, final TaskInfo taskInfo) {
        identificationNode.setIsChanging(false);
        treeModel.nodeChanged(identificationNode);
        final ArrayList createdDatasetList = new ArrayList();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (success) {
                    DDataset dataset = (DDataset)createdDatasetList.get(0);
                    identificationNode.setIsChanging(false);
                    ((DataSetData)identificationNode.getData()).setDataset(dataset);
                    ImportMaxQuantResultJMSAction.this.createSubDataset(identificationNode, project, dataset, treeModel, resultSetIds, rsmIdByRsId, taskInfo);
                    treeModel.nodeChanged(identificationNode);
                } else {
                    treeModel.removeNodeFromParent(identificationNode);
                }
            }
        };
        DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
        task.initCreateDatasetAggregate(project, parentDataset, Aggregation.ChildNature.BIOLOGICAL_GROUP, name, createdDatasetList);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
    }

    private void createSubDataset(DataSetNode parentNode, Project project, DDataset parentDataset, final DefaultTreeModel treeModel, List resultSetIds, Map<String, Long> rsmIdByRsId, TaskInfo taskInfo) {
        for (int i = 0; i < resultSetIds.size(); ++i) {
            String dsName = parentDataset.getName() + "." + resultSetIds.get(i).toString();
            DataSetData identificationData = DataSetData.createTemporaryIdentification((String)dsName);
            final DataSetNode identificationNode = new DataSetNode((AbstractData)identificationData);
            identificationNode.setIsChanging(true);
            treeModel.insertNodeInto(identificationNode, parentNode, parentNode.getChildCount());
            final ArrayList createdDatasetList = new ArrayList();
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    if (success) {
                        DDataset dataset = (DDataset)createdDatasetList.get(0);
                        identificationNode.setIsChanging(false);
                        ((DataSetData)identificationNode.getData()).setDataset(dataset);
                        treeModel.nodeChanged(identificationNode);
                    } else {
                        treeModel.removeNodeFromParent(identificationNode);
                    }
                }
            };
            DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
            Long rsId = (Long)resultSetIds.get(i);
            Long rmsId = rsmIdByRsId != null && rsmIdByRsId.containsKey(rsId.toString()) ? rsmIdByRsId.get(rsId.toString()) : null;
            task.initCreateDatasetForIdentification(project, parentDataset, Aggregation.ChildNature.SAMPLE_ANALYSIS, dsName, (Long)resultSetIds.get(i), rmsId, createdDatasetList, taskInfo);
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
        }
    }
}

