/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.SpectralCountTask;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.spectralcount.SpectralCountDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import fr.proline.studio.rsmexplorer.tree.quantitation.QuantitationTree;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpectralCountAction
extends AbstractRSMAction {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    public static final String DS_NAME_PROPERTIES = "dsName";
    public static final String DS_DESCRIPTION_PROPERTIES = "dsDescription";
    public static final String DS_LIST_PROPERTIES = "dsList";
    public static final String DS_WEIGHT_LIST_PROPERTIES = "dsWeightList";

    public SpectralCountAction(AbstractTree tree) {
        super("Spectral Counting...", tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        final DataSetNode refDatasetNode = (DataSetNode)selectedNodes[0];
        IdentificationTree childTree = IdentificationTree.getCurrentTree().copyDataSetRootSubTree(refDatasetNode.getDataset(), refDatasetNode.getDataset().getProject().getId());
        final SpectralCountDialog spectralCountDialog = new SpectralCountDialog((Window)WindowManager.getDefault().getMainWindow(), childTree);
        spectralCountDialog.setLocation(x, y);
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                DataSetNode quantitationNode;
                m_logger.debug(" Choose RSM for Weighted SC");
                String qttDSName = "";
                String qttDSDescr = "";
                ArrayList<DDataset> datasetList = new ArrayList<DDataset>();
                ArrayList<DDataset> weightDatasetList = new ArrayList<DDataset>();
                String error = null;
                if (spectralCountDialog.getButtonClicked() == 0) {
                    ArrayList<DataSetNode> selectedDSNodes = spectralCountDialog.getSelectedRSMDSNodeList();
                    for (DataSetNode dataSetNode : selectedDSNodes) {
                        if (!dataSetNode.hasResultSummary()) {
                            error = " Spectral Count is not possible on Search result (" + dataSetNode.getDataset().getName() + ").  Identification Summary should be created first";
                            break;
                        }
                        if (dataSetNode.isChanging()) {
                            error = " Spectral Count is not possible while import or validation is on going. (Search result " + dataSetNode.getDataset().getName() + ")";
                            break;
                        }
                        datasetList.add(dataSetNode.getDataset());
                    }
                    ArrayList<DataSetNode> selectedWeightDSNodes = spectralCountDialog.getSelectedWeightRSMDSNodeList();
                    for (DataSetNode dsNode : selectedWeightDSNodes) {
                        weightDatasetList.add(dsNode.getDataset());
                    }
                } else {
                    return;
                }
                qttDSName = spectralCountDialog.getSpectralCountName();
                qttDSDescr = spectralCountDialog.getSpectralCountDescription();
                if (error != null) {
                    JOptionPane.showMessageDialog(IdentificationTree.getCurrentTree(), error, "Warning", 0);
                    return;
                }
                m_logger.debug(" Will Compute SC on " + datasetList.size() + " RSMs : " + datasetList);
                final Long[] _quantiDatasetId = new Long[1];
                QuantitationTree tree = QuantitationTree.getCurrentTree();
                final DefaultTreeModel defaultTreeModel = (DefaultTreeModel)tree.getModel();
                final DataSetNode[] _quantitationNode = new DataSetNode[1];
                DataSetData quantitationData = DataSetData.createTemporaryQuantitation((String)qttDSName);
                _quantitationNode[0] = quantitationNode = new DataSetNode((AbstractData)quantitationData);
                quantitationNode.setIsChanging(true);
                AbstractNode rootNode = (AbstractNode)defaultTreeModel.getRoot();
                defaultTreeModel.insertNodeInto(quantitationNode, rootNode, rootNode.getChildCount() - 1);
                tree.expandNodeIfNeeded(rootNode);
                AbstractJMSCallback scCallback = new AbstractJMSCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success) {
                        if (success) {
                            m_logger.debug(" SC SUCCESS : " + _quantiDatasetId[0]);
                            QuantitationTree.getCurrentTree().loadDataSet(_quantiDatasetId[0], _quantitationNode[0]);
                        } else {
                            m_logger.debug(" SC ERROR ");
                            defaultTreeModel.removeNodeFromParent(_quantitationNode[0]);
                        }
                    }
                };
                SpectralCountTask task = new SpectralCountTask(scCallback, refDatasetNode.getDataset(), datasetList, weightDatasetList, qttDSName, qttDSDescr, _quantiDatasetId);
                AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
            }
        };
        spectralCountDialog.setVisible(true);
        IdentificationTree.getCurrentTree().loadInBackground(refDatasetNode, callback);
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        if (selectedNodes.length != 1) {
            this.setEnabled(false);
            return;
        }
        AbstractNode node = selectedNodes[0];
        if (node.isChanging()) {
            this.setEnabled(false);
            return;
        }
        if (node.getType() != AbstractNode.NodeTypes.DATA_SET) {
            this.setEnabled(false);
            return;
        }
        DataSetNode datasetNode = (DataSetNode)node;
        if (!datasetNode.hasResultSummary()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

