/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.xic;

import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopPanel;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;

public class DisplayXICProteinSetAction
extends AbstractRSMAction {
    public DisplayXICProteinSetAction(AbstractTree tree) {
        super("Proteins Sets", tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        int nbNodes = selectedNodes.length;
        for (int i = 0; i < nbNodes; ++i) {
            DataSetNode dataSetNode = (DataSetNode)selectedNodes[i];
            this.actionImpl(dataSetNode);
        }
    }

    private void actionImpl(DataSetNode dataSetNode) {
        DDataset dataset = ((DataSetData)dataSetNode.getData()).getDataset();
        DDatasetType.QuantitationMethodInfo quantitationMethodInfo = ((DataSetData)dataSetNode.getData()).getDatasetType().getQuantMethodInfo();
        WindowBox wbox = WindowBoxFactory.getQuantificationProteinSetWindowBox(dataset.getName(), dataset.getName() + " Protein Sets", quantitationMethodInfo, dataset.isAggregation());
        wbox.setEntryData(dataset.getProject().getId(), dataset);
        DataBoxViewerTopPanel win = new DataBoxViewerTopPanel(wbox);
        WindowManager.getDefault().getMainWindow().displayWindow((AbstractTopPanel)win);
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        if (selectedNodes.length < 0) {
            this.setEnabled(false);
            return;
        }
        for (int i = 0; i < selectedNodes.length; ++i) {
            AbstractNode node = selectedNodes[i];
            if (node.isChanging()) {
                this.setEnabled(false);
                return;
            }
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET) {
                this.setEnabled(false);
                return;
            }
            DataSetNode datasetNode = (DataSetNode)node;
            if (datasetNode.isQuantitation()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

