/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.xic;

import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopPanel;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;

public class DisplayXICReporterIonAction
extends AbstractRSMAction {
    public DisplayXICReporterIonAction(AbstractTree tree) {
        super("PSMs", tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        int nbNodes = selectedNodes.length;
        for (int i = 0; i < nbNodes; ++i) {
            DataSetNode dataSetNode = (DataSetNode)selectedNodes[i];
            this.actionImpl(dataSetNode);
        }
    }

    private void actionImpl(DataSetNode dataSetNode) {
        DDataset dataset = ((DataSetData)dataSetNode.getData()).getDataset();
        WindowBox wbox = WindowBoxFactory.getQuantificationReporterIonWindowBox(dataset.getName(), dataset.getName() + " PSMs", ((DataSetData)dataSetNode.getData()).getDatasetType().getQuantMethodInfo());
        wbox.setEntryData(dataset.getProject().getId(), dataset);
        DataBoxViewerTopPanel win = new DataBoxViewerTopPanel(wbox);
        WindowManager.getDefault().getMainWindow().displayWindow((AbstractTopPanel)win);
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        if (selectedNodes.length != 1) {
            this.setEnabled(false);
            return;
        }
        AbstractNode anode = selectedNodes[0];
        if (anode.getType() != AbstractNode.NodeTypes.DATA_SET) {
            this.setEnabled(false);
            return;
        }
        DataSetNode node = (DataSetNode)anode;
        if (node.isChanging()) {
            this.setEnabled(false);
            return;
        }
        if (node.getType() != AbstractNode.NodeTypes.DATA_SET) {
            this.setEnabled(false);
            return;
        }
        if (!((DataSetData)node.getData()).getDatasetType().getQuantMethodInfo().equals((Object)DDatasetType.QuantitationMethodInfo.ISOBARIC_TAGGING)) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

