/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public class FilesTransferable
implements Transferable,
Serializable {
    public static final DataFlavor Files_FLAVOR = new DataFlavor(FilesTransferable.class, "Drag and drop Files Selection");
    private static final DataFlavor[] DATA_FLAVORS = new DataFlavor[]{Files_FLAVOR};
    private final ArrayList<File> m_selectedFiles;
    private final SourceFileSystem m_source;

    public FilesTransferable(ArrayList<File> selectedFiles, SourceFileSystem source) {
        this.m_selectedFiles = selectedFiles;
        this.m_source = source;
    }

    public ArrayList<File> getFiles() {
        return this.m_selectedFiles;
    }

    public SourceFileSystem getSource() {
        return this.m_source;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            return this;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return DATA_FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return DATA_FLAVORS[0].equals(flavor);
    }

    public static enum SourceFileSystem {
        SOURCE_LOCAL_FILE_SYSTEM,
        SOURCE_SERVE_FILE_SYSTEM;

    }
}

