/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.studio.export.ExportButton;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelInterface;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.filter.actions.ClearRestrainAction;
import fr.proline.studio.filter.actions.RestrainAction;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.info.InfoInterface;
import fr.proline.studio.info.InfoToggleButton;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.search.SearchToggleButton;
import fr.proline.studio.table.AbstractTableAction;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TablePopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class GenericPanel
extends HourglassPanel
implements DataBoxPanelInterface,
GlobalTabelModelProviderInterface {
    private AbstractDataBox m_dataBox;
    private SettingsButton m_settingsButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;
    private SearchToggleButton m_searchToggleButton;
    private InfoToggleButton m_infoToggleButton;
    private JScrollPane m_dataScrollPane = new JScrollPane();
    private DataTable m_dataTable;
    private MarkerContainerPanel m_markerContainerPanel;

    public GenericPanel(boolean removeStripAndSort) {
        this.setLayout(new BorderLayout());
        final JPanel resultPanel = this.createResultPanel(removeStripAndSort);
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                resultPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)resultPanel, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.m_infoToggleButton.getInfoPanel(), JLayeredPane.PALETTE_LAYER);
        layeredPane.add((Component)this.m_searchToggleButton.getSearchPanel(), (Object)(JLayeredPane.PALETTE_LAYER + 1));
    }

    private JPanel createResultPanel(boolean removeStripAndSort) {
        JPanel resultPanel = new JPanel();
        resultPanel.setLayout(new BorderLayout());
        resultPanel.setBounds(0, 0, 500, 400);
        JPanel internalPanel = this.initComponents(removeStripAndSort);
        resultPanel.add((Component)internalPanel, "Center");
        JToolBar toolbar = this.initToolbar();
        resultPanel.add((Component)toolbar, "West");
        return resultPanel;
    }

    private JPanel initComponents(boolean removeStripAndSort) {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_dataScrollPane = new JScrollPane();
        this.m_dataTable = new DataTable();
        this.m_dataTable.setModel((TableModel)new CompoundTableModel(null, true));
        if (removeStripAndSort) {
            this.m_dataTable.removeStriping();
            this.m_dataTable.forbidSort(true);
            this.m_dataTable.setRowSorter(null);
        }
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_dataScrollPane, (MarkerComponentInterface)this.m_dataTable);
        this.m_dataScrollPane.setViewportView((Component)((Object)this.m_dataTable));
        this.m_dataTable.setFillsViewportHeight(true);
        this.m_dataTable.setViewport(this.m_dataScrollPane.getViewport());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        return internalPanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        this.m_settingsButton = new SettingsButton((ProgressInterface)this.m_dataTable.getModel(), (SettingsInterface)this.m_dataTable);
        this.m_searchToggleButton = new SearchToggleButton((ProgressInterface)this.m_dataTable, (JXTable)this.m_dataTable, (FilterTableModelInterface)((CompoundTableModel)this.m_dataTable.getModel()));
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_dataTable.getModel())){

            protected void filteringDone() {
                GenericPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                GenericPanel.this.m_dataBox.propagateDataChanged();
                GenericPanel.this.m_infoToggleButton.updateInfo();
            }
        };
        this.m_exportButton = new ExportButton((ProgressInterface)this.m_dataTable.getModel(), "Data", (JXTable)this.m_dataTable);
        this.m_infoToggleButton = new InfoToggleButton((ProgressInterface)this.m_dataTable, (InfoInterface)this.m_dataTable);
        toolbar.add((Component)this.m_searchToggleButton);
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_settingsButton);
        toolbar.add((Component)this.m_exportButton);
        toolbar.add((Component)this.m_infoToggleButton);
        return toolbar;
    }

    public void setData(GlobalTableModelInterface dataInterface) {
        CompoundTableModel model = new CompoundTableModel(dataInterface, true);
        this.m_dataTable.setModel((TableModel)model);
        this.m_settingsButton.setProgressInterface((ProgressInterface)model);
        this.m_filterButton.setModelFilterInterface((FilterTableModelInterface)model);
        this.m_exportButton.setProgressInterface((ProgressInterface)model);
        this.m_searchToggleButton.init((ProgressInterface)this.m_dataTable, (JXTable)this.m_dataTable, (FilterTableModelInterface)model);
        this.m_infoToggleButton.updateInfo();
        this.m_markerContainerPanel.setMaxLineNumber(model.getRowCount());
    }

    public void setMaxLineNumber(int nb) {
        this.m_markerContainerPanel.setMaxLineNumber(nb);
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    @Override
    public void addSingleValue(Object v) {
        GlobalTableModelInterface model = this.getGlobalTableModelInterface();
        if (model != null) {
            this.getGlobalTableModelInterface().addSingleValue(v);
        }
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return ((CompoundTableModel)this.m_dataTable.getModel()).getBaseModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_dataTable;
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        return this.m_dataTable;
    }

    public Object getValue(Class c, boolean isList) {
        return this.m_dataTable.getValue(c, isList);
    }

    private class DataTable
    extends LazyTable
    implements ExportModelInterface,
    InfoInterface {
        public DataTable() {
            super(GenericPanel.this.m_dataScrollPane.getVerticalScrollBar());
            this.setSortable(true);
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        public void dataUpdated() {
        }

        public TablePopupMenu initPopupMenu() {
            TablePopupMenu popupMenu = new TablePopupMenu();
            popupMenu.addAction((AbstractTableAction)new RestrainAction(){

                public void filteringDone() {
                    GenericPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                    GenericPanel.this.m_dataBox.propagateDataChanged();
                }
            });
            popupMenu.addAction((AbstractTableAction)new ClearRestrainAction(){

                public void filteringDone() {
                    GenericPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                    GenericPanel.this.m_dataBox.propagateDataChanged();
                }
            });
            return popupMenu;
        }

        public void prepostPopupMenu() {
        }

        public boolean isLoaded() {
            CompoundTableModel model = (CompoundTableModel)this.getModel();
            return model == null ? false : model.isLoaded();
        }

        public int getLoadingPercentage() {
            return ((CompoundTableModel)this.getModel()).getLoadingPercentage();
        }

        public String getExportRowCell(int row, int col) {
            return ((ExportModelInterface)this.getModel()).getExportRowCell(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(col));
        }

        public ArrayList<ExportFontData> getExportFonts(int row, int col) {
            return ((ExportModelInterface)this.getModel()).getExportFonts(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(col));
        }

        public String getExportColumnName(int col) {
            return ((ExportModelInterface)this.getModel()).getExportColumnName(col);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (e.getValueIsAdjusting()) {
                return;
            }
            CompoundTableModel compoundTableModel = (CompoundTableModel)this.getModel();
            ArrayList extraDataTypeList = compoundTableModel.getExtraDataTypes();
            if (extraDataTypeList != null) {
                for (ExtraDataType extraDataType : extraDataTypeList) {
                    if (!extraDataType.isList()) continue;
                    GenericPanel.this.m_dataBox.addDataChanged(extraDataType.getTypeClass());
                    GenericPanel.this.m_dataBox.propagateDataChanged();
                }
            }
        }

        public Object getValue(Class c, boolean isList) {
            CompoundTableModel compoundTableModel = (CompoundTableModel)this.getModel();
            if (isList) {
                int selectedIndex = this.getSelectionModel().getMinSelectionIndex();
                if (selectedIndex == -1) {
                    return null;
                }
                int indexInModelSelected = this.convertRowIndexToModel(selectedIndex);
                indexInModelSelected = compoundTableModel.convertCompoundRowToBaseModelRow(indexInModelSelected);
                return compoundTableModel.getBaseModel().getRowValue(c, indexInModelSelected);
            }
            return compoundTableModel.getValue(c);
        }

        public String getInfo() {
            int count;
            return count + ((count = this.getModel().getRowCount()) > 1 ? " Rows" : "Row");
        }
    }
}

