/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.studio.export.ExportButton;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.rsmexplorer.gui.MSDiagOutput_AW;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainCategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerItem;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSDiag_BoxAndWhisker
extends HourglassPanel {
    public static final String SERIES_NAME = "Chromatogram";
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private static final long serialVersionUID = 1L;
    private final DefaultBoxAndWhiskerCategoryDataset m_dataSet = new DefaultBoxAndWhiskerCategoryDataset();
    private final JFreeChart m_chart;
    private JPanel m_chromatogragmPanel;
    private final CategoryPlot m_subplot;

    public MSDiag_BoxAndWhisker() {
        NumberAxis rangeAxis = new NumberAxis("");
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BoxAndWhiskerRenderer renderer = new BoxAndWhiskerRenderer();
        renderer.setDefaultToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        renderer.setSeriesFillPaint(0, (Paint)new Color(128, 60, 60));
        renderer.setSeriesOutlinePaint(0, (Paint)new Color(128, 60, 60));
        renderer.setFillBox(false);
        renderer.setSeriesOutlinePaint(0, (Paint)Color.blue);
        renderer.setSeriesOutlineStroke(0, (Stroke)new BasicStroke(2.0f), true);
        renderer.setDefaultOutlinePaint((Paint)Color.blue, true);
        renderer.setItemMargin(0.2);
        renderer.setMaximumBarWidth(1.0);
        renderer.setDefaultLegendShape((Shape)new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0));
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        renderer.setDefaultToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        renderer.setSeriesPaint(0, (Paint)Color.red);
        renderer.setSeriesPaint(0, (Paint)Color.blue);
        renderer.setSeriesPaint(0, (Paint)Color.green);
        this.m_subplot = new CategoryPlot((CategoryDataset)this.m_dataSet, null, (ValueAxis)rangeAxis, (CategoryItemRenderer)renderer);
        this.m_subplot.setDomainGridlinesVisible(true);
        CategoryAxis domainAxis = new CategoryAxis("");
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.7853981633974483));
        CombinedDomainCategoryPlot plot = new CombinedDomainCategoryPlot(domainAxis);
        plot.add(this.m_subplot, 1);
        this.m_chart = new JFreeChart("Combined Chart title", new Font("SansSerif", 1, 12), (Plot)plot, true);
        this.m_chart.setBackgroundPaint((Paint)Color.white);
        TextTitle textTitle = this.m_chart.getTitle();
        textTitle.setFont(textTitle.getFont().deriveFont(0, 10.0f));
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        ChartPanel cp = new ChartPanel(this.m_chart, true){};
        cp.setMinimumDrawWidth(0);
        cp.setMinimumDrawHeight(0);
        cp.setMaximumDrawWidth(Integer.MAX_VALUE);
        cp.setMaximumDrawHeight(Integer.MAX_VALUE);
        this.m_chart.getPlot().setBackgroundPaint((Paint)Color.white);
        this.m_chromatogragmPanel = cp;
        JToolBar toolbar = this.initToolbar();
        this.add(toolbar, "West");
        this.add(this.m_chromatogragmPanel, "Center");
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        ExportButton exportImageButton = new ExportButton("pieChart", this.m_chromatogragmPanel);
        toolbar.add((Component)exportImageButton);
        return toolbar;
    }

    public void setData(MSDiagOutput_AW msdo) {
        this.constructChromatogram(msdo);
    }

    private void constructChromatogram(MSDiagOutput_AW msdo) {
        this.m_dataSet.clear();
        if (msdo == null) {
            return;
        }
        String title = msdo.description;
        this.m_chart.setTitle(title);
        this.m_chart.getPlot().setBackgroundPaint((Paint)Color.white);
        this.m_subplot.getRangeAxis().setLabel(msdo.y_axis_description);
        this.m_chart.getCategoryPlot().getDomainAxis().setLabel(msdo.x_axis_description);
        int nbSeries = msdo.matrix[0].length;
        for (int serie = 1; serie < nbSeries; ++serie) {
            String serieString = msdo.column_names[serie];
            String catString = msdo.matrix[serie][0].toString();
            double mean = (Double)msdo.matrix[serie][3];
            double median = (Double)msdo.matrix[serie][4];
            double q1 = 0.0;
            double q3 = 0.0;
            double minRegularValue = (Double)msdo.matrix[serie][1];
            double maxRegularValue = (Double)msdo.matrix[serie][2];
            double minOutlier = minRegularValue;
            double maxOutlier = maxRegularValue;
            ArrayList listOutliers = new ArrayList(0);
            this.m_dataSet.add(new BoxAndWhiskerItem(mean, median, q1, q3, minRegularValue, maxRegularValue, minOutlier, maxOutlier, listOutliers), (Comparable)((Object)serieString), (Comparable)((Object)catString));
        }
    }
}

