/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.ui.RawFileManager;
import fr.proline.mzscope.ui.RawFilesPanel;
import fr.proline.mzscope.utils.IPopupMenuDelegate;
import fr.proline.studio.NbPreferences;
import fr.proline.studio.pattern.MzScopeWindowBoxManager;
import fr.proline.studio.rsmexplorer.gui.MzScope;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class MzDBFilesPanel
extends JPanel
implements IPopupMenuDelegate {
    private static MzDBFilesPanel m_singleton = null;
    private JPanel m_mzdbPathPanel;
    private JTextField m_mzdbPathField;
    private JButton m_mzdbPathBtn;
    private JFileChooser m_fchooser;
    private Preferences m_preferences;
    private String m_mzdbDir;
    private static final String LAST_DIR = "Last directory";
    private RawFilesPanel m_rawFilesPanel;
    private Map<IRawFile, File> mapFiles;
    private JMenuItem detectPeakelsMI;
    private JMenuItem viewRawFileMI;
    private ActionListener viewRawFileAction;

    public static MzDBFilesPanel getMzdbFilesPanel() {
        if (m_singleton == null) {
            m_singleton = new MzDBFilesPanel();
        }
        return m_singleton;
    }

    public MzDBFilesPanel() {
        this.setLayout(new BorderLayout());
        this.init();
    }

    private void init() {
        this.mapFiles = new HashMap<IRawFile, File>();
        this.m_preferences = NbPreferences.root();
        this.m_mzdbDir = this.m_preferences.get("mzdbDirectory", null);
        File dir = new File(".");
        if (this.m_mzdbDir != null) {
            dir = new File(this.m_mzdbDir);
        }
        this.m_fchooser = new JFileChooser();
        this.m_fchooser.setCurrentDirectory(dir);
        this.m_fchooser.setDialogTitle("Mzdb local directory");
        this.m_fchooser.setFileSelectionMode(1);
        this.m_fchooser.setAcceptAllFileFilterUsed(false);
        this.add((Component)this.getMzdbPathPanel(), "North");
        this.add((Component)this.getRawFilesPanel(), "Center");
        this.setRawFiles();
    }

    private JPanel getMzdbPathPanel() {
        if (this.m_mzdbPathPanel == null) {
            this.m_mzdbPathPanel = new JPanel();
            this.m_mzdbPathPanel.setName("m_mzdbPathPanel");
            this.m_mzdbPathPanel.setLayout(new GridBagLayout());
            this.m_mzdbPathPanel.setBorder(BorderFactory.createTitledBorder("Mzdb local directory"));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(5, 5, 5, 5);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            c.weightx = 2.0;
            this.m_mzdbPathPanel.add((Component)this.getFieldMzdbPath(), c);
            c.gridx += 2;
            c.gridwidth = 1;
            c.weightx = 1.0;
            this.m_mzdbPathPanel.add((Component)this.getBtnMzdbPath(), c);
        }
        return this.m_mzdbPathPanel;
    }

    private JTextField getFieldMzdbPath() {
        if (this.m_mzdbPathField == null) {
            this.m_mzdbPathField = new JTextField(30);
            this.m_mzdbPathField.setText(this.m_mzdbDir);
            this.m_mzdbPathField.setEditable(false);
        }
        return this.m_mzdbPathField;
    }

    private JButton getBtnMzdbPath() {
        if (this.m_mzdbPathBtn == null) {
            this.m_mzdbPathBtn = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.OPEN_FILE));
            this.m_mzdbPathBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int result = MzDBFilesPanel.this.m_fchooser.showOpenDialog(MzDBFilesPanel.this.m_mzdbPathBtn);
                    if (result == 0) {
                        MzDBFilesPanel.this.updateMzdbDir(MzDBFilesPanel.this.m_fchooser.getSelectedFile().getAbsolutePath());
                    }
                }
            });
        }
        return this.m_mzdbPathBtn;
    }

    private RawFilesPanel getRawFilesPanel() {
        if (this.m_rawFilesPanel == null) {
            this.m_rawFilesPanel = new RawFilesPanel((IPopupMenuDelegate)this);
            this.m_rawFilesPanel.setName("m_rawFilesPanel");
        }
        return this.m_rawFilesPanel;
    }

    public void updateMzdbDir(String directory) {
        this.m_mzdbDir = directory;
        this.m_preferences.put("mzdbDirectory", this.m_mzdbDir);
        this.m_mzdbPathField.setText(directory);
        this.setRawFiles();
    }

    private void setRawFiles() {
        File mzdbDir;
        File[] list;
        this.m_rawFilesPanel.removeAllFiles();
        RawFileManager.getInstance().removeAllFiles();
        this.mapFiles = new HashMap<IRawFile, File>();
        if (this.m_mzdbDir != null && (list = (mzdbDir = new File(this.m_mzdbDir)).listFiles()) != null) {
            for (File f : list) {
                if (!this.isMzdbFile(f)) continue;
                IRawFile rawfile = RawFileManager.getInstance().addRawFile(f);
                this.m_rawFilesPanel.addFile(rawfile);
                this.mapFiles.put(rawfile, f);
            }
        }
    }

    private boolean isMzdbFile(File f) {
        return f.getName().toLowerCase().endsWith(".mzdb");
    }

    public void displayRaw(IRawFile rawfile) {
        File file = this.mapFiles.get(rawfile);
        if (file != null) {
            MzScope mzScope = new MzScope(1, file);
            MzScopeWindowBoxManager.addMzdbScope(mzScope);
        }
    }

    public void displayRaw(List<IRawFile> rawfiles) {
        ArrayList<File> files = new ArrayList<File>();
        for (IRawFile rawFile : rawfiles) {
            File file = this.mapFiles.get(rawFile);
            files.add(file);
        }
        MzScope mzScope = new MzScope(1, files);
        MzScopeWindowBoxManager.addMzdbScope(mzScope);
    }

    public void detectPeakels(List<IRawFile> rawfiles) {
        ArrayList<File> files = new ArrayList<File>();
        for (IRawFile rawFile : rawfiles) {
            File file = this.mapFiles.get(rawFile);
            files.add(file);
        }
        MzScope mzScope = new MzScope(0, files);
        MzScopeWindowBoxManager.addMzdbScope(mzScope);
    }

    public void initPopupMenu(JPopupMenu popupMenu) {
        this.viewRawFileAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MzDBFilesPanel.this.displayRaw(MzDBFilesPanel.this.getRawFilesPanel().getSelectedValues());
            }
        };
        this.viewRawFileMI = new JMenuItem();
        this.viewRawFileMI.setText("View");
        this.viewRawFileMI.addActionListener(this.viewRawFileAction);
        popupMenu.add(this.viewRawFileMI);
        this.detectPeakelsMI = new JMenuItem();
        this.detectPeakelsMI.setText("Detect Peakels...");
        this.detectPeakelsMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MzDBFilesPanel.this.detectPeakels(MzDBFilesPanel.this.getRawFilesPanel().getSelectedValues());
            }
        });
        popupMenu.add(this.detectPeakelsMI);
    }

    public void updatePopupMenu() {
        int nbS = this.getRawFilesPanel().getSelectedValues().size();
        this.viewRawFileMI.setEnabled(nbS > 0);
        this.detectPeakelsMI.setEnabled(nbS > 0);
    }

    public ActionListener getDefaultAction() {
        return this.viewRawFileAction;
    }
}

