/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.core.orm.msi.dto.DMasterQuantPeptide;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.data.ptm.PTMCluster;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.AddDataAnalyzerButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.info.InfoInterface;
import fr.proline.studio.info.InfoToggleButton;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataAnalyzerWindowBoxManager;
import fr.proline.studio.pattern.DataBoxPTMPeptides;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.pattern.MsQueryInfoRsm;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.actions.table.DisplayTablePopupMenu;
import fr.proline.studio.rsmexplorer.gui.model.PTMPeptidesTableModel;
import fr.proline.studio.search.SearchToggleButton;
import fr.proline.studio.table.CustomColumnControlButton;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.table.TablePopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTMPeptidesTablePanel
extends HourglassPanel
implements DataBoxPanelInterface,
GlobalTabelModelProviderInterface,
SplittedPanelContainer.ReactiveTabbedComponent {
    protected static final Logger LOG = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer.ptm");
    protected AbstractDataBox m_dataBox;
    private JScrollPane m_ptmPeptidesScrollPane;
    protected PTMPeptidesTable m_ptmPeptidesTable;
    protected PTMPeptidesTableModel m_ptmPeptidesTableModel;
    protected MarkerContainerPanel m_markerContainerPanel;
    private SearchToggleButton m_searchToggleButton;
    private InfoToggleButton m_infoToggleButton;
    private SettingsButton m_settingsButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;
    private AddDataAnalyzerButton m_addCompareDataButton;
    protected List<PTMPeptideInstance> m_ptmPeptideInstances = null;
    private final boolean m_isXICResult;
    private final boolean m_displayPeptidesMatches;
    private boolean m_isDisplayed = true;

    public PTMPeptidesTablePanel(boolean viewAll, boolean isXicResult) {
        this.m_displayPeptidesMatches = viewAll;
        this.m_isXICResult = isXicResult;
        this.initComponents();
    }

    public PTMPeptideInstance getSelectedPTMPeptideInstance() {
        if (this.m_ptmPeptidesTableModel.getRowCount() <= 0) {
            return null;
        }
        PTMPeptidesTableModel.Row row = this.m_ptmPeptidesTableModel.getPTMPeptideInstanceAt(this.getSelectedRowInTableModel());
        return row != null ? row.ptmPeptideInstance : null;
    }

    public DPeptideMatch getSelectedPeptideMatch() {
        if (this.m_ptmPeptidesTableModel.getRowCount() <= 0) {
            return null;
        }
        PTMPeptidesTableModel.Row row = this.m_ptmPeptidesTableModel.getPTMPeptideInstanceAt(this.getSelectedRowInTableModel());
        return row != null ? row.peptideMatch : null;
    }

    public DMasterQuantPeptide getSelectedMasterQuantPeptide() {
        if (this.m_ptmPeptidesTableModel.getRowCount() <= 0) {
            return null;
        }
        return this.m_ptmPeptidesTableModel.getMasterQuantPeptideAt(this.getSelectedRowInTableModel());
    }

    public int getSelectedIndex() {
        if (this.m_ptmPeptidesTableModel.getRowCount() <= 0) {
            return -1;
        }
        return this.getSelectedRowInTableModel();
    }

    private int getSelectedRowInTableModel() {
        int selectedRow = this.m_ptmPeptidesTable.getSelectedRow();
        if (selectedRow == -1) {
            return -1;
        }
        CompoundTableModel compoundTableModel = (CompoundTableModel)this.m_ptmPeptidesTable.getModel();
        selectedRow = this.m_ptmPeptidesTable.convertRowIndexToModel(selectedRow);
        selectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(selectedRow);
        return selectedRow;
    }

    public void setSelectedPeptide(PTMPeptideInstance pep) {
        int index = this.m_ptmPeptidesTableModel.getPeptideInstanceIndex(pep);
        if (index != -1) {
            CompoundTableModel compoundTableModel = (CompoundTableModel)this.m_ptmPeptidesTable.getModel();
            int selectedRow = compoundTableModel.convertBaseModelRowToCompoundRow(index);
            index = this.m_ptmPeptidesTable.convertRowIndexToView(selectedRow);
            this.setSelectedRow(index);
        }
    }

    public void setData(Long taskId, List<PTMPeptideInstance> ptmPeptides, List<PTMCluster> ptmClusters, Map<Long, DMasterQuantPeptide> quantPeptidesByPepInsId, boolean finished) {
        if (Objects.equals(ptmPeptides, this.m_ptmPeptideInstances)) {
            return;
        }
        this.m_ptmPeptideInstances = ptmPeptides;
        int previousPtmSitesColumnCount = this.m_ptmPeptidesTableModel.getPtmSitesColumnCount();
        List<Boolean> prevColumnsVisibility = this.m_ptmPeptidesTable.getColumns(true).stream().map(tc -> ((TableColumnExt)tc).isVisible()).collect(Collectors.toList());
        this.m_ptmPeptidesTableModel.setData(taskId, this.m_ptmPeptideInstances, ptmClusters, quantPeptidesByPepInsId);
        if (this.m_ptmPeptideInstances != null) {
            this.m_ptmPeptidesTable.getSelectionModel().setSelectionInterval(0, 0);
            this.m_markerContainerPanel.setMaxLineNumber(this.m_ptmPeptidesTable.getModel().getRowCount());
        }
        this.m_infoToggleButton.updateInfo();
        if (previousPtmSitesColumnCount != 0) {
            this.restoreColumnsVisibility(prevColumnsVisibility, previousPtmSitesColumnCount);
        } else {
            this.setColumnsDefaultVisibility();
        }
        if (finished) {
            this.m_ptmPeptidesTable.setSortable(true);
        }
    }

    private void restoreColumnsVisibility(List<Boolean> prevColumnsVisibility, int previousPtmSitesColumnCount) {
        int ptmSitesColumnCount = this.m_ptmPeptidesTableModel.getPtmSitesColumnCount();
        List columns = this.m_ptmPeptidesTable.getColumns(true);
        for (int i = 0; i < columns.size(); ++i) {
            if (i <= 9) {
                this.m_ptmPeptidesTable.getColumnExt(this.m_ptmPeptidesTable.convertColumnIndexToView(i)).setVisible(prevColumnsVisibility.get(i).booleanValue());
                continue;
            }
            if (i > 9 + ptmSitesColumnCount) {
                this.m_ptmPeptidesTable.getColumnExt(this.m_ptmPeptidesTable.convertColumnIndexToView(i)).setVisible(prevColumnsVisibility.get(i + (previousPtmSitesColumnCount - ptmSitesColumnCount)).booleanValue());
                continue;
            }
            this.m_ptmPeptidesTable.getColumnExt(this.m_ptmPeptidesTable.convertColumnIndexToView(i)).setVisible(true);
        }
    }

    private void setColumnsDefaultVisibility() {
        List<Integer> listIdsToHide = this.m_ptmPeptidesTableModel.getDefaultColumnsToHide();
        List columns = this.m_ptmPeptidesTable.getColumns(true);
        for (Integer id : listIdsToHide) {
            boolean columnVisible = ((TableColumnExt)columns.get(id)).isVisible();
            if (!columnVisible) continue;
            this.m_ptmPeptidesTable.getColumnExt(this.m_ptmPeptidesTable.convertColumnIndexToView(id)).setVisible(false);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        final JPanel ptmPeptidesPanel = this.createPTMPeptidesPanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                ptmPeptidesPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)ptmPeptidesPanel, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.m_infoToggleButton.getInfoPanel(), JLayeredPane.PALETTE_LAYER);
        layeredPane.add((Component)this.m_searchToggleButton.getSearchPanel(), (Object)(JLayeredPane.PALETTE_LAYER + 1));
        this.setColumnsDefaultVisibility();
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        this.m_exportButton = new ExportButton((ProgressInterface)((CompoundTableModel)this.m_ptmPeptidesTable.getModel()), "PTM Peptides", (JXTable)this.m_ptmPeptidesTable);
        this.m_searchToggleButton = new SearchToggleButton((ProgressInterface)this.m_ptmPeptidesTable, (JXTable)this.m_ptmPeptidesTable, (FilterTableModelInterface)((CompoundTableModel)this.m_ptmPeptidesTable.getModel()));
        this.m_settingsButton = new SettingsButton((ProgressInterface)this.m_ptmPeptidesTable.getModel(), (SettingsInterface)this.m_ptmPeptidesTable);
        this.m_infoToggleButton = new InfoToggleButton((ProgressInterface)this.m_ptmPeptidesTable, (InfoInterface)this.m_ptmPeptidesTable);
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_ptmPeptidesTable.getModel())){

            protected void filteringDone() {
                PTMPeptidesTablePanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                PTMPeptidesTablePanel.this.m_dataBox.propagateDataChanged();
                PTMPeptidesTablePanel.this.m_infoToggleButton.updateInfo();
            }
        };
        this.m_addCompareDataButton = new AddDataAnalyzerButton((ProgressInterface)((CompoundTableModel)this.m_ptmPeptidesTable.getModel())){

            public void actionPerformed() {
                JXTable table = PTMPeptidesTablePanel.this.getGlobalAssociatedTable();
                TableInfo tableInfo = new TableInfo(PTMPeptidesTablePanel.this.m_dataBox.getId(), PTMPeptidesTablePanel.this.m_dataBox.getUserName(), PTMPeptidesTablePanel.this.m_dataBox.getDataName(), PTMPeptidesTablePanel.this.m_dataBox.getTypeName(), table);
                Image i = PTMPeptidesTablePanel.this.m_dataBox.getIcon();
                if (i != null) {
                    tableInfo.setIcon(new ImageIcon(i));
                }
                DataAnalyzerWindowBoxManager.addTableInfo(tableInfo);
            }
        };
        toolbar.add((Component)this.m_searchToggleButton);
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_settingsButton);
        toolbar.add((Component)this.m_exportButton);
        toolbar.add((Component)this.m_addCompareDataButton);
        toolbar.add((Component)this.m_infoToggleButton);
        return toolbar;
    }

    private JPanel createPTMPeptidesPanel() {
        JPanel ptmPeptidesPanel = new JPanel();
        ptmPeptidesPanel.setBounds(0, 0, 500, 400);
        ptmPeptidesPanel.setLayout(new BorderLayout());
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_ptmPeptidesScrollPane = new JScrollPane();
        this.m_ptmPeptidesTable = new PTMPeptidesTable();
        this.m_ptmPeptidesTableModel = new PTMPeptidesTableModel(this.m_ptmPeptidesTable, this.m_isXICResult, this.m_displayPeptidesMatches);
        this.m_ptmPeptidesTable.setModel((TableModel)new CompoundTableModel((GlobalTableModelInterface)this.m_ptmPeptidesTableModel, true));
        CustomColumnControlButton customColumnControl = new CustomColumnControlButton((JXTable)this.m_ptmPeptidesTable);
        this.m_ptmPeptidesTable.setColumnControl((JComponent)customColumnControl);
        this.m_ptmPeptidesTable.getColumnExt(this.m_ptmPeptidesTable.convertColumnIndexToView(0)).setVisible(false);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.m_ptmPeptidesTable.getModel());
        this.m_ptmPeptidesTable.setRowSorter(sorter);
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_ptmPeptidesScrollPane, (MarkerComponentInterface)this.m_ptmPeptidesTable);
        this.m_ptmPeptidesScrollPane.setViewportView((Component)((Object)this.m_ptmPeptidesTable));
        this.m_ptmPeptidesTable.setFillsViewportHeight(true);
        this.m_ptmPeptidesTable.setViewport(this.m_ptmPeptidesScrollPane.getViewport());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        JToolBar toolbar = this.initToolbar();
        ptmPeptidesPanel.add((Component)toolbar, "West");
        ptmPeptidesPanel.add((Component)internalPanel, "Center");
        return ptmPeptidesPanel;
    }

    public void dataUpdated(SubTask subTask, boolean finished) {
        this.m_ptmPeptidesTable.dataUpdated(subTask, finished);
        if (finished) {
            this.m_ptmPeptidesTable.setSortable(true);
        }
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
        this.getGlobalTableModelInterface().addSingleValue(v);
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return (GlobalTableModelInterface)this.m_ptmPeptidesTable.getModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_ptmPeptidesTable;
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        return this.m_ptmPeptidesTable;
    }

    public void setSelectedRow(int i) {
        this.m_ptmPeptidesTable.setRowSelectionInterval(i, i);
    }

    public void setShowed(boolean showed) {
        if (showed == this.m_isDisplayed) {
            return;
        }
        this.m_isDisplayed = showed;
        if (showed && this.m_dataBox instanceof DataBoxPTMPeptides) {
            ((DataBoxPTMPeptides)this.m_dataBox).updateData();
        }
    }

    public boolean isShowed() {
        return this.m_isDisplayed;
    }

    private class PTMPeptidesTable
    extends LazyTable
    implements CrossSelectionInterface,
    InfoInterface,
    ProgressInterface {
        private boolean selectionWillBeRestored;
        private DisplayTablePopupMenu m_popupMenu;

        public PTMPeptidesTable() {
            super(PTMPeptidesTablePanel.this.m_ptmPeptidesScrollPane.getVerticalScrollBar());
            this.selectionWillBeRestored = false;
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (this.selectionWillBeRestored) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            PTMPeptidesTablePanel.this.m_dataBox.addDataChanged(PTMPeptideInstance.class, null);
            PTMPeptidesTablePanel.this.m_dataBox.addDataChanged(DPeptideMatch.class);
            PTMPeptidesTablePanel.this.m_dataBox.addDataChanged(MsQueryInfoRsm.class);
            PTMPeptidesTablePanel.this.m_dataBox.propagateDataChanged();
        }

        public void selectionWillBeRestored(boolean b) {
            this.selectionWillBeRestored = b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataUpdated(SubTask subTask, boolean finished) {
            LazyTable.LastAction keepLastAction = this.m_lastAction;
            try {
                int rowSelected = this.getSelectionModel().getMinSelectionIndex();
                int rowSelectedInModel = rowSelected == -1 ? -1 : this.convertRowIndexToModel(rowSelected);
                this.selectionWillBeRestored(true);
                try {
                    ((PTMPeptidesTableModel)((CompoundTableModel)this.getModel()).getBaseModel()).dataUpdated();
                }
                finally {
                    this.selectionWillBeRestored(false);
                }
                if (rowSelectedInModel != -1) {
                    int rowSelectedInView = this.convertRowIndexToView(rowSelectedInModel);
                    this.setSelection(rowSelectedInView);
                    if ((keepLastAction == LazyTable.LastAction.ACTION_SELECTING || keepLastAction == LazyTable.LastAction.ACTION_SORTING) && subTask.getSubTaskId() == ((CompoundTableModel)this.getModel()).getSubTaskId(this.getSortedColumnIndex())) {
                        this.scrollRowToVisible(rowSelectedInView);
                    }
                }
            }
            finally {
                this.m_lastAction = keepLastAction;
            }
            if (finished) {
                this.setSortable(true);
            }
        }

        public TablePopupMenu initPopupMenu() {
            this.m_popupMenu = new DisplayTablePopupMenu(PTMPeptidesTablePanel.this);
            return this.m_popupMenu;
        }

        public void prepostPopupMenu() {
            this.m_popupMenu.prepostPopupMenu();
        }

        public String getInfo() {
            int count = this.getModel().getRowCount();
            StringBuilder sb = new StringBuilder().append(count);
            if (count > 1) {
                sb.append(" Peptides ");
            } else {
                sb.append(" Peptide ");
            }
            if (PTMPeptidesTablePanel.this.m_displayPeptidesMatches) {
                sb.append("Match ");
            }
            sb.append("for PTM Sites");
            return sb.toString();
        }

        public boolean isLoaded() {
            return PTMPeptidesTablePanel.this.m_dataBox.isLoaded();
        }

        public int getLoadingPercentage() {
            return PTMPeptidesTablePanel.this.m_dataBox.getLoadingPercentage();
        }
    }
}

