/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import com.google.gson.Gson;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.gui.FlipButton;
import fr.proline.studio.rsmexplorer.gui.MSDiagOutput_AW;
import fr.proline.studio.rsmexplorer.gui.MSDiagTable_GenericTable;
import fr.proline.studio.rsmexplorer.gui.MSDiag_BoxChart;
import fr.proline.studio.rsmexplorer.gui.MSDiag_CategoryPlot;
import fr.proline.studio.rsmexplorer.gui.MSDiag_Chromatogram;
import fr.proline.studio.rsmexplorer.gui.MSDiag_PieChart;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsetMSDiagPanel
extends HourglassPanel
implements DataBoxPanelInterface {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private static final long serialVersionUID = 1L;
    private AbstractDataBox m_dataBox;
    public JTabbedPane m_tabbedPane = null;
    public String m_displayType = "default";
    private String m_lastUsedDataContent;
    private JXTable m_table;
    private ExportButton m_exportButton;
    public FlipButton m_flipModeButton;

    public RsetMSDiagPanel(String message) {
        this.setLayout(new BorderLayout());
        this.m_tabbedPane = this.createInternalPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.add(this.m_tabbedPane, "Center");
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
    }

    public final JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        this.m_flipModeButton = new FlipButton("flip button text", this);
        toolbar.add(this.m_flipModeButton);
        return toolbar;
    }

    public final JTabbedPane createInternalPanel() {
        JTabbedPane jtabbedPane = new JTabbedPane();
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridLayout(0, 1));
        internalPanel.setBackground(Color.white);
        return jtabbedPane;
    }

    public void setData(String jsonMessageHashMapJson) {
        this.launchMSDiag(jsonMessageHashMapJson);
        this.m_lastUsedDataContent = jsonMessageHashMapJson;
    }

    public void setDisplayType(String type) {
        this.m_displayType = type;
    }

    private void launchMSDiag(String messageHashMapJson) {
        ImageIcon icon = IconManager.getIcon((IconManager.IconType)IconManager.IconType.CHART_PIE);
        String SERIES_NAME = "MSDiag data";
        if (messageHashMapJson != null && messageHashMapJson.length() != 0 && messageHashMapJson.startsWith("{")) {
            Gson gson = new Gson();
            HashMap msOutputHashMap = new HashMap();
            if ((msOutputHashMap = (HashMap)gson.fromJson(messageHashMapJson, msOutputHashMap.getClass())) != null) {
                MSDiagOutput_AW msOutput;
                Iterator msOutputHashMapIterator = msOutputHashMap.keySet().iterator();
                ArrayList<MSDiagOutput_AW> msdiags = new ArrayList<MSDiagOutput_AW>();
                while (msOutputHashMapIterator.hasNext()) {
                    String msOutputItem = (String)msOutputHashMapIterator.next();
                    msOutput = (MSDiagOutput_AW)gson.fromJson((String)msOutputHashMap.get(msOutputItem), MSDiagOutput_AW.class);
                    if (msOutput == null) continue;
                    msdiags.add(msOutput);
                }
                msdiags.sort((m1, m2) -> m1.getOrder().compareTo(m2.getOrder()));
                for (int i = 0; i < msdiags.size(); ++i) {
                    msOutput = (MSDiagOutput_AW)msdiags.get(i);
                    JScrollPane scrollPane = new JScrollPane();
                    if (this.m_displayType.equals("default")) {
                        switch (msOutput.output_type.value) {
                            case "chromatogram": {
                                MSDiag_Chromatogram m_msdiagChromatogram = new MSDiag_Chromatogram(this);
                                m_msdiagChromatogram.setData(msOutput);
                                scrollPane.setViewportView((Component)((Object)m_msdiagChromatogram));
                                this.m_tabbedPane.addTab(msOutput.description, icon, scrollPane);
                                break;
                            }
                            case "box": {
                                MSDiag_BoxChart m_msdiagBoxChart = new MSDiag_BoxChart(this);
                                m_msdiagBoxChart.setData(msOutput);
                                scrollPane.setViewportView((Component)((Object)m_msdiagBoxChart));
                                this.m_tabbedPane.addTab(msOutput.description, icon, scrollPane);
                                break;
                            }
                            case "categoryplot": {
                                MSDiag_CategoryPlot m_msdiagCategoryPlot = new MSDiag_CategoryPlot(this);
                                m_msdiagCategoryPlot.setData(msOutput);
                                scrollPane.setViewportView((Component)((Object)m_msdiagCategoryPlot));
                                this.m_tabbedPane.addTab(msOutput.description, icon, scrollPane);
                                break;
                            }
                            case "pie": {
                                MSDiag_PieChart m_msdiagPieChart = new MSDiag_PieChart(this);
                                m_msdiagPieChart.setData(msOutput);
                                scrollPane.setViewportView((Component)((Object)m_msdiagPieChart));
                                this.m_tabbedPane.addTab(msOutput.description, icon, scrollPane);
                                break;
                            }
                            default: {
                                MSDiagTable_GenericTable m_msdiagTable = new MSDiagTable_GenericTable(this);
                                m_msdiagTable.setModel((TableModel)((Object)new MSDiagTable_GenericTable.MSdiagTable_GenericTableModel()));
                                ((MSDiagTable_GenericTable.MSdiagTable_GenericTableModel)((Object)m_msdiagTable.getModel())).setData(msOutput);
                                scrollPane.setViewportView((Component)((Object)m_msdiagTable));
                                JPanel localPanel = new JPanel();
                                JToolBar toolbar = this.initToolbar();
                                this.m_flipModeButton.setEnabled(false);
                                toolbar.setFloatable(false);
                                this.m_table = m_msdiagTable;
                                this.m_exportButton = new ExportButton((ProgressInterface)null, "Peptide Match", this.m_table);
                                toolbar.add((Component)this.m_exportButton);
                                localPanel.setLayout(new BorderLayout());
                                localPanel.add((Component)toolbar, "West");
                                localPanel.add((Component)scrollPane, "Center");
                                this.m_tabbedPane.addTab(msOutput.description, icon, localPanel);
                                break;
                            }
                        }
                        continue;
                    }
                    MSDiagTable_GenericTable m_msdiagTable = new MSDiagTable_GenericTable(this);
                    m_msdiagTable.setModel((TableModel)((Object)new MSDiagTable_GenericTable.MSdiagTable_GenericTableModel()));
                    ((MSDiagTable_GenericTable.MSdiagTable_GenericTableModel)((Object)m_msdiagTable.getModel())).setData(msOutput);
                    scrollPane.setViewportView((Component)((Object)m_msdiagTable));
                    JPanel localPanel = new JPanel();
                    JToolBar toolbar = new JToolBar(1);
                    toolbar.setFloatable(false);
                    this.m_table = m_msdiagTable;
                    FlipButton flipModeButton = new FlipButton("flip button text", this);
                    toolbar.add(flipModeButton);
                    this.m_exportButton = new ExportButton((ProgressInterface)null, "Peptide Match", this.m_table);
                    toolbar.add((Component)this.m_exportButton);
                    localPanel.setLayout(new BorderLayout());
                    localPanel.add((Component)toolbar, "West");
                    localPanel.add((Component)scrollPane, "Center");
                    this.m_tabbedPane.addTab(msOutput.description, icon, localPanel);
                }
                this.repaint();
            }
        }
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public static byte[] floatsToBytes(float[] floats) {
        ByteBuffer byteBuf = ByteBuffer.allocate(4 * floats.length).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < floats.length; ++i) {
            byteBuf.putFloat(floats[i]);
        }
        return byteBuf.array();
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public void displayData() {
        this.launchMSDiag(this.m_lastUsedDataContent);
    }
}

