/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.core.orm.msi.SequenceMatchPK;
import fr.proline.core.orm.msi.dto.DInfoPTM;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DPeptidePTM;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewSetting;
import fr.proline.studio.rsmexplorer.gui.renderer.PeptideRenderer;
import fr.proline.studio.utils.CyclicColorPalette;
import fr.proline.studio.utils.DataFormat;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsmProteinAndPeptideOverviewPlotPanel
extends JPanel {
    private static final Logger m_logger = LoggerFactory.getLogger(RsmProteinAndPeptideOverviewPlotPanel.class);
    protected DataBoxPanelInterface m_superCtrl;
    protected HashMap<Integer, ArrayList<DPeptideInstance>> m_postionPeptideMap;
    protected HashMap<Integer, ArrayList<DPeptidePTM>> m_peptidePTMMap;
    protected int m_proteinLength;
    protected String m_proteinSequence;
    protected DPeptideInstance[] m_peptideInstances;
    protected DPeptideInstance m_selectedPeptideInstance;
    protected double m_aaWidth;
    protected double m_aaWidthOriginal;
    protected int m_startPositionProtein = 0;
    protected boolean m_needCreateSequence;
    protected final int m_x0 = 10;
    protected final int m_y0 = 10;
    protected final int m_height = 25;
    protected final int m_bottom_margin = 15;
    protected final int m_ptm_y0 = 20;
    protected final int m_ptm_height = 10;
    protected final int m_protein_y0 = 20;
    protected final int m_protein_height = 10;
    protected final BasicStroke STROKE_PROTEINE_LINE = new BasicStroke(3.0f, 2, 1);
    protected final BasicStroke STROKE_NORMAL = new BasicStroke(2.0f, 2, 1);
    protected final String TITLE = "Protein Sequence Coverage";
    protected final Color SELECTED_COLOR = Color.black;
    protected final Color PEPTIDE_COLOR = CyclicColorPalette.getColor((Color)ViewSetting.PEPTIDE_COLOR, (int)100);
    protected int m_oldWidth;

    public RsmProteinAndPeptideOverviewPlotPanel(DataBoxPanelInterface superCtrl) {
        this.m_superCtrl = superCtrl;
        this.m_needCreateSequence = false;
        this.setLayout(new BorderLayout());
        this.initComponent();
    }

    private void initComponent() {
        this.setBorder(BorderFactory.createTitledBorder("Protein Sequence Coverage"));
        this.m_oldWidth = this.getWidth();
        ProteinMouseAdapter mouseAdapter = new ProteinMouseAdapter();
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseWheelListener(mouseAdapter);
    }

    public void setSelectedPeptide(DPeptideInstance selectedPeptideInstance) {
        this.m_selectedPeptideInstance = selectedPeptideInstance;
    }

    protected int getPosOnProtein(int x) {
        return this.m_startPositionProtein + (int)((double)(x - 10) / this.m_aaWidth);
    }

    public void setEmpty(String proteinName) {
        this.setBorder(BorderFactory.createTitledBorder(proteinName + " Protein Sequence Coverage"));
        this.removeAll();
    }

    public void setData(String proteinName, String sequence, DPeptideInstance selectedPeptide, DPeptideInstance[] peptideInstances) {
        this.m_peptideInstances = peptideInstances;
        String titleComment = "";
        if (sequence == null) {
            this.m_proteinLength = 0;
            titleComment = " (estimated protein length)";
            this.m_needCreateSequence = true;
            this.m_proteinSequence = "";
        } else {
            this.m_proteinLength = sequence.length();
            this.m_proteinSequence = sequence;
            this.m_needCreateSequence = false;
        }
        this.m_selectedPeptideInstance = selectedPeptide;
        this.m_startPositionProtein = 0;
        this.createAADataMap(peptideInstances);
        this.m_aaWidth = this.m_aaWidthOriginal = (double)(this.getWidth() - 20) / (double)this.m_proteinLength;
        String title = proteinName + " Protein Sequence Coverage " + this.m_proteinLength + " amino acid" + titleComment;
        ((TitledBorder)this.getBorder()).setTitle(title);
        this.removeAll();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, 40);
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.setSize(this.getWidth(), 40);
        g.setColor(Color.white);
        Insets i = this.getBorder().getBorderInsets(this);
        g.fillRect(i.left, i.top, this.getWidth() - (i.left + i.right), this.getHeight() - (i.top + i.bottom));
        if (this.getWidth() != this.m_oldWidth && this.m_proteinLength != 0 && this.m_aaWidth == this.m_aaWidthOriginal) {
            this.m_aaWidth = this.m_aaWidthOriginal = (double)(this.getWidth() - 20) / (double)this.m_proteinLength;
            this.m_oldWidth = this.getWidth();
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.m_peptideInstances != null && this.m_peptideInstances.length != 0) {
            this.paintPeptideListOnSequence(g2);
            this.paintPTM(g2);
            this.paintSelectedPeptide(g2);
        }
    }

    protected void paintPTM(Graphics2D g) {
        if (this.m_peptidePTMMap.isEmpty()) {
            return;
        }
        for (Integer i : this.m_peptidePTMMap.keySet()) {
            int x0 = (int)(10.0 + this.m_aaWidth * (double)(i - this.m_startPositionProtein));
            int y0 = 20;
            DPeptidePTM ptm = this.m_peptidePTMMap.get(i).get(0);
            Color color = ViewSetting.getColor(ptm.getIdPtmSpecificity());
            g.setColor(color);
            g.fillRect(x0, y0, (int)(this.m_aaWidth + 1.0), 10);
        }
    }

    protected void paintPeptideListOnSequence(Graphics2D g) {
        if (this.m_peptideInstances == null || this.m_peptideInstances.length == 0) {
            return;
        }
        int startPos = (int)((double)this.m_startPositionProtein * this.m_aaWidth);
        int endPos = (int)((double)(this.m_proteinLength + 1) * this.m_aaWidth);
        g.setColor(Color.LIGHT_GRAY);
        g.setStroke(this.STROKE_PROTEINE_LINE);
        g.drawLine(10 - startPos, 25, 10 - startPos + endPos, 25);
        g.drawLine(10 - startPos, 20, 10 - startPos, 30);
        g.drawLine(10 - startPos + endPos, 20, 10 - startPos + endPos, 30);
        g.setStroke(this.STROKE_NORMAL);
        g.setColor(this.PEPTIDE_COLOR);
        for (DPeptideInstance pep : this.m_peptideInstances) {
            this.fillPeptide(g, pep);
        }
    }

    protected void paintSelectedPeptide(Graphics2D g) {
        g.setColor(this.SELECTED_COLOR);
        if (this.m_selectedPeptideInstance != null) {
            int start = this.m_selectedPeptideInstance.getBestPeptideMatch().getSequenceMatch().getId().getStart();
            int stop = this.m_selectedPeptideInstance.getBestPeptideMatch().getSequenceMatch().getId().getStop();
            int length = stop - start + 1;
            this.drawPeptide(g, start, length);
        }
    }

    protected void drawPeptide(Graphics2D g, int start, int length) {
        int width = (int)((double)length * this.m_aaWidth);
        int x0 = (int)(10.0 + this.m_aaWidth * (double)(start - this.m_startPositionProtein));
        g.drawRoundRect(x0, 20, width, 10, 10, 10);
    }

    protected void fillPeptide(Graphics2D g, DPeptideInstance pep) {
        int start = pep.getBestPeptideMatch().getSequenceMatch().getId().getStart();
        int stop = pep.getBestPeptideMatch().getSequenceMatch().getId().getStop();
        int length = stop - start + 1;
        int width = (int)((double)length * this.m_aaWidth);
        int x0 = (int)(10.0 + this.m_aaWidth * (double)(start - this.m_startPositionProtein));
        g.fillRoundRect(x0, 20, width, 10, 10, 10);
    }

    private String getTooltips(int x, int y) {
        if (this.m_peptidePTMMap == null) {
            return null;
        }
        int positionOnProtein = this.getPosOnProtein(x);
        if (y > 20 && y < 30) {
            List ptms = this.m_peptidePTMMap.get(positionOnProtein);
            if (ptms == null) {
                return this.getToolotipsPeptide(positionOnProtein);
            }
            Object s = "";
            for (DPeptidePTM pep : ptms) {
                DInfoPTM ptmTypeInfo = (DInfoPTM)DInfoPTM.getInfoPTMMap().get(pep.getIdPtmSpecificity());
                int position = positionOnProtein;
                s = (String)s + ptmTypeInfo.toReadablePtmString(position);
            }
            return s;
        }
        return null;
    }

    private String getToolotipsPeptide(int positionOnProtein) {
        List peptides = this.m_postionPeptideMap.get(positionOnProtein);
        Object s = null;
        if (peptides != null) {
            s = s == null ? "" : s;
            for (DPeptideInstance pep : peptides) {
                Long id = pep.getId();
                String sequence = PeptideRenderer.constructPeptideDisplay(pep.getBestPeptideMatch().getPeptide()).replaceAll("<html>", "").replaceAll("</html>", "");
                String score = DataFormat.format((Float)pep.getBestPeptideMatch().getScore(), (int)2);
                SequenceMatchPK pepSequencePK = pep.getBestPeptideMatch().getSequenceMatch().getId();
                String tips = String.format("%d -%s- %d, score: %s", pepSequencePK.getStart(), sequence, pepSequencePK.getStop(), score);
                s = (String)s + tips + "<br>";
            }
            return "<html><body>" + (String)s + "</body></html>";
        }
        return "position: " + positionOnProtein;
    }

    protected void createAADataMap(DPeptideInstance[] peptideInstances) {
        this.m_postionPeptideMap = new HashMap();
        this.m_peptidePTMMap = new HashMap();
        for (DPeptideInstance pep : peptideInstances) {
            int start = 0;
            int stop = 0;
            String pepSequence = "";
            try {
                DPeptideMatch bestPeptideMatch = pep.getBestPeptideMatch();
                if (bestPeptideMatch != null) {
                    start = bestPeptideMatch.getSequenceMatch().getId().getStart();
                    stop = bestPeptideMatch.getSequenceMatch().getId().getStop();
                    try {
                        pepSequence = bestPeptideMatch.getPeptide().getSequence();
                    }
                    catch (Exception e) {
                        m_logger.debug("EEEE Exception get peptide sequence:{}", (Object)e.getMessage());
                    }
                    if (this.m_needCreateSequence) {
                        this.buildSequence(start, stop, pepSequence);
                    }
                    if (stop > this.m_proteinLength) {
                        this.m_proteinLength = stop - 1;
                        m_logger.debug("Protein Sequence Coverage");
                    }
                    for (int i = start; i <= stop; ++i) {
                        ArrayList<DPeptideInstance> pepList = this.m_postionPeptideMap.get(i);
                        pepList = pepList == null ? new ArrayList<DPeptideInstance>() : pepList;
                        pepList.add(pep);
                        this.m_postionPeptideMap.put(i, pepList);
                    }
                }
                Collection allPtm = bestPeptideMatch.getPeptide().getTransientData().getDPeptidePtmMap().values();
                for (DPeptidePTM ptm : allPtm) {
                    int position = (int)ptm.getSeqPosition() + start - 1;
                    ArrayList<Object> ptmList = this.m_peptidePTMMap.get(position);
                    if (ptmList == null) {
                        ptmList = new ArrayList();
                        ptmList.add(ptm);
                        this.m_peptidePTMMap.put(position, ptmList);
                        continue;
                    }
                    boolean isExist = false;
                    long ptmId = ptm.getIdPtmSpecificity();
                    for (DPeptidePTM dPeptidePTM : ptmList) {
                        if (ptmId != dPeptidePTM.getIdPtmSpecificity()) continue;
                        isExist = true;
                    }
                    if (isExist) continue;
                    ptmList.add(ptm);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public String getProteinSequence() {
        return this.m_proteinSequence;
    }

    protected void buildSequence(int start, int stop, String pepSequence) {
        StringBuilder sb = new StringBuilder(this.m_proteinSequence);
        int cLength = pepSequence.length();
        if (start - 1 > sb.length()) {
            for (int i = sb.length(); i < start - 1; ++i) {
                sb.append("-");
            }
            sb.append(pepSequence);
        } else {
            sb.replace(start - 1, start - 1 + cLength, pepSequence);
        }
        this.m_proteinSequence = new String(sb);
        this.m_proteinLength = this.m_proteinSequence.length();
    }

    protected void actionMouseClicked(MouseEvent e) {
    }

    private class ProteinMouseAdapter
    extends MouseAdapter {
        int currentX;
        int currentY;
        int startX;
        int startY;
        ZoomMouseAction _action = null;

        ProteinMouseAdapter() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            String tips = RsmProteinAndPeptideOverviewPlotPanel.this.getTooltips(x, y);
            RsmProteinAndPeptideOverviewPlotPanel.this.setToolTipText(tips);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this._action = null;
            Point point = event.getPoint();
            this.startX = point.x;
            this.startY = point.y;
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            Point p = event.getPoint();
            this.currentX = p.x;
            this.currentY = p.y;
            if (this._action == null) {
                if (event.getButton() == 1) {
                    RsmProteinAndPeptideOverviewPlotPanel.this.actionMouseClicked(event);
                }
                return;
            }
            switch (this._action) {
                case ZOOM_IN: {
                    break;
                }
                case ZOOM_OUT: {
                    double scale = 1.0 + 0.2 * (double)Math.max((this.currentX - this.startX) / 25, 1);
                    this.zoom(this.currentX, scale);
                    break;
                }
                case UN_ZOOM: {
                    RsmProteinAndPeptideOverviewPlotPanel.this.m_startPositionProtein = 0;
                    RsmProteinAndPeptideOverviewPlotPanel.this.m_aaWidth = RsmProteinAndPeptideOverviewPlotPanel.this.m_aaWidthOriginal;
                    RsmProteinAndPeptideOverviewPlotPanel.this.repaint();
                    break;
                }
                case MOVE_HORIZONTAL: {
                    this.move();
                    break;
                }
                default: {
                    throw new AssertionError((Object)this._action.name());
                }
            }
            this.startX = this.currentX;
            this.startY = this.currentY;
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            Point p = event.getPoint();
            this.currentX = p.x;
            this.currentY = p.y;
            if (SwingUtilities.isRightMouseButton(event)) {
                this._action = this.currentX - this.startX < 0 ? ZoomMouseAction.UN_ZOOM : ZoomMouseAction.ZOOM_OUT;
            } else if (SwingUtilities.isLeftMouseButton(event) && Math.abs(this.currentX - this.startX) >= 3) {
                this._action = ZoomMouseAction.MOVE_HORIZONTAL;
            }
            if (this._action == ZoomMouseAction.MOVE_HORIZONTAL) {
                this.move();
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent event) {
            Point p = event.getPoint();
            this.currentX = p.x;
            int nbWheel = event.getWheelRotation();
            double scale = 1.2;
            if (nbWheel < 0) {
                this._action = ZoomMouseAction.ZOOM_OUT;
                this.zoom(this.currentX, scale);
            } else {
                this._action = ZoomMouseAction.ZOOM_IN;
                this.zoom(this.currentX, scale);
            }
        }

        private void zoom(int x, double scale) {
            int startNb = (int)((double)x / RsmProteinAndPeptideOverviewPlotPanel.this.m_aaWidth);
            if (this._action == ZoomMouseAction.ZOOM_OUT) {
                RsmProteinAndPeptideOverviewPlotPanel.this.m_aaWidth *= scale;
            } else if (this._action == ZoomMouseAction.ZOOM_IN) {
                RsmProteinAndPeptideOverviewPlotPanel.this.m_aaWidth /= scale;
                if (RsmProteinAndPeptideOverviewPlotPanel.this.m_aaWidth < RsmProteinAndPeptideOverviewPlotPanel.this.m_aaWidthOriginal) {
                    RsmProteinAndPeptideOverviewPlotPanel.this.m_aaWidth = RsmProteinAndPeptideOverviewPlotPanel.this.m_aaWidthOriginal;
                    RsmProteinAndPeptideOverviewPlotPanel.this.m_startPositionProtein = 0;
                }
            }
            int currentNB = (int)((double)this.currentX / RsmProteinAndPeptideOverviewPlotPanel.this.m_aaWidth);
            RsmProteinAndPeptideOverviewPlotPanel.this.m_startPositionProtein = RsmProteinAndPeptideOverviewPlotPanel.this.m_startPositionProtein + startNb - currentNB;
            if (RsmProteinAndPeptideOverviewPlotPanel.this.m_startPositionProtein < 0) {
                RsmProteinAndPeptideOverviewPlotPanel.this.m_startPositionProtein = 0;
            }
            RsmProteinAndPeptideOverviewPlotPanel.this.repaint();
        }

        private void move() {
            int distance = this.currentX - this.startX;
            int startPosition = RsmProteinAndPeptideOverviewPlotPanel.this.getPosOnProtein(this.startX);
            int currentPosition = RsmProteinAndPeptideOverviewPlotPanel.this.getPosOnProtein(this.currentX);
            distance = currentPosition - startPosition;
            RsmProteinAndPeptideOverviewPlotPanel.this.m_startPositionProtein = Math.min(RsmProteinAndPeptideOverviewPlotPanel.this.m_startPositionProtein - distance, RsmProteinAndPeptideOverviewPlotPanel.this.m_proteinLength - (int)((double)(RsmProteinAndPeptideOverviewPlotPanel.this.getWidth() - 20) / RsmProteinAndPeptideOverviewPlotPanel.this.m_aaWidth));
            RsmProteinAndPeptideOverviewPlotPanel.this.m_startPositionProtein = Math.max(RsmProteinAndPeptideOverviewPlotPanel.this.m_startPositionProtein, 0);
            this.startX = this.currentX;
            this.startY = this.currentY;
            RsmProteinAndPeptideOverviewPlotPanel.this.repaint();
        }
    }

    private static enum ZoomMouseAction {
        ZOOM_IN,
        ZOOM_OUT,
        UN_ZOOM,
        MOVE_HORIZONTAL;

    }
}

