/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc;

import fr.proline.studio.rserver.RServerManager;
import fr.proline.studio.rsmexplorer.gui.calc.DataTree;
import fr.proline.studio.rsmexplorer.gui.calc.DataTreeTransferable;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.UserMacroParser;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractFunction;
import fr.proline.studio.rsmexplorer.gui.calc.graph.DataGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.FunctionGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphicGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.AbstractGraphic;
import fr.proline.studio.rsmexplorer.gui.calc.macros.AbstractMacro;
import fr.proline.studio.table.TableInfo;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;

public class DataTreeTransferHandler
extends TransferHandler {
    private GraphPanel m_graphPanel;

    public DataTreeTransferHandler(GraphPanel panel) {
        this.m_graphPanel = panel;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof DataTree) {
            DataTree tree = (DataTree)c;
            DataTree.DataNode[] selectedNodes = tree.getSelectedNodes();
            int nbSelectedNode = selectedNodes.length;
            for (int i = 0; i < nbSelectedNode; ++i) {
                boolean actionNotAllowed;
                DataTree.DataNode node = selectedNodes[i];
                DataTree.DataNode.DataNodeType nodeType = node.getType();
                if (nodeType != DataTree.DataNode.DataNodeType.VIEW_DATA && nodeType != DataTree.DataNode.DataNodeType.FUNCTION && nodeType != DataTree.DataNode.DataNodeType.GRAPHIC && nodeType != DataTree.DataNode.DataNodeType.MACRO && nodeType != DataTree.DataNode.DataNodeType.USERMACRO) {
                    return null;
                }
                boolean bl = actionNotAllowed = node.isRNeeded() && !RServerManager.getRServerManager().isRStarted();
                if (!actionNotAllowed) continue;
                return null;
            }
            DataTreeTransferable.TransferData data = new DataTreeTransferable.TransferData();
            data.setDataNodes(selectedNodes);
            Integer transferKey = DataTreeTransferable.register(data);
            return new DataTreeTransferable(transferKey);
        }
        return null;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        support.setShowDropLocation(true);
        if (support.isDataFlavorSupported(DataTreeTransferable.DATANODE_FLAVOR)) {
            TransferHandler.DropLocation dropLocation = support.getDropLocation();
            if (dropLocation == null) {
                return false;
            }
            return !(dropLocation instanceof JTree.DropLocation);
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (this.canImport(support)) {
            try {
                DataTreeTransferable transfer = (DataTreeTransferable)support.getTransferable().getTransferData(DataTreeTransferable.DATANODE_FLAVOR);
                DataTreeTransferable.TransferData data = DataTreeTransferable.getData(transfer.getTransferKey());
                DataTree.DataNode[] dataNodes = data.getDataNodes();
                TransferHandler.DropLocation dropLocation = support.getDropLocation();
                Point p = dropLocation.getDropPoint();
                int x = p.x;
                int y = p.y;
                GraphPanel graphPanel = (GraphPanel)support.getComponent();
                for (DataTree.DataNode node : dataNodes) {
                    switch (node.getType()) {
                        case VIEW_DATA: {
                            TableInfo tableInfo = ((DataTree.ViewDataNode)node).getTableInfo();
                            GraphNode graphNode = new DataGraphNode(tableInfo, this.m_graphPanel);
                            graphPanel.addGraphNode(graphNode, x, y);
                            break;
                        }
                        case FUNCTION: {
                            AbstractFunction function = ((DataTree.FunctionNode)node).getFunction().cloneFunction(this.m_graphPanel);
                            GraphNode graphNode = new FunctionGraphNode(function, this.m_graphPanel);
                            graphPanel.addGraphNode(graphNode, x, y);
                            break;
                        }
                        case GRAPHIC: {
                            AbstractGraphic graphic = ((DataTree.GraphicNode)node).getGraphic().cloneGraphic(this.m_graphPanel);
                            GraphNode graphNode = new GraphicGraphNode(this.m_graphPanel, graphic);
                            graphPanel.addGraphNode(graphNode, x, y);
                            break;
                        }
                        case MACRO: {
                            AbstractMacro macro = ((DataTree.MacroNode)node).getMacro();
                            graphPanel.addMacroToGraph(macro, x, y);
                            break;
                        }
                        case USERMACRO: {
                            String macroXML = ((DataTree.UserMacroNode)node).getXMLMacro();
                            try {
                                UserMacroParser.getGraphFileManager().parseFile(macroXML, graphPanel, x, y);
                            }
                            catch (Exception e) {
                                System.out.println(e);
                            }
                            break;
                        }
                    }
                    x += 30;
                    y += 30;
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                return false;
            }
        }
        return false;
    }
}

