/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.functions;

import fr.proline.studio.extendedtablemodel.AbstractJoinDataModel;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.BooleanParameter;
import fr.proline.studio.parameter.DoubleParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.python.data.Table;
import fr.proline.studio.python.interpreter.CalcError;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractFunction;
import fr.proline.studio.rsmexplorer.gui.calc.graph.FunctionGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class DiffFunction
extends AbstractFunction {
    private static final String JOIN_TABLE1_KEY1 = "JOIN_TABLE1_KEY1";
    private static final String JOIN_TABLE2_KEY1 = "JOIN_TABLE2_KEY1";
    private static final String TOLERANCE_KEY1 = "TOLERANCE_KEY1";
    private static final String JOIN_TABLE1_KEY2 = "JOIN_TABLE1_KEY2";
    private static final String JOIN_TABLE2_KEY2 = "JOIN_TABLE2_KEY2";
    private static final String TOLERANCE_KEY2 = "TOLERANCE_KEY2";
    private static final String SOURCE_COL = "SOURCE_COL";
    private ParameterList m_parameterList;
    private ObjectParameter m_paramTable1Key1;
    private ObjectParameter m_paramTable2Key1;
    private DoubleParameter m_tolerance1;
    private ObjectParameter m_paramTable1Key2;
    private ObjectParameter m_paramTable2Key2;
    private DoubleParameter m_tolerance2;
    private BooleanParameter m_addSourceCol;

    public DiffFunction(GraphPanel panel) {
        super(panel, AbstractFunction.FUNCTION_TYPE.DiffFunction);
    }

    @Override
    public void inLinkModified() {
        super.inLinkModified();
        this.m_paramTable1Key1 = null;
        this.m_paramTable2Key1 = null;
        this.m_tolerance1 = null;
        this.m_paramTable1Key2 = null;
        this.m_paramTable2Key2 = null;
        this.m_tolerance2 = null;
        this.m_addSourceCol = null;
    }

    @Override
    public String getName(int index) {
        return "Difference";
    }

    @Override
    public int getNumberOfInParameters() {
        return 2;
    }

    @Override
    public int getNumberOfOutParameters() {
        return 1;
    }

    @Override
    public boolean settingsDone() {
        if (this.m_parameterList == null) {
            return false;
        }
        return this.m_paramTable1Key1 != null && this.m_paramTable2Key1 != null;
    }

    @Override
    public boolean calculationDone() {
        return this.m_globalTableModelInterface != null;
    }

    @Override
    public AbstractFunction cloneFunction(GraphPanel p) {
        DiffFunction clone = new DiffFunction(p);
        clone.cloneInfo(this);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(GraphConnector[] graphObjects, FunctionGraphNode functionGraphNode, ProcessCallbackInterface callback) {
        try {
            if (this.m_globalTableModelInterface != null) {
                return;
            }
            this.setCalculating(true);
            this.setInError(false, null);
            try {
                Table diffTable;
                Table t1 = new Table(graphObjects[0].getGlobalTableModelInterface());
                graphObjects[0].getGlobalTableModelInterface().setName(graphObjects[0].getGraphNode().getDataName());
                Table t2 = new Table(graphObjects[1].getGlobalTableModelInterface());
                graphObjects[1].getGlobalTableModelInterface().setName(graphObjects[1].getGraphNode().getDataName());
                if (this.m_paramTable1Key1 != null && this.m_paramTable2Key1 != null) {
                    Integer table1Key1 = (Integer)this.m_paramTable1Key1.getAssociatedObjectValue();
                    Integer table2Key1 = (Integer)this.m_paramTable2Key1.getAssociatedObjectValue();
                    Double tolerance1 = Double.valueOf(this.m_tolerance1.getStringValue());
                    Integer table1Key2 = (Integer)this.m_paramTable1Key2.getAssociatedObjectValue();
                    Integer table2Key2 = (Integer)this.m_paramTable2Key2.getAssociatedObjectValue();
                    Double tolerance2 = Double.valueOf(this.m_tolerance2.getStringValue());
                    Boolean showSourceColumn = (Boolean)this.m_addSourceCol.getObjectValue();
                    diffTable = Table.diff((Table)t1, (Table)t2, (Integer)table1Key1, (Integer)table2Key1, (Double)tolerance1, (Integer)table1Key2, (Integer)table2Key2, (Double)tolerance2, (Boolean)showSourceColumn);
                } else {
                    diffTable = Table.diff((Table)t1, (Table)t2);
                }
                this.addModel(diffTable.getModel());
            }
            catch (Exception e) {
                this.setInError(new CalcError((Throwable)e, null, -1));
            }
            this.setCalculating(false);
        }
        finally {
            callback.finished(functionGraphNode);
        }
    }

    @Override
    public void askDisplay(FunctionGraphNode functionGraphNode, int index) {
        this.display(functionGraphNode.getPreviousDataName(), this.getName(index), index);
    }

    @Override
    public ArrayList<WindowBox> getDisplayWindowBox(FunctionGraphNode functionGraphNode, int index) {
        return this.getDisplayWindowBoxList(functionGraphNode.getPreviousDataName(), this.getName(index), index);
    }

    @Override
    public void generateDefaultParameters(GraphConnector[] graphObjects) {
        GlobalTableModelInterface modelForDefaultKey = this.getMainGlobalTableModelInterface(0);
        if (modelForDefaultKey == null) {
            Table t1 = new Table(graphObjects[0].getGlobalTableModelInterface());
            Table t2 = new Table(graphObjects[1].getGlobalTableModelInterface());
            Table joinedTable = Table.join((Table)t1, (Table)t2);
            modelForDefaultKey = joinedTable.getModel();
        }
        final GlobalTableModelInterface model1 = graphObjects[0].getGlobalTableModelInterface();
        int nbColumns = model1.getColumnCount();
        int nbColumnsKept = 0;
        for (int i = 0; i < nbColumns; ++i) {
            Class c = model1.getDataColumnClass(i);
            if (!c.equals(String.class) && !c.equals(Integer.class) && !c.equals(Long.class) && !c.equals(Float.class) && !c.equals(Double.class)) continue;
            ++nbColumnsKept;
        }
        Object[] objectArrayTable1Key1 = new Object[nbColumnsKept];
        Object[] associatedObjectArrayTable1Key1 = new Object[nbColumnsKept];
        int iKept = 0;
        for (int i = 0; i < nbColumns; ++i) {
            Class c = model1.getDataColumnClass(i);
            if (!c.equals(String.class) && !c.equals(Integer.class) && !c.equals(Long.class) && !c.equals(Float.class) && !c.equals(Double.class)) continue;
            objectArrayTable1Key1[iKept] = model1.getColumnName(i);
            associatedObjectArrayTable1Key1[iKept] = i;
            ++iKept;
        }
        GlobalTableModelInterface model2 = graphObjects[1].getGlobalTableModelInterface();
        nbColumns = model2.getColumnCount();
        nbColumnsKept = 0;
        for (int i = 0; i < nbColumns; ++i) {
            Class c = model2.getDataColumnClass(i);
            if (!c.equals(String.class) && !c.equals(Integer.class) && !c.equals(Long.class) && !c.equals(Float.class) && !c.equals(Double.class)) continue;
            ++nbColumnsKept;
        }
        Object[] objectArrayTable2Key1 = new Object[nbColumnsKept];
        Object[] associatedObjectArrayTable2Key1 = new Object[nbColumnsKept];
        iKept = 0;
        for (int i = 0; i < nbColumns; ++i) {
            Class c = model2.getDataColumnClass(i);
            if (!c.equals(String.class) && !c.equals(Integer.class) && !c.equals(Long.class) && !c.equals(Float.class) && !c.equals(Double.class)) continue;
            objectArrayTable2Key1[iKept] = model2.getColumnName(i);
            associatedObjectArrayTable2Key1[iKept] = i;
            ++iKept;
        }
        int nb = objectArrayTable1Key1.length;
        Object[] objectArrayTable1Key2 = new Object[nb + 1];
        Object[] associatedObjectArrayTable1Key2 = new Object[nb + 1];
        objectArrayTable1Key2[0] = "<No Second Key>";
        associatedObjectArrayTable1Key2[0] = -1;
        for (int i = 0; i < nb; ++i) {
            objectArrayTable1Key2[i + 1] = objectArrayTable1Key1[i];
            associatedObjectArrayTable1Key2[i + 1] = associatedObjectArrayTable1Key1[i];
        }
        nb = objectArrayTable2Key1.length;
        Object[] objectArrayTable2Key2 = new Object[nb + 1];
        Object[] associatedObjectArrayTable2Key2 = new Object[nb + 1];
        objectArrayTable2Key2[0] = "<No Second Key>";
        associatedObjectArrayTable2Key2[0] = -1;
        for (int i = 0; i < nb; ++i) {
            objectArrayTable2Key2[i + 1] = objectArrayTable2Key1[i];
            associatedObjectArrayTable2Key2[i + 1] = associatedObjectArrayTable2Key1[i];
        }
        this.m_paramTable1Key1 = new ObjectParameter(JOIN_TABLE1_KEY1, graphObjects[0].getFullName() + " Join Column Key 1", new JComboBox<Object>(objectArrayTable1Key1), objectArrayTable1Key1, associatedObjectArrayTable1Key1, ((AbstractJoinDataModel)modelForDefaultKey).getSelectedKey1(), null);
        this.m_paramTable2Key1 = new ObjectParameter(JOIN_TABLE2_KEY1, graphObjects[1].getFullName() + " Join Column Key 1", new JComboBox<Object>(objectArrayTable2Key1), objectArrayTable2Key1, associatedObjectArrayTable2Key1, ((AbstractJoinDataModel)modelForDefaultKey).getSelectedKey2(), null);
        this.m_tolerance1 = new DoubleParameter(TOLERANCE_KEY1, "Tolerance", JTextField.class, Double.valueOf(0.0), Double.valueOf(0.0), null);
        this.m_paramTable1Key2 = new ObjectParameter(JOIN_TABLE1_KEY2, graphObjects[0].getFullName() + " Join Column Key 2", new JComboBox<Object>(objectArrayTable1Key2), objectArrayTable1Key2, associatedObjectArrayTable1Key2, 0, null);
        this.m_paramTable2Key2 = new ObjectParameter(JOIN_TABLE2_KEY2, graphObjects[1].getFullName() + " Join Column Key 2", new JComboBox<Object>(objectArrayTable2Key2), objectArrayTable2Key2, associatedObjectArrayTable2Key2, 0, null);
        this.m_tolerance2 = new DoubleParameter(TOLERANCE_KEY2, "Tolerance 2", JTextField.class, Double.valueOf(0.0), Double.valueOf(0.0), null);
        this.m_addSourceCol = new BooleanParameter(SOURCE_COL, "Add Source Info", JCheckBox.class, Boolean.valueOf(true));
        this.m_parameterList = new ParameterList("Join");
        AbstractLinkedParameters linkedParameters1 = new AbstractLinkedParameters(this.m_parameterList){

            public void valueChanged(String value, Object associatedValue) {
                int index = (Integer)associatedValue;
                Class c = model1.getDataColumnClass(index);
                this.showParameter((AbstractParameter)DiffFunction.this.m_tolerance1, c.equals(Double.class) || c.equals(Float.class));
                this.updateParameterListPanel();
            }
        };
        AbstractLinkedParameters linkedParameters2 = new AbstractLinkedParameters(this.m_parameterList){

            public void valueChanged(String value, Object associatedValue) {
                int index = (Integer)associatedValue;
                if (index == -1) {
                    this.showParameter((AbstractParameter)DiffFunction.this.m_tolerance2, false);
                } else {
                    Class c = model1.getDataColumnClass(index);
                    this.showParameter((AbstractParameter)DiffFunction.this.m_tolerance2, c.equals(Double.class) || c.equals(Float.class));
                }
                this.updateParameterListPanel();
            }
        };
        this.m_parameters = new ParameterList[1];
        this.m_parameters[0] = this.m_parameterList;
        this.m_parameterList.add((Object)this.m_paramTable1Key1);
        this.m_parameterList.add((Object)this.m_paramTable2Key1);
        this.m_parameterList.add((Object)this.m_tolerance1);
        this.m_parameterList.add((Object)this.m_paramTable1Key2);
        this.m_parameterList.add((Object)this.m_paramTable2Key2);
        this.m_parameterList.add((Object)this.m_tolerance2);
        this.m_parameterList.add((Object)this.m_addSourceCol);
        this.m_parameterList.getPanel();
        this.m_paramTable1Key1.addLinkedParameters(linkedParameters1);
        this.m_paramTable1Key2.addLinkedParameters(linkedParameters2);
    }

    @Override
    public ParameterError checkParameters(GraphConnector[] graphObjects) {
        Integer keyTable1Key1 = (Integer)this.m_paramTable1Key1.getAssociatedObjectValue();
        Integer keyTable2Key1 = (Integer)this.m_paramTable2Key1.getAssociatedObjectValue();
        Integer keyTable1Key2 = (Integer)this.m_paramTable1Key2.getAssociatedObjectValue();
        Integer keyTable2Key2 = (Integer)this.m_paramTable2Key2.getAssociatedObjectValue();
        GlobalTableModelInterface modelForDefaultKey = this.getMainGlobalTableModelInterface(0);
        if (modelForDefaultKey == null) {
            Table t1 = new Table(graphObjects[0].getGlobalTableModelInterface());
            Table t2 = new Table(graphObjects[1].getGlobalTableModelInterface());
            Table joinedTable = Table.join((Table)t1, (Table)t2);
            modelForDefaultKey = joinedTable.getModel();
        }
        boolean checkKeys = ((AbstractJoinDataModel)modelForDefaultKey).checkKeys(keyTable1Key1.intValue(), keyTable2Key1.intValue()) && ((AbstractJoinDataModel)modelForDefaultKey).checkKeys(keyTable1Key2.intValue(), keyTable2Key2.intValue());
        ParameterError error = null;
        if (!checkKeys) {
            error = new ParameterError("Selected Keys are not compatible", (JComponent)this.m_parameterList.getPanel());
        }
        return error;
    }

    @Override
    public void userParametersChanged() {
        this.m_globalTableModelInterface = null;
    }
}

