/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataboxManager;
import fr.proline.studio.pattern.ParameterDistance;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.progress.ProgressBarDialog;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.table.DecoratedMarkerTable;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.TablePopupMenu;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class DataBoxChooserDialog
extends DefaultDialog {
    private JTextField m_titleTextField = null;
    private DataBoxTable m_dataBoxTable = null;
    private JRadioButton m_belowRadioButton;
    private JRadioButton m_tabbedRadioButton;
    private JRadioButton m_splittedRadioButton;
    private AbstractDataBox m_previousDatabox = null;

    public DataBoxChooserDialog(Window parent, ArrayList<ParameterList> outParameters, boolean firstView) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setSize(780, 420);
        this.setButtonVisible(5, false);
        this.setResizable(true);
        TreeMap<ParameterDistance, AbstractDataBox> dataBoxMap = DataboxManager.getDataboxManager().findCompatibleStartingDataboxList(outParameters);
        this.initDialog(dataBoxMap, firstView);
        this.m_previousDatabox = null;
    }

    public DataBoxChooserDialog(Window parent, AbstractDataBox previousDatabox, boolean firstView, Class[] importantInParameter) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setSize(800, 320);
        this.setButtonVisible(5, false);
        TreeMap<ParameterDistance, AbstractDataBox> dataBoxMap = DataboxManager.getDataboxManager().findCompatibleDataboxList(previousDatabox, importantInParameter);
        this.initDialog(dataBoxMap, firstView);
        this.m_previousDatabox = previousDatabox;
    }

    public void pack() {
    }

    private void initDialog(TreeMap<ParameterDistance, AbstractDataBox> dataBoxMap, boolean firstView) {
        this.setTitle(firstView ? "User Defined Window" : "Add a View");
        JPanel internalPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        if (firstView) {
            JPanel windowPanel = this.createWindowPanel();
            internalPanel.add((Component)windowPanel, c);
            ++c.gridy;
        }
        c.weighty = 1.0;
        JPanel viewPanel = this.createViewsPanel(dataBoxMap, firstView);
        internalPanel.add((Component)viewPanel, c);
        this.setInternalComponent(internalPanel);
    }

    private JPanel createWindowPanel() {
        JPanel windowPanel = new JPanel(new GridBagLayout());
        windowPanel.setBorder(BorderFactory.createTitledBorder(" Window Title "));
        JLabel titleLabel = new JLabel("Title : ");
        this.m_titleTextField = new JTextField();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        windowPanel.add((Component)titleLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        windowPanel.add((Component)this.m_titleTextField, c);
        return windowPanel;
    }

    private JPanel createViewsPanel(TreeMap<ParameterDistance, AbstractDataBox> dataBoxMap, boolean firstView) {
        JPanel viewPanel = new JPanel(new GridBagLayout());
        viewPanel.setBorder(BorderFactory.createTitledBorder(" Views "));
        JScrollPane scrollPane = new JScrollPane();
        this.m_dataBoxTable = new DataBoxTable();
        this.m_dataBoxTable.setModel((TableModel)((Object)new DataBoxTableModel(dataBoxMap)));
        scrollPane.setViewportView((Component)((Object)this.m_dataBoxTable));
        this.m_dataBoxTable.setFillsViewportHeight(true);
        JLabel positionLabel = null;
        if (!firstView) {
            positionLabel = new JLabel("View Position : ");
            this.m_belowRadioButton = new JRadioButton("Below");
            this.m_belowRadioButton.setSelected(true);
            this.m_tabbedRadioButton = new JRadioButton("Tabbed");
            this.m_splittedRadioButton = new JRadioButton("Splitted");
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_belowRadioButton);
        group.add(this.m_tabbedRadioButton);
        group.add(this.m_splittedRadioButton);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        viewPanel.add((Component)scrollPane, c);
        if (!firstView) {
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.gridx = 0;
            ++c.gridy;
            viewPanel.add((Component)positionLabel, c);
            ++c.gridx;
            viewPanel.add((Component)this.m_belowRadioButton, c);
            ++c.gridx;
            viewPanel.add((Component)this.m_tabbedRadioButton, c);
            ++c.gridx;
            viewPanel.add((Component)this.m_splittedRadioButton, c);
        }
        return viewPanel;
    }

    protected boolean okCalled() {
        if (this.m_titleTextField != null && this.m_titleTextField.getText().trim().length() == 0) {
            this.setStatus(true, "You must fill a Window Title");
            this.highlight(this.m_titleTextField);
            return false;
        }
        int selectedRow = this.m_dataBoxTable.getSelectedRow();
        if (selectedRow == -1) {
            this.setStatus(true, "You must select a View");
            this.highlight((Component)((Object)this.m_dataBoxTable));
            return false;
        }
        if (this.m_previousDatabox != null && !this.m_previousDatabox.isLoaded()) {
            ProgressBarDialog dialog = ProgressBarDialog.getDialog((Window)((Object)this), (ProgressInterface)this.m_previousDatabox, (String)"Data loading", (String)"This functionnality is not available while data is loading. Please Wait.");
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (!dialog.isWaitingFinished()) {
                return false;
            }
        }
        this.m_previousDatabox = null;
        return true;
    }

    public AbstractDataBox getSelectedDataBox() {
        int selectedRow = this.m_dataBoxTable.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        selectedRow = this.m_dataBoxTable.convertRowIndexToModel(selectedRow);
        return ((DataBoxTableModel)((Object)this.m_dataBoxTable.getModel())).getDataBox(selectedRow);
    }

    public String getWndTitle() {
        return this.m_titleTextField.getText();
    }

    public boolean addBelow() {
        return this.m_belowRadioButton.isSelected();
    }

    public boolean addTabbed() {
        return this.m_tabbedRadioButton.isSelected();
    }

    public boolean addSplitted() {
        return this.m_splittedRadioButton.isSelected();
    }

    private class DataBoxTable
    extends DecoratedMarkerTable {
        private String m_previouslySelectedWndTitle = null;

        public DataBoxTable() {
            this.setSelectionMode(0);
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        public void valueChanged(ListSelectionEvent e) {
            String text;
            super.valueChanged(e);
            if (DataBoxChooserDialog.this.m_titleTextField != null && ((text = DataBoxChooserDialog.this.m_titleTextField.getText().trim()).length() == 0 || this.m_previouslySelectedWndTitle != null && text.compareTo(this.m_previouslySelectedWndTitle) == 0)) {
                int selectedRow = this.getSelectedRow();
                if (selectedRow == -1) {
                    return;
                }
                selectedRow = this.convertRowIndexToModel(selectedRow);
                String wndTitle = ((String)this.getModel().getValueAt(selectedRow, 0)).trim();
                DataBoxChooserDialog.this.m_titleTextField.setText(wndTitle);
                this.m_previouslySelectedWndTitle = wndTitle;
            }
        }

        public TablePopupMenu initPopupMenu() {
            return null;
        }

        public void prepostPopupMenu() {
        }
    }

    private static class DataBoxTableModel
    extends DecoratedTableModel {
        public static final int COLTYPE_NAME = 0;
        public static final int COLTYPE_DESCRIPTION = 1;
        private static final String[] columnNames = new String[]{"name", "description"};
        private ArrayList<AbstractDataBox> m_databoxList = null;

        public DataBoxTableModel(TreeMap<ParameterDistance, AbstractDataBox> dataBoxMap) {
            this.m_databoxList = new ArrayList(dataBoxMap.size());
            Iterator<ParameterDistance> it = dataBoxMap.descendingKeySet().iterator();
            while (it.hasNext()) {
                this.m_databoxList.add(dataBoxMap.get(it.next()));
            }
        }

        public AbstractDataBox getDataBox(int row) {
            if (row < 0 || row >= this.m_databoxList.size()) {
                return null;
            }
            return this.m_databoxList.get(row);
        }

        public Class getColumnClass(int col) {
            return String.class;
        }

        public int getRowCount() {
            if (this.m_databoxList == null) {
                return 0;
            }
            return this.m_databoxList.size();
        }

        public int getColumnCount() {
            return columnNames.length;
        }

        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            AbstractDataBox dataBox = this.m_databoxList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return dataBox.getTypeName();
                }
                case 1: {
                    return dataBox.getDescription();
                }
            }
            return null;
        }

        public String getToolTipForHeader(int col) {
            return null;
        }

        public String getTootlTipValue(int row, int col) {
            return null;
        }

        public TableCellRenderer getRenderer(int row, int col) {
            return null;
        }
    }
}

