/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;

public class TreeSelectionDialog
extends DefaultDialog {
    private IdentificationTree m_tree = null;
    private ArrayList<DDataset> m_selectedDatasetList = null;
    private ArrayList<DataSetNode> m_selectedRSMDSNodeList = null;
    private boolean m_userSetSize = false;

    public TreeSelectionDialog(Window parent, IdentificationTree tree, String title) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setButtonVisible(5, false);
        this.setStatusVisible(false);
        this.setResizable(true);
        this.m_tree = tree;
        this.setTitle(title);
        JScrollPane scrollPane = new JScrollPane(tree);
        this.setInternalComponent(scrollPane);
    }

    public TreeSelectionDialog(Window parent, IdentificationTree tree, String title, int width, int height) {
        this(parent, tree, title);
        this.setSize(width, height);
        this.m_userSetSize = true;
    }

    public void pack() {
        if (this.m_userSetSize) {
            return;
        }
        super.pack();
    }

    public void setSelection(ArrayList<ResultSummary> rsmArray) {
        this.m_tree.setSelection(rsmArray);
    }

    public ArrayList<DDataset> getSelectedDatasetList() {
        ArrayList<DDataset> returnedList = this.m_selectedDatasetList;
        this.m_selectedDatasetList = null;
        this.m_selectedRSMDSNodeList = null;
        return returnedList;
    }

    public ArrayList<DataSetNode> getSelectedRSMDSNodeList() {
        ArrayList<DataSetNode> returnedList = this.m_selectedRSMDSNodeList;
        this.m_selectedDatasetList = null;
        this.m_selectedRSMDSNodeList = null;
        return returnedList;
    }

    protected boolean okCalled() {
        TreePath[] paths = this.m_tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            this.showSelectionError();
            return false;
        }
        this.m_selectedDatasetList = new ArrayList();
        this.m_selectedRSMDSNodeList = new ArrayList();
        int size = paths.length;
        for (int i = 0; i < size; ++i) {
            AbstractNode node = (AbstractNode)paths[i].getLastPathComponent();
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET) continue;
            DataSetNode dataSetNode = (DataSetNode)node;
            this.m_selectedDatasetList.add(dataSetNode.getDataset());
            this.m_selectedRSMDSNodeList.add(dataSetNode);
        }
        if (this.m_selectedDatasetList.isEmpty()) {
            this.showSelectionError();
            return false;
        }
        return true;
    }

    protected boolean cancelCalled() {
        this.m_selectedDatasetList = null;
        this.m_selectedRSMDSNodeList = null;
        return true;
    }

    private void showSelectionError() {
        JOptionPane.showMessageDialog(this.m_tree, "You must at least select one Identification Summary.", "Warning", 0);
    }
}

