/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.core.orm.msi.PtmSpecificity;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.QuantitationLabel;
import fr.proline.core.orm.uds.QuantitationMethod;
import fr.proline.core.orm.uds.RawFile;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DMasterQuantitationChannel;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.Exceptions;
import fr.proline.studio.NbPreferences;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.data.RunInfoData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabasePTMsTask;
import fr.proline.studio.dam.tasks.DatabasePeaklistTask;
import fr.proline.studio.dam.tasks.DatabaseRunsTask;
import fr.proline.studio.dam.tasks.DatabaseVerifySpectrumFromResultSets;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dock.gui.InfoLabel;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.RegisterRawFileTask;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.LoadWaitingDialog;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.AbstractParamsPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.CheckDesignTreeDialog;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.IsobaricMethodParamsPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.LabelFreeMSParamsPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.QuantExperimentalDesignPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.ResidueMethodParamsPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.SelectRawFilesPanel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import fr.proline.studio.rsmexplorer.tree.xic.DatasetReferenceNode;
import fr.proline.studio.rsmexplorer.tree.xic.QuantExpDesignTreeListener;
import fr.proline.studio.rsmexplorer.tree.xic.QuantExperimentalDesignTree;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalSampleAnalysisNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICRunNode;
import fr.proline.studio.settings.FilePreferences;
import fr.proline.studio.settings.SettingsDialog;
import fr.proline.studio.settings.SettingsUtils;
import fr.proline.studio.utils.IconManager;
import fr.proline.studio.utils.StudioResourceBundle;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.persistence.EntityManager;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateQuantitationDialog
extends CheckDesignTreeDialog
implements QuantExpDesignTreeListener {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private static final int STEP_PANEL_CREATE_EXPERIMENTAL_DESIGN = 0;
    private static final int STEP_PANEL_QUANT_METHOD_PARAMS = 1;
    private static final int STEP_PANEL_LINK_RAW_FILES = 2;
    private static final int STEP_PANEL_LABEL_FREE_PARAMS = 3;
    private int m_step = 0;
    private static final String SETTINGS_KEY = "XIC";
    private static CreateQuantitationDialog m_singletonDialog = null;
    private AbstractNode m_experimentalDesignNode = null;
    private QuantitationMethod.Type m_quantitationType;
    private DDataset m_refIdentDataset = null;
    private Long m_refResultSummaryId = null;
    private SelectRawFilesPanel m_selectRawFilePanel = null;
    private AbstractParamsPanel m_quantMethodParamsPanel;
    private DatabaseVerifySpectrumFromResultSets m_spectrumTask;
    private List<PtmSpecificity> m_identifiedPtms = null;
    private QuantExperimentalDesignPanel m_experimentalDesignPanel;

    public static CreateQuantitationDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new CreateQuantitationDialog(parent);
        }
        return m_singletonDialog;
    }

    private CreateQuantitationDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Quantitation Wizard");
        this.setDocumentationSuffix("id.3ls5o66");
        this.setSize(1000, 768);
        this.setResizable(true);
    }

    public boolean isMultipleQuantDefined() {
        return this.m_experimentalDesignPanel.isMultiQuantPanel();
    }

    public void initializeExperimentalDesignTree(DDataset existingQuantDataset, DDataset refIdentDataset, IdentificationTree selectionTree, QuantitationMethod.Type quantitationType) {
        QuantExperimentalDesignTree experimentalDesignTree;
        block8: {
            this.m_refIdentDataset = refIdentDataset;
            this.m_identifiedPtms = null;
            this.m_quantitationType = quantitationType;
            DataSetNode rootNode = new DataSetNode((AbstractData)DataSetData.createTemporaryQuantitation((String)"Quant"));
            this.m_experimentalDesignPanel = new QuantExperimentalDesignPanel(rootNode, selectionTree, quantitationType);
            experimentalDesignTree = this.m_experimentalDesignPanel.getExperimentalDesignTree();
            this.m_experimentalDesignPanel.addQuantExpDesignTreeListener(this);
            if (existingQuantDataset != null) {
                AbstractNode firstChildNode;
                QuantExperimentalDesignTree.displayExperimentalDesign(existingQuantDataset, rootNode, experimentalDesignTree, false, false);
                experimentalDesignTree.renameXicTitle(existingQuantDataset.getName() + "-Copy");
                if (rootNode.getChildCount() > 0 && (firstChildNode = (AbstractNode)rootNode.getChildAt(0)) instanceof DatasetReferenceNode && ((DatasetReferenceNode)firstChildNode).isInvalidReference()) {
                    this.m_refResultSummaryId = ((DMasterQuantitationChannel)existingQuantDataset.getMasterQuantitationChannels().get(0)).getIdentResultSummaryId();
                }
                try {
                    Map quantConfig = existingQuantDataset.getQuantProcessingConfigAsMap();
                    if (quantConfig.containsKey("config_version") && quantConfig.get("config_version").equals("3.0")) {
                        LabelFreeMSParamsPanel.getLabelFreeMSQuantParamsPanel().setIsSimplifiedPanel(false);
                        LabelFreeMSParamsPanel.getLabelFreeMSQuantParamsPanel().getParamsPanel().setQuantParams(quantConfig);
                        break block8;
                    }
                    String msg = "Can't clone old quantitation parameters to new one. Default parameters will be used !!";
                    JOptionPane.showMessageDialog((Component)((Object)this), msg, "Clone Error", 0);
                    ParameterList parameterList = LabelFreeMSParamsPanel.getLabelFreeMSQuantParamsPanel().getParamsPanel().getParameterList();
                    parameterList.initDefaults();
                    LabelFreeMSParamsPanel.getLabelFreeMSQuantParamsPanel().setIsSimplifiedPanel(true);
                }
                catch (Exception ex) {
                    LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer").error("Error while setting Quant Param ", (Throwable)ex);
                    WindowManager.getDefault().getMainWindow().alert(InfoLabel.INFO_LEVEL.ERROR, "An error occured while cloning XIC parameters", (Throwable)ex);
                }
            } else if (this.m_refIdentDataset != null) {
                DatasetReferenceNode refDatasetNode = new DatasetReferenceNode((AbstractData)DataSetData.createTemporaryAggregate((String)this.m_refIdentDataset.getName()));
                rootNode.add(refDatasetNode);
            }
        }
        if (this.m_selectRawFilePanel != null) {
            this.m_selectRawFilePanel.resetDropZonePanel();
        }
        this.displayExperimentalDesignPanel((AbstractNode)experimentalDesignTree.getModel().getRoot());
    }

    private void displayExperimentalDesignPanel(AbstractNode rootNode) {
        this.m_experimentalDesignNode = rootNode;
        this.m_step = 0;
        this.setButtonName(0, "Next");
        this.setButtonIcon(0, IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW));
        this.setButtonVisible(3, false);
        this.setButtonVisible(4, false);
        this.setButtonVisible(6, false);
        this.setHelpHeader("<html><b>Step 1:</b> Define the experimental design</html>", "<b>Drag and Drop</b> identification summaries from the right panel to build the experimental design on the left.");
        this.replaceInternalComponent(this.m_experimentalDesignPanel);
        this.revalidate();
        this.repaint();
    }

    private boolean isQuantConfigPanelNeeded() {
        return this.m_quantitationType == QuantitationMethod.Type.LABEL_FREE || this.m_quantMethodParamsPanel != null && (Boolean)this.m_quantMethodParamsPanel.getQuantParams().get("label_free_quant_config") != false;
    }

    protected void displayLinkRawFilesPanel() {
        this.m_step = 2;
        if (this.isQuantConfigPanelNeeded()) {
            this.setButtonName(0, "Next");
            this.setButtonIcon(0, IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW));
        } else {
            this.setButtonName(0, StudioResourceBundle.getMessage(DefaultDialog.class, (String)"DefaultDialog.okButton.text"));
            this.setButtonIcon(0, IconManager.getIcon((IconManager.IconType)IconManager.IconType.OK));
        }
        this.setButtonVisible(3, false);
        this.setButtonVisible(4, false);
        this.setButtonVisible(6, true);
        this.m_selectRawFilePanel = SelectRawFilesPanel.getPanel(this.m_experimentalDesignNode);
        this.setHelpHeader("<html><b>Step 2:</b> Associate MS files to sample analyses.</html>", "Drag and Drop files from the file explorer (right panel) to the drop zone or to the sample analyses table to link files to sample analyses.");
        this.replaceInternalComponent(this.m_selectRawFilePanel);
        this.revalidate();
        this.repaint();
    }

    protected void displayQuantMethodParamsPanel() {
        this.m_step = 1;
        this.setButtonName(0, "Next");
        this.setButtonIcon(0, IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW));
        this.setButtonVisible(3, false);
        this.setButtonVisible(4, false);
        this.setButtonVisible(6, true);
        if (this.m_quantitationType == QuantitationMethod.Type.RESIDUE_LABELING) {
            if (this.m_identifiedPtms == null) {
                final ArrayList ptms = new ArrayList();
                AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                        if (success) {
                            CreateQuantitationDialog.this.m_identifiedPtms = ptms;
                            CreateQuantitationDialog.this.m_quantMethodParamsPanel = new ResidueMethodParamsPanel(CreateQuantitationDialog.this.m_experimentalDesignPanel.getQuantitationMethod(), CreateQuantitationDialog.this.m_identifiedPtms);
                            CreateQuantitationDialog.this.setHelpHeader("<html><b>Step 1.a:</b> Specify residue labeling method parameters.</html>", null);
                            CreateQuantitationDialog.this.replaceInternalComponent(CreateQuantitationDialog.this.m_quantMethodParamsPanel);
                            CreateQuantitationDialog.this.revalidate();
                            CreateQuantitationDialog.this.repaint();
                        }
                    }
                };
                DatabasePTMsTask task = new DatabasePTMsTask(callback);
                if (this.m_refIdentDataset == null) {
                    Long projectId = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject().getId();
                    List<Long> rsmIds = this.m_experimentalDesignPanel.getQuantifiedRsmIds();
                    task.initLoadUsedPTMs(projectId, rsmIds, ptms);
                } else {
                    task.initLoadUsedPTMs(Long.valueOf(this.m_refIdentDataset.getProject().getId()), this.m_refIdentDataset.getResultSummaryId(), ptms);
                }
                AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
            } else {
                this.m_quantMethodParamsPanel = new ResidueMethodParamsPanel(this.m_experimentalDesignPanel.getQuantitationMethod(), this.m_identifiedPtms);
                this.setHelpHeader("<html><b>Step 1.a:</b> Specify residue labeling method parameters.</html>", null);
                this.replaceInternalComponent(this.m_quantMethodParamsPanel);
                this.revalidate();
                this.repaint();
            }
        } else if (this.m_quantitationType == QuantitationMethod.Type.ISOBARIC_TAGGING) {
            if (this.m_quantMethodParamsPanel == null) {
                this.m_quantMethodParamsPanel = new IsobaricMethodParamsPanel(this.m_experimentalDesignPanel.getQuantitationMethod());
            }
            this.setHelpHeader("<html><b>Step 1.a:</b> Specify isobaric quantitation method parameters.</html>", null);
            this.replaceInternalComponent(this.m_quantMethodParamsPanel);
            this.revalidate();
            this.repaint();
        }
    }

    protected void displayLabelFreeParamsPanel() {
        this.m_step = 3;
        this.setButtonName(0, StudioResourceBundle.getMessage(DefaultDialog.class, (String)"DefaultDialog.okButton.text"));
        this.setButtonIcon(0, IconManager.getIcon((IconManager.IconType)IconManager.IconType.OK));
        this.setButtonVisible(6, true);
        this.setButtonVisible(3, true);
        this.setButtonVisible(4, true);
        LabelFreeMSParamsPanel quantPanel = LabelFreeMSParamsPanel.getLabelFreeMSQuantParamsPanel();
        this.setHelpHeader("<html><b>Step 3:</b> Specify quantitation parameters.</html>", null);
        quantPanel.getParamsPanel().resetScrollbar();
        this.replaceInternalComponent(quantPanel);
        this.revalidate();
        this.repaint();
    }

    public void pack() {
    }

    public DataSetData getQuantitationDataset() {
        return this.m_experimentalDesignNode == null ? null : (DataSetData)this.m_experimentalDesignNode.getData();
    }

    public List<DataSetData> getQuantitationDatasets() {
        ArrayList<DataSetData> allQuantDS = new ArrayList<DataSetData>();
        if (this.isMultipleQuantDefined()) {
            if (this.m_experimentalDesignNode == null) {
                allQuantDS = null;
            } else {
                Enumeration<TreeNode> enumeration = this.m_experimentalDesignNode.children();
                while (enumeration.hasMoreElements()) {
                    allQuantDS.add((DataSetData)((AbstractNode)enumeration.nextElement()).getData());
                }
            }
        } else if (this.m_experimentalDesignNode == null) {
            allQuantDS = null;
        } else {
            allQuantDS.add((DataSetData)this.m_experimentalDesignNode.getData());
        }
        return allQuantDS;
    }

    private void updatePeaklist(RunInfoData runInfoData, long projectID, long resultSetID) {
        if (runInfoData.getStatus() == RunInfoData.Status.LINKED_IN_DATABASE || runInfoData.getStatus() == RunInfoData.Status.USER_DEFINED || runInfoData.getStatus() == RunInfoData.Status.SYSTEM_PROPOSED) {
            RawFile rawFile;
            RawFile rawFile2 = rawFile = runInfoData.getSelectedRawFile() == null ? runInfoData.getLinkedRawFile() : runInfoData.getSelectedRawFile();
            if (rawFile == null) {
                return;
            }
            DatabasePeaklistTask task = new DatabasePeaklistTask(null);
            task.initUpdatePeaklistIdentifier(projectID, Long.valueOf(resultSetID), rawFile.getIdentifier());
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerRawFiles() {
        long pID = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject().getId();
        String errorMsg = null;
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            Project project = (Project)entityManagerUDS.find(Project.class, (Object)pID);
            Object mutexFileRegistered = new Object();
            if (this.isMultipleQuantDefined()) {
                Enumeration<TreeNode> childEnum = this.m_experimentalDesignNode.children();
                while (childEnum.hasMoreElements()) {
                    AbstractNode nextQttNode = (AbstractNode)childEnum.nextElement();
                    this.registerExpDesignRawFiles(nextQttNode, pID, project, mutexFileRegistered);
                }
            } else {
                this.registerExpDesignRawFiles(this.m_experimentalDesignNode, pID, project, mutexFileRegistered);
            }
        }
        return errorMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerExpDesignRawFiles(AbstractNode quantNode, final long pID, Project project, final Object mutexFileRegistered) {
        Enumeration<TreeNode> xicGroups = quantNode.children();
        while (xicGroups.hasMoreElements()) {
            AbstractNode grpNode = (AbstractNode)xicGroups.nextElement();
            Enumeration<TreeNode> groupSamples = grpNode.children();
            while (groupSamples.hasMoreElements()) {
                AbstractNode groupSampleNode = (AbstractNode)groupSamples.nextElement();
                Enumeration<TreeNode> identiResultSummaries = groupSampleNode.children();
                while (identiResultSummaries.hasMoreElements()) {
                    AbstractNode biologicalSampleAnalysisNode = (AbstractNode)identiResultSummaries.nextElement();
                    final Long rsID = ((DataSetNode)biologicalSampleAnalysisNode).getDataset().getResultSetId();
                    Enumeration<TreeNode> runNodes = biologicalSampleAnalysisNode.children();
                    while (runNodes.hasMoreElements()) {
                        XICRunNode runNode = (XICRunNode)runNodes.nextElement();
                        final RunInfoData runData = (RunInfoData)runNode.getData();
                        if (!runData.isRunInfoInDatabase()) {
                            try {
                                Object object = mutexFileRegistered;
                                synchronized (object) {
                                    long instrumentID = 1L;
                                    AbstractJMSCallback registerRawFileCallback = new AbstractJMSCallback(){

                                        public boolean mustBeCalledInAWT() {
                                            return false;
                                        }

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public void run(boolean success) {
                                            if (success) {
                                                CreateQuantitationDialog.this.updatePeaklist(runData, pID, rsID);
                                            }
                                            Object object = mutexFileRegistered;
                                            synchronized (object) {
                                                mutexFileRegistered.notifyAll();
                                            }
                                        }
                                    };
                                    RegisterRawFileTask task = new RegisterRawFileTask(registerRawFileCallback, instrumentID, project.getOwner().getId(), runData);
                                    AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
                                    mutexFileRegistered.wait();
                                }
                            }
                            catch (InterruptedException ie) {
                                m_logger.error("", (Throwable)ie);
                            }
                        } else {
                            this.updatePeaklist(runData, pID, rsID);
                        }
                        if (runData.getRun().getId() <= -1L) continue;
                        DatabaseRunsTask registerRunIdsTask = new DatabaseRunsTask(null);
                        registerRunIdsTask.initRegisterIdentificationDatasetRun(((DataSetData)biologicalSampleAnalysisNode.getData()).getDataset().getId(), runData.getSelectedRawFile(), runData.getRun());
                        registerRunIdsTask.fetchData();
                    }
                }
            }
        }
    }

    public Map<String, Object> getExperimentalDesignParameters() throws IllegalAccessException {
        if (this.m_experimentalDesignNode == null) {
            throw new IllegalAccessException("Design parameters have not been set.");
        }
        Map<String, Object> experimentalDesignParams = !this.isMultipleQuantDefined() ? QuantExperimentalDesignTree.toExperimentalDesignParameters(this.m_experimentalDesignNode, this.m_refIdentDataset, this.m_refResultSummaryId) : QuantExperimentalDesignTree.toExperimentalDesignParameters((AbstractNode)this.m_experimentalDesignNode.getChildAt(0), this.m_refIdentDataset, this.m_refResultSummaryId);
        if (this.m_quantitationType != QuantitationMethod.Type.LABEL_FREE) {
            QuantitationMethod method = this.m_experimentalDesignPanel.getQuantitationMethod();
            ArrayList qcs = (ArrayList)((Map)((List)experimentalDesignParams.get("master_quant_channels")).get(0)).get("quant_channels");
            int nbQcs = qcs.size();
            ArrayList newQcs = new ArrayList(nbQcs * method.getLabels().size());
            for (Object o : qcs) {
                Map qc = (Map)o;
                for (QuantitationLabel label : method.getLabels()) {
                    HashMap<String, Object> newQc = new HashMap<String, Object>(qc);
                    newQc.put("quant_label_id", label.getId());
                    newQc.put("name", qc.get("name") + "." + label.getName());
                    newQc.put("number", newQcs.size() + 1);
                    newQcs.add(newQc);
                }
            }
            qcs.clear();
            qcs.addAll(newQcs);
        }
        return experimentalDesignParams;
    }

    public List<Map<String, Object>> getExperimentalDesignsParameters() throws IllegalAccessException {
        if (this.m_experimentalDesignPanel == null) {
            throw new IllegalAccessException("Design parameters have not been set.");
        }
        ArrayList<Map<String, Object>> expDesigns = new ArrayList<Map<String, Object>>();
        if (!this.isMultipleQuantDefined()) {
            expDesigns.add(this.getExperimentalDesignParameters());
            return expDesigns;
        }
        Enumeration<TreeNode> childs = this.m_experimentalDesignNode.children();
        while (childs.hasMoreElements()) {
            AbstractNode aQuantRoot = (AbstractNode)childs.nextElement();
            Map<String, Object> experimentalDesignParams = QuantExperimentalDesignTree.toExperimentalDesignParameters(aQuantRoot, this.m_refIdentDataset, this.m_refResultSummaryId);
            if (this.m_quantitationType != QuantitationMethod.Type.LABEL_FREE) {
                QuantitationMethod method = this.m_experimentalDesignPanel.getQuantitationMethod();
                ArrayList qcs = (ArrayList)((Map)((List)experimentalDesignParams.get("master_quant_channels")).get(0)).get("quant_channels");
                int nbQcs = qcs.size();
                ArrayList newQcs = new ArrayList(nbQcs * method.getLabels().size());
                for (Object o : qcs) {
                    Map qc = (Map)o;
                    for (QuantitationLabel label : method.getLabels()) {
                        HashMap<String, Object> newQc = new HashMap<String, Object>(qc);
                        newQc.put("quant_label_id", label.getId());
                        newQc.put("name", qc.get("name") + "." + label.getName());
                        newQc.put("number", newQcs.size() + 1);
                        newQcs.add(newQc);
                    }
                }
                qcs.clear();
                qcs.addAll(newQcs);
            }
            expDesigns.add(experimentalDesignParams);
        }
        return expDesigns;
    }

    public Long getQuantMethodId() {
        return this.m_experimentalDesignPanel.getQuantitationMethod().getId();
    }

    public Map<String, Object> getQuantiParameters() {
        Map<String, Object> lfParamas = LabelFreeMSParamsPanel.getLabelFreeMSQuantParamsPanel().getParamsPanel().getQuantParams();
        if (this.m_quantitationType == QuantitationMethod.Type.LABEL_FREE) {
            return lfParamas;
        }
        Map<String, Object> quantiParams = this.m_quantMethodParamsPanel.getQuantParams();
        if (((Boolean)quantiParams.get("label_free_quant_config")).booleanValue()) {
            quantiParams.put("label_free_quant_config", lfParamas);
        } else {
            quantiParams.remove("label_free_quant_config");
        }
        return quantiParams;
    }

    private void displayNextPanel() {
        switch (this.m_step) {
            case 0: {
                if (this.m_quantitationType == QuantitationMethod.Type.LABEL_FREE) {
                    this.displayLinkRawFilesPanel();
                    break;
                }
                this.displayQuantMethodParamsPanel();
                break;
            }
            case 1: {
                this.displayLinkRawFilesPanel();
                break;
            }
            case 2: {
                if (!this.isQuantConfigPanelNeeded()) break;
                this.displayLabelFreeParamsPanel();
                break;
            }
        }
    }

    private boolean checkQuantMethod() {
        if (this.m_experimentalDesignPanel.getQuantitationMethod() == null) {
            this.setStatus(true, "Specify Quantitation Method");
            this.highlight(this.m_experimentalDesignPanel.getQuantMethodComponent());
            return false;
        }
        return true;
    }

    protected boolean okCalled() {
        ParameterList qMethodParameterList;
        switch (this.m_step) {
            case 0: {
                if (this.checkDesignStructure(this.m_experimentalDesignPanel.getExperimentalDesignTree(), this.m_experimentalDesignNode, new HashSet<String>()) && this.checkBiologicalGroupName(this.m_experimentalDesignPanel.getExperimentalDesignTree(), this.m_experimentalDesignNode) && this.checkQuantMethod()) {
                    this.checkSpectrum();
                }
                return false;
            }
            case 1: {
                this.displayNextPanel();
                return false;
            }
            case 2: {
                if (this.checkRawFiles()) {
                    if (this.isQuantConfigPanelNeeded()) {
                        this.displayNextPanel();
                    } else {
                        if (this.m_quantMethodParamsPanel != null) {
                            Preferences preferences = NbPreferences.root();
                            ParameterList qMethodParameterList2 = this.m_quantMethodParamsPanel.getParameterList();
                            qMethodParameterList2.saveParameters(preferences);
                        }
                        return true;
                    }
                }
                return false;
            }
        }
        if (!this.checkQuantParameters()) {
            return false;
        }
        ParameterList parameterList = LabelFreeMSParamsPanel.getLabelFreeMSQuantParamsPanel().getParamsPanel().getParameterList();
        Preferences preferences = NbPreferences.root();
        parameterList.saveParameters(preferences);
        preferences.putBoolean("XicParameters.isSimplifiedParameters", LabelFreeMSParamsPanel.getLabelFreeMSQuantParamsPanel().getParamsPanel().isSimplifiedPanel());
        if (this.m_quantMethodParamsPanel != null && (qMethodParameterList = this.m_quantMethodParamsPanel.getParameterList()) != null) {
            qMethodParameterList.saveParameters(preferences);
        }
        return true;
    }

    private boolean checkQuantParameters() {
        ParameterList parameterList = LabelFreeMSParamsPanel.getLabelFreeMSQuantParamsPanel().getParamsPanel().getParameterList();
        ParameterError error = parameterList.checkParameters();
        if (error != null) {
            this.setStatus(true, error.getErrorMessage());
            this.highlight(error.getParameterComponent());
            return false;
        }
        return true;
    }

    protected boolean saveCalled() {
        if (!this.checkQuantParameters()) {
            return false;
        }
        JFileChooser fileChooser = SettingsUtils.getFileChooser((String)SETTINGS_KEY);
        int result = fileChooser.showSaveDialog((Component)((Object)this));
        if (result == 0) {
            try {
                File f = fileChooser.getSelectedFile();
                if (f.exists()) {
                    FileOutputStream fos = new FileOutputStream(f);
                    fos.close();
                }
                FilePreferences filePreferences = new FilePreferences(f, null, "");
                ParameterList parameterList = LabelFreeMSParamsPanel.getLabelFreeMSQuantParamsPanel().getParamsPanel().getParameterList();
                parameterList.saveParameters((Preferences)filePreferences);
                filePreferences.putBoolean("XicParameters.isSimplifiedParameters", LabelFreeMSParamsPanel.getLabelFreeMSQuantParamsPanel().getParamsPanel().isSimplifiedPanel());
                filePreferences.put("XicParameters.parametersVersion", LabelFreeMSParamsPanel.getLabelFreeMSQuantParamsPanel().getParamsVersion());
                SettingsUtils.addSettingsPath((String)SETTINGS_KEY, (String)f.getAbsolutePath());
                SettingsUtils.writeDefaultDirectory((String)SETTINGS_KEY, (String)f.getParent());
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
                JOptionPane.showMessageDialog((Component)((Object)this), "Error saving settings " + e.getMessage(), "Save Settings Error", 0);
            }
        }
        return false;
    }

    protected boolean loadCalled() {
        SettingsDialog settingsDialog = new SettingsDialog((Window)((Object)this), SETTINGS_KEY);
        settingsDialog.setLocationRelativeTo((Component)((Object)this));
        settingsDialog.setVisible(true);
        if (settingsDialog.getButtonClicked() == 0) {
            if (settingsDialog.isDefaultSettingsSelected()) {
                ParameterList parameterList = LabelFreeMSParamsPanel.getLabelFreeMSQuantParamsPanel().getParamsPanel().getParameterList();
                parameterList.initDefaults();
            } else {
                try {
                    String panelVersion;
                    String version;
                    File settingsFile = settingsDialog.getSelectedFile();
                    FilePreferences filePreferences = new FilePreferences(settingsFile, null, "");
                    if (Arrays.asList(filePreferences.keys()).contains("XicParameters.isSimplifiedParameters")) {
                        boolean isSimplified = filePreferences.getBoolean("XicParameters.isSimplifiedParameters", true);
                        LabelFreeMSParamsPanel.getLabelFreeMSQuantParamsPanel().setIsSimplifiedPanel(isSimplified);
                    }
                    if (!(version = filePreferences.get("XicParameters.parametersVersion", "1.0")).equals(panelVersion = LabelFreeMSParamsPanel.getLabelFreeMSQuantParamsPanel().getParamsVersion())) {
                        String msg = "Can't load " + version + " quantitation parameters to " + panelVersion + " one. All parameters may not have been taken into account !";
                        JOptionPane.showMessageDialog((Component)((Object)this), msg, "Load XIC parameters error", 0);
                    }
                    LabelFreeMSParamsPanel.getLabelFreeMSQuantParamsPanel().getParamsPanel().loadParameters(filePreferences);
                }
                catch (HeadlessException | BackingStoreException e) {
                    LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer").error("Parsing of User Settings File Failed", (Throwable)e);
                    this.setStatus(true, "Parsing of your Settings File failed");
                }
            }
        }
        return false;
    }

    protected boolean backCalled() {
        switch (this.m_step) {
            case 1: {
                this.displayExperimentalDesignPanel(this.m_experimentalDesignNode);
                return false;
            }
            case 2: {
                this.m_selectRawFilePanel.pruneDesignTree();
                if (this.m_quantitationType == QuantitationMethod.Type.LABEL_FREE) {
                    this.displayExperimentalDesignPanel(this.m_experimentalDesignNode);
                } else {
                    this.displayQuantMethodParamsPanel();
                }
                return false;
            }
            case 3: {
                this.displayLinkRawFilesPanel();
                return false;
            }
        }
        return false;
    }

    private Map<Long, DataSetNode> getSampleAnalysisNodesPerRsId(AbstractNode parentNode) {
        HashMap<Long, DataSetNode> spectraNodesPerRsId = new HashMap<Long, DataSetNode>();
        Enumeration<TreeNode> children = parentNode.children();
        while (children.hasMoreElements()) {
            AbstractNode currentChild = (AbstractNode)children.nextElement();
            AbstractNode.NodeTypes type = currentChild.getType();
            if (type == AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) {
                Long rsID = ((DataSetNode)currentChild).getDataset().getResultSetId();
                XICBiologicalSampleAnalysisNode.SpectrumVerificationStatus verificationStatus = ((XICBiologicalSampleAnalysisNode)currentChild).getVerificationStatus();
                if (verificationStatus != XICBiologicalSampleAnalysisNode.SpectrumVerificationStatus.NOT_VERIFIED && verificationStatus != XICBiologicalSampleAnalysisNode.SpectrumVerificationStatus.UNSUCCESSFULLY_VERIFIED) continue;
                spectraNodesPerRsId.put(rsID, (DataSetNode)currentChild);
                continue;
            }
            spectraNodesPerRsId.putAll(this.getSampleAnalysisNodesPerRsId(currentChild));
        }
        return spectraNodesPerRsId;
    }

    private void checkSpectrum() {
        final Map<Long, DataSetNode> spectraNodesPerRsId = this.getSampleAnalysisNodesPerRsId(this.m_experimentalDesignNode);
        if (spectraNodesPerRsId.size() > 0) {
            final Long projectId = spectraNodesPerRsId.values().iterator().next().getDataset().getProject().getId();
            final ArrayList<Long> resultSetIds = new ArrayList<Long>(spectraNodesPerRsId.keySet());
            final ArrayList failedRSIds = new ArrayList();
            final HashMap failedSpectraPerRSIds = new HashMap();
            String waitingTxt = "Please wait while checking Identification Spectra...";
            final LoadWaitingDialog loadWaitingDialog = new LoadWaitingDialog((Window)WindowManager.getDefault().getMainWindow(), waitingTxt);
            DefaultDialog.ProgressTask loadConfigTasktask = new DefaultDialog.ProgressTask(){

                public int getMinValue() {
                    return 0;
                }

                public int getMaxValue() {
                    return 100;
                }

                protected Object doInBackground() throws Exception {
                    AbstractDatabaseCallback spectraTestCallback = new AbstractDatabaseCallback(){

                        public boolean mustBeCalledInAWT() {
                            return true;
                        }

                        public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                            loadWaitingDialog.setVisible(false);
                            if (success) {
                                for (Map.Entry entry : spectraNodesPerRsId.entrySet()) {
                                    if (failedSpectraPerRSIds.containsKey(entry.getKey())) {
                                        ((XICBiologicalSampleAnalysisNode)entry.getValue()).setVerificationStatus(XICBiologicalSampleAnalysisNode.SpectrumVerificationStatus.SUCCESSFULLY_VERIFIED);
                                        continue;
                                    }
                                    ((XICBiologicalSampleAnalysisNode)entry.getValue()).setVerificationStatus(XICBiologicalSampleAnalysisNode.SpectrumVerificationStatus.UNSUCCESSFULLY_VERIFIED);
                                }
                                if (failedRSIds.isEmpty()) {
                                    for (Map.Entry entry : spectraNodesPerRsId.entrySet()) {
                                        ((XICBiologicalSampleAnalysisNode)entry.getValue()).setVerificationStatus(XICBiologicalSampleAnalysisNode.SpectrumVerificationStatus.SUCCESSFULLY_VERIFIED);
                                    }
                                    CreateQuantitationDialog.this.displayNextPanel();
                                } else if (failedRSIds.size() == 1) {
                                    DataSetNode dsNode = (DataSetNode)spectraNodesPerRsId.get(failedRSIds.get(0));
                                    CreateQuantitationDialog.this.showErrorOnNode(CreateQuantitationDialog.this.m_experimentalDesignPanel.getExperimentalDesignTree(), dsNode, dsNode.getDataset().getName() + " at least one of the following attributes {First Time, First Scan, First Cycle} must be initialized. Remove the highlighted node from your design.");
                                } else {
                                    ArrayList<String> failedNodes = new ArrayList<String>();
                                    for (Long failedRSId : failedRSIds) {
                                        failedNodes.add(((DataSetNode)spectraNodesPerRsId.get(failedRSId)).toString());
                                    }
                                    JList<String> failedList = new JList<String>(failedNodes.toArray(new String[0]));
                                    JOptionPane.showMessageDialog(CreateQuantitationDialog.this.rootPane, failedList, "The following datasets failed spectrum check.", 0);
                                }
                            }
                        }
                    };
                    CreateQuantitationDialog.this.m_spectrumTask = new DatabaseVerifySpectrumFromResultSets(spectraTestCallback, resultSetIds, projectId.longValue(), failedRSIds, failedSpectraPerRSIds);
                    AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)CreateQuantitationDialog.this.m_spectrumTask);
                    return null;
                }
            };
            loadWaitingDialog.setTask(loadConfigTasktask);
            Point p = this.getLocation();
            loadWaitingDialog.setLocation(p.x, p.y);
            loadWaitingDialog.setVisible(true);
        } else {
            this.displayNextPanel();
        }
    }

    private boolean checkRawFiles() {
        boolean check = SelectRawFilesPanel.getPanel().check(this);
        if (!check) {
            this.setStatus(true, "You must specify a Raw(mzDb) File for each Sample Analysis.");
        }
        return check;
    }

    protected boolean cancelCalled() {
        return true;
    }

    @Override
    public void experiementalTreeChange(QuantExperimentalDesignTree newQuantExperimentalTree) {
        this.m_experimentalDesignNode = (AbstractNode)newQuantExperimentalTree.getModel().getRoot();
    }
}

