/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.core.orm.uds.QuantitationMethod;
import fr.proline.studio.WindowManager;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.rsmexplorer.gui.editor.FloatTableCellEditor;
import fr.proline.studio.rsmexplorer.gui.model.AbstractCorrectionMatrixTableModel;
import fr.proline.studio.rsmexplorer.gui.model.PurityCorrectionMatrixTableModel;
import fr.proline.studio.rsmexplorer.gui.model.ThermoCorrectionMatrixTableModel;
import fr.proline.studio.table.DecoratedTable;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.table.renderer.DefaultAlignRenderer;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditIsobaricMatrixDialog
extends DefaultDialog {
    private static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private static final String[] KNOWN_TMT_METHODS = new String[]{"TMT 6plex", "TMT 10plex", "TMT 11plex", "TMT 16plex", "TMT 18plex", "TMT 16plex-Deuterated", "TMT 35plex"};
    private static final String KNOWN_HELP_MESSAGE = "Enter values as given by Thermo for this TMT Plex";
    private static final String UNKNOWN_HELP_MESSAGE = "Enter the matrix specifying purity correction to use";
    private static final String READ_ONLY_HELP_MESSAGE = "NO modification can be done here...";
    private final QuantitationMethod m_quantMethod;
    boolean m_isGenericMatrix;
    JScrollPane m_tableScrollPane;
    PurityCorrectionMatrixTable m_purityCorrectionTable;
    private boolean m_readOnly = false;
    private int m_preferredDialogWidth;

    public EditIsobaricMatrixDialog(Window parent, QuantitationMethod method) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setButtonVisible(2, true);
        this.setButtonName(2, "Clear");
        this.setButtonIcon(2, IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
        this.m_quantMethod = method;
        this.m_isGenericMatrix = Arrays.stream(KNOWN_TMT_METHODS).noneMatch(c -> c.equals(this.m_quantMethod.getName()));
        this.setTitle("Edit Purity Matrix for " + this.m_quantMethod.getName());
        this.setResizable(true);
        this.initDialog();
        this.m_purityCorrectionTable.packAll();
        this.pack();
    }

    public EditIsobaricMatrixDialog(Window parent, QuantitationMethod method, Double[][] tableData) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.m_readOnly = true;
        this.setButtonVisible(1, false);
        this.m_quantMethod = method;
        this.m_isGenericMatrix = true;
        this.setTitle("View Purity Matrix for " + this.m_quantMethod.getName());
        this.setResizable(true);
        this.initDialog();
        ((PurityCorrectionMatrixTableModel)((Object)this.m_purityCorrectionTable.getModel())).setData(tableData);
        this.m_purityCorrectionTable.packAll();
        this.pack();
    }

    private void initDialog() {
        this.setButtonVisible(5, false);
        if (this.m_readOnly) {
            this.setHelpHeader("View Purity Correction Matrix", READ_ONLY_HELP_MESSAGE);
        } else if (this.m_isGenericMatrix) {
            this.setHelpHeader("Purity Correction Matrix", UNKNOWN_HELP_MESSAGE);
        } else {
            this.setHelpHeader("Thermo Correction Matrix", KNOWN_HELP_MESSAGE);
        }
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.insets = new Insets(5, 10, 5, 5);
        c.anchor = 18;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.m_tableScrollPane = new JScrollPane();
        this.m_purityCorrectionTable = this.createTable();
        this.m_tableScrollPane.setViewportView((Component)((Object)this.m_purityCorrectionTable));
        this.m_tableScrollPane.setHorizontalScrollBarPolicy(30);
        this.m_purityCorrectionTable.setFillsViewportHeight(true);
        this.m_purityCorrectionTable.setAutoResizeMode(4);
        if (this.m_readOnly) {
            this.m_purityCorrectionTable.setEditable(false);
        }
        internalPanel.add((Component)this.m_tableScrollPane, c);
        this.setInternalComponent(internalPanel);
        int windowWitdh = WindowManager.getDefault().getMainWindow() == null ? this.m_preferredDialogWidth : WindowManager.getDefault().getMainWindow().getWidth();
        this.setPreferredSize(new Dimension(Math.min(this.m_preferredDialogWidth, windowWitdh), 500));
    }

    PurityCorrectionMatrixTable createTable() {
        this.m_preferredDialogWidth = 0;
        PurityCorrectionMatrixTable table = new PurityCorrectionMatrixTable();
        table.removeStriping();
        table.getTableHeader().setDefaultRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 0));
        table.setCellSelectionEnabled(true);
        AbstractCorrectionMatrixTableModel tableModel = this.m_isGenericMatrix ? new PurityCorrectionMatrixTableModel(this.m_quantMethod) : new ThermoCorrectionMatrixTableModel(this.m_quantMethod.getName());
        table.setModel((TableModel)((Object)tableModel));
        TableColumnModel columnModel = table.getColumnModel();
        int colCount = tableModel.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            if (i == tableModel.getCenterColIndex()) {
                columnModel.getColumn(i).setPreferredWidth(40);
                columnModel.getColumn(i).setMaxWidth(40);
                this.m_preferredDialogWidth += 60;
                continue;
            }
            if (i == 0) {
                columnModel.getColumn(i).setPreferredWidth(80);
                columnModel.getColumn(i).setMaxWidth(100);
                this.m_preferredDialogWidth += 120;
                continue;
            }
            int colWidth = tableModel.getCoeffColumWidth();
            columnModel.getColumn(i).setPreferredWidth(colWidth);
            columnModel.getColumn(i).setMaxWidth(colWidth + 20);
            columnModel.getColumn(i).setCellEditor(new FloatTableCellEditor(2));
            this.m_preferredDialogWidth += colWidth + 30;
        }
        return table;
    }

    protected boolean okCalled() {
        return true;
    }

    protected boolean defaultCalled() {
        ((AbstractCorrectionMatrixTableModel)((Object)this.m_purityCorrectionTable.getModel())).clearMatrix();
        this.repaint();
        return false;
    }

    protected String getPurityMatrix() {
        return ((AbstractCorrectionMatrixTableModel)((Object)this.m_purityCorrectionTable.getModel())).getPurityMatrixAsString();
    }

    private class PurityCorrectionMatrixTable
    extends DecoratedTable {
        public PurityCorrectionMatrixTable() {
            this.setSortable(false);
            this.setSelectionMode(0);
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        public TablePopupMenu initPopupMenu() {
            return null;
        }

        public void prepostPopupMenu() {
        }
    }
}

