/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.studio.NbPreferences;
import fr.proline.studio.gui.CheckBoxTitledBorder;
import fr.proline.studio.parameter.BooleanParameter;
import fr.proline.studio.parameter.DoubleParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.AbstractLabelFreeMSParamsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class LabelFreeMSParamsSimplifiedPanel
extends AbstractLabelFreeMSParamsPanel {
    private ObjectParameter<String> m_crossAssignStrategyParameter;
    JPanel m_crossAssignSettingsPanel;
    private JTextField m_extractionMoZTolTF;
    private JTextField m_crossAssignFeatureMapRTTolTF;
    private CheckBoxTitledBorder m_crossAssignCBoxTitle;
    private JComboBox m_crossAssignStrategyCB;
    private JLabel m_allowCrossAssLabel;
    private JLabel m_crossAssRTToleranceLabel;
    private JLabel m_alignmentFeatureTimeTolLabel;
    private JTextField m_alignmentFeatureMapTimeToleranceTF;
    protected JCheckBox m_alignRTCB;

    public LabelFreeMSParamsSimplifiedPanel(String labelFreeParamVersion) {
        super(false, labelFreeParamVersion);
        this.createParameters();
        this.m_parameterList.updateValues(NbPreferences.root());
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JPanel mainPanel = this.createMainPanel();
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setViewportView(mainPanel);
        this.m_scrollPane.createVerticalScrollBar();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.m_scrollPane, c);
    }

    @Override
    public boolean isSimplifiedPanel() {
        return true;
    }

    private void createParameters() {
        this.m_extractionMoZTolTF = new JTextField();
        DoubleParameter extractionMoZTolParameter = new DoubleParameter("extractionMoZTol", "Extraction moz tolerance", (JComponent)this.m_extractionMoZTolTF, DEFAULT_EXTRACTION_MOZTOL_VALUE, Double.valueOf(0.0), null);
        this.m_parameterList.add((Object)extractionMoZTolParameter);
        this.m_crossAssignCBoxTitle = new CheckBoxTitledBorder("Cross Assignment", DEFAULT_CROSS_ASSIGN_VALUE.booleanValue());
        this.m_crossAssignCBoxTitle.addChangeListener(e -> this.enableCrossAssignment(((JToggleButton)e.getSource()).isSelected()));
        BooleanParameter crossAssignParameter = new BooleanParameter("crossAssignment", "Cross Assignment", (JComponent)this.m_crossAssignCBoxTitle.getInternalCheckBox(), DEFAULT_CROSS_ASSIGN_VALUE);
        this.m_parameterList.add((Object)crossAssignParameter);
        this.m_crossAssignStrategyCB = new JComboBox<String>(CROSSASSIGN_STRATEGY_VALUES);
        this.m_crossAssignStrategyParameter = new ObjectParameter("crossAssignStrategy", "Cross Assignement Strategy", this.m_crossAssignStrategyCB, (Object[])CROSSASSIGN_STRATEGY_VALUES, (Object[])CROSSASSIGN_STRATEGY_KEYS, 0, null);
        this.m_parameterList.add(this.m_crossAssignStrategyParameter);
        this.m_crossAssignFeatureMapRTTolTF = new JTextField();
        DoubleParameter featureMappingTimeTolParameter = new DoubleParameter("featureTimeTol", "RT tolerance", (JComponent)this.m_crossAssignFeatureMapRTTolTF, DEFAULT_CA_FEATMAP_RTTOL_VALUE, Double.valueOf(0.0), null);
        this.m_parameterList.add((Object)featureMappingTimeTolParameter);
        this.m_alignRTCB = new JCheckBox("Align RT", (boolean)DEFAULT_ALIGN_VALUE);
        this.m_alignRTCB.addChangeListener(e -> this.enableAlignment(((JToggleButton)e.getSource()).isSelected()));
        BooleanParameter alignRTParameter = new BooleanParameter("alignRT", "Align RT", (JComponent)this.m_alignRTCB, DEFAULT_ALIGN_VALUE);
        this.m_parameterList.add((Object)alignRTParameter);
        this.m_alignmentFeatureMapTimeToleranceTF = new JTextField();
        DoubleParameter alignmentFeatureMappingTimeToleranceParameter = new DoubleParameter("featureMappingTimeTolerance", "Feature Mapping Time Tolerance", (JComponent)this.m_alignmentFeatureMapTimeToleranceTF, DEFAULT_ALIGN_FEATMAP_TIMETOL_VALUE, Double.valueOf(1.0), null);
        this.m_parameterList.add((Object)alignmentFeatureMappingTimeToleranceParameter);
    }

    private void enableAlignment(boolean isEnabled) {
        this.m_alignmentFeatureTimeTolLabel.setEnabled(isEnabled);
        this.m_alignmentFeatureMapTimeToleranceTF.setEnabled(isEnabled);
    }

    @Override
    public void setQuantParams(Map<String, Object> quantParams) {
        throw new UnsupportedOperationException("setQuantParams is not supported in SimplifiedPanel  ");
    }

    @Override
    public Map<String, Object> getQuantParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("config_version", "3.0");
        HashMap<String, String> extractionParams = new HashMap<String, String>();
        extractionParams.put("moz_tol", this.m_extractionMoZTolTF.getText());
        extractionParams.put("moz_tol_unit", "PPM");
        params.put("extraction_params", extractionParams);
        HashMap<String, Object> clusteringParams = new HashMap<String, Object>();
        clusteringParams.put("moz_tol", this.m_extractionMoZTolTF.getText());
        clusteringParams.put("moz_tol_unit", "PPM");
        clusteringParams.put("time_tol", DEFAULT_CLUSTER_TIMETOL_VALUE);
        clusteringParams.put("time_computation", "MOST_INTENSE");
        clusteringParams.put("intensity_computation", "MOST_INTENSE");
        params.put("clustering_params", clusteringParams);
        params.put("detection_method_name", DETECTION_METHOD_KEYS[0]);
        HashMap detectionParams = new HashMap();
        HashMap<String, String> detectionToleranceParams = new HashMap<String, String>();
        detectionToleranceParams.put("moz_tol", this.m_extractionMoZTolTF.getText());
        detectionToleranceParams.put("moz_tol_unit", "PPM");
        detectionParams.put("psm_matching_params", detectionToleranceParams);
        detectionParams.put("isotope_matching_params", detectionToleranceParams);
        params.put("detection_params", detectionParams);
        if (this.m_crossAssignCBoxTitle.isSelected()) {
            HashMap<String, Object> crossAssignmentConfig = new HashMap<String, Object>();
            crossAssignmentConfig.put("method_name", this.m_crossAssignStrategyParameter.getStringValue());
            crossAssignmentConfig.put("restrain_to_reliable_features", DEFAULT_CA_USE_RELIABLE_FEAT);
            HashMap<String, Object> ftMappingParams = new HashMap<String, Object>();
            ftMappingParams.put("moz_tol", this.m_extractionMoZTolTF.getText());
            ftMappingParams.put("moz_tol_unit", "PPM");
            ftMappingParams.put("time_tol", this.m_crossAssignFeatureMapRTTolTF.getText());
            ftMappingParams.put("use_moz_calibration", true);
            ftMappingParams.put("use_automatic_time_tol", false);
            crossAssignmentConfig.put("ft_mapping_params", ftMappingParams);
            HashMap<String, Object> ftParams = new HashMap<String, Object>();
            ftParams.put("name", "INTENSITY");
            ftParams.put("operator", "GT");
            ftParams.put("value", DEFAULT_CA_FILTER_VALUE);
            crossAssignmentConfig.put("ft_filter", ftParams);
            params.put("cross_assignment_config", crossAssignmentConfig);
            if (this.m_alignRTCB.isSelected()) {
                HashMap<String, Object> alignmentConfig = new HashMap<String, Object>();
                alignmentConfig.put("method_name", ALIGNMENT_METHOD_KEYS[0]);
                alignmentConfig.put("smoothing_method_name", ALIGNMENT_SMOOTHING_METHOD_KEYS[0]);
                alignmentConfig.put("ft_mapping_method_name", FEATURE_MAPPING_METHOD_KEYS[0]);
                HashMap<String, String> alnFtParams = new HashMap<String, String>();
                alnFtParams.put("time_tol", this.m_alignmentFeatureMapTimeToleranceTF.getText());
                alignmentConfig.put("ft_mapping_params", alnFtParams);
                alignmentConfig.put("ignore_errors", false);
                params.put("alignment_config", alignmentConfig);
            }
        }
        params.put("moz_calibration_smoothing_method", MOZ_CALIBRATION_SMOOTHING_METHOD_KEYS[0]);
        return params;
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        mainPanel.add((Component)this.createMzTolerancePanel(), c);
        ++c.gridy;
        mainPanel.add((Component)this.createCrossAssignmentPanel(), c);
        ++c.gridy;
        c.weighty = 1.0;
        mainPanel.add(Box.createVerticalGlue(), c);
        return mainPanel;
    }

    private JPanel createMzTolerancePanel() {
        JPanel headerPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel extractionMoZTolLabel = new JLabel("Moz tolerance (ppm):");
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        headerPanel.add((Component)extractionMoZTolLabel, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        headerPanel.add((Component)this.m_extractionMoZTolTF, c);
        return headerPanel;
    }

    private void enableCrossAssignment(boolean isEnabled) {
        if (this.m_crossAssignSettingsPanel == null) {
            this.createCrossAssignmentPanel();
        }
        this.m_crossAssignSettingsPanel.setEnabled(isEnabled);
        this.m_allowCrossAssLabel.setEnabled(isEnabled);
        this.m_crossAssignStrategyCB.setEnabled(isEnabled);
        this.m_crossAssRTToleranceLabel.setEnabled(isEnabled);
        this.m_crossAssignFeatureMapRTTolTF.setEnabled(isEnabled);
        this.m_alignRTCB.setEnabled(isEnabled);
        this.enableAlignment(this.m_alignRTCB.isSelected() && isEnabled);
    }

    private JPanel createCrossAssignmentPanel() {
        JPanel panelA = new JPanel(new BorderLayout());
        panelA.setBorder((Border)this.m_crossAssignCBoxTitle);
        this.m_crossAssignSettingsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        this.m_allowCrossAssLabel = new JLabel("Allow cross assignment ");
        this.m_crossAssignSettingsPanel.add((Component)this.m_allowCrossAssLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.m_crossAssignSettingsPanel.add((Component)this.m_crossAssignStrategyCB, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.m_crossAssRTToleranceLabel = new JLabel("RT tolerance (s):");
        this.m_crossAssignSettingsPanel.add((Component)this.m_crossAssRTToleranceLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.m_crossAssignSettingsPanel.add((Component)this.m_crossAssignFeatureMapRTTolTF, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 2.0;
        c.gridwidth = 2;
        this.m_crossAssignSettingsPanel.add((Component)this.m_alignRTCB, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.m_alignmentFeatureTimeTolLabel = new JLabel("Time tolerance (s):");
        this.m_alignmentFeatureTimeTolLabel.setEnabled(this.m_alignRTCB.isSelected() && this.m_alignRTCB.isEnabled());
        this.m_crossAssignSettingsPanel.add((Component)this.m_alignmentFeatureTimeTolLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.m_alignmentFeatureMapTimeToleranceTF.setEnabled(this.m_alignRTCB.isSelected() && this.m_alignRTCB.isEnabled());
        this.m_crossAssignSettingsPanel.add((Component)this.m_alignmentFeatureMapTimeToleranceTF, c);
        panelA.add((Component)this.m_crossAssignSettingsPanel, "North");
        return panelA;
    }
}

