/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.core.orm.uds.QuantitationMethod;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.studio.NbPreferences;
import fr.proline.studio.WindowManager;
import fr.proline.studio.corewrapper.data.QuantPostProcessingParams;
import fr.proline.studio.gui.CheckBoxTitledBorder;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.BooleanParameter;
import fr.proline.studio.parameter.FloatParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.StringParameter;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.EditIsobaricMatrixDialog;
import fr.proline.studio.rsmexplorer.gui.model.PurityCorrectionMatrixTableModel;
import fr.proline.studio.table.DecoratedTable;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.table.renderer.DefaultColoredCellRenderer;
import fr.proline.studio.utils.IconManager;
import fr.proline.studio.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuantSimplifiedPostProcessingPanel
extends JPanel {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer.QuantSimplifiedPostProcessingPanel");
    private ParameterList m_parameterList;
    private File m_purityMatrixFile;
    private String m_purityMatrixValues;
    JPanel m_psmMatrixPanel;
    PurityCorrectionMatrixTableModel m_readOnlyPurityTableModel;
    JButton m_savePurityMatrix;
    JLabel m_psmFileMatrixStatus;
    JLabel m_psmTableMatrixStatus;
    private CheckBoxTitledBorder m_usePurityCorrectionMatrixCBoxTitle;
    private JComboBox<String> m_peptidesSelectionMethodCB;
    private JCheckBox m_discardMissCleavedPeptidesChB;
    private JCheckBox m_discardModifiedPeptidesChB;
    private CheckBoxTitledBorder m_usePIFCBoxTitle;
    private JTextField m_discardPSMPIFValueTF;
    private JLabel m_discardPSMPIFValueLabel;
    private JCheckBox m_applyPepNormalizationChB;
    private JCheckBox m_discardPeptideIonsSharingPeakelsChB;
    private List<JCheckBox> m_peptideModificationListChB;
    private JComboBox<String> m_peptideAbundanceSummarizingMethodCB;
    private JLabel m_modifiedPeptidesFilteringMethodLabel;
    private JComboBox<String> m_modifiedPeptidesFilteringMethodCB;
    private JComboBox<String> m_peptideIonAbundanceSummarizingMethodCB;
    private JComboBox<String> m_psmAbundanceSummarizingMethodCB;
    private JCheckBox m_applyProtNormalizationChB;
    private BooleanParameter m_discardPSMUsingPIFParameter;
    private FloatParameter m_discardPSMPIFValueParameter;
    private StringParameter m_purityCorrectionMatrixParameter;
    private BooleanParameter m_usePurityCorrectionMatrixParameter;
    private BooleanParameter m_discardMissCleavedPeptidesParameter;
    private BooleanParameter m_discardModifiedPeptidesParameter;
    private BooleanParameter m_discardPeptideIonsSharingPeakelsParameter;
    private BooleanParameter m_applyPepNormalizationParameter;
    private BooleanParameter m_applyProtNormalizationParameter;
    private List<BooleanParameter> m_peptidesModificationListParameter;
    private ObjectParameter<String> m_peptidesSelectionMethodParameter;
    private ObjectParameter<String> m_peptideAbundanceSummarizingMethodParameter;
    private ObjectParameter<String> m_modifiedPeptidesFilteringMethodParameter;
    private ObjectParameter<String> m_pepIonsAbundanceSummarizingMethodParameter;
    private ObjectParameter<String> m_psmAbundanceSummarizingMethodParameter;
    private final boolean m_readOnly;
    private final DDatasetType.QuantitationMethodInfo m_quantitationMethodInfo;
    private final QuantitationMethod m_quantitationMethod;
    Map<Long, String> m_ptmSpecificityNameById;
    boolean m_isValidLabeledQMethod;
    private EditIsobaricMatrixDialog m_matrixDialog;
    private String errorMsg;
    private Component errorCompo;

    public QuantSimplifiedPostProcessingPanel(boolean readOnly, QuantitationMethod quantitationMethod, DDatasetType.QuantitationMethodInfo quantitationMethodInfo, Map<Long, String> ptmSpecificityNameById, boolean isValidLabeledQMethod) {
        this.m_readOnly = readOnly;
        this.m_ptmSpecificityNameById = ptmSpecificityNameById;
        this.m_quantitationMethodInfo = quantitationMethodInfo;
        this.m_quantitationMethod = quantitationMethod;
        this.m_isValidLabeledQMethod = isValidLabeledQMethod;
        this.init();
    }

    private void init() {
        this.m_parameterList = new ParameterList("QuantPostProcessing");
        this.m_parameterList.addBackwardCompatiblePrefix("QuantProfile");
        this.m_peptideModificationListChB = new ArrayList<JCheckBox>();
        this.m_peptidesModificationListParameter = new ArrayList<BooleanParameter>();
        this.createParameters();
        this.initPanel();
        this.m_parameterList.updateValues(NbPreferences.root());
        for (AbstractParameter param : this.m_parameterList) {
            param.setUsed(true);
        }
        this.updateDiscardPTMs();
        this.updateDiscardPIF();
    }

    private void createParameters() {
        String paramKey = QuantPostProcessingParams.getSettingKey((String)"discard_miss_cleaved_peptides");
        this.m_discardMissCleavedPeptidesChB = new JCheckBox(StringUtils.getLabelFromCamelCase((String)paramKey));
        this.m_discardMissCleavedPeptidesChB.setEnabled(!this.m_readOnly);
        this.m_discardMissCleavedPeptidesParameter = new BooleanParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), (JComponent)this.m_discardMissCleavedPeptidesChB, Boolean.valueOf(false));
        this.m_discardMissCleavedPeptidesParameter.addBackwardCompatibleKey(QuantPostProcessingParams.getSettingKey((String)"discard_missed_cleaved_peptides"));
        this.m_parameterList.add((Object)this.m_discardMissCleavedPeptidesParameter);
        paramKey = QuantPostProcessingParams.getSettingKey((String)"discard_peptide_matches_pif_value");
        this.m_discardPSMPIFValueTF = new JTextField();
        this.m_discardPSMPIFValueLabel = new JLabel("Discard PSM with PIF <= ");
        this.m_discardPSMPIFValueTF.setEnabled(!this.m_readOnly);
        this.m_discardPSMPIFValueLabel.setEnabled(!this.m_readOnly);
        this.m_discardPSMPIFValueParameter = new FloatParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), (JComponent)this.m_discardPSMPIFValueTF, QuantPostProcessingParams.DEFAULT_PIF_FILTER_VALUE, Float.valueOf(0.0f), Float.valueOf(1.0f));
        this.m_parameterList.add((Object)this.m_discardPSMPIFValueParameter);
        paramKey = QuantPostProcessingParams.getSettingKey((String)"discard_peptide_matches_pif");
        this.m_usePIFCBoxTitle = new CheckBoxTitledBorder("Use Precursor Ion Fraction filter", false);
        this.m_usePIFCBoxTitle.setEnabled(!this.m_readOnly);
        this.m_usePIFCBoxTitle.addChangeListener(e -> this.updateDiscardPIF());
        this.m_discardPSMUsingPIFParameter = new BooleanParameter(paramKey, "Use Precursor Ion Fraction filter", (JComponent)this.m_usePIFCBoxTitle.getInternalCheckBox(), Boolean.valueOf(false));
        this.m_parameterList.add((Object)this.m_discardPSMUsingPIFParameter);
        paramKey = QuantPostProcessingParams.getSettingKey((String)"discard_modified_peptides");
        this.m_discardModifiedPeptidesChB = new JCheckBox(StringUtils.getLabelFromCamelCase((String)paramKey));
        this.m_discardModifiedPeptidesChB.addActionListener(e -> this.updateDiscardPTMs());
        this.m_discardModifiedPeptidesChB.setEnabled(!this.m_readOnly);
        this.m_discardModifiedPeptidesParameter = new BooleanParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), (JComponent)this.m_discardModifiedPeptidesChB, Boolean.valueOf(false));
        this.m_discardModifiedPeptidesParameter.addBackwardCompatibleKey(QuantPostProcessingParams.getSettingKey((String)"discard_oxidized_peptides"));
        this.m_parameterList.add((Object)this.m_discardModifiedPeptidesParameter);
        this.m_ptmSpecificityNameById.forEach((id, name) -> {
            JCheckBox discardPeptidesWithModifChB = new JCheckBox((String)name);
            discardPeptidesWithModifChB.setEnabled(!this.m_readOnly);
            BooleanParameter ptmToDiscardParameter = new BooleanParameter("discardPeptideModification_" + id, name, (JComponent)discardPeptidesWithModifChB, Boolean.valueOf(false));
            ptmToDiscardParameter.setAssociatedData(id);
            this.m_peptideModificationListChB.add(discardPeptidesWithModifChB);
            this.m_peptidesModificationListParameter.add(ptmToDiscardParameter);
            this.m_parameterList.add((Object)ptmToDiscardParameter);
        });
        paramKey = QuantPostProcessingParams.getSettingKey((String)"discard_pep_ions_sharing_peakels");
        this.m_discardPeptideIonsSharingPeakelsChB = new JCheckBox(StringUtils.getLabelFromCamelCase((String)paramKey));
        this.m_discardPeptideIonsSharingPeakelsChB.setEnabled(!this.m_readOnly);
        this.m_discardPeptideIonsSharingPeakelsParameter = new BooleanParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), (JComponent)this.m_discardPeptideIonsSharingPeakelsChB, Boolean.valueOf(false));
        this.m_discardPeptideIonsSharingPeakelsParameter.addBackwardCompatibleKey(QuantPostProcessingParams.getSettingKey((String)"discard_peptides_sharing_peakels"));
        this.m_parameterList.add((Object)this.m_discardPeptideIonsSharingPeakelsParameter);
        paramKey = QuantPostProcessingParams.getSettingKey((String)"use_purity_correction_matrix");
        this.m_usePurityCorrectionMatrixCBoxTitle = new CheckBoxTitledBorder(StringUtils.getLabelFromCamelCase((String)paramKey), true);
        this.m_usePurityCorrectionMatrixCBoxTitle.setEnabled(!this.m_readOnly);
        this.m_usePurityCorrectionMatrixCBoxTitle.addChangeListener(e -> QuantSimplifiedPostProcessingPanel.setEnabled(this.m_psmMatrixPanel, !this.m_readOnly && this.m_usePurityCorrectionMatrixCBoxTitle.isSelected()));
        this.m_usePurityCorrectionMatrixParameter = new BooleanParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), (JComponent)this.m_usePurityCorrectionMatrixCBoxTitle.getInternalCheckBox(), Boolean.valueOf(false));
        this.m_parameterList.add((Object)this.m_usePurityCorrectionMatrixParameter);
        paramKey = QuantPostProcessingParams.getSettingKey((String)"purity_correction_matrix");
        this.m_purityCorrectionMatrixParameter = new StringParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), JTextField.class, "", Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        this.m_parameterList.add((Object)this.m_purityCorrectionMatrixParameter);
        this.m_applyPepNormalizationChB = new JCheckBox("Apply Normalization");
        this.m_applyPepNormalizationChB.setEnabled(!this.m_readOnly);
        this.m_applyPepNormalizationParameter = new BooleanParameter("applyPepNormalization", "Apply Normalization on peptides", (JComponent)this.m_applyPepNormalizationChB, Boolean.valueOf(false));
        this.m_parameterList.add((Object)this.m_applyPepNormalizationParameter);
        this.m_applyProtNormalizationChB = new JCheckBox("Apply Normalization");
        this.m_applyProtNormalizationChB.setEnabled(!this.m_readOnly);
        this.m_applyProtNormalizationParameter = new BooleanParameter("applyProtNormalization", "Apply Normalization on proteins", (JComponent)this.m_applyProtNormalizationChB, Boolean.valueOf(false));
        this.m_parameterList.add((Object)this.m_applyProtNormalizationParameter);
        paramKey = QuantPostProcessingParams.getSettingKey((String)"peptides_selection_method");
        this.m_peptidesSelectionMethodCB = new JComboBox<String>(QuantPostProcessingParams.getPeptidesSelectionMethodValues());
        this.m_peptidesSelectionMethodCB.setEnabled(!this.m_readOnly);
        this.m_peptidesSelectionMethodParameter = new ObjectParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), this.m_peptidesSelectionMethodCB, (Object[])QuantPostProcessingParams.getPeptidesSelectionMethodValues(), (Object[])QuantPostProcessingParams.getPeptidesSelectionMethodKeys(), 0, null);
        this.m_parameterList.add(this.m_peptidesSelectionMethodParameter);
        paramKey = QuantPostProcessingParams.getSettingKey((String)"peptide_abundance_summarizing_method");
        this.m_peptideAbundanceSummarizingMethodCB = new JComboBox<String>(QuantPostProcessingParams.getPeptideAbundanceSummarizingMethodValues());
        this.m_peptideAbundanceSummarizingMethodCB.setEnabled(!this.m_readOnly);
        this.m_peptideAbundanceSummarizingMethodParameter = new ObjectParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), this.m_peptideAbundanceSummarizingMethodCB, (Object[])QuantPostProcessingParams.getPeptideAbundanceSummarizingMethodValues(), (Object[])QuantPostProcessingParams.getPeptideAbundanceSummarizingMethodKeys(), 5, null);
        this.m_peptideAbundanceSummarizingMethodParameter.addBackwardCompatibleKey(QuantPostProcessingParams.getSettingKey((String)"abundance_summarizing_method"));
        this.m_peptideAbundanceSummarizingMethodParameter.addBackwardCompatibleKey(QuantPostProcessingParams.getSettingKey((String)"abundance_summarizer_method"));
        this.m_parameterList.add(this.m_peptideAbundanceSummarizingMethodParameter);
        paramKey = QuantPostProcessingParams.getSettingKey((String)"pep_ion_abundance_summarizing_method");
        this.m_peptideIonAbundanceSummarizingMethodCB = new JComboBox<String>(QuantPostProcessingParams.getPepIonAbundanceSummarizingMethodValues());
        this.m_peptideIonAbundanceSummarizingMethodCB.setEnabled(!this.m_readOnly);
        this.m_pepIonsAbundanceSummarizingMethodParameter = new ObjectParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), this.m_peptideIonAbundanceSummarizingMethodCB, (Object[])QuantPostProcessingParams.getPepIonAbundanceSummarizingMethodValues(), (Object[])QuantPostProcessingParams.getPepIonAbundanceSummarizingMethodKeys(), 0, null);
        this.m_pepIonsAbundanceSummarizingMethodParameter.addBackwardCompatibleKey("ionAbundanceSummarizerMethod");
        this.m_parameterList.add(this.m_pepIonsAbundanceSummarizingMethodParameter);
        paramKey = QuantPostProcessingParams.getSettingKey((String)"reporter_ion_abundance_summarizing_method");
        this.m_psmAbundanceSummarizingMethodCB = new JComboBox<String>(QuantPostProcessingParams.getPSMAbundanceSummarizingMethodValues());
        this.m_psmAbundanceSummarizingMethodCB.setEnabled(!this.m_readOnly);
        String psmSummarizingLabel = "PSM Abundance Summarizing Method";
        this.m_psmAbundanceSummarizingMethodParameter = new ObjectParameter(paramKey, psmSummarizingLabel, this.m_psmAbundanceSummarizingMethodCB, (Object[])QuantPostProcessingParams.getPSMAbundanceSummarizingMethodValues(), (Object[])QuantPostProcessingParams.getPSMAbundanceSummarizingMethodKeys(), 0, null);
        this.m_parameterList.add(this.m_psmAbundanceSummarizingMethodParameter);
        paramKey = QuantPostProcessingParams.getSettingKey((String)"modified_peptide_filtering_method");
        this.m_modifiedPeptidesFilteringMethodCB = new JComboBox<String>(QuantPostProcessingParams.getModifiedPeptideFilteringMethodValues());
        this.m_modifiedPeptidesFilteringMethodCB.setEnabled(!this.m_readOnly);
        this.m_modifiedPeptidesFilteringMethodParameter = new ObjectParameter(paramKey, StringUtils.getLabelFromCamelCase((String)paramKey), this.m_modifiedPeptidesFilteringMethodCB, (Object[])QuantPostProcessingParams.getModifiedPeptideFilteringMethodValues(), (Object[])QuantPostProcessingParams.getModifiedPeptideFilteringMethodKeys(), 0, null);
        this.m_modifiedPeptidesFilteringMethodParameter.addBackwardCompatibleKey("modifiedPeptidesFilteringMethod");
        this.m_parameterList.add(this.m_modifiedPeptidesFilteringMethodParameter);
    }

    private void updateDiscardPTMs() {
        if (!this.m_readOnly) {
            this.m_peptideModificationListChB.forEach(ptmCBx -> ptmCBx.setEnabled(this.m_discardModifiedPeptidesChB.isSelected()));
            this.m_modifiedPeptidesFilteringMethodLabel.setEnabled(this.m_discardModifiedPeptidesChB.isSelected());
            this.m_modifiedPeptidesFilteringMethodCB.setEnabled(this.m_discardModifiedPeptidesChB.isSelected());
        }
    }

    private void updateDiscardPIF() {
        if (!this.m_readOnly) {
            this.m_discardPSMPIFValueTF.setEnabled(this.m_usePIFCBoxTitle.isSelected());
            this.m_discardPSMPIFValueLabel.setEnabled(this.m_usePIFCBoxTitle.isSelected());
        }
    }

    private static void setEnabled(Container container, boolean isEnabled) {
        if (container == null) {
            return;
        }
        container.setEnabled(isEnabled);
        for (Component children : container.getComponents()) {
            if (Container.class.isAssignableFrom(children.getClass())) {
                QuantSimplifiedPostProcessingPanel.setEnabled((Container)children, isEnabled);
                continue;
            }
            children.setEnabled(isEnabled);
        }
    }

    public void loadParameters(Preferences filePreferences, String version) throws BackingStoreException {
        boolean loadedPTMsParamsError = false;
        Preferences preferences = NbPreferences.root();
        String[] keys = filePreferences.keys();
        HashSet<CallSite> thisQuantPtmIds = new HashSet<CallSite>();
        HashSet<String> prefQuantPtmIds = new HashSet<String>();
        for (BooleanParameter ptmToDiscardParameter : this.m_peptidesModificationListParameter) {
            Long ptmId = (Long)ptmToDiscardParameter.getAssociatedData();
            thisQuantPtmIds.add((CallSite)((Object)(this.m_parameterList.getPrefixName() + "discardPeptideModification_" + ptmId)));
        }
        boolean discardModifiedPeptides = false;
        boolean purityMatrixDefined = false;
        boolean usePurityMatrix = false;
        String filePrefix = version.equals("1.0") ? (String)this.m_parameterList.getBackwardCompatiblePrefixes().get(0) : this.m_parameterList.getPrefixName();
        for (String key : keys) {
            if (key.startsWith(filePrefix + "discardPeptideModification_")) {
                prefQuantPtmIds.add(key);
            }
            if (key.startsWith(filePrefix + QuantPostProcessingParams.getSettingKey((String)"discard_modified_peptides"))) {
                discardModifiedPeptides = filePreferences.getBoolean(key, false);
            } else if (key.startsWith(filePrefix + QuantPostProcessingParams.getSettingKey((String)"discard_oxidized_peptides"))) {
                discardModifiedPeptides = filePreferences.getBoolean(key, false);
            }
            if (key.startsWith(filePrefix + QuantPostProcessingParams.getSettingKey((String)"use_purity_correction_matrix"))) {
                usePurityMatrix = filePreferences.getBoolean(key, false) && this.m_quantitationMethodInfo.equals((Object)DDatasetType.QuantitationMethodInfo.ISOBARIC_TAGGING) && this.m_isValidLabeledQMethod;
                filePreferences.put(filePrefix + QuantPostProcessingParams.getSettingKey((String)"use_purity_correction_matrix"), Boolean.toString(usePurityMatrix));
            }
            if (key.startsWith(filePrefix + QuantPostProcessingParams.getSettingKey((String)"purity_correction_matrix")) && this.m_quantitationMethodInfo.equals((Object)DDatasetType.QuantitationMethodInfo.ISOBARIC_TAGGING) && this.m_isValidLabeledQMethod) {
                this.m_purityMatrixValues = filePreferences.get(key, null);
                if (this.m_purityMatrixValues != null && !this.m_purityMatrixValues.isEmpty()) {
                    purityMatrixDefined = true;
                }
            }
            String value = filePreferences.get(key, null);
            preferences.put(key, value);
        }
        if (prefQuantPtmIds.size() >= thisQuantPtmIds.size()) {
            if (!prefQuantPtmIds.containsAll(thisQuantPtmIds)) {
                loadedPTMsParamsError = true;
            }
        } else {
            loadedPTMsParamsError = true;
        }
        if (loadedPTMsParamsError && discardModifiedPeptides) {
            JOptionPane.showMessageDialog(this, "Warning: PTMs to discard don't match current PTMs list", "Load Parameter ERROR", 0);
            String label = this.m_discardModifiedPeptidesChB.getText() + " (WARNING-PTMs: Read parameters don't match current list)";
            this.m_discardModifiedPeptidesChB.setText(label);
        }
        if (purityMatrixDefined) {
            this.m_psmFileMatrixStatus.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.TICK_SMALL));
        }
        this.getParameterList().loadParameters(filePreferences);
        this.updateDiscardPTMs();
    }

    public ParameterList getParameterList() {
        this.m_parameterList.getParameter(QuantPostProcessingParams.getSettingKey((String)"purity_correction_matrix")).setValue(this.m_purityMatrixValues);
        return this.m_parameterList;
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
        JTabbedPane m_tabbedPane = new JTabbedPane();
        m_tabbedPane.addTab(" Abundances computing ", null, this.getAbundancePanel(), "Parameters used to compute abundances");
        m_tabbedPane.addTab(" Aggregation config. ", null, this.getAggregationCfgPanel(), "Parameters used to aggregate abundances");
        JScrollPane m_scrollPane = new JScrollPane();
        m_scrollPane.setViewportView(m_tabbedPane);
        m_scrollPane.createVerticalScrollBar();
        this.add((Component)m_scrollPane, "Center");
    }

    private JPanel getAbundancePanel() {
        JPanel abundancePanel = new JPanel(new GridBagLayout());
        GridBagConstraints tabPanelC = new GridBagConstraints();
        tabPanelC.anchor = 18;
        tabPanelC.fill = 1;
        tabPanelC.insets = new Insets(5, 2, 2, 2);
        tabPanelC.gridwidth = 1;
        tabPanelC.gridx = 0;
        tabPanelC.gridy = 0;
        tabPanelC.weightx = 1.0;
        if (this.m_quantitationMethodInfo.equals((Object)DDatasetType.QuantitationMethodInfo.ISOBARIC_TAGGING)) {
            JPanel psmPanel = this.createPSMAbundancePanel();
            abundancePanel.add((Component)psmPanel, tabPanelC);
            ++tabPanelC.gridy;
        }
        JPanel pepPanel = new JPanel(new BorderLayout());
        pepPanel.setBorder(BorderFactory.createTitledBorder(" Peptides "));
        pepPanel.add((Component)this.m_applyPepNormalizationChB, "North");
        tabPanelC.gridx = 0;
        abundancePanel.add((Component)pepPanel, tabPanelC);
        JPanel protPanel = this.createProteinAbundancePanel();
        tabPanelC.gridx = 0;
        ++tabPanelC.gridy;
        abundancePanel.add((Component)protPanel, tabPanelC);
        ++tabPanelC.gridy;
        tabPanelC.weighty = 1.0;
        abundancePanel.add(Box.createVerticalGlue(), tabPanelC);
        return abundancePanel;
    }

    private JPanel createProteinAbundancePanel() {
        JPanel protPanel = new JPanel(new BorderLayout());
        protPanel.setBorder(BorderFactory.createTitledBorder(" Proteins "));
        JPanel pepSelectionPanel = new JPanel();
        pepSelectionPanel.setBorder(new TitledBorder("Selection"));
        pepSelectionPanel.setLayout(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.anchor = 18;
        c1.fill = 1;
        c1.insets = new Insets(5, 10, 5, 5);
        c1.gridx = 0;
        c1.gridy = 0;
        c1.weightx = 0.0;
        JLabel peptideSelectionMethodLabel = new JLabel(this.m_peptidesSelectionMethodParameter.getName());
        pepSelectionPanel.add((Component)peptideSelectionMethodLabel, c1);
        c1.insets = new Insets(5, 5, 5, 5);
        ++c1.gridx;
        c1.weightx = 1.0;
        pepSelectionPanel.add(this.m_peptidesSelectionMethodCB, c1);
        c1.gridx = 0;
        ++c1.gridy;
        c1.gridwidth = 2;
        c1.weightx = 1.0;
        pepSelectionPanel.add((Component)this.m_discardMissCleavedPeptidesChB, c1);
        ++c1.gridy;
        pepSelectionPanel.add((Component)this.m_discardModifiedPeptidesChB, c1);
        c1.insets = new Insets(5, 20, 5, 5);
        for (JCheckBox modifCB : this.m_peptideModificationListChB) {
            ++c1.gridy;
            c1.weightx = 0.5;
            pepSelectionPanel.add((Component)modifCB, c1);
        }
        ++c1.gridy;
        c1.weightx = 0.0;
        c1.gridwidth = 1;
        c1.insets = new Insets(5, 10, 5, 5);
        this.m_modifiedPeptidesFilteringMethodLabel = new JLabel(this.m_modifiedPeptidesFilteringMethodParameter.getName());
        pepSelectionPanel.add((Component)this.m_modifiedPeptidesFilteringMethodLabel, c1);
        c1.insets = new Insets(5, 5, 5, 5);
        ++c1.gridx;
        c1.weightx = 1.0;
        pepSelectionPanel.add(this.m_modifiedPeptidesFilteringMethodCB, c1);
        c1.gridx = 0;
        ++c1.gridy;
        c1.gridwidth = 2;
        c1.weightx = 1.0;
        pepSelectionPanel.add((Component)this.m_discardPeptideIonsSharingPeakelsChB, c1);
        protPanel.add((Component)this.m_applyProtNormalizationChB, "North");
        protPanel.add((Component)pepSelectionPanel, "Center");
        return protPanel;
    }

    private JPanel createPSMAbundancePanel() {
        JPanel psmPanel = new JPanel(new BorderLayout());
        psmPanel.setBorder(BorderFactory.createTitledBorder(" PSMs "));
        JPanel pifPanel = new JPanel(new GridBagLayout());
        pifPanel.setBorder((Border)this.m_usePIFCBoxTitle);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        pifPanel.add((Component)this.m_discardPSMPIFValueLabel, c);
        c.weightx = 0.5;
        ++c.gridx;
        pifPanel.add((Component)this.m_discardPSMPIFValueTF, c);
        psmPanel.add((Component)pifPanel, "North");
        if (this.m_isValidLabeledQMethod) {
            JPanel psmMatrixPanel = new JPanel(new BorderLayout());
            psmMatrixPanel.setBorder((Border)this.m_usePurityCorrectionMatrixCBoxTitle);
            if (!this.m_readOnly) {
                this.m_psmMatrixPanel = new JPanel();
                this.m_psmMatrixPanel.setLayout(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.anchor = 17;
                gbc.fill = 0;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                gbc.insets = new Insets(5, 5, 5, 5);
                gbc.gridx = 0;
                gbc.gridy = 0;
                JLabel psmMatrixFileLabel = new JLabel("Select Purity Correction Matrix file:");
                this.m_psmMatrixPanel.add((Component)psmMatrixFileLabel, gbc);
                ++gbc.gridx;
                gbc.insets = new Insets(5, 5, 5, 2);
                JButton fileChooser = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.OPEN_FILE));
                fileChooser.setMargin(new Insets(5, 5, 5, 5));
                fileChooser.addActionListener(e -> this.getPurityMatrixFile());
                this.m_psmMatrixPanel.add((Component)fileChooser, gbc);
                ++gbc.gridx;
                gbc.weightx = 1.0;
                gbc.insets = new Insets(5, 0, 5, 5);
                this.m_psmFileMatrixStatus = new JLabel();
                this.m_psmFileMatrixStatus.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CROSS_SMALL16));
                this.m_psmFileMatrixStatus.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
                this.m_psmMatrixPanel.add((Component)this.m_psmFileMatrixStatus, gbc);
                gbc.gridx = 0;
                ++gbc.gridy;
                gbc.weightx = 0.0;
                JLabel label2 = new JLabel("Specify Purity Correction Matrix :");
                this.m_psmMatrixPanel.add((Component)label2, gbc);
                ++gbc.gridx;
                gbc.weightx = 0.0;
                gbc.insets = new Insets(5, 5, 5, 2);
                JButton matrixAccess = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.GRID));
                matrixAccess.setMargin(new Insets(5, 5, 5, 5));
                matrixAccess.addActionListener(e -> this.openMatrixDialog());
                this.m_psmMatrixPanel.add((Component)matrixAccess, gbc);
                ++gbc.gridx;
                gbc.weightx = 1.0;
                gbc.insets = new Insets(5, 0, 5, 5);
                this.m_psmTableMatrixStatus = new JLabel();
                this.m_psmTableMatrixStatus.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CROSS_SMALL16));
                this.m_psmTableMatrixStatus.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
                this.m_psmMatrixPanel.add((Component)this.m_psmTableMatrixStatus, gbc);
                ++gbc.gridy;
                gbc.anchor = 13;
                gbc.fill = 0;
                ++gbc.gridx;
                gbc.weightx = 1.0;
                gbc.insets = new Insets(5, 0, 5, 2);
                this.m_psmMatrixPanel.add(Box.createHorizontalGlue(), gbc);
                ++gbc.gridx;
                gbc.weightx = 0.0;
                JButton matrixView = new JButton("View Matrix");
                matrixView.setMargin(new Insets(5, 5, 5, 5));
                matrixView.addActionListener(e -> this.viewMatrixDialog());
                this.m_psmMatrixPanel.add((Component)matrixView, gbc);
                ++gbc.gridx;
                gbc.weightx = 0.0;
                this.m_savePurityMatrix = new JButton("Save Matrix");
                this.m_savePurityMatrix.setMargin(new Insets(5, 5, 5, 5));
                this.m_savePurityMatrix.addActionListener(e -> this.saveMatrixDialog());
                this.m_psmMatrixPanel.add((Component)this.m_savePurityMatrix, gbc);
            } else {
                this.m_psmMatrixPanel = new JPanel();
                this.m_psmMatrixPanel.setLayout(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.anchor = 17;
                gbc.fill = 1;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.insets = new Insets(5, 5, 5, 5);
                gbc.gridx = 0;
                gbc.gridy = 0;
                JScrollPane readOnlyTableScrollPane = new JScrollPane();
                DecoratedTable purityCorrectionTable = this.createReadOnlyTable();
                readOnlyTableScrollPane.setViewportView((Component)purityCorrectionTable);
                readOnlyTableScrollPane.setHorizontalScrollBarPolicy(30);
                readOnlyTableScrollPane.setVerticalScrollBarPolicy(21);
                purityCorrectionTable.setFillsViewportHeight(true);
                this.m_psmMatrixPanel.add((Component)readOnlyTableScrollPane, gbc);
            }
            QuantSimplifiedPostProcessingPanel.setEnabled(this.m_psmMatrixPanel, !this.m_readOnly);
            psmMatrixPanel.add((Component)this.m_psmMatrixPanel, "North");
            psmPanel.add((Component)psmMatrixPanel, "Center");
        }
        return psmPanel;
    }

    private void saveMatrixDialog() {
        if (this.m_purityMatrixValues == null || this.m_purityMatrixValues.isEmpty()) {
            JOptionPane.showMessageDialog(this.getParent(), "\nNo Purity matrix was defined yet ...\n", "View Purity Matrix", 0);
        } else {
            JFileChooser fchooser = new JFileChooser();
            fchooser.setMultiSelectionEnabled(false);
            int result = fchooser.showOpenDialog(this);
            if (result == 0) {
                File newFile = fchooser.getSelectedFile();
                try {
                    int resultSave;
                    if (newFile.exists()) {
                        int resultOverwrite = JOptionPane.showConfirmDialog(this, "File exist. Overwrite ?!", "Overwrite File", 0);
                        if (resultOverwrite == 0) {
                            newFile.delete();
                        } else {
                            return;
                        }
                    }
                    if ((resultSave = JOptionPane.showConfirmDialog(this, "Save current purity matrix in file " + newFile.getName() + " (in generic format) ? ", "Save matrix", 0)) == 0) {
                        FileWriter fw = new FileWriter(newFile);
                        fw.write(this.m_purityMatrixValues);
                        fw.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private DecoratedTable createReadOnlyTable() {
        DecoratedTable table = new DecoratedTable(){

            public void prepostPopupMenu() {
            }

            public TablePopupMenu initPopupMenu() {
                return null;
            }
        };
        table.removeStriping();
        this.m_readOnlyPurityTableModel = new PurityCorrectionMatrixTableModel(this.m_quantitationMethod, true);
        table.setModel((TableModel)((Object)this.m_readOnlyPurityTableModel));
        table.getTableHeader().setDefaultRenderer((TableCellRenderer)DefaultColoredCellRenderer.disabledCellRendered);
        TableColumnModel columnModel = table.getColumnModel();
        int colCount = this.m_readOnlyPurityTableModel.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            if (i == this.m_readOnlyPurityTableModel.getCenterColIndex()) {
                columnModel.getColumn(i).setMaxWidth(40);
                continue;
            }
            if (i == 0) {
                columnModel.getColumn(i).setMaxWidth(80);
                continue;
            }
            int colWidth = this.m_readOnlyPurityTableModel.getCoeffColumWidth();
            columnModel.getColumn(i).setMaxWidth(colWidth);
        }
        return table;
    }

    private void viewMatrixDialog() {
        if (this.m_purityMatrixValues == null || this.m_purityMatrixValues.isEmpty()) {
            JOptionPane.showMessageDialog(this.getParent(), "\nNo Purity matrix was defined yet ...\n", "View Purity Matrix", 0);
        } else {
            EditIsobaricMatrixDialog viewDialog = new EditIsobaricMatrixDialog((Window)WindowManager.getDefault().getMainWindow(), this.m_quantitationMethod, this.convertStringToDoubleMatrix(this.m_purityMatrixValues));
            viewDialog.setMaximumSize(new Dimension(100, 100));
            viewDialog.setVisible(true);
        }
    }

    private void openMatrixDialog() {
        if (this.m_matrixDialog == null) {
            this.m_matrixDialog = new EditIsobaricMatrixDialog((Window)WindowManager.getDefault().getMainWindow(), this.m_quantitationMethod);
        }
        this.m_matrixDialog.setVisible(true);
        this.m_purityMatrixValues = null;
        this.m_psmFileMatrixStatus.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CROSS_SMALL16));
        if (this.m_matrixDialog.getButtonClicked() == 0) {
            this.m_purityMatrixValues = this.m_matrixDialog.getPurityMatrix();
            this.m_psmTableMatrixStatus.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.TICK_SMALL));
        } else {
            this.m_psmTableMatrixStatus.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CROSS_SMALL16));
        }
    }

    private int getAggLabelMaxSize() {
        int width1;
        FontMetrics fm = new JLabel().getFontMetrics(new JLabel().getFont());
        int width = fm.stringWidth(this.m_pepIonsAbundanceSummarizingMethodParameter.getName());
        if (width < (width1 = fm.stringWidth(this.m_psmAbundanceSummarizingMethodParameter.getName()))) {
            width = width1;
        }
        if (width < (width1 = fm.stringWidth(this.m_peptideAbundanceSummarizingMethodParameter.getName()))) {
            width = width1;
        }
        return width;
    }

    private JPanel getAggregationCfgPanel() {
        JPanel tabPanel = new JPanel(new GridBagLayout());
        GridBagConstraints tabPanelC = new GridBagConstraints();
        tabPanelC.anchor = 18;
        tabPanelC.fill = 1;
        tabPanelC.insets = new Insets(5, 2, 2, 2);
        tabPanelC.gridwidth = 1;
        tabPanelC.gridx = 0;
        tabPanelC.gridy = 0;
        tabPanelC.weightx = 1.0;
        int labelWidth = this.getAggLabelMaxSize();
        int labelHeight = 20;
        if (this.m_quantitationMethodInfo.equals((Object)DDatasetType.QuantitationMethodInfo.ISOBARIC_TAGGING)) {
            JPanel psmCfgPanel = new JPanel(new GridBagLayout());
            psmCfgPanel.setBorder(BorderFactory.createTitledBorder(" To Pep. Ions "));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.fill = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(5, 5, 5, 5);
            JLabel psmAblabel = new JLabel(this.m_psmAbundanceSummarizingMethodParameter.getName());
            psmAblabel.setPreferredSize(new Dimension(labelWidth, labelHeight));
            psmAblabel.setHorizontalAlignment(4);
            psmCfgPanel.add((Component)psmAblabel, c);
            c.weightx = 1.0;
            ++c.gridx;
            psmCfgPanel.add(this.m_psmAbundanceSummarizingMethodCB, c);
            tabPanel.add((Component)psmCfgPanel, tabPanelC);
            ++tabPanelC.gridy;
        }
        JPanel pepCfgPanel = new JPanel(new GridBagLayout());
        pepCfgPanel.setBorder(BorderFactory.createTitledBorder(" To Peptides "));
        GridBagConstraints c2 = new GridBagConstraints();
        c2.anchor = 18;
        c2.fill = 1;
        c2.insets = new Insets(5, 5, 5, 5);
        c2.gridx = 0;
        c2.gridy = 0;
        c2.weightx = 0.0;
        c2.gridwidth = 1;
        JLabel ionAbundanceSummarizerMethodLabel = new JLabel(this.m_pepIonsAbundanceSummarizingMethodParameter.getName());
        ionAbundanceSummarizerMethodLabel.setPreferredSize(new Dimension(labelWidth, labelHeight));
        ionAbundanceSummarizerMethodLabel.setHorizontalAlignment(4);
        pepCfgPanel.add((Component)ionAbundanceSummarizerMethodLabel, c2);
        ++c2.gridx;
        c2.weightx = 1.0;
        pepCfgPanel.add(this.m_peptideIonAbundanceSummarizingMethodCB, c2);
        tabPanel.add((Component)pepCfgPanel, tabPanelC);
        JPanel protCfgPanel = new JPanel(new GridBagLayout());
        protCfgPanel.setBorder(BorderFactory.createTitledBorder(" To Proteins "));
        GridBagConstraints c3 = new GridBagConstraints();
        c3.anchor = 18;
        c3.fill = 0;
        c3.insets = new Insets(5, 5, 5, 5);
        c3.gridx = 0;
        c3.gridy = 0;
        c3.gridwidth = 1;
        JLabel abundanceSummarizerMethodLabel = new JLabel(this.m_peptideAbundanceSummarizingMethodParameter.getName());
        abundanceSummarizerMethodLabel.setPreferredSize(new Dimension(labelWidth, labelHeight));
        abundanceSummarizerMethodLabel.setHorizontalAlignment(4);
        protCfgPanel.add((Component)abundanceSummarizerMethodLabel, c3);
        c3.fill = 2;
        ++c3.gridx;
        c3.weightx = 1.0;
        protCfgPanel.add(this.m_peptideAbundanceSummarizingMethodCB, c3);
        ++tabPanelC.gridy;
        tabPanel.add((Component)protCfgPanel, tabPanelC);
        ++tabPanelC.gridy;
        tabPanelC.weighty = 1.0;
        tabPanel.add(Box.createVerticalGlue(), tabPanelC);
        return tabPanel;
    }

    private void getPurityMatrixFile() {
        JFileChooser fchooser = new JFileChooser();
        fchooser.setMultiSelectionEnabled(false);
        fchooser.setFileSelectionMode(0);
        int result = fchooser.showOpenDialog(this);
        this.m_purityMatrixFile = null;
        this.m_purityMatrixValues = null;
        if (result == 0) {
            this.m_psmTableMatrixStatus.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CROSS_SMALL16));
            this.m_purityMatrixFile = fchooser.getSelectedFile();
            boolean fileOk = this.readPurityMatrixFile();
            if (fileOk) {
                this.m_psmFileMatrixStatus.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.TICK_SMALL));
            } else {
                this.m_psmFileMatrixStatus.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CROSS_SMALL16));
                this.m_purityMatrixFile = null;
            }
        } else {
            this.m_psmFileMatrixStatus.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CROSS_SMALL16));
        }
    }

    private boolean readPurityMatrixFile() {
        if (this.m_purityMatrixFile != null && this.m_purityMatrixFile.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(this.m_purityMatrixFile));
                String purityMatrixValues = br.lines().collect(Collectors.joining(" "));
                Double[][] matrix = this.convertStringToDoubleMatrix(purityMatrixValues);
                if (matrix == null) {
                    m_logger.warn("Invalid matrix file specified");
                    return false;
                }
                this.m_purityMatrixValues = purityMatrixValues;
                return true;
            }
            catch (FileNotFoundException e) {
                m_logger.warn("Quant Post Processing Error: Unable to read purity matrix file");
                return false;
            }
        }
        return false;
    }

    boolean checkQuantPostProcessingParam() {
        this.errorMsg = "";
        this.errorCompo = null;
        if (this.m_quantitationMethodInfo.equals((Object)DDatasetType.QuantitationMethodInfo.ISOBARIC_TAGGING) && this.m_isValidLabeledQMethod && this.m_usePurityCorrectionMatrixCBoxTitle.isSelected()) {
            if (this.m_purityMatrixValues == null || this.m_purityMatrixValues.isEmpty()) {
                this.errorMsg = "No (or invalid) purity matrix specified ";
                this.errorCompo = this.m_psmMatrixPanel;
                return false;
            }
            Double[][] matrix = this.convertStringToDoubleMatrix(this.m_purityMatrixValues);
            if (matrix == null) {
                this.errorMsg = "Invalid purity matrix specified ";
                this.errorCompo = this.m_psmMatrixPanel;
                return false;
            }
        }
        boolean discardPSMOK = true;
        if (this.m_discardModifiedPeptidesChB.isSelected()) {
            discardPSMOK = false;
            for (JCheckBox cb : this.m_peptideModificationListChB) {
                if (!cb.isSelected()) continue;
                discardPSMOK = true;
                break;
            }
            if (!discardPSMOK) {
                this.errorMsg = "No modification specified for Discard modified peptides option.";
                this.errorCompo = this.m_discardModifiedPeptidesChB;
            }
        }
        return discardPSMOK;
    }

    public String getCheckErrorMessage() {
        return this.errorMsg;
    }

    public Component getCheckErrorComponent() {
        return this.errorCompo;
    }

    public Map<String, Object> getQuantParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("config_version", "3.0");
        params.put("discard_peptide_matches_pif", this.m_usePIFCBoxTitle.isSelected());
        params.put("discard_peptide_matches_pif_value", Float.valueOf(this.m_discardPSMPIFValueTF.getText()));
        params.put("discard_miss_cleaved_peptides", this.m_discardMissCleavedPeptidesChB.isSelected());
        params.put("discard_modified_peptides", this.m_discardModifiedPeptidesChB.isSelected());
        params.put("pep_ion_abundance_summarizing_method", QuantPostProcessingParams.getPepIonAbundanceSummarizingMethodKeys()[this.m_peptideIonAbundanceSummarizingMethodCB.getSelectedIndex()]);
        params.put("peptides_selection_method", QuantPostProcessingParams.getPeptidesSelectionMethodKeys()[this.m_peptidesSelectionMethodCB.getSelectedIndex()]);
        HashMap modifiedPeptideFilterConfigMap = new HashMap();
        ArrayList<Long> ptmIds = new ArrayList<Long>();
        for (BooleanParameter ptmToDiscardParameter : this.m_peptidesModificationListParameter) {
            if (!((JCheckBox)ptmToDiscardParameter.getComponent()).isSelected()) continue;
            Long ptmId = (Long)ptmToDiscardParameter.getAssociatedData();
            ptmIds.add(ptmId);
        }
        modifiedPeptideFilterConfigMap.put("ptm_definition_ids_to_discard", ptmIds);
        params.put("modified_peptide_filter_config", modifiedPeptideFilterConfigMap);
        params.put("modified_peptide_filtering_method", QuantPostProcessingParams.getModifiedPeptideFilteringMethodKeys()[this.m_modifiedPeptidesFilteringMethodCB.getSelectedIndex()]);
        params.put("discard_pep_ions_sharing_peakels", this.m_discardPeptideIonsSharingPeakelsChB.isSelected());
        params.put("peptide_abundance_summarizing_method", QuantPostProcessingParams.getPeptideAbundanceSummarizingMethodKeys()[this.m_peptideAbundanceSummarizingMethodCB.getSelectedIndex()]);
        params.put("apply_profile_clustering", false);
        params.put("use_purity_correction_matrix", this.m_usePurityCorrectionMatrixCBoxTitle.isSelected());
        params.put("reporter_ion_abundance_summarizing_method", QuantPostProcessingParams.getPSMAbundanceSummarizingMethodKeys()[this.m_psmAbundanceSummarizingMethodCB.getSelectedIndex()]);
        if (this.m_purityMatrixValues != null && !this.m_purityMatrixValues.isEmpty()) {
            params.put("purity_correction_matrix", this.m_purityMatrixValues);
        }
        HashMap<String, Object> peptideStatConfigMap = new HashMap<String, Object>();
        peptideStatConfigMap.put("stat_tests_alpha", "0.01");
        peptideStatConfigMap.put("apply_normalization", this.m_applyPepNormalizationChB.isSelected());
        peptideStatConfigMap.put("apply_miss_val_inference", false);
        peptideStatConfigMap.put("apply_variance_correction", false);
        peptideStatConfigMap.put("apply_ttest", false);
        peptideStatConfigMap.put("apply_ztest", false);
        params.put(QuantPostProcessingParams.getPrefixedParam((String)"peptide", (String)"stat_config"), peptideStatConfigMap);
        HashMap<String, Object> proteinStatConfigMap = new HashMap<String, Object>();
        proteinStatConfigMap.put("stat_tests_alpha", "0.01");
        proteinStatConfigMap.put("apply_normalization", this.m_applyProtNormalizationChB.isSelected());
        proteinStatConfigMap.put("apply_miss_val_inference", false);
        proteinStatConfigMap.put("apply_variance_correction", false);
        proteinStatConfigMap.put("apply_ttest", false);
        proteinStatConfigMap.put("apply_ztest", false);
        params.put(QuantPostProcessingParams.getPrefixedParam((String)"protein", (String)"stat_config"), proteinStatConfigMap);
        return params;
    }

    public void setRefinedParams(Map<String, Object> refinedParams) {
        boolean useOnlySpecificPeptides;
        boolean isVersion3 = false;
        boolean isVersion2 = false;
        boolean isVersion1 = false;
        String version = (String)refinedParams.get("config_version");
        Object isDiscardModifiedPeptide = refinedParams.get("discard_modified_peptides");
        if (version == null) {
            isVersion1 = true;
        } else if ("2.0".equals(version)) {
            isVersion2 = true;
        } else {
            isVersion3 = true;
        }
        String selectionMethod = "";
        selectionMethod = isVersion3 ? (String)refinedParams.getOrDefault("peptides_selection_method", "ALL_PEPTIDES") : ((useOnlySpecificPeptides = Boolean.parseBoolean(refinedParams.getOrDefault("use_only_specific_peptides", "false").toString())) ? "SPECIFIC" : "ALL_PEPTIDES");
        String[] pepSelectionMethodKeys = QuantPostProcessingParams.getPeptidesSelectionMethodKeys();
        int index = 0;
        for (int i = 0; i < pepSelectionMethodKeys.length; ++i) {
            if (!pepSelectionMethodKeys[i].equals(selectionMethod)) continue;
            index = i;
            break;
        }
        this.m_peptidesSelectionMethodCB.setSelectedIndex(index);
        Object isDmcPep = isVersion1 ? refinedParams.getOrDefault("discard_missed_cleaved_peptides", "false") : refinedParams.getOrDefault("discard_miss_cleaved_peptides", "false");
        this.m_discardMissCleavedPeptidesChB.setSelected(Boolean.parseBoolean(isDmcPep.toString()));
        boolean isV1DiscardOxidPepSelected = false;
        if (isVersion1) {
            isV1DiscardOxidPepSelected = Boolean.parseBoolean(refinedParams.get("discard_oxidized_peptides").toString());
            this.m_discardModifiedPeptidesChB.setSelected(isV1DiscardOxidPepSelected);
            this.m_modifiedPeptidesFilteringMethodLabel.setEnabled(false);
        } else {
            this.m_discardModifiedPeptidesChB.setSelected(Boolean.parseBoolean(isDiscardModifiedPeptide.toString()));
        }
        ArrayList ptmIdListFromParam = null;
        if (isVersion2) {
            ptmIdListFromParam = (ArrayList)refinedParams.get("ptm_definition_ids_to_discard");
        } else if (isVersion3) {
            Map modifiedPeptideFilterConfigMap = (Map)refinedParams.get("modified_peptide_filter_config");
            ptmIdListFromParam = (ArrayList)modifiedPeptideFilterConfigMap.get("ptm_definition_ids_to_discard");
        }
        ArrayList<Long> ptmIdList = new ArrayList<Long>();
        if (ptmIdListFromParam != null) {
            for (Object l : ptmIdListFromParam) {
                ptmIdList.add(Long.parseLong("" + l));
            }
        } else if (isV1DiscardOxidPepSelected) {
            ptmIdList = new ArrayList();
            for (Long id : this.m_ptmSpecificityNameById.keySet()) {
                if (!this.m_ptmSpecificityNameById.get(id).contains("Oxidation")) continue;
                ptmIdList.add(id);
            }
        }
        for (BooleanParameter ptmToDiscardParameter : this.m_peptidesModificationListParameter) {
            JCheckBox ptmChB = (JCheckBox)ptmToDiscardParameter.getComponent();
            Long ptmId = (Long)ptmToDiscardParameter.getAssociatedData();
            ptmChB.setSelected(ptmIdList.contains(ptmId));
        }
        String pmfMethod = isVersion1 ? "" : (String)refinedParams.get("modified_peptide_filtering_method");
        index = 0;
        String[] modifPepFilteringMethodKeys = QuantPostProcessingParams.getModifiedPeptideFilteringMethodKeys();
        for (int i = 0; i < modifPepFilteringMethodKeys.length; ++i) {
            if (!modifPepFilteringMethodKeys[i].equals(pmfMethod)) continue;
            index = i;
            break;
        }
        this.m_modifiedPeptidesFilteringMethodCB.setSelectedIndex(index);
        Boolean discardSharingPeakel = isVersion3 ? Boolean.valueOf(refinedParams.get("discard_pep_ions_sharing_peakels").toString()) : Boolean.valueOf(refinedParams.get("discard_peptides_sharing_peakels").toString());
        this.m_discardPeptideIonsSharingPeakelsChB.setSelected(discardSharingPeakel);
        Boolean usePifOption = Boolean.valueOf(refinedParams.getOrDefault("discard_peptide_matches_pif", false).toString());
        this.m_usePIFCBoxTitle.setSelected(usePifOption.booleanValue());
        if (usePifOption.booleanValue()) {
            try {
                Float pifValue = Float.valueOf(refinedParams.getOrDefault("discard_peptide_matches_pif_value", QuantPostProcessingParams.DEFAULT_PIF_FILTER_VALUE).toString());
                this.m_discardPSMPIFValueTF.setText("" + pifValue);
            }
            catch (NumberFormatException ex) {
                m_logger.error("error while settings m_discardPSMPIFValueTF quantification params " + ex);
                this.m_discardPSMPIFValueTF.setText("" + QuantPostProcessingParams.DEFAULT_PIF_FILTER_VALUE);
            }
        }
        Boolean usePurityCorrMatrix = Boolean.valueOf(refinedParams.getOrDefault("use_purity_correction_matrix", false).toString());
        this.m_usePurityCorrectionMatrixCBoxTitle.setSelected(usePurityCorrMatrix.booleanValue());
        if (usePurityCorrMatrix.booleanValue()) {
            this.m_purityMatrixValues = refinedParams.getOrDefault("purity_correction_matrix", "").toString();
            this.m_readOnlyPurityTableModel.setData(this.convertStringToDoubleMatrix(this.m_purityMatrixValues));
        }
        String[] abundanceSummarizingMethodKeys = QuantPostProcessingParams.getPeptideAbundanceSummarizingMethodKeys();
        String summarisedMethodKey = isVersion3 ? (String)refinedParams.get("peptide_abundance_summarizing_method") : (String)refinedParams.get("abundance_summarizing_method");
        index = 0;
        for (int i = 0; i < abundanceSummarizingMethodKeys.length; ++i) {
            if (!abundanceSummarizingMethodKeys[i].equals(summarisedMethodKey)) continue;
            index = i;
            break;
        }
        this.m_peptideAbundanceSummarizingMethodCB.setSelectedIndex(index);
        String ionPepSummarisingMethodKey = isVersion1 ? "BEST_ION" : (String)refinedParams.getOrDefault("pep_ion_abundance_summarizing_method", "BEST_ION");
        String[] ionAbundanceSummarizingMethodKeys = QuantPostProcessingParams.getPepIonAbundanceSummarizingMethodKeys();
        index = 0;
        for (int i = 0; i < ionAbundanceSummarizingMethodKeys.length; ++i) {
            if (!ionAbundanceSummarizingMethodKeys[i].equals(ionPepSummarisingMethodKey)) continue;
            index = i;
            break;
        }
        this.m_peptideIonAbundanceSummarizingMethodCB.setSelectedIndex(index);
        Map peptideStatConfigMap = (Map)refinedParams.get(QuantPostProcessingParams.getPrefixedParam((String)"peptide", (String)"stat_config"));
        this.m_applyPepNormalizationChB.setSelected(Boolean.parseBoolean(peptideStatConfigMap.get("apply_normalization").toString()));
        Map proteinStatConfigMap = (Map)refinedParams.get(QuantPostProcessingParams.getPrefixedParam((String)"protein", (String)"stat_config"));
        this.m_applyProtNormalizationChB.setSelected(Boolean.valueOf(proteinStatConfigMap.get("apply_normalization").toString()));
        this.updateDiscardPTMs();
        this.updateDiscardPIF();
    }

    private Double[][] convertStringToDoubleMatrix(String input) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        try {
            String[] allCoeffs = input.substring(1, input.length() - 1).replaceAll("\\s", "").split("\\],\\[");
            Double[][] finalMatrix = new Double[allCoeffs.length][];
            for (int i = 0; i < allCoeffs.length; ++i) {
                String aReporterCoeffList = allCoeffs[i].replaceAll("[\\[\\]\\s]", "");
                String[] indivCoefList = aReporterCoeffList.split(",");
                if (indivCoefList.length != allCoeffs.length) {
                    m_logger.debug(" Error converting matrix : not square " + allCoeffs.length + " X " + indivCoefList.length);
                    return null;
                }
                finalMatrix[i] = new Double[indivCoefList.length];
                for (int j = 0; j < indivCoefList.length; ++j) {
                    finalMatrix[i][j] = Double.parseDouble(indivCoefList[j]);
                }
            }
            return finalMatrix;
        }
        catch (Exception e) {
            m_logger.debug(" Error converting matrix : Exception " + e.getMessage());
            return null;
        }
    }

    public void setDiscardPeptidesSharingPeakelsChB(boolean isAggregation) {
        if (isAggregation) {
            this.m_discardPeptideIonsSharingPeakelsChB.setSelected(false);
        }
        this.m_discardPeptideIonsSharingPeakelsChB.setEnabled(!isAggregation);
    }
}

