/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.core.orm.uds.RawFile;
import fr.proline.core.orm.uds.Run;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.RunInfoData;
import fr.proline.studio.dpm.serverfilesystem.ServerFileSystemView;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.gui.OptionDialog;
import fr.proline.studio.rsmexplorer.gui.TreeFileChooserPanel;
import fr.proline.studio.rsmexplorer.gui.TreeFileChooserTableModelInterface;
import fr.proline.studio.rsmexplorer.gui.TreeFileChooserTransferHandler;
import fr.proline.studio.rsmexplorer.gui.TreeUtils;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.CreateQuantitationDialog;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.SelectRawFileDialog;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.XICDropZone;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.XICDropZoneInfo;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalGroupNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalSampleAnalysisNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalSampleNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICRunNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICRunNodeInitListener;
import fr.proline.studio.table.DecoratedMarkerTable;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.utils.HelpUtils;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jdesktop.swingx.table.TableColumnExt;

public class SelectRawFilesPanel
extends JPanel
implements XICRunNodeInitListener {
    private static final String USER_DEFINED_ASSOCIATION = "User Defined Association";
    private static final String MISSING_ASSOCIATION = "Missing Association";
    private static final String AUTOMATIC_ASSOCIATION = "System Proposed Association";
    private static final String PREVIOUS_LINK_ASSOCIATION = "Previous Association Proposed";
    private static final String EXISTING_ASSOCIATION = "Existing Association in Database";
    private static final String NOT_INITIALIZED_ASSOCIATION = "Not Initialized Association";
    private static SelectRawFilesPanel m_singleton = null;
    private FlatDesignTableModel m_model = null;
    private FlatDesignTable m_table = null;
    private XICDropZone m_dropZone;
    private XICDropZoneInfo m_dropZoneInfo;
    private static final String[] SUFFIX = new String[]{".raw", ".mzdb", ".wiff"};
    private final TreeFileChooserTransferHandler m_transferHandler = new TreeFileChooserTransferHandler();
    private AbstractNode m_rootNode;
    JButton m_cleanAssciatBt;

    public static SelectRawFilesPanel getPanel(AbstractNode rootNode) {
        if (m_singleton == null) {
            m_singleton = new SelectRawFilesPanel();
        }
        m_singleton.setRootNode(rootNode);
        return m_singleton;
    }

    public static SelectRawFilesPanel getPanel() {
        return m_singleton;
    }

    private SelectRawFilesPanel() {
        JPanel mainPanel = this.createMainPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
    }

    private void setRootNode(AbstractNode rootNode) {
        this.m_rootNode = rootNode;
        this.m_model.setData(rootNode);
    }

    public boolean check(DefaultDialog dialog) {
        int nbRows = this.m_model.getRowCount();
        for (int i = 0; i < nbRows; ++i) {
            XICRunNode run = this.m_model.getXICRunNode(i);
            if (run != null && ((RunInfoData)run.getData()).hasRawFile()) continue;
            dialog.highlight((Component)((Object)this.m_table), this.m_table.getCellRect(this.m_table.convertRowIndexToView(i), this.m_table.convertColumnIndexToView(3), true));
            return false;
        }
        return true;
    }

    public final JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        JPanel designTablePanel = this.createDesignTablePanel();
        JPanel filePathPanel = this.createFilePathPanel();
        JPanel framePanel = new JPanel(new GridBagLayout());
        framePanel.setBorder(BorderFactory.createTitledBorder(" MS files association "));
        JSplitPane sp = new JSplitPane();
        sp.setLeftComponent(designTablePanel);
        sp.setRightComponent(filePathPanel);
        sp.setResizeWeight(0.5);
        GridBagConstraints cFrame = new GridBagConstraints();
        cFrame.insets = new Insets(5, 5, 5, 5);
        cFrame.gridx = 0;
        cFrame.gridy = 0;
        cFrame.weightx = 1.0;
        cFrame.weighty = 1.0;
        cFrame.anchor = 18;
        cFrame.fill = 1;
        cFrame.gridwidth = 1;
        framePanel.add((Component)sp, cFrame);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 18;
        c.fill = 1;
        mainPanel.add((Component)framePanel, c);
        return mainPanel;
    }

    private JPanel createDesignTablePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 1));
        JPanel designTablePanel = new JPanel();
        designTablePanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 0, 5, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.m_cleanAssciatBt = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
        this.m_cleanAssciatBt.setFocusPainted(false);
        this.m_cleanAssciatBt.setOpaque(true);
        this.m_cleanAssciatBt.setToolTipText("Disassociate mzDB Raw file - Mascot dat file");
        this.m_cleanAssciatBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Point p = SelectRawFilesPanel.this.m_cleanAssciatBt.getLocationOnScreen();
                SelectRawFilesPanel.this.cleanRawFileDialog(p.x, p.y);
            }
        });
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add(this.m_cleanAssciatBt);
        designTablePanel.add((Component)toolbar, c);
        ++c.gridy;
        designTablePanel.add((Component)Box.createVerticalBox(), c);
        c.gridy = 0;
        c.gridheight = 2;
        ++c.gridx;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JScrollPane tableScrollPane = new JScrollPane();
        tableScrollPane.getViewport().setBackground(Color.white);
        this.m_table = new FlatDesignTable();
        this.m_model = new FlatDesignTableModel();
        this.m_model.setXICDropZone(this.m_dropZone);
        this.m_table.setModel((TableModel)((Object)this.m_model));
        this.m_table.setColumnsVisibility();
        tableScrollPane.setViewportView((Component)((Object)this.m_table));
        designTablePanel.add((Component)tableScrollPane, c);
        panel.add(designTablePanel);
        panel.add(this.createDropZonePanel());
        return panel;
    }

    private JPanel createDropZonePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 2, 5, 5));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Automatic MS file association"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.m_dropZoneInfo = new XICDropZoneInfo();
        this.m_dropZone = new XICDropZone(this.m_transferHandler);
        this.m_dropZone.setTable((JTable)((Object)this.m_table));
        this.m_dropZone.setDropZoneInfo(this.m_dropZoneInfo);
        panel.add(this.m_dropZoneInfo);
        panel.add(this.m_dropZone);
        return panel;
    }

    public void resetDropZonePanel() {
        if (this.m_dropZone != null) {
            this.m_dropZone.clearDropZone();
        }
    }

    public void pruneDesignTree() {
        Enumeration<TreeNode> e = this.m_rootNode.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            AbstractNode currentElement = (AbstractNode)e.nextElement();
            if (currentElement.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) continue;
            XICBiologicalSampleAnalysisNode sampleAnalysisNode = (XICBiologicalSampleAnalysisNode)currentElement;
            sampleAnalysisNode.removeAllChildren();
        }
    }

    private JPanel createFilePathPanel() {
        JPanel fileFilePathPanel = new JPanel();
        fileFilePathPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        TreeFileChooserPanel tree = new TreeFileChooserPanel((FileSystemView)ServerFileSystemView.getServerFileSystemView(), this.m_transferHandler);
        tree.initTree();
        tree.restoreTree(TreeUtils.TreeType.XIC);
        JScrollPane treeScrollPane = new JScrollPane();
        treeScrollPane.setViewportView(tree);
        fileFilePathPanel.add((Component)treeScrollPane, c);
        return fileFilePathPanel;
    }

    @Override
    public void initCompleted(XICRunNode node) {
        if (this.m_model != null && this.m_model.getRowCount() > 0) {
            this.m_dropZone.updateTable();
        }
    }

    private void cleanRawFileDialog(int posX, int posY) {
        OptionDialog yesNoDialog = new OptionDialog(null, "Clean Raw File", "Erase all associated Row file except DB-Linded");
        yesNoDialog.setIconImage(IconManager.getImage((IconManager.IconType)IconManager.IconType.ERASER));
        yesNoDialog.setLocation(posX, posY);
        yesNoDialog.setVisible(true);
        if (yesNoDialog.getButtonClicked() == 0) {
            this.m_model.cleanRawFile();
            this.resetDropZonePanel();
            this.repaint();
        }
    }

    protected static class FlatDesignTableModel
    extends DecoratedTableModel
    implements TreeFileChooserTableModelInterface {
        public static final int COLTYPE_GROUP = 0;
        public static final int COLTYPE_SAMPLE = 1;
        public static final int COLTYPE_SAMPLE_ANALYSIS = 2;
        public static final int COLTYPE_RAW_FILE = 3;
        public static final int COLTYPE_RAW_FILE_DIRECTORY = 4;
        public static final int COLTYPE_PEAKLIST = 5;
        public static final int COLTYPE_ASSOCIATION_SOURCE = 6;
        private static final String[] columnNames = new String[]{"Group", "Sample", "Sample Analysis", "mzDB File", "mzDB File Path", "Peaklist", "Association Source"};
        private XICDropZone m_dropZone = null;
        private final ArrayList<NodeModelRow> m_dataList = new ArrayList();
        private final HashMap<Integer, HashSet<String>> m_potentialFileNameForMissings = new HashMap();

        public void setXICDropZone(XICDropZone dropZone) {
            this.m_dropZone = dropZone;
        }

        public XICDropZone getXICDropZone() {
            return this.m_dropZone;
        }

        public void setData(AbstractNode rootNode) {
            this.m_dataList.clear();
            this.parseTree(rootNode);
            this.fireTableDataChanged();
        }

        private void parseTree(AbstractNode node) {
            if (node.getType() == AbstractNode.NodeTypes.BIOLOGICAL_GROUP) {
                this.parseGroup((XICBiologicalGroupNode)node);
            } else {
                int nbChildren = node.getChildCount();
                for (int i = 0; i < nbChildren; ++i) {
                    AbstractNode child = (AbstractNode)node.getChildAt(i);
                    this.parseTree(child);
                }
            }
        }

        private void parseGroup(XICBiologicalGroupNode groupNode) {
            int nbChildren = groupNode.getChildCount();
            for (int i = 0; i < nbChildren; ++i) {
                AbstractNode child = (AbstractNode)groupNode.getChildAt(i);
                if (child.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE) continue;
                this.parseSample(groupNode, (XICBiologicalSampleNode)child);
            }
        }

        private void parseSample(XICBiologicalGroupNode groupNode, XICBiologicalSampleNode sampleNode) {
            int nbChildren = sampleNode.getChildCount();
            for (int i = 0; i < nbChildren; ++i) {
                AbstractNode child = (AbstractNode)sampleNode.getChildAt(i);
                if (child.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) continue;
                XICBiologicalSampleAnalysisNode sampleAnalysisNode = (XICBiologicalSampleAnalysisNode)child;
                if (sampleAnalysisNode.getXicRunNode() == null) {
                    XICRunNode runNode = new XICRunNode((AbstractData)new RunInfoData(), (DefaultTreeModel)IdentificationTree.getCurrentTree().getModel());
                    runNode.addXICRunNodeInitListener(m_singleton);
                    sampleAnalysisNode.addXicRunNode(runNode, true);
                    runNode.init(sampleAnalysisNode.getDataset(), (AbstractTableModel)((Object)this));
                } else {
                    sampleAnalysisNode.add(sampleAnalysisNode.getXicRunNode());
                }
                this.parseRun(groupNode, sampleNode, (XICBiologicalSampleAnalysisNode)child);
            }
        }

        private void parseRun(XICBiologicalGroupNode groupNode, XICBiologicalSampleNode sampleNode, XICBiologicalSampleAnalysisNode sampleAnalysisNode) {
            int nbChildren = sampleAnalysisNode.getChildCount();
            for (int i = 0; i < nbChildren; ++i) {
                AbstractNode child = (AbstractNode)sampleAnalysisNode.getChildAt(i);
                if (child.getType() != AbstractNode.NodeTypes.RUN) continue;
                this.m_dataList.add(new NodeModelRow(groupNode, sampleNode, sampleAnalysisNode, (XICRunNode)child));
            }
        }

        public int getRowCount() {
            if (this.m_dataList == null) {
                return 0;
            }
            return this.m_dataList.size();
        }

        public int getColumnCount() {
            return columnNames.length;
        }

        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return String.class;
                }
                case 6: {
                    return RunInfoData.Status.class;
                }
            }
            return null;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            NodeModelRow nodeModelRow = this.m_dataList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return nodeModelRow.m_group.toString();
                }
                case 1: {
                    return nodeModelRow.m_sample.toString();
                }
                case 2: {
                    return nodeModelRow.m_sampleAnalysis.toString();
                }
                case 3: {
                    return nodeModelRow.m_run.toString();
                }
                case 4: {
                    RunInfoData infoD = (RunInfoData)nodeModelRow.m_run.getData();
                    String directory = "";
                    if (infoD != null) {
                        if (infoD.getLinkedRawFile() != null) {
                            directory = infoD.getLinkedRawFile().getRawFileDirectory();
                        } else if (infoD.getRawFileOnDisk() != null) {
                            File f = infoD.getRawFileOnDisk();
                            directory = Paths.get(f.getPath(), new String[0]).getParent().toString();
                        } else if (infoD.getSelectedRawFile() != null) {
                            directory = infoD.getSelectedRawFile().getRawFileDirectory();
                        }
                    }
                    return directory;
                }
                case 5: {
                    if (nodeModelRow == null) {
                        return "<html><font color='#FF0000'>NodeModelRow is null</font></html>";
                    }
                    return nodeModelRow.getName();
                }
                case 6: {
                    RunInfoData info = (RunInfoData)nodeModelRow.m_run.getData();
                    if (info != null) {
                        return info.getStatus();
                    }
                    return RunInfoData.Status.MISSING;
                }
            }
            return null;
        }

        public XICRunNode getXICRunNode(int row) {
            NodeModelRow nodeModelRow = this.m_dataList.get(row);
            return nodeModelRow.m_run;
        }

        public XICRunNode getXICRunNode(int row, int col) {
            NodeModelRow nodeModelRow = this.m_dataList.get(row);
            return nodeModelRow.m_run;
        }

        public XICBiologicalSampleAnalysisNode getXICBiologicalSampleAnalysisNode(int row) {
            NodeModelRow nodeModelRow = this.m_dataList.get(row);
            return nodeModelRow.m_sampleAnalysis;
        }

        public String getToolTipForHeader(int col) {
            return this.getColumnName(col);
        }

        public String getTootlTipValue(int row, int col) {
            return null;
        }

        public TableCellRenderer getRenderer(int row, int col) {
            return null;
        }

        @Override
        public void setFiles(ArrayList<File> fileList, int rowIndex) {
            int nbFiles = fileList.size();
            int nbRows = this.getRowCount();
            for (int i = rowIndex; i < rowIndex + nbFiles && i < nbRows; ++i) {
                NodeModelRow nodeModelRow = this.m_dataList.get(i);
                final int _curRow = i;
                ((RunInfoData)nodeModelRow.m_run.getData()).setStatus(RunInfoData.Status.USER_DEFINED);
                nodeModelRow.m_run.setRawFile(fileList.get(i - rowIndex), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.fireTableRowsUpdated(_curRow, _curRow);
                        this.updatePotentialsListForMissings();
                    }
                });
            }
        }

        public void updatePotentialsListForMissings() {
            this.m_potentialFileNameForMissings.clear();
            int numberOfRows = this.getRowCount();
            for (int i = 0; i < numberOfRows; ++i) {
                RunInfoData info;
                NodeModelRow nodeModelRow = this.m_dataList.get(i);
                XICRunNode currentXicNode = nodeModelRow.m_run;
                if (currentXicNode == null || (info = (RunInfoData)currentXicNode.getData()).getStatus() != RunInfoData.Status.MISSING) continue;
                HashMap rawFiles = info.getPotentialRawFiles();
                HashSet<String> set = new HashSet<String>();
                if (info.hasPotentialRawFiles()) {
                    for (String key : rawFiles.keySet()) {
                        set.add(HelpUtils.getFileName((String)key.toLowerCase(), (String[])SUFFIX));
                    }
                } else if (info.getPeakListPath() != null) {
                    set.add(HelpUtils.getFileName((String)info.getPeakListPath().toLowerCase(), (String[])SUFFIX));
                }
                this.m_potentialFileNameForMissings.put(i, set);
            }
        }

        public HashMap<Integer, HashSet<String>> getPotentialFilenamesForMissings() {
            return this.m_potentialFileNameForMissings;
        }

        @Override
        public boolean shouldConfirmCorruptFiles(ArrayList<Integer> indices) {
            for (int i = 0; i < indices.size(); ++i) {
                RunInfoData.Status status = ((RunInfoData)this.getXICRunNode(indices.get(i)).getData()).getStatus();
                if (status != RunInfoData.Status.LAST_DEFINED) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean canSetFiles(ArrayList<Integer> indices) {
            for (int i = 0; i < indices.size(); ++i) {
                if (((RunInfoData)this.getXICRunNode(indices.get(i)).getData()).getStatus() != RunInfoData.Status.LINKED_IN_DATABASE) continue;
                return false;
            }
            return true;
        }

        private void cleanRawFile() {
            if (this.m_dataList != null) {
                for (NodeModelRow node : this.m_dataList) {
                    RunInfoData userObject = (RunInfoData)node.m_run.getData();
                    RunInfoData.Status status = userObject.getStatus();
                    if (status == RunInfoData.Status.LINKED_IN_DATABASE) continue;
                    RawFile linkedFile = userObject.getSelectedRawFile();
                    if (linkedFile != null) {
                        userObject.addPotentialRawFiles(linkedFile);
                    }
                    userObject.setStatus(RunInfoData.Status.MISSING);
                    userObject.setSelectedRawFile(null);
                    userObject.setMessage("<html><font color='#FF0000'>Missing Raw File</font></html>");
                }
                this.updatePotentialsListForMissings();
                this.fireTableDataChanged();
            }
        }
    }

    private class FlatDesignTable
    extends DecoratedMarkerTable
    implements MouseListener {
        public FlatDesignTable() {
            this.setDragEnabled(true);
            this.setDropMode(DropMode.ON);
            this.setTransferHandler(SelectRawFilesPanel.this.m_transferHandler);
            this.addMouseListener(this);
        }

        private void setColumnsVisibility() {
            List columns = this.getColumns(true);
            TableColumnExt columnExt = (TableColumnExt)columns.get(4);
            if (columnExt != null) {
                columnExt.setVisible(false);
            }
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            int columnM = this.convertColumnIndexToModel(column);
            switch (columnM) {
                case 6: {
                    return new LinkAssociationRenderer();
                }
            }
            return super.getCellRenderer(this.convertRowIndexToModel(row), columnM);
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        public TablePopupMenu initPopupMenu() {
            return null;
        }

        public void prepostPopupMenu() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                RawFile rawFile;
                int row = this.rowAtPoint(e.getPoint());
                int col = this.columnAtPoint(e.getPoint());
                if (row == -1 || col == -1) {
                    return;
                }
                XICRunNode runNode = SelectRawFilesPanel.this.m_model.getXICRunNode(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(col));
                if (runNode == null || runNode.isChanging()) {
                    return;
                }
                RunInfoData runInfoData = (RunInfoData)runNode.getData();
                if (runInfoData.getLinkedRawFile() != null) {
                    return;
                }
                HashMap potentialRawFiles = runInfoData.getPotentialRawFiles();
                if (potentialRawFiles == null) {
                    return;
                }
                SelectRawFileDialog selectRawFileDialog = SelectRawFileDialog.getSelectRawFileDialog((Window)((Object)CreateQuantitationDialog.getDialog(null)));
                selectRawFileDialog.init(potentialRawFiles, runInfoData);
                int x = (int)(CreateQuantitationDialog.getDialog(null).getLocationOnScreen().getX() + (double)(CreateQuantitationDialog.getDialog(null).getWidth() / 2));
                int y = (int)CreateQuantitationDialog.getDialog(null).getLocationOnScreen().getY();
                selectRawFileDialog.setLocation(x, y);
                selectRawFileDialog.setVisible(true);
                if (selectRawFileDialog.getButtonClicked() == 0 && (rawFile = selectRawFileDialog.getSelectedRawFile()) != null) {
                    runInfoData.setSelectedRawFile(rawFile);
                    runInfoData.setStatus(RunInfoData.Status.USER_DEFINED);
                    runInfoData.setRun((Run)rawFile.getRuns().get(0));
                    SelectRawFilesPanel.this.m_model.fireTableDataChanged();
                    SelectRawFilesPanel.this.m_model.updatePotentialsListForMissings();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private static class NodeModelRow {
        private XICBiologicalGroupNode m_group;
        private XICBiologicalSampleNode m_sample;
        private XICBiologicalSampleAnalysisNode m_sampleAnalysis;
        private XICRunNode m_run;
        private String m_name;

        public NodeModelRow(XICBiologicalGroupNode group, XICBiologicalSampleNode sample, XICBiologicalSampleAnalysisNode sampleAnalysis, XICRunNode run) {
            this.m_group = group;
            this.m_sample = sample;
            this.m_sampleAnalysis = sampleAnalysis;
            this.m_run = run;
            this.m_name = HelpUtils.getFileName((String)this.m_sampleAnalysis.getResultSet().getMsiSearch().getPeaklist().getPath(), (String[])SUFFIX);
        }

        public XICBiologicalSampleAnalysisNode getXICBiologicalSampleAnalysisNode() {
            return this.m_sampleAnalysis;
        }

        public String getName() {
            return this.m_name;
        }
    }

    private class LinkAssociationRenderer
    extends DefaultTableCellRenderer {
        private LinkAssociationRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            if (value instanceof RunInfoData.Status) {
                RunInfoData.Status status = (RunInfoData.Status)value;
                switch (status) {
                    case MISSING: {
                        this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.DELETE));
                        this.setToolTipText(SelectRawFilesPanel.MISSING_ASSOCIATION);
                        break;
                    }
                    case LAST_DEFINED: {
                        this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.TARGET));
                        this.setToolTipText(SelectRawFilesPanel.PREVIOUS_LINK_ASSOCIATION);
                        break;
                    }
                    case SYSTEM_PROPOSED: {
                        this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.TARGET));
                        this.setToolTipText(SelectRawFilesPanel.AUTOMATIC_ASSOCIATION);
                        break;
                    }
                    case USER_DEFINED: {
                        this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.USER));
                        this.setToolTipText(SelectRawFilesPanel.USER_DEFINED_ASSOCIATION);
                        break;
                    }
                    case LINKED_IN_DATABASE: {
                        this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.DATABASES_RELATION));
                        this.setToolTipText(SelectRawFilesPanel.EXISTING_ASSOCIATION);
                        break;
                    }
                    case NOT_INITIALIZED: {
                        this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.DELETE));
                        this.setToolTipText(SelectRawFilesPanel.NOT_INITIALIZED_ASSOCIATION);
                    }
                }
            }
            this.setHorizontalAlignment(0);
            if (isSelected) {
                this.setBackground(UIManager.getDefaults().getColor("Table.selectionBackground"));
                this.setForeground(Color.WHITE);
            } else {
                this.setBackground(UIManager.getDefaults().getColor("Table.background"));
                this.setForeground(Color.BLACK);
            }
            return this;
        }
    }
}

