/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic.aggregation;

import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.Exceptions;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.aggregation.DQuantitationChannelMapping;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.aggregation.QCMappingTreeTable;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.aggregation.QCMappingTreeTableModel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.xic.AbstractTreeTransferHandler;
import fr.proline.studio.rsmexplorer.tree.xic.XICSelectionTransferable;
import java.awt.Component;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QCMappingTransferHandler
extends AbstractTreeTransferHandler {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private QCMappingTreeTable m_treeTable;
    private QCMappingTreeTableModel m_treeTableModel;

    public QCMappingTransferHandler(QCMappingTreeTable tree) {
        super(false, -1);
        this.m_treeTable = tree;
        this.m_treeTableModel = (QCMappingTreeTableModel)this.m_treeTable.getTreeTableModel();
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        support.setShowDropLocation(true);
        if (support.isDataFlavorSupported(XICSelectionTransferable.RSMNodeList_FLAVOR)) {
            JTable.DropLocation dropLocation = (JTable.DropLocation)support.getDropLocation();
            if (dropLocation == null || dropLocation.getRow() == -1 || dropLocation.getColumn() == -1 || dropLocation.getColumn() == 0) {
                return false;
            }
            int currentRow = dropLocation.getRow();
            AbstractNode dropChannelTreeNode = this.m_treeTable.getNodeForRow(currentRow);
            DQuantitationChannelMapping dropLocationMapping = this.m_treeTableModel.getMapping().get(dropChannelTreeNode);
            if (dropLocationMapping == null) {
                return false;
            }
            AbstractNode.NodeTypes designNodeType = null;
            try {
                XICSelectionTransferable transfer = (XICSelectionTransferable)support.getTransferable().getTransferData(XICSelectionTransferable.RSMNodeList_FLAVOR);
                XICSelectionTransferable.TransferData data = XICSelectionTransferable.getData(transfer.getTransferKey());
                designNodeType = data.getDesignNodeType();
                ArrayList<AbstractNode> nodesList = data.getDesignList();
                if (nodesList != null && !nodesList.isEmpty()) {
                    AbstractData rootData = ((AbstractNode)nodesList.get(0).getRoot()).getData();
                    DDataset sourceDS = ((DataSetData)rootData).getDataset();
                    DDataset destDS = this.m_treeTableModel.getDatasetAt(dropLocation.getColumn());
                    if (sourceDS.getId() != destDS.getId()) {
                        return false;
                    }
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                m_logger.error(this.getClass().getSimpleName() + " DnD error ", (Throwable)e);
                return false;
            }
            return designNodeType == AbstractNode.NodeTypes.BIOLOGICAL_GROUP || designNodeType == AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        try {
            XICSelectionTransferable transfer = (XICSelectionTransferable)support.getTransferable().getTransferData(XICSelectionTransferable.RSMNodeList_FLAVOR);
            XICSelectionTransferable.TransferData transferData = XICSelectionTransferable.getData(transfer.getTransferKey());
            ArrayList<AbstractNode> transferDsNodesList = transferData.getDesignList();
            if (transferDsNodesList == null) {
                return false;
            }
            JTable.DropLocation dropLocation = (JTable.DropLocation)support.getDropLocation();
            int currentRow = dropLocation.getRow();
            AbstractNode dropChannelTreeNode = this.m_treeTable.getNodeForRow(currentRow);
            DDataset dropLocationDs = this.m_treeTableModel.getDatasetAt(dropLocation.getColumn());
            for (AbstractNode dsNode : transferDsNodesList) {
                switch (dsNode.getType()) {
                    case BIOLOGICAL_GROUP: {
                        m_logger.info("moving group");
                    }
                    case BIOLOGICAL_SAMPLE_ANALYSIS: {
                        int nextRowIndex;
                        DQuantitationChannelMapping dropLocationMapping = this.m_treeTableModel.getMapping().get(dropChannelTreeNode);
                        if (dropLocationMapping != null) {
                            DataSetData userObject = (DataSetData)dsNode.getData();
                            dropLocationMapping.put(dropLocationDs, userObject.getChannelNumber());
                        }
                        if ((nextRowIndex = this.m_treeTable.getNextChannelRowIndex(currentRow, 1)) != -1) {
                            dropChannelTreeNode = this.m_treeTable.getNodeForRow(nextRowIndex);
                            currentRow = nextRowIndex;
                        } else {
                            dropChannelTreeNode = null;
                        }
                        if (dropChannelTreeNode != null) break;
                        break;
                    }
                }
            }
            String doubleChannel = this.m_treeTableModel.redundantChannel(dropLocationDs);
            if (doubleChannel != null && !doubleChannel.isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)this.m_treeTable), doubleChannel);
            }
            return false;
        }
        catch (UnsupportedFlavorException ex) {
            m_logger.error(this.getClass().getSimpleName() + " DnD error ", (Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return false;
    }
}

