/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.editor;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FloatTableCellEditor
extends DefaultCellEditor {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private int m_digits = 2;

    public FloatTableCellEditor(int digits) {
        super(new JTextField());
        this.editorComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ((JTextField)e.getComponent()).selectAll();
            }
        });
        this.m_digits = digits;
    }

    @Override
    public Object getCellEditorValue() {
        return super.getCellEditorValue();
    }

    @Override
    public boolean stopCellEditing() {
        try {
            Float.valueOf(this.getCellEditorValue().toString());
            this.fireEditingStopped();
            return true;
        }
        catch (NumberFormatException nfe) {
            String fVal = this.getCellEditorValue().toString().replace(',', '.');
            try {
                Float.valueOf(fVal);
                this.delegate.setValue(fVal);
                this.fireEditingStopped();
                return true;
            }
            catch (NumberFormatException nfe2) {
                return false;
            }
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return super.getTableCellEditorComponent(table, "", isSelected, row, column);
    }
}

