/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.model;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.PeptideReadablePtmString;
import fr.proline.core.orm.msi.SequenceMatch;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.studio.corewrapper.util.PeptideClassesUtils;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.BooleanFilter;
import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.renderer.BooleanRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.FloatRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.MsQueryRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.PeptideRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.ScoreRenderer;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.LazyTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultAlignRenderer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class PeptideMatchTableModel
extends LazyTableModel
implements GlobalTableModelInterface {
    public static final int COLTYPE_PEPTIDE_ID = 0;
    public static final int COLTYPE_PEPTIDE_PREVIOUS_AA = 1;
    public static final int COLTYPE_PEPTIDE_NAME = 2;
    public static final int COLTYPE_PEPTIDE_NEXT_AA = 3;
    public static final int COLTYPE_PEPTIDE_LENGTH = 4;
    public static final int COLTYPE_PEPTIDE_PTM = 5;
    public static final int COLTYPE_PEPTIDE_SCORE = 6;
    public static final int COLTYPE_PEPTIDE_START = 7;
    public static final int COLTYPE_PEPTIDE_STOP = 8;
    public static final int COLTYPE_PEPTIDE_CALCULATED_MASS = 9;
    public static final int COLTYPE_PEPTIDE_EXPERIMENTAL_MOZ = 10;
    public static final int COLTYPE_PEPTIDE_PPM = 11;
    public static final int COLTYPE_PEPTIDE_CHARGE = 12;
    public static final int COLTYPE_PEPTIDE_MISSED_CLIVAGE = 13;
    public static final int COLTYPE_PEPTIDE_RANK = 14;
    public static final int COLTYPE_PEPTIDE_RETENTION_TIME = 15;
    public static final int COLTYPE_PEPTIDE_PROTEIN_SET_COUNT = 16;
    public static final int COLTYPE_PEPTIDE_PROTEIN_SET_NAMES = 17;
    public static final int COLTYPE_PEPTIDE_ION_PARENT_INTENSITY = 18;
    public static final int COLTYPE_PEPTIDE_IS_DECOY = 19;
    public static final int COLTYPE_PEPTIDE_IS_VALIDATED = 20;
    public static final int COLTYPE_PEPTIDE_MSQUERY = 21;
    public static final int COLTYPE_SRC_DAT_FILE = 22;
    public static final int COLTYPE_SPECTRUM_TITLE = 23;
    private static final String[] m_columnNames = new String[]{"Id", "Prev. AA", "Peptide", "Next AA", "Length", "PTMs", "Score", "Start", "Stop", "Calc. Mass", "Exp. MoZ", "Ppm", "Charge", "Missed Cl.", "Rank", "RT", "Protein Set Count", "Protein Sets", "Ion Parent Int.", "Decoy", "Validated", "MsQuery", ".dat File", "Spectrum Title"};
    private static final String[] m_columnTooltips = new String[]{"PeptideMatch Id", "Previous Amino Acid", "Peptide", "Next Amino Acid", "Length", "Post Translational Modifications", "Score", "Start", "Stop", "Calculated Mass", "Experimental Mass to Charge Ratio", "parts-per-million", "Charge", "Missed Clivage", "Pretty Rank", "Retention Time (min)", "Potein Set Count", "Protein Sets", "Ion Parent Intensity", "Is Decoy", "Is Validated", "MsQuery", ".dat file of best PSM", "Spectrum Title"};
    private final ArrayList<Integer> m_colUsed = new ArrayList();
    private DPeptideMatch[] m_peptideMatches = null;
    private long[] m_peptideMatchesId = null;
    private final boolean m_forRSM;
    private final boolean m_hasPrevNextAA;
    private final boolean m_isDecoyAndValidated;
    private final boolean m_isMerged;
    private ScoreRenderer m_scoreRenderer = new ScoreRenderer();
    private String m_modelName;
    private final StringBuilder m_sb = new StringBuilder();
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();

    public PeptideMatchTableModel(LazyTable table, boolean forRSM, boolean hasPrevNextAA, boolean isDecoyAndValidated, boolean isMerged) {
        super(table);
        this.m_forRSM = forRSM;
        this.m_hasPrevNextAA = hasPrevNextAA;
        this.m_isDecoyAndValidated = isDecoyAndValidated;
        this.m_isMerged = isMerged;
        this.m_colUsed.add(0);
        if (hasPrevNextAA) {
            this.m_colUsed.add(1);
        }
        this.m_colUsed.add(2);
        if (hasPrevNextAA) {
            this.m_colUsed.add(3);
        }
        this.m_colUsed.add(4);
        this.m_colUsed.add(5);
        this.m_colUsed.add(6);
        if (hasPrevNextAA) {
            this.m_colUsed.add(7);
            this.m_colUsed.add(8);
        }
        this.m_colUsed.add(9);
        this.m_colUsed.add(10);
        this.m_colUsed.add(11);
        this.m_colUsed.add(12);
        this.m_colUsed.add(13);
        this.m_colUsed.add(14);
        this.m_colUsed.add(15);
        if (forRSM) {
            this.m_colUsed.add(16);
            this.m_colUsed.add(17);
        }
        this.m_colUsed.add(18);
        if (isDecoyAndValidated) {
            this.m_colUsed.add(19);
            if (forRSM) {
                this.m_colUsed.add(20);
            }
        }
        this.m_colUsed.add(21);
        if (isMerged) {
            this.m_colUsed.add(22);
        }
        this.m_colUsed.add(23);
    }

    public int convertColToColUsed(int col) {
        for (int i = 0; i < this.m_colUsed.size(); ++i) {
            if (col != this.m_colUsed.get(i)) continue;
            return i;
        }
        return -1;
    }

    public DPeptideMatch getPeptideMatch(int row) {
        return this.m_peptideMatches[row];
    }

    public int getColumnCount() {
        return this.m_colUsed.size();
    }

    public String getColumnName(int col) {
        return m_columnNames[this.m_colUsed.get(col)];
    }

    public String getToolTipForHeader(int col) {
        return m_columnTooltips[this.m_colUsed.get(col)];
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public Class getColumnClass(int col) {
        if ((col = this.m_colUsed.get(col).intValue()) == 0) {
            return Long.class;
        }
        return LazyData.class;
    }

    @Override
    public int getSubTaskId(int col) {
        col = col == -1 ? -1 : this.m_colUsed.get(col);
        switch (col) {
            case 13: 
            case 19: 
            case 20: {
                return 0;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                return 1;
            }
            case 15: 
            case 21: 
            case 23: {
                return 2;
            }
            case 18: {
                return 2;
            }
            case 16: 
            case 17: {
                return 3;
            }
            case 22: {
                return 4;
            }
        }
        return -1;
    }

    public int getRowCount() {
        if (this.m_peptideMatches == null) {
            return 0;
        }
        return this.m_peptideMatches.length;
    }

    public Object getValueAt(int row, int col) {
        LazyData lazyData = this.getLazyData(row, col);
        col = this.m_colUsed.get(col);
        DPeptideMatch peptideMatch = this.m_peptideMatches[row];
        if (peptideMatch == null) {
            this.givePriorityTo(this.m_taskId, row, 13);
            lazyData.setData(null);
            return lazyData;
        }
        switch (col) {
            case 0: {
                return peptideMatch.getId();
            }
            case 1: {
                SequenceMatch sequenceMatch = peptideMatch.getSequenceMatch();
                if (sequenceMatch == null) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                } else {
                    Character residueBefore = sequenceMatch.getResidueBefore();
                    if (residueBefore != null) {
                        lazyData.setData((Comparable)((Object)String.valueOf(Character.toUpperCase(residueBefore.charValue()))));
                    } else {
                        lazyData.setData((Comparable)((Object)""));
                    }
                }
                return lazyData;
            }
            case 2: {
                if (this.m_hasPrevNextAA) {
                    SequenceMatch sequenceMatch = peptideMatch.getSequenceMatch();
                    if (sequenceMatch == null) {
                        this.givePriorityTo(this.m_taskId, row, col);
                        lazyData.setData(null);
                    } else {
                        lazyData.setData((Comparable)peptideMatch);
                    }
                } else {
                    lazyData.setData((Comparable)peptideMatch);
                }
                return lazyData;
            }
            case 3: {
                SequenceMatch sequenceMatch = peptideMatch.getSequenceMatch();
                if (sequenceMatch == null) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                } else {
                    Character residueAfter = sequenceMatch.getResidueAfter();
                    if (residueAfter != null) {
                        lazyData.setData((Comparable)((Object)String.valueOf(Character.toUpperCase(residueAfter.charValue()))));
                    } else {
                        lazyData.setData((Comparable)((Object)""));
                    }
                }
                return lazyData;
            }
            case 4: {
                if (peptideMatch == null || peptideMatch.getPeptide() == null || peptideMatch.getPeptide().getSequence() == null) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                } else {
                    lazyData.setData((Comparable)Integer.valueOf(peptideMatch.getPeptide().getSequence().length()));
                }
                return lazyData;
            }
            case 6: {
                Float score = Float.valueOf(peptideMatch.getScore().floatValue());
                lazyData.setData((Comparable)score);
                return lazyData;
            }
            case 7: {
                SequenceMatch sequenceMatch = peptideMatch.getSequenceMatch();
                if (sequenceMatch == null) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                } else {
                    int start = sequenceMatch.getId().getStart();
                    lazyData.setData((Comparable)Integer.valueOf(start));
                }
                return lazyData;
            }
            case 8: {
                SequenceMatch sequenceMatch = peptideMatch.getSequenceMatch();
                if (sequenceMatch == null) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                } else {
                    int stop = sequenceMatch.getId().getStop();
                    lazyData.setData((Comparable)Integer.valueOf(stop));
                }
                return lazyData;
            }
            case 21: {
                if (!peptideMatch.isMsQuerySet()) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                } else {
                    DMsQuery msQuery = peptideMatch.getMsQuery();
                    lazyData.setData((Comparable)msQuery);
                }
                return lazyData;
            }
            case 14: {
                lazyData.setData((Comparable)(peptideMatch.getCDPrettyRank() == null ? "" : peptideMatch.getCDPrettyRank()));
                return lazyData;
            }
            case 12: {
                lazyData.setData((Comparable)Integer.valueOf(peptideMatch.getCharge()));
                return lazyData;
            }
            case 10: {
                BigDecimal bd = new BigDecimal(peptideMatch.getExperimentalMoz());
                Float expMoz = Float.valueOf(bd.setScale(4, RoundingMode.HALF_UP).floatValue());
                lazyData.setData((Comparable)expMoz);
                return lazyData;
            }
            case 11: {
                Peptide peptide = peptideMatch.getPeptide();
                if (peptide == null) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                    return lazyData;
                }
                float ppm = PeptideClassesUtils.getPPMFor((DPeptideMatch)peptideMatch, (Peptide)peptide).floatValue();
                lazyData.setData((Comparable)Float.valueOf(ppm));
                return lazyData;
            }
            case 9: {
                Peptide peptide = peptideMatch.getPeptide();
                if (peptide == null) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                } else {
                    BigDecimal bd = new BigDecimal(peptide.getCalculatedMass());
                    Float calculatedMass = Float.valueOf(bd.setScale(4, RoundingMode.HALF_UP).floatValue());
                    lazyData.setData((Comparable)calculatedMass);
                }
                return lazyData;
            }
            case 13: {
                lazyData.setData((Comparable)Integer.valueOf(peptideMatch.getMissedCleavage()));
                return lazyData;
            }
            case 15: {
                if (!peptideMatch.isMsQuerySet()) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                } else {
                    Float retentionTime = peptideMatch.getRetentionTime();
                    if (retentionTime == null) {
                        lazyData.setData((Comparable)Float.valueOf(Float.NaN));
                    } else {
                        lazyData.setData((Comparable)retentionTime);
                    }
                }
                return lazyData;
            }
            case 23: {
                if (!peptideMatch.isMsQuerySet()) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                } else {
                    String spectrumTitle = peptideMatch.getMsQuery().getDSpectrum().getTitle();
                    lazyData.setData((Comparable)((Object)spectrumTitle));
                }
                return lazyData;
            }
            case 18: {
                if (!peptideMatch.isMsQuerySet()) {
                    this.givePriorityTo(this.m_taskId, row, 21);
                    lazyData.setData(null);
                } else {
                    DMsQuery msQuery = peptideMatch.getMsQuery();
                    Float precursorIntenstity = msQuery.getPrecursorIntensity();
                    if (precursorIntenstity == null) {
                        lazyData.setData((Comparable)Float.valueOf(Float.NaN));
                    } else {
                        lazyData.setData((Comparable)precursorIntenstity);
                    }
                }
                return lazyData;
            }
            case 5: {
                Peptide peptide = peptideMatch.getPeptide();
                if (peptide == null) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                    return lazyData;
                }
                boolean ptmStringLoadeed = peptide.getTransientData().isPeptideReadablePtmStringLoaded();
                if (!ptmStringLoadeed) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                    return lazyData;
                }
                String ptm = "";
                PeptideReadablePtmString ptmString = peptide.getTransientData().getPeptideReadablePtmString();
                if (ptmString != null) {
                    ptm = ptmString.getReadablePtmString();
                }
                lazyData.setData((Comparable)((Object)ptm));
                return lazyData;
            }
            case 16: {
                String[] proteinSetNames = peptideMatch.getProteinSetStringArray();
                if (proteinSetNames == null) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                } else {
                    lazyData.setData((Comparable)Integer.valueOf(proteinSetNames.length));
                }
                return lazyData;
            }
            case 17: {
                String[] proteinSetNames = peptideMatch.getProteinSetStringArray();
                if (proteinSetNames == null) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                } else {
                    for (int i = 0; i < proteinSetNames.length; ++i) {
                        String name = proteinSetNames[i];
                        if (i < proteinSetNames.length - 1) {
                            this.m_sb.append(name).append(", ");
                            continue;
                        }
                        this.m_sb.append(name);
                    }
                    lazyData.setData((Comparable)((Object)this.m_sb.toString()));
                    this.m_sb.setLength(0);
                }
                return lazyData;
            }
            case 19: {
                Boolean isDecoy = peptideMatch.isDecoy();
                lazyData.setData((Comparable)isDecoy);
                return lazyData;
            }
            case 20: {
                Boolean isValidated = peptideMatch.isValidated();
                lazyData.setData((Comparable)isValidated);
                return lazyData;
            }
            case 22: {
                String srcDatFile = peptideMatch.getSourceDatFile();
                if (srcDatFile == null) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                } else {
                    lazyData.setData((Comparable)((Object)srcDatFile));
                }
                return lazyData;
            }
        }
        return null;
    }

    public void setData(Long taskId, DPeptideMatch[] peptideMatches, long[] peptideMatchesId) {
        this.m_peptideMatches = peptideMatches;
        this.m_peptideMatchesId = peptideMatchesId;
        this.m_taskId = taskId;
        this.updateMinMax();
        this.fireTableDataChanged();
    }

    private void updateMinMax() {
        if (this.m_peptideMatches == null) {
            return;
        }
        if (this.m_scoreRenderer == null) {
            return;
        }
        float maxScore = 0.0f;
        for (DPeptideMatch peptideMatch : this.m_peptideMatches) {
            float score;
            if (peptideMatch == null || !((score = peptideMatch.getScore().floatValue()) > maxScore)) continue;
            maxScore = score;
        }
        this.m_scoreRenderer.setMaxValue(maxScore);
    }

    public DPeptideMatch[] getPeptideMatches() {
        return this.m_peptideMatches;
    }

    public long getResultSetId() {
        if (this.m_peptideMatches == null || this.m_peptideMatches.length == 0) {
            return -1L;
        }
        return this.m_peptideMatches[0].getResultSetId();
    }

    public void dataUpdated() {
        this.fireTableDataChanged();
    }

    public int findRow(long peptideMatchId) {
        int nb = this.m_peptideMatches.length;
        for (int i = 0; i < nb; ++i) {
            if (peptideMatchId != this.m_peptideMatchesId[i]) continue;
            return i;
        }
        return -1;
    }

    public void sortAccordingToModel(ArrayList<Long> peptideMatchIds, CompoundTableModel compoundTableModel) {
        if (this.m_peptideMatches == null) {
            return;
        }
        HashSet<Long> peptideMatchIdMap = new HashSet<Long>(peptideMatchIds.size());
        peptideMatchIdMap.addAll(peptideMatchIds);
        int nb = this.m_table.getRowCount();
        int iCur = 0;
        for (int iView = 0; iView < nb; ++iView) {
            Long psId;
            int iModel = this.m_table.convertRowIndexToModel(iView);
            if (compoundTableModel != null) {
                iModel = compoundTableModel.convertCompoundRowToBaseModelRow(iModel);
            }
            if (!peptideMatchIdMap.contains(psId = Long.valueOf(this.m_peptideMatchesId[iModel]))) continue;
            peptideMatchIds.set(iCur++, psId);
        }
    }

    private void putFilter(int modelColumnType, Class filterClass, ConvertValueInterface converter, LinkedHashMap<Integer, Filter> filtersMap) {
        int usedColIndex = this.convertColToColUsed(modelColumnType);
        StringDiffFilter filter = null;
        if (usedColIndex != -1) {
            if (filterClass == StringDiffFilter.class) {
                filter = new StringDiffFilter(this.getColumnName(usedColIndex), converter, usedColIndex);
            } else if (filterClass == IntegerFilter.class) {
                filter = new IntegerFilter(this.getColumnName(usedColIndex), converter, usedColIndex);
            } else if (filterClass == DoubleFilter.class) {
                filter = new DoubleFilter(this.getColumnName(usedColIndex), converter, usedColIndex);
            } else if (filterClass == BooleanFilter.class) {
                filter = new BooleanFilter(this.getColumnName(usedColIndex), converter, usedColIndex);
            }
            if (filter != null) {
                filtersMap.put(usedColIndex, (Filter)filter);
            }
        }
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        if (this.m_hasPrevNextAA) {
            this.putFilter(1, StringDiffFilter.class, null, filtersMap);
        }
        ConvertValueInterface peptideConverter = new ConvertValueInterface(){

            public Object convertValue(Object o) {
                if (o == null) {
                    return null;
                }
                return ((DPeptideMatch)o).getPeptide().getSequence();
            }
        };
        this.putFilter(2, StringDiffFilter.class, peptideConverter, filtersMap);
        if (this.m_hasPrevNextAA) {
            this.putFilter(3, StringDiffFilter.class, null, filtersMap);
        }
        this.putFilter(4, IntegerFilter.class, null, filtersMap);
        this.putFilter(6, DoubleFilter.class, null, filtersMap);
        if (this.m_hasPrevNextAA) {
            this.putFilter(7, IntegerFilter.class, null, filtersMap);
            this.putFilter(8, IntegerFilter.class, null, filtersMap);
        }
        ConvertValueInterface msQueryConverter = new ConvertValueInterface(){

            public Object convertValue(Object o) {
                if (o == null) {
                    return null;
                }
                return ((DMsQuery)o).getInitialId();
            }
        };
        this.putFilter(9, DoubleFilter.class, null, filtersMap);
        this.putFilter(10, DoubleFilter.class, null, filtersMap);
        this.putFilter(11, DoubleFilter.class, null, filtersMap);
        this.putFilter(12, IntegerFilter.class, null, filtersMap);
        this.putFilter(13, IntegerFilter.class, null, filtersMap);
        this.putFilter(14, IntegerFilter.class, null, filtersMap);
        this.putFilter(15, DoubleFilter.class, null, filtersMap);
        this.putFilter(5, StringDiffFilter.class, null, filtersMap);
        if (this.m_forRSM) {
            this.putFilter(16, IntegerFilter.class, null, filtersMap);
            this.putFilter(17, StringDiffFilter.class, null, filtersMap);
        }
        this.putFilter(18, DoubleFilter.class, null, filtersMap);
        if (this.m_isDecoyAndValidated) {
            this.putFilter(19, BooleanFilter.class, null, filtersMap);
            if (this.m_forRSM) {
                this.putFilter(20, BooleanFilter.class, null, filtersMap);
            }
        }
        this.putFilter(21, IntegerFilter.class, msQueryConverter, filtersMap);
        if (this.m_isMerged) {
            this.putFilter(22, StringDiffFilter.class, null, filtersMap);
        }
        this.putFilter(23, StringDiffFilter.class, null, filtersMap);
    }

    public boolean isLoaded() {
        return this.m_table.isSortable();
    }

    public int getLoadingPercentage() {
        return this.m_table.getLoadingPercentage();
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        int realColumnIndex = this.m_colUsed.get(columnIndex);
        switch (realColumnIndex) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 17: 
            case 23: {
                return String.class;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                return Float.class;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 21: {
                return Integer.class;
            }
            case 18: {
                return Object.class;
            }
            case 19: 
            case 20: {
                return Boolean.class;
            }
        }
        return this.getColumnClass(columnIndex);
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        Object data = this.getValueAt(rowIndex, columnIndex);
        if (data instanceof LazyData) {
            data = ((LazyData)data).getData();
        }
        if (data instanceof DPeptideMatch) {
            data = ((DPeptideMatch)data).getPeptide().getSequence();
        } else if (data instanceof DMsQuery) {
            data = ((DMsQuery)data).getInitialId();
        }
        return data;
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{this.convertColToColUsed(2), this.convertColToColUsed(0)};
        return keys;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public PlotType getBestPlotType() {
        return PlotType.HISTOGRAM_PLOT;
    }

    public int[] getBestColIndex(PlotType plotType) {
        switch (plotType) {
            case HISTOGRAM_PLOT: {
                int[] cols = new int[]{this.convertColToColUsed(11), this.convertColToColUsed(6)};
                return cols;
            }
            case SCATTER_PLOT: {
                int[] cols = new int[]{this.convertColToColUsed(9), this.convertColToColUsed(6)};
                return cols;
            }
        }
        return null;
    }

    public int getInfoColumn() {
        return this.convertColToColUsed(2);
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public String getExportRowCell(int row, int col) {
        return ExportModelUtilities.getExportRowCell((ExtendedTableModelInterface)this, (int)row, (int)col);
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    public String getExportColumnName(int col) {
        return this.getColumnName(col);
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_rendererMap.containsKey(col = this.m_colUsed.get(col).intValue())) {
            return this.m_rendererMap.get(col);
        }
        TableCellRenderer renderer = null;
        switch (col) {
            case 2: {
                renderer = new PeptideRenderer();
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 18: {
                renderer = new FloatRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 4);
                break;
            }
            case 21: {
                renderer = new MsQueryRenderer();
                break;
            }
            case 6: {
                renderer = this.m_scoreRenderer;
                break;
            }
            case 11: {
                renderer = new FloatRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4));
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class), 4);
                break;
            }
            case 19: 
            case 20: {
                renderer = new BooleanRenderer();
            }
        }
        this.m_rendererMap.put(col, renderer);
        return renderer;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(DPeptideMatch.class, true));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(DPeptideMatch.class)) {
            return this.m_peptideMatches[row];
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }
}

