/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.model;

import fr.proline.core.orm.msi.dto.DBioSequence;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.gui.renderer.FloatRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.SamesetRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.ScoreRenderer;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultAlignRenderer;
import fr.proline.studio.utils.IconManager;
import fr.proline.studio.utils.URLCellRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class ProteinTableModel
extends DecoratedTableModel
implements GlobalTableModelInterface {
    private DProteinMatch[] m_sameSetMatches = null;
    private DProteinMatch[] m_subSetMatches = null;
    private Long m_rsmId = null;
    private long m_representativeProteinMatchId;
    private ProgressInterface m_progressInterface = null;
    private ScoreRenderer m_scoreRenderer = new ScoreRenderer();
    private String m_modelName;
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();

    public ProteinTableModel(ProgressInterface progressInterface) {
        this.m_progressInterface = progressInterface;
    }

    public DProteinMatch getProteinMatch(int row) {
        int sameSetNb = this.m_sameSetMatches.length;
        if (row < sameSetNb) {
            return this.m_sameSetMatches[row];
        }
        return this.m_subSetMatches[row - sameSetNb];
    }

    public int getColumnCount() {
        return Column.values().length;
    }

    public String getColumnName(int col) {
        return Column.values()[col].m_name;
    }

    public String getToolTipForHeader(int col) {
        if (col == Column.SAMESET_SUBSET.ordinal()) {
            String urlTypical = IconManager.getURLForIcon((IconManager.IconType)IconManager.IconType.TYPICAL);
            String urlSameset = IconManager.getURLForIcon((IconManager.IconType)IconManager.IconType.SAME_SET);
            String urlSubset = IconManager.getURLForIcon((IconManager.IconType)IconManager.IconType.SUB_SET);
            return "<html><img src=\"" + urlTypical + "\">&nbsp;Typical Protein in Sameset<br><img src=\"" + urlSameset + "\">&nbsp;Sameset<br><img src=\"" + urlSubset + "\">&nbsp;Subset</html>";
        }
        return this.getColumnName(col);
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public Class getColumnClass(int col) {
        return Column.values()[col].m_class;
    }

    public int getRowCount() {
        if (this.m_sameSetMatches == null) {
            return 0;
        }
        return this.m_sameSetMatches.length + this.m_subSetMatches.length;
    }

    public Object getValueAt(int row, int col) {
        DProteinMatch proteinMatch = this.getProteinMatch(row);
        switch (Column.values()[col]) {
            case PROTEIN_ID: {
                return proteinMatch.getId();
            }
            case PROTEIN_NAME: {
                return proteinMatch.getAccession();
            }
            case PROTEIN_DESCRIPTION: {
                return proteinMatch.getDescription();
            }
            case SAMESET_SUBSET: {
                if (proteinMatch.getId() == this.m_representativeProteinMatchId) {
                    return Sameset.getSameset(0);
                }
                if (row < this.m_sameSetMatches.length) {
                    return Sameset.getSameset(1);
                }
                return Sameset.getSameset(2);
            }
            case PROTEIN_SCORE: {
                Float score = Float.valueOf(proteinMatch.getPeptideSet(this.m_rsmId).getScore());
                return score;
            }
            case OBSERVABLE_PEPTIDES: {
                Integer observablePeptideCount = proteinMatch.getObservablePeptidesCount();
                return observablePeptideCount;
            }
            case PROTEIN_PEPTIDES_COUNT: {
                return proteinMatch.getPeptideSet(this.m_rsmId).getPeptideCount();
            }
            case PROTEIN_UNIQUE_PEPTIDE_SEQUENCES_COUNT: {
                try {
                    return proteinMatch.getPeptideSet(this.m_rsmId).getSequenceCount();
                }
                catch (Exception e) {
                    return null;
                }
            }
            case PROTEIN_MASS: {
                DBioSequence bioSequence = proteinMatch.getDBioSequence();
                if (bioSequence != null) {
                    return Float.valueOf((float)bioSequence.getMass());
                }
                return null;
            }
        }
        return null;
    }

    public void setData(long rsmId, long representativeProteinMatchId, DProteinMatch[] sameSetMatches, DProteinMatch[] subSetMatches) {
        this.m_rsmId = rsmId;
        this.m_representativeProteinMatchId = representativeProteinMatchId;
        this.m_sameSetMatches = sameSetMatches;
        this.m_subSetMatches = subSetMatches;
        this.fireTableDataChanged();
    }

    public int findRowToSelect(String searchedText) {
        int rowToBeSelected = 0;
        if (searchedText != null && searchedText.length() > 0) {
            String searchedTextUpper = searchedText.toUpperCase();
            for (int row = 0; row < this.getRowCount(); ++row) {
                String proteinName = ((String)this.getValueAt(row, Column.PROTEIN_NAME.ordinal())).toUpperCase();
                if (proteinName.indexOf(searchedTextUpper) == -1) continue;
                rowToBeSelected = row;
            }
        }
        return rowToBeSelected;
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        filtersMap.put(Column.PROTEIN_NAME.ordinal(), (Filter)new StringDiffFilter(this.getColumnName(Column.PROTEIN_NAME.ordinal()), null, Column.PROTEIN_NAME.ordinal()));
        filtersMap.put(Column.PROTEIN_DESCRIPTION.ordinal(), (Filter)new StringDiffFilter(this.getColumnName(Column.PROTEIN_DESCRIPTION.ordinal()), null, Column.PROTEIN_DESCRIPTION.ordinal()));
        filtersMap.put(Column.PROTEIN_SCORE.ordinal(), (Filter)new DoubleFilter(this.getColumnName(Column.PROTEIN_SCORE.ordinal()), null, Column.PROTEIN_SCORE.ordinal()));
        filtersMap.put(Column.OBSERVABLE_PEPTIDES.ordinal(), (Filter)new IntegerFilter(this.getColumnName(Column.OBSERVABLE_PEPTIDES.ordinal()), null, Column.OBSERVABLE_PEPTIDES.ordinal()));
        filtersMap.put(Column.PROTEIN_PEPTIDES_COUNT.ordinal(), (Filter)new IntegerFilter(this.getColumnName(Column.PROTEIN_PEPTIDES_COUNT.ordinal()), null, Column.PROTEIN_PEPTIDES_COUNT.ordinal()));
        filtersMap.put(Column.PROTEIN_UNIQUE_PEPTIDE_SEQUENCES_COUNT.ordinal(), (Filter)new IntegerFilter(this.getColumnName(Column.PROTEIN_UNIQUE_PEPTIDE_SEQUENCES_COUNT.ordinal()), null, Column.PROTEIN_UNIQUE_PEPTIDE_SEQUENCES_COUNT.ordinal()));
        filtersMap.put(Column.PROTEIN_MASS.ordinal(), (Filter)new DoubleFilter(this.getColumnName(Column.PROTEIN_MASS.ordinal()), null, Column.PROTEIN_MASS.ordinal()));
    }

    public int getLoadingPercentage() {
        return this.m_progressInterface.getLoadingPercentage();
    }

    public boolean isLoaded() {
        return this.m_progressInterface.isLoaded();
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        if (Column.values()[columnIndex].equals((Object)Column.SAMESET_SUBSET)) {
            return String.class;
        }
        return this.getColumnClass(columnIndex);
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        if (Column.values()[columnIndex].equals((Object)Column.SAMESET_SUBSET)) {
            return ((Sameset)this.getValueAt(rowIndex, columnIndex)).toString();
        }
        return this.getValueAt(rowIndex, columnIndex);
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{Column.PROTEIN_NAME.m_colId, Column.PROTEIN_ID.m_colId};
        return keys;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public int getInfoColumn() {
        return Column.PROTEIN_NAME.m_colId;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public Long getTaskId() {
        return -1L;
    }

    public LazyData getLazyData(int row, int col) {
        return null;
    }

    public void givePriorityTo(Long taskId, int row, int col) {
    }

    public void sortingChanged(int col) {
    }

    public int getSubTaskId(int col) {
        return -1;
    }

    public PlotType getBestPlotType() {
        return null;
    }

    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }

    public String getExportRowCell(int row, int col) {
        switch (Column.values()[col]) {
            case SAMESET_SUBSET: {
                DProteinMatch proteinMatch = this.getProteinMatch(row);
                if (proteinMatch.getId() == this.m_representativeProteinMatchId) {
                    return Sameset.getSameset(0).toString();
                }
                if (row < this.m_sameSetMatches.length) {
                    return Sameset.getSameset(1).toString();
                }
                return Sameset.getSameset(2).toString();
            }
        }
        return ExportModelUtilities.getExportRowCell((ExtendedTableModelInterface)this, (int)row, (int)col);
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    public String getExportColumnName(int col) {
        return this.getColumnName(col);
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_rendererMap.containsKey(col)) {
            return this.m_rendererMap.get(col);
        }
        TableCellRenderer renderer = null;
        switch (Column.values()[col]) {
            case PROTEIN_NAME: {
                renderer = new URLCellRenderer("URL_Template_Protein_Accession", "http://www.uniprot.org/uniprot/", Column.PROTEIN_NAME.ordinal());
                break;
            }
            case PROTEIN_DESCRIPTION: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 2);
                break;
            }
            case SAMESET_SUBSET: {
                renderer = new SamesetRenderer();
                break;
            }
            case PROTEIN_SCORE: {
                renderer = this.m_scoreRenderer;
                break;
            }
            case PROTEIN_MASS: {
                renderer = new FloatRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4));
                break;
            }
            case OBSERVABLE_PEPTIDES: 
            case PROTEIN_PEPTIDES_COUNT: 
            case PROTEIN_UNIQUE_PEPTIDE_SEQUENCES_COUNT: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class), 4);
            }
        }
        this.m_rendererMap.put(col, renderer);
        return renderer;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(DProteinMatch.class, true));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(DProteinMatch.class)) {
            return this.getProteinMatch(row);
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }

    public static enum Column {
        PROTEIN_ID("Id", Long.class, 0),
        PROTEIN_NAME("Protein", String.class, 1),
        PROTEIN_DESCRIPTION("Description", String.class, 2),
        SAMESET_SUBSET("Sameset / Subset", Sameset.class, 3),
        PROTEIN_SCORE("Score", Float.class, 4),
        PROTEIN_PEPTIDES_COUNT("Peptides", Integer.class, 5),
        OBSERVABLE_PEPTIDES("Observable Peptides", Integer.class, 6),
        PROTEIN_UNIQUE_PEPTIDE_SEQUENCES_COUNT("Sequence Count", Integer.class, 7),
        PROTEIN_MASS("Mass", Float.class, 8);

        String m_name;
        Class m_class;
        int m_colId;

        private Column(String n2, Class cl, int colId) {
            this.m_name = n2;
            this.m_class = cl;
            this.m_colId = colId;
        }
    }

    public static class Sameset {
        private static final int TYPICAL_SAMESET = 0;
        private static final int SAMESET = 1;
        private static final int SUBSET = 2;
        private int m_type;
        private static Sameset[] samesetArray = new Sameset[]{new Sameset(0), new Sameset(1), new Sameset(2)};

        private Sameset(int type) {
            this.m_type = type;
        }

        public static Sameset getSameset(int type) {
            return samesetArray[type];
        }

        public boolean isTypical() {
            return this.m_type == 0;
        }

        public boolean isSameset() {
            return this.m_type == 1;
        }

        public String toString() {
            if (this.isTypical()) {
                return "typical";
            }
            if (this.isSameset()) {
                return "sameset";
            }
            return "subset";
        }
    }
}

