/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.ptm;

import fr.proline.studio.dam.tasks.data.ptm.PTMCluster;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.rsmexplorer.gui.ptm.PTMGraphicCtrlPanel;
import fr.proline.studio.rsmexplorer.gui.ptm.PTMPeptidesGraphicModel;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewContext;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewSetting;
import fr.proline.studio.rsmexplorer.gui.ptm.mark.PTMMarkCtrl;
import fr.proline.studio.rsmexplorer.gui.ptm.mark.ProteinSequence;
import fr.proline.studio.rsmexplorer.gui.ptm.pep.PeptideAreaCtrl;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PTMPeptidesGraphicPanel
extends JPanel {
    private final Logger m_logger = LoggerFactory.getLogger(PTMPeptidesGraphicPanel.class);
    private AbstractDataBox m_dataBox;
    private PTMGraphicCtrlPanel m_superCtrl;
    private static final int INITIAL_WIDTH = 1200;
    private static final int AJUSTE_GAP = 3;
    private PTMPeptidesGraphicModel m_ptmPepDataModel = null;
    private JScrollPane m_scrollPane;
    private final TitlePane m_titlePane;
    private final PeptidePane m_peptidesPane;
    private final ColoredClusterMarkPane m_clusterMarkPane;
    private int m_sequenceLength;
    private boolean m_isDataNull;
    PeptideAreaCtrl m_peptideAreaCtrl = new PeptideAreaCtrl();

    public PTMPeptidesGraphicPanel() {
        PTMMarkCtrl ctrlMark = new PTMMarkCtrl();
        ProteinSequence ctrlSequence = new ProteinSequence();
        this.m_titlePane = new TitlePane(ctrlMark, ctrlSequence);
        this.m_peptidesPane = new PeptidePane();
        this.m_clusterMarkPane = new ColoredClusterMarkPane();
        this.m_sequenceLength = 0;
        this.initComponents();
    }

    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    protected PTMPeptidesGraphicModel getPTMPeptidesModel() {
        return this.m_ptmPepDataModel;
    }

    private void initComponents() {
        this.setDoubleBuffered(false);
        this.m_titlePane.setMarkBeginPoint(ViewSetting.BORDER_GAP, ViewSetting.BORDER_GAP);
        this.m_titlePane.setSequenceBeginPoint(ViewSetting.BORDER_GAP, ViewSetting.HEIGHT_MARK);
        this.m_peptidesPane.setBeginPoint(ViewSetting.BORDER_GAP, ViewSetting.BORDER_GAP);
        this.m_clusterMarkPane.setBeginPoint(ViewSetting.BORDER_GAP, ViewSetting.BORDER_GAP);
        this.m_titlePane.setPreferredSize(new Dimension(1200, ViewSetting.HEIGHT_MARK + ViewSetting.HEIGHT_SEQUENCE));
        this.m_titlePane.setBackground(Color.WHITE);
        this.m_titlePane.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, CyclicColorPalette.GRAY_GRID));
        this.m_peptidesPane.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, CyclicColorPalette.GRAY_GRID));
        this.m_peptidesPane.setBackground(Color.WHITE);
        this.m_scrollPane = new JScrollPane(this.m_peptidesPane, 20, 30);
        this.m_scrollPane.setColumnHeaderView(this.m_titlePane);
        this.m_scrollPane.setRowHeaderView(this.m_clusterMarkPane);
        this.m_scrollPane.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_scrollPane, "Center");
    }

    public void setModel(PTMPeptidesGraphicModel dataModel) {
        this.m_ptmPepDataModel = dataModel;
    }

    protected void setHorizonScrollLocation(int ajustedLocation) {
        JScrollBar bar = this.m_scrollPane.getHorizontalScrollBar();
        int max = bar.getMaximum();
        int visibleAmount = bar.getVisibleAmount();
        int prevAdjLoc = ajustedLocation;
        this.m_logger.debug("setHorizonScrollLocation. m_sequenceLength" + this.m_sequenceLength + " passed ajustedLocation " + prevAdjLoc + " max " + max + " visiblaAmout " + visibleAmount + " new ajustedLocation " + (ajustedLocation -= (int)Math.round((double)this.m_sequenceLength * (double)(visibleAmount / 2) / (double)max)));
        int x = (int)((float)max / (float)this.m_sequenceLength * (float)(ajustedLocation - 3));
        this.m_logger.debug("setHorizonScrollLocation x " + x);
        bar.setValue(x);
        this.setViewPosition(ajustedLocation, this.getSelectedPeptideIndex());
    }

    private void setViewPosition(int ajustedLocation, int peptideIndex) {
        JViewport jvp = this.m_scrollPane.getViewport();
        Rectangle visibleRec = jvp.getVisibleRect();
        Point vp = jvp.getViewPosition();
        int x = ajustedLocation * ViewSetting.WIDTH_AA;
        int y = peptideIndex * (ViewSetting.HEIGHT_AA * 2 - ViewSetting.HEIGHT_AA / 2);
        Point p = new Point(x, y);
        if (Math.abs(vp.x - p.x) > visibleRec.width || Math.abs(vp.y - p.y) > visibleRec.height) {
            jvp.setViewPosition(p);
        }
    }

    @Override
    public void paint(Graphics g) {
        this.m_scrollPane.getViewport().revalidate();
        super.paint(g);
    }

    protected int getSelectedPeptideIndex() {
        return this.m_peptideAreaCtrl.getSelectedIndex();
    }

    protected void clean() {
        this.m_isDataNull = true;
    }

    protected void setSelectedPeptideIndex(int i) {
        this.m_peptideAreaCtrl.setSelectedIndex(i);
    }

    protected void updateData() {
        this.m_titlePane.updateData();
        this.m_peptidesPane.updateData();
        this.m_isDataNull = false;
        this.m_sequenceLength = this.m_ptmPepDataModel.getProteinSequence().length();
    }

    protected void setSuperCtrl(PTMGraphicCtrlPanel superCtrl) {
        this.m_superCtrl = superCtrl;
    }

    private void selectedAction(int selectedIndex, int oldSelected) {
        if (selectedIndex >= 0 && selectedIndex < this.m_ptmPepDataModel.getRowCount()) {
            PTMPeptideInstance pep = this.m_ptmPepDataModel.getPeptideAt(selectedIndex);
            PTMPeptideInstance oldPep = this.m_ptmPepDataModel.getPeptideAt(oldSelected);
            if (pep != null) {
                if (oldPep != null) {
                    if (Math.abs(oldPep.getStartPosition() - pep.getStartPosition()) > 3) {
                        this.setHorizonScrollLocation(pep.getStartPosition());
                    }
                } else {
                    this.setHorizonScrollLocation(pep.getStartPosition());
                }
            }
            this.m_peptideAreaCtrl.setSelectedIndex(selectedIndex);
            if (selectedIndex != oldSelected && selectedIndex != -1 && this.m_dataBox != null) {
                if (this.m_superCtrl != null) {
                    this.m_superCtrl.onMessage(PTMGraphicCtrlPanel.Source.PEPTIDE_AREA, PTMGraphicCtrlPanel.Message.SELECTED);
                }
                this.m_dataBox.addDataChanged(PTMPeptideInstance.class, null);
                this.m_dataBox.propagateDataChanged();
                this.repaint();
            }
        }
    }

    private class TitlePane
    extends JPanel {
        private PTMMarkCtrl m_ctrlMark;
        private ProteinSequence m_ctrlSequence;

        private TitlePane(PTMMarkCtrl ctrlMark, ProteinSequence ctrlSequence) {
            this.m_ctrlMark = ctrlMark;
            this.m_ctrlSequence = ctrlSequence;
            this.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    int x = e.getX();
                    int y = e.getY();
                    String tips = TitlePane.this.m_ctrlMark.getToolTipText(x, y);
                    TitlePane.this.setToolTipText(tips);
                }
            });
        }

        public void updateData() {
            this.m_ctrlSequence.setData(PTMPeptidesGraphicPanel.this.m_ptmPepDataModel.getProteinSequence());
            this.m_ctrlMark.setData(PTMPeptidesGraphicPanel.this.m_ptmPepDataModel.getAllPtmMarks());
        }

        public void setMarkBeginPoint(int x, int y) {
            this.m_ctrlMark.setBeginPoint(x, y);
        }

        public void setSequenceBeginPoint(int x, int y) {
            this.m_ctrlSequence.setBeginPoint(x, y);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension((PTMPeptidesGraphicPanel.this.m_sequenceLength + 3) * ViewSetting.WIDTH_AA, ViewSetting.HEIGHT_MARK + ViewSetting.HEIGHT_SEQUENCE);
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.isPaintingOrigin();
            super.paintComponent(g);
            if (!PTMPeptidesGraphicPanel.this.m_isDataNull) {
                ViewContext viewContext = new ViewContext();
                viewContext.setShowNCtermIndex(false);
                Graphics2D g2 = (Graphics2D)g;
                this.m_ctrlMark.paint(g2, viewContext);
                this.m_ctrlSequence.paint(g2, viewContext);
            }
        }
    }

    private class PeptidePane
    extends JPanel {
        private PeptidePane() {
            PeptideAreaMouseAdapter mouseAdapter = new PeptideAreaMouseAdapter();
            this.addMouseListener(mouseAdapter);
            this.addMouseMotionListener(mouseAdapter);
            this.addKeyListener(new PeptideAreaKeyAdapter());
        }

        public void updateData() {
            PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.setPTMPepInstanceData(PTMPeptidesGraphicPanel.this.m_ptmPepDataModel.getPTMPeptideInstance());
            PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.setSelectedIndex(0);
        }

        public void setBeginPoint(int x, int y) {
            PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.setBeginPoint(x, y);
        }

        @Override
        public Dimension getPreferredSize() {
            int width = (PTMPeptidesGraphicPanel.this.m_sequenceLength + 3) * ViewSetting.WIDTH_AA;
            int height = PTMPeptidesGraphicPanel.this.m_ptmPepDataModel.getRowCount() * (ViewSetting.HEIGHT_AA * 2 - ViewSetting.HEIGHT_AA / 2);
            if (height == 0) {
                height = 5 * ViewSetting.HEIGHT_AA;
            }
            return new Dimension(width, height);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!PTMPeptidesGraphicPanel.this.m_isDataNull) {
                ViewContext viewContext = new ViewContext();
                viewContext.setAreaWidth(this.getWidth());
                Graphics2D g2 = (Graphics2D)g;
                PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.paint(g2, viewContext);
            }
        }

        class PeptideAreaMouseAdapter
        extends MouseAdapter {
            PeptideAreaMouseAdapter() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                PeptidePane.this.requestFocusInWindow();
                int oldSelected = PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.getSelectedIndex();
                int selectedIndex = PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.getSelectedIndex(e.getX(), e.getY());
                PTMPeptidesGraphicPanel.this.selectedAction(selectedIndex, oldSelected);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                String tips = PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.getToolTipText(x, y);
                PeptidePane.this.setToolTipText(tips);
            }
        }

        class PeptideAreaKeyAdapter
        extends KeyAdapter {
            @Override
            public void keyPressed(KeyEvent evt) {
                int oldSelected = PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.getSelectedIndex();
                if (evt.getKeyCode() == 38) {
                    PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.setRelativeSelected(-1);
                } else if (evt.getKeyCode() == 40) {
                    PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.setRelativeSelected(1);
                }
                int selectedIndex = PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.getSelectedIndex();
                PTMPeptidesGraphicPanel.this.selectedAction(selectedIndex, oldSelected);
            }
        }
    }

    private class ColoredClusterMarkPane
    extends JPanel {
        private Map<PTMCluster, Color> PTM_CLUSTER_COLORS = new HashMap<PTMCluster, Color>();
        private Map<PTMCluster, String> PTM_CLUSTER_ID = new HashMap<PTMCluster, String>();
        int m_x0;
        int m_y0;

        private ColoredClusterMarkPane() {
            this.setBackground(Color.WHITE);
            ScrollPaneRowHeaderMouseAdapter coloredTooltips = new ScrollPaneRowHeaderMouseAdapter();
            this.addMouseMotionListener(coloredTooltips);
            this.addMouseListener(coloredTooltips);
        }

        public Color getColor(PTMCluster cluster) {
            Color c = this.PTM_CLUSTER_COLORS.get(cluster);
            if (c == null) {
                Color co = CyclicColorPalette.getColorBlue((int)this.PTM_CLUSTER_COLORS.size());
                int rgb = co.getRGB() | 0xFF000000;
                c = new Color(rgb & 0xFFFFFF);
                this.PTM_CLUSTER_COLORS.put(cluster, c);
                String s = String.valueOf(cluster.getId());
                this.PTM_CLUSTER_ID.put(cluster, s);
            }
            return c;
        }

        public void setBeginPoint(int x, int y) {
            this.m_x0 = x;
            this.m_y0 = y;
        }

        @Override
        public Dimension getPreferredSize() {
            int width = ViewSetting.WIDTH_AA + 2 * ViewSetting.BORDER_GAP;
            int height = PTMPeptidesGraphicPanel.this.m_ptmPepDataModel.getRowCount() * (ViewSetting.HEIGHT_AA * 2 - ViewSetting.HEIGHT_AA / 2);
            if (height == 0) {
                height = 5 * ViewSetting.HEIGHT_AA;
            }
            return new Dimension(width, height);
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (!PTMPeptidesGraphicPanel.this.m_isDataNull) {
                this.PTM_CLUSTER_COLORS = new HashMap<PTMCluster, Color>();
                this.PTM_CLUSTER_ID = new HashMap<PTMCluster, String>();
                Graphics2D g2 = (Graphics2D)g;
                FontMetrics f = g2.getFontMetrics(ViewSetting.FONT_NUMBER);
                int ascend = f.getAscent();
                int y0 = this.m_y0;
                g2.setFont(ViewSetting.FONT_NUMBER);
                int rowCount = PTMPeptidesGraphicPanel.this.m_ptmPepDataModel.getRowCount();
                for (int i = 1; i < rowCount + 1; ++i) {
                    PTMPeptideInstance item = PTMPeptidesGraphicPanel.this.m_ptmPepDataModel.getPeptideAt(i - 1);
                    List clusters = item.getClusters();
                    int size = clusters.size();
                    int xi0 = this.m_x0;
                    int colorWidth = ViewSetting.WIDTH_AA / size;
                    for (int j = 0; j < size; ++j) {
                        int xi;
                        xi0 = xi = xi0 + colorWidth * j;
                        PTMCluster cluster = (PTMCluster)clusters.get(j);
                        g2.setColor(this.getColor(cluster));
                        g2.fillRect(xi0, y0, colorWidth, ViewSetting.WIDTH_AA);
                    }
                    String colorId = this.PTM_CLUSTER_ID.get(clusters.get(0));
                    int stringWidth = f.stringWidth(colorId);
                    int x0 = this.m_x0 + (ViewSetting.WIDTH_AA - stringWidth) / 2;
                    g2.setColor(Color.WHITE);
                    g2.drawString(colorId, x0, y0 + ascend);
                    y0 = (int)((double)y0 + (double)ViewSetting.HEIGHT_AA * 1.5);
                }
            }
        }

        class ScrollPaneRowHeaderMouseAdapter
        extends MouseAdapter {
            ScrollPaneRowHeaderMouseAdapter() {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                PTMPeptideInstance pep;
                int x = e.getX();
                int y = e.getY();
                StringBuilder tips = new StringBuilder();
                int index = (int)((double)(y - ColoredClusterMarkPane.this.m_y0) / ((double)ViewSetting.HEIGHT_AA * 1.5));
                if (index >= 0 && index < PTMPeptidesGraphicPanel.this.m_ptmPepDataModel.getRowCount() && (pep = PTMPeptidesGraphicPanel.this.m_ptmPepDataModel.getPeptideAt(index)) != null) {
                    List clusters = pep.getClusters();
                    int size = clusters.size();
                    tips.append("<html>").append("<body>Clusters: ");
                    for (int j = 0; j < size; ++j) {
                        PTMCluster cluster = (PTMCluster)clusters.get(j);
                        String htmlColor = CyclicColorPalette.getHTMLColoredBlock((Color)ColoredClusterMarkPane.this.getColor(cluster));
                        tips.append(htmlColor).append(ColoredClusterMarkPane.this.PTM_CLUSTER_ID.get(cluster)).append(' ');
                    }
                    tips.append("</body>").append("</html>");
                }
                ColoredClusterMarkPane.this.setToolTipText(tips.toString());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                int oldSelected = PTMPeptidesGraphicPanel.this.m_peptideAreaCtrl.getSelectedIndex();
                int selectedIndex = (int)((double)(y - ColoredClusterMarkPane.this.m_y0) / ((double)ViewSetting.HEIGHT_AA * 1.5));
                PTMPeptidesGraphicPanel.this.selectedAction(selectedIndex, oldSelected);
            }
        }
    }
}

