/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.ptm;

import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.rsmexplorer.gui.ptm.PTMGraphicCtrlPanel;
import fr.proline.studio.rsmexplorer.gui.ptm.PTMPeptidesGraphicModel;
import fr.proline.studio.rsmexplorer.gui.ptm.PTMPeptidesGraphicPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTMPeptidesGraphicView
extends JPanel {
    private static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.rsmexplorer.ptm");
    protected AbstractDataBox m_dataBox;
    private final PTMPeptidesGraphicPanel m_internalPanel = new PTMPeptidesGraphicPanel();
    private final PTMPeptidesGraphicModel m_dataModel = new PTMPeptidesGraphicModel();

    public void setSuperCtrl(PTMGraphicCtrlPanel superCtrl) {
        this.m_internalPanel.setSuperCtrl(superCtrl);
    }

    public void setScrollLocation(int ajustedLocation) {
        this.m_internalPanel.setHorizonScrollLocation(ajustedLocation);
        this.repaint();
    }

    public void setViewPosition(int sequencePosition) {
        this.m_internalPanel.setHorizonScrollLocation(sequencePosition);
        this.repaint();
    }

    public void setProteinSequence(String sequence) {
        this.m_internalPanel.getPTMPeptidesModel().setProteinSequence(sequence);
        this.m_internalPanel.updateData();
    }

    public PTMPeptidesGraphicView() {
        this.m_internalPanel.setModel(this.m_dataModel);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.m_internalPanel.setSize(-29, 2);
        this.add((Component)this.m_internalPanel, "Center");
    }

    public void setSelectedRow(int i) {
        this.m_internalPanel.setSelectedPeptideIndex(i);
    }

    public void setSelectedPTMPeptide(PTMPeptideInstance pep) {
        int row = this.m_dataModel.getPeptideIndex(pep);
        this.m_internalPanel.setSelectedPeptideIndex(row);
        this.repaint();
    }

    public PTMPeptideInstance getSelectedPTMPeptideInstance() {
        int selectedRowIndex = this.m_internalPanel.getSelectedPeptideIndex();
        if (this.m_dataModel.getRowCount() > 0 && selectedRowIndex < this.m_dataModel.getRowCount()) {
            return this.m_dataModel.getPeptideAt(selectedRowIndex);
        }
        return null;
    }

    public int getSelectedIndex() {
        return this.m_internalPanel.getSelectedPeptideIndex();
    }

    public void setData(List<PTMPeptideInstance> peptidesInstances) {
        this.m_dataModel.setData(peptidesInstances, this.m_dataBox.getProjectId());
        if (peptidesInstances == null) {
            this.m_internalPanel.clean();
        } else {
            this.m_internalPanel.updateData();
            this.m_dataBox.addDataChanged(PTMPeptideInstance.class, null);
            this.m_dataBox.propagateDataChanged();
        }
        this.setScrollLocation(this.m_dataModel.getLowerStartInProtSeq());
        this.repaint();
    }

    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
        this.m_internalPanel.setDataBox(dataBox);
    }

    public String getSequence() {
        return this.m_dataModel.getProteinSequence();
    }
}

