/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.ptm;

import fr.proline.studio.dam.tasks.data.ptm.PTMSite;
import fr.proline.studio.rsmexplorer.gui.ptm.PTMMark;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;

public class ViewSetting {
    public static int WIDTH_AA;
    public static int HEIGHT_AA;
    public static int BORDER_GAP;
    public static int HEIGHT_MARK;
    public static int HEIGHT_SEQUENCE;
    public static Font FONT_NUMBER;
    public static Font FONT_PTM;
    public static Font FONT_SEQUENCE;
    public static Color PEPTIDE_COLOR;
    public static Color SELECTED_PEPTIDE_COLOR;
    public static Color SEQUENCE_COLOR;
    private static final double FONT_ROTATE = -0.5235987755982988;
    public static Font FONT_NUMBER_DIAGONAL;
    public static final BasicStroke STROKE;
    public static final Stroke DASHED;
    public static final BasicStroke STROKE_PEP;
    public static Map<Long, Color> PTM_COLORS;

    public static final Color getColor(PTMSite site) {
        return ViewSetting.getColor(site.getPTMSpecificity().getIdPtmSpecificity());
    }

    public static final Color getMultiPTMColor() {
        return CyclicColorPalette.GRAY_TEXT_LIGHT;
    }

    public static final Color getColor(Long specificityId) {
        Color c = PTM_COLORS.get(specificityId);
        if (c == null) {
            c = CyclicColorPalette.getColor((int)(PTM_COLORS.size() + 1));
            PTM_COLORS.put(specificityId, c);
        }
        return c;
    }

    public static final Color getColor(PTMMark mark) {
        return ViewSetting.getColor(mark.getPtmSpecificityId());
    }

    static {
        BORDER_GAP = 5;
        FONT_NUMBER = new Font("SansSerif", 0, 8);
        FONT_PTM = new Font("Monospaced", 1, 11);
        FONT_SEQUENCE = new Font("Monospaced", 1, 16);
        PEPTIDE_COLOR = CyclicColorPalette.getDarkerColor((Color)CyclicColorPalette.getColor((int)5), (double)-0.7);
        SELECTED_PEPTIDE_COLOR = CyclicColorPalette.GRAY_DARK;
        SEQUENCE_COLOR = Color.BLUE;
        STROKE = new BasicStroke(1.5f, 2, 1);
        DASHED = new BasicStroke(1.0f, 1, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);
        STROKE_PEP = new BasicStroke(1.2f, 0, 0);
        PTM_COLORS = new HashMap<Long, Color>();
        AffineTransform affinetransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affinetransform, false, true);
        WIDTH_AA = (int)Math.round(FONT_SEQUENCE.getStringBounds("M", frc).getWidth());
        HEIGHT_AA = Math.round(WIDTH_AA);
        HEIGHT_MARK = (int)Math.round((double)HEIGHT_AA * 2.5 + (double)(BORDER_GAP * 2));
        HEIGHT_SEQUENCE = HEIGHT_AA + HEIGHT_AA / 2 + BORDER_GAP;
        AffineTransform rotateText = new AffineTransform();
        rotateText.rotate(-0.5235987755982988);
        FONT_NUMBER_DIAGONAL = FONT_NUMBER.deriveFont(rotateText);
    }
}

