/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.renderer;

import fr.profi.util.CollectionUtils;
import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DPeptidePTM;
import fr.proline.studio.table.renderer.GrayableTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class PeptideRenderer
extends DefaultTableCellRenderer
implements GrayableTableCellRenderer {
    private boolean m_grayed = false;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String displayString = value == null || !DPeptideMatch.class.isAssignableFrom(value.getClass()) && !Peptide.class.isAssignableFrom(value.getClass()) ? "" : (DPeptideMatch.class.isAssignableFrom(value.getClass()) ? PeptideRenderer.constructPeptideDisplay(((DPeptideMatch)value).getPeptide(), (DPeptideMatch)value) : PeptideRenderer.constructPeptideDisplay((Peptide)value));
        JLabel l = (JLabel)super.getTableCellRendererComponent(table, displayString, isSelected, hasFocus, row, column);
        if (this.m_grayed) {
            l.setFont(l.getFont().deriveFont(2));
            l.setForeground(Color.lightGray);
        }
        return l;
    }

    public static String constructPeptideDisplay(Peptide peptide) {
        return PeptideRenderer.constructPeptideDisplay(peptide, null);
    }

    public static String constructPeptideDisplay(Peptide peptide, DPeptideMatch match) {
        String textToExport;
        if (peptide != null && peptide.getTransientData() != null) {
            boolean hasPtms;
            String sequence = peptide.getSequence();
            ArrayList ambiguousIndex = new ArrayList();
            boolean hasAmbiguity = false;
            if (match != null && match.hasAmbiguousSeq().booleanValue()) {
                hasAmbiguity = true;
                String ambiguityInfo = (String)((Map)match.getPropertiesAsMap().get("mascot_properties")).get("ambiguity_string");
                List<String> ambiguityChars = Arrays.asList(ambiguityInfo.split(","));
                CollectionUtils.createSlidingWindow(ambiguityChars, (int)3).forEach(substInfo -> ambiguousIndex.add(Integer.parseInt((String)substInfo.get(0)) - 1));
            }
            StringBuilder m_displaySB = new StringBuilder();
            HashMap ptmMap = peptide.getTransientData().getDPeptidePtmMap();
            boolean bl = hasPtms = ptmMap != null;
            if (!hasPtms && !hasAmbiguity) {
                m_displaySB.append(sequence);
            } else {
                m_displaySB.append("<html>");
                int nb = sequence.length();
                for (int i = 0; i < nb; ++i) {
                    boolean aminoAcidModification;
                    boolean isAmbiguous = false;
                    if (ambiguousIndex.contains(i)) {
                        isAmbiguous = true;
                    }
                    boolean nTerOrCterModification = false;
                    DPeptidePTM ptm = null;
                    if (hasPtms) {
                        DPeptidePTM cterPtm;
                        if (i == 0) {
                            DPeptidePTM nterPtm = (DPeptidePTM)ptmMap.get(0);
                            if (nterPtm != null) {
                                nTerOrCterModification = true;
                            }
                        } else if (i == nb - 1 && (cterPtm = (DPeptidePTM)ptmMap.get(-1)) != null) {
                            nTerOrCterModification = true;
                        }
                        ptm = (DPeptidePTM)ptmMap.get(i + 1);
                    }
                    boolean bl2 = aminoAcidModification = ptm != null;
                    if (nTerOrCterModification || aminoAcidModification || isAmbiguous) {
                        if (nTerOrCterModification && aminoAcidModification) {
                            m_displaySB.append("<span style='color:").append("#ce85fd;").append("'>");
                        } else if (nTerOrCterModification) {
                            m_displaySB.append("<span style='color:").append("#6eb86a;").append("'>");
                        } else if (aminoAcidModification) {
                            m_displaySB.append("<span style='color:").append("#fdb800;").append("'>");
                        }
                        if (isAmbiguous) {
                            m_displaySB.append("<b>");
                        }
                        m_displaySB.append(sequence.charAt(i));
                        if (isAmbiguous) {
                            m_displaySB.append("</b>");
                        }
                        if (!nTerOrCterModification && !aminoAcidModification) continue;
                        m_displaySB.append("</span>");
                        continue;
                    }
                    m_displaySB.append(sequence.charAt(i));
                }
                m_displaySB.append("</html>");
            }
            textToExport = m_displaySB.toString();
        } else {
            textToExport = peptide == null ? "" : peptide.getSequence();
        }
        return textToExport;
    }

    public void setGrayed(boolean v) {
        this.m_grayed = v;
    }
}

