/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.renderer;

import fr.proline.studio.utils.DataFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.swingx.util.PaintUtils;

public class ScoreRenderer
extends DefaultTableCellRenderer {
    private int m_digits = 2;
    private boolean m_scientific = false;
    private boolean m_showNaN = false;
    private Float m_value = Float.valueOf(0.0f);
    private float m_maxValue = 100.0f;
    private static Color SCORE_COLOR = null;

    public ScoreRenderer(int digits, boolean scientific, boolean showNaN) {
        this.m_digits = digits;
        this.m_scientific = scientific;
        this.m_showNaN = showNaN;
    }

    public ScoreRenderer(int digits) {
        this.m_digits = digits;
    }

    public ScoreRenderer() {
    }

    public void setMaxValue(float maxValue) {
        this.m_maxValue = maxValue;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String formatedValue;
        Float f;
        this.m_value = f = (Float)value;
        if (f == null || f.isNaN()) {
            this.m_value = Float.valueOf(0.0f);
            formatedValue = this.m_showNaN ? "NaN" : "";
        } else if (this.m_scientific) {
            double dAbs = Math.abs(f.floatValue());
            if (dAbs != 0.0 && dAbs * Math.pow(10.0, this.m_digits - 1) >= 1.0) {
                formatedValue = DataFormat.format((float)f.floatValue(), (int)this.m_digits);
            } else {
                int digits = this.m_digits - 2;
                if (digits < 2) {
                    digits = 2;
                }
                formatedValue = DataFormat.formatScientific((float)f.floatValue(), (int)digits);
            }
        } else {
            formatedValue = DataFormat.format((float)f.floatValue(), (int)this.m_digits);
        }
        JLabel l = (JLabel)super.getTableCellRendererComponent(table, f, isSelected, hasFocus, row, column);
        l.setHorizontalAlignment(4);
        l.setText(formatedValue);
        return l;
    }

    @Override
    public void paint(Graphics g) {
        this.setOpaque(true);
        super.paint(g);
        double length = this.m_value.floatValue() / this.m_maxValue;
        if (length > 1.0) {
            length = 1.0;
        }
        int maxLength = this.getWidth() - 2;
        int scoreWidth = (int)Math.round(length * (double)maxLength);
        int start = 1 + maxLength - scoreWidth;
        if (SCORE_COLOR == null) {
            Color c = PaintUtils.setSaturation((Color)Color.GREEN, (float)0.7f);
            SCORE_COLOR = PaintUtils.setAlpha((Color)c, (int)125);
        }
        g.setColor(SCORE_COLOR);
        g.fillRect(start, 1, scoreWidth, this.getHeight() - 2);
        this.setOpaque(false);
        super.paint(g);
    }
}

