/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.spectrum;

import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DSpectrum;
import fr.proline.studio.rsmexplorer.gui.spectrum.AbstractPeptideSpectrumPanel;
import fr.proline.studio.rsmexplorer.gui.spectrum.PeptideFragmentationData;
import fr.proline.studio.utils.DataFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.annotations.XYPointerAnnotation;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;

public class RsetPeptideSpectrumErrorPanel
extends AbstractPeptideSpectrumPanel {
    private boolean m_isDisplayed = true;

    public RsetPeptideSpectrumErrorPanel() {
        super("Delta Mass Error");
    }

    @Override
    public void updateFragmentationPlot(DPeptideMatch peptideMatch, PeptideFragmentationData peptideFragmentationData) {
        if (this.m_isDisplayed) {
            this.m_chart.getPlot().removeChangeListener((PlotChangeListener)this);
            this.constructSpectrumChart(peptideMatch);
            double maxY = Math.max(Math.abs(this.m_chart.getXYPlot().getRangeAxis().getLowerBound()), Math.abs(this.m_chart.getXYPlot().getRangeAxis().getUpperBound()));
            this.m_chart.getXYPlot().getRangeAxis().setUpperMargin(0.5);
            this.m_chart.getXYPlot().getRangeAxis().setLowerMargin(0.5);
            this.m_chart.getXYPlot().getRangeAxis().setDefaultAutoRange(new Range(-maxY, maxY));
            this.m_chart.getXYPlot().getDomainAxis().setDefaultAutoRange(new Range(this.m_chart.getXYPlot().getDomainAxis().getLowerBound(), this.m_chart.getXYPlot().getDomainAxis().getUpperBound()));
            this.m_chart.getXYPlot().getRangeAxis().setRange(new Range(-maxY, maxY));
            this.annotateSpectrum();
            this.m_chart.getPlot().addChangeListener((PlotChangeListener)this);
        }
    }

    @Override
    public double[][] getMassIntensityValues(DSpectrum spectrum) {
        double[][] data = new double[2][this.m_peptideFragmentationData.getFragmentMatches().length + 1];
        int count = 0;
        for (PeptideFragmentationData.FragmentMatch match : this.m_peptideFragmentationData.getFragmentMatches()) {
            data[0][count] = match.moz;
            data[1][count] = match.calculated_moz - match.moz;
            ++count;
        }
        data[0][count] = spectrum.getPrecursorMoz();
        data[1][count] = 0.0;
        return data;
    }

    @Override
    public void addCustomAnnotations() {
        PeptideFragmentationData.FragmentMatch[] fragmentationMatches = this.m_peptideFragmentationData.getFragmentMatches();
        XYPlot plot = (XYPlot)this.m_chart.getPlot();
        double spacerValue = this.pixelToValueRange(3.0);
        ValueMarker baseline = new ValueMarker(0.0);
        baseline.setPaint((Paint)Color.BLACK);
        plot.addRangeMarker((Marker)baseline);
        for (PeptideFragmentationData.FragmentMatch match : fragmentationMatches) {
            double error = match.calculated_moz - match.moz;
            String label = match.neutral_loss_mass != null && match.neutral_loss_mass.floatValue() > 0.0f ? match.label + "-" + Math.round(match.neutral_loss_mass.floatValue()) : match.label;
            XYPointerAnnotation pointer = new XYPointerAnnotation(label, match.moz.doubleValue(), error + Math.signum(error) * spacerValue, Math.signum(error) * 6.0 * Math.PI / 4.0);
            pointer.setBaseRadius(5.0);
            pointer.setTipRadius(0.0);
            pointer.setArrowWidth(2.0);
            pointer.setFont(new Font("SansSerif", 0, 9));
            Color color = match.isABCSerie() ? AbstractPeptideSpectrumPanel.ABC_SERIE_COLOR : AbstractPeptideSpectrumPanel.XYZ_SERIE_COLOR;
            pointer.setArrowPaint((Paint)color);
            pointer.setPaint((Paint)color);
            pointer.setTextAnchor(error > 0.0 ? TextAnchor.BOTTOM_CENTER : TextAnchor.TOP_CENTER);
            StringBuilder builder = new StringBuilder("<html>");
            builder.append("m/z: ").append(match.moz).append("<br>");
            builder.append("error: ").append(DataFormat.format((double)error, (int)6)).append("<br>");
            builder.append("ppm error: ").append(DataFormat.format((double)(1000000.0 * error / match.moz), (int)2)).append("ppm<br>");
            if (match.neutral_loss_mass != null && match.neutral_loss_mass.floatValue() > 0.0f) {
                builder.append("<br>").append("Neutral loss: ").append(match.neutral_loss_mass).append("<br>");
            }
            builder.append("</html>");
            pointer.setToolTipText(builder.toString());
            plot.addAnnotation((XYAnnotation)pointer);
            BasicStroke stk = new BasicStroke(2.0f, 0, 0);
            XYLineAnnotation line = new XYLineAnnotation(match.calculated_moz.doubleValue(), 0.0, match.calculated_moz.doubleValue(), error, (Stroke)stk, (Paint)color);
            plot.addAnnotation((XYAnnotation)line);
        }
    }

    public void setShowed(boolean showed) {
        if (showed == this.m_isDisplayed) {
            return;
        }
        if (showed && !this.m_isDisplayed) {
            this.m_isDisplayed = true;
            if (this.m_peptideMatch != null) {
                this.updateFragmentationPlot(this.m_peptideMatch, this.m_peptideFragmentationData);
            }
        }
    }

    public boolean isShowed() {
        return this.m_isDisplayed;
    }
}

