/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.tasklog;

import fr.proline.studio.WindowManager;
import fr.proline.studio.dpm.data.JMSNotificationMessage;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.PurgeConsumer;
import fr.proline.studio.dpm.task.util.ConnectionListener;
import fr.proline.studio.dpm.task.util.JMSConnectionManager;
import fr.proline.studio.dpm.task.util.ServiceNotificationListener;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.rsmexplorer.gui.dialog.GetSystemInfoButtonAction;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTasksPanel
extends HourglassPanel
implements DataBoxPanelInterface,
ConnectionListener {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    protected static final ImageIcon[] PUBLIC_STATE_ICONS = new ImageIcon[]{IconManager.getIcon((IconManager.IconType)IconManager.IconType.HOUR_GLASS_MINI16), IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW_RIGHT_SMALL), IconManager.getIcon((IconManager.IconType)IconManager.IconType.CROSS_BLUE_SMALL16), IconManager.getIcon((IconManager.IconType)IconManager.IconType.TICK_SMALL), IconManager.getIcon((IconManager.IconType)IconManager.IconType.CROSS_SMALL16)};
    private AbstractDataBox m_dataBox;
    private boolean m_isConnected = false;
    private ServiceNotificationListener m_serviceListener = null;
    private AbstractJMSCallback m_notifierCallback = null;
    private AbstractJMSCallback m_purgerCallback = null;

    public AbstractTasksPanel() {
        this.initListener();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add(this.createToolbarPanel(), c);
    }

    protected JPanel createToolbarPanel() {
        JPanel toolbarPanel = new JPanel();
        toolbarPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        toolbarPanel.add((Component)internalPanel, "Center");
        JToolBar toolbar = this.initToolbar();
        toolbarPanel.add((Component)toolbar, "West");
        return toolbarPanel;
    }

    protected JButton getEraseButton() {
        JButton b = new JButton();
        b.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
        b.setToolTipText("Clear Tasks list");
        return b;
    }

    protected abstract JPanel createInternalPanel();

    protected abstract void clearActionPerformed();

    protected abstract FilterTableModelInterface getTaskTableModel();

    protected JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        FilterButton filterButton = new FilterButton(this.getTaskTableModel()){

            protected void filteringDone() {
            }
        };
        toolbar.add((Component)filterButton);
        JButton clearBtn = this.getEraseButton();
        clearBtn.addActionListener(e -> this.clearActionPerformed());
        toolbar.add(clearBtn);
        GetSystemInfoButtonAction systemInfoButton = new GetSystemInfoButtonAction();
        toolbar.add(systemInfoButton);
        return toolbar;
    }

    protected boolean isMonitoringConnected() {
        return this.m_isConnected;
    }

    public final void initListener() {
        JMSConnectionManager.getJMSConnectionManager().addConnectionListener((ConnectionListener)this);
        int currentState = JMSConnectionManager.getJMSConnectionManager().getConnectionState();
        this.connectionStateChanged(currentState);
    }

    protected boolean checkJMSVariables() {
        if (this.m_serviceListener == null) {
            this.m_serviceListener = JMSConnectionManager.getJMSConnectionManager().getNotificationListener();
            if (this.m_serviceListener == null) {
                JOptionPane.showMessageDialog((Component)WindowManager.getDefault().getMainWindow(), "Unable to get Notification Listener (JMS Connection problem ?!). Try Later", "Server Tasks Logs error", 0);
                return false;
            }
        }
        return true;
    }

    protected abstract AbstractJMSCallback getServiceNotificationCallback(JMSNotificationMessage[] var1);

    protected abstract AbstractJMSCallback getPurgeConsumerCallback(JMSNotificationMessage[] var1);

    abstract void startOtherDataCollecting();

    abstract void stopOtherDataCollecting();

    public void connectionStateChanged(int newStatus) {
        switch (newStatus) {
            case 3: {
                if (this.m_isConnected) break;
                this.m_serviceListener = null;
                if (this.checkJMSVariables()) {
                    JMSNotificationMessage[] sysInfoResult = new JMSNotificationMessage[1];
                    this.m_notifierCallback = this.getServiceNotificationCallback(sysInfoResult);
                    this.m_serviceListener.addServiceNotifierCallback(this.m_notifierCallback, sysInfoResult);
                    JMSNotificationMessage[] purgerResult = new JMSNotificationMessage[1];
                    this.m_purgerCallback = this.getPurgeConsumerCallback(purgerResult);
                    if (this.m_purgerCallback != null) {
                        PurgeConsumer.getPurgeConsumer().addCallback(this.m_purgerCallback, purgerResult);
                    }
                    this.startOtherDataCollecting();
                }
                this.m_isConnected = true;
                break;
            }
            case 0: 
            case 2: {
                if (this.m_isConnected && this.m_serviceListener != null) {
                    if (this.m_notifierCallback != null) {
                        this.m_serviceListener.removeCallback(this.m_notifierCallback);
                    }
                    this.m_serviceListener = null;
                    this.m_notifierCallback = null;
                    if (this.m_purgerCallback != null) {
                        PurgeConsumer.getPurgeConsumer().removeCallback(this.m_purgerCallback);
                    }
                    this.m_purgerCallback = null;
                    this.stopOtherDataCollecting();
                }
                this.m_isConnected = false;
            }
        }
    }

    @Override
    public void addSingleValue(Object v) {
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }
}

