/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.tasklog;

import fr.proline.logparser.gui.ColorPalette;
import fr.proline.logparser.model.Utility;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.ServerConnectionManager;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.DownloadFileTask;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.rsmexplorer.gui.tasklog.ServerLogControlPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerLogFileNameDialog
extends DefaultDialog {
    protected static final Logger m_logger = LoggerFactory.getLogger(ServerLogFileNameDialog.class);
    private static final String LOG_REMOTE_PATH = "./logs/";
    private static final File LOG_LOCAL_PATH = new File(Utility.WORKING_DATA_DIRECTORY + File.separator + "cortexlogs");
    private static final String LOG_DEBUG_FILE_NAME = "proline_cortex_debug";
    private static final String LOG_TODAY_DEBUG_FILE_NAME = "proline_cortex_debug.txt";
    private static final String LOG_FILE_NAME = "proline_cortex_log";
    private static final String LOG_FILE_SUFFIX = ".txt";
    private JComboBox m_dateChooser;
    private JTextField m_fileNameTxtField;
    private JCheckBox m_debugFileCheckBox;
    private JRadioButton m_singleFileButton;
    private JRadioButton m_batchFileButton;
    private int m_dateAdjust = 0;
    boolean m_isTodayDebug = false;
    ArrayList<File> m_fileList;
    File m_localPath;

    public ServerLogFileNameDialog() {
        super((Window)WindowManager.getDefault().getMainWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        JPanel m_internalPanel = this.initInternalPanel();
        this.m_fileList = new ArrayList();
        ServerConnectionManager serverConnectionManager = ServerConnectionManager.getServerConnectionManager();
        String host = serverConnectionManager.getServerURL();
        Utility.init();
        if (!LOG_LOCAL_PATH.isDirectory()) {
            LOG_LOCAL_PATH.mkdir();
        }
        this.m_localPath = new File(LOG_LOCAL_PATH + File.separator + host);
        if (!this.m_localPath.isDirectory()) {
            this.m_localPath.mkdir();
        }
        String dialog_title = "Server Parsed Tasks";
        super.setTitle(dialog_title);
        String help_text = "<html>Specify which server tasks log to view : <br> select the date and  log mode (debug or info)</html>";
        super.setHelpHeaderText(help_text);
        super.setInternalComponent((Component)m_internalPanel);
        super.setButtonVisible(5, false);
        super.setStatusVisible(false);
        super.setResizable(true);
    }

    private JDialog createLogParserDialog(ArrayList<File> fileList) {
        JDialog logViewDialog = new JDialog((Window)WindowManager.getDefault().getMainWindow(), "Server Parsed Tasks", Dialog.ModalityType.APPLICATION_MODAL);
        logViewDialog.getContentPane().setLayout(new BorderLayout());
        JTextPane taskFlowTextPane = new JTextPane();
        JInternalFrame taskFlowFrame = new JInternalFrame("Log Task Flow", true, true);
        taskFlowFrame.setSize(700, 650);
        taskFlowFrame.setVisible(false);
        logViewDialog.getLayeredPane().add((Component)taskFlowFrame, JLayeredPane.PALETTE_LAYER);
        ColorPalette colorPalette = new ColorPalette();
        colorPalette.setLocation(800, 2);
        colorPalette.setVisible(true);
        logViewDialog.getLayeredPane().add((Component)colorPalette, JLayeredPane.PALETTE_LAYER + 1);
        JProgressBar progressBar = new JProgressBar(0, 100);
        progressBar.setValue(0);
        progressBar.setStringPainted(true);
        progressBar.setSize(400, 50);
        progressBar.setVisible(false);
        progressBar.setLocation(200, 200);
        logViewDialog.getLayeredPane().add((Component)progressBar, JLayeredPane.PALETTE_LAYER + 2);
        ServerLogControlPanel logPanel = new ServerLogControlPanel(fileList, taskFlowFrame, progressBar);
        logViewDialog.getContentPane().add((Component)((Object)logPanel), "Center");
        logViewDialog.pack();
        logViewDialog.setDefaultCloseOperation(2);
        logViewDialog.setVisible(true);
        return logViewDialog;
    }

    private JPanel initInternalPanel() {
        this.m_fileNameTxtField = new JTextField(LOG_TODAY_DEBUG_FILE_NAME);
        int maxDuration = 7;
        String[] dateChoice = new String[maxDuration];
        for (int i = 0; i < maxDuration; ++i) {
            dateChoice[i] = this.getDateInFileName(i);
        }
        this.m_dateChooser = new JComboBox<String>(dateChoice);
        this.m_dateChooser.addActionListener(this.createDateChoiceActionListener());
        this.m_debugFileCheckBox = new JCheckBox("Debug mode");
        this.m_debugFileCheckBox.setSelected(true);
        this.m_debugFileCheckBox.addItemListener(this.createIsDebugFileItemListener());
        this.m_singleFileButton = new JRadioButton("Single File");
        this.m_batchFileButton = new JRadioButton("Batch File");
        ButtonGroup debugFileGroup = new ButtonGroup();
        debugFileGroup.add(this.m_singleFileButton);
        debugFileGroup.add(this.m_batchFileButton);
        this.m_batchFileButton.setSelected(true);
        JPanel pane = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        pane.add((Component)new JLabel("File:"), c);
        ++c.gridx;
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 2;
        pane.add((Component)this.m_fileNameTxtField, c);
        ++c.gridy;
        c.gridx = 0;
        pane.add((Component)new JPanel(), c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        pane.add((Component)new JLabel("Log date:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        pane.add((Component)this.m_dateChooser, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        c.insets = new Insets(0, 0, 0, 0);
        pane.add((Component)this.m_debugFileCheckBox, c);
        c.gridx = 1;
        ++c.gridy;
        c.gridwidth = 1;
        pane.add((Component)this.m_singleFileButton, c);
        ++c.gridx;
        pane.add((Component)this.m_batchFileButton, c);
        Dimension d = pane.getPreferredSize();
        pane.setBorder(new EmptyBorder(8, 16, 8, 16));
        pane.setBounds(0, 0, (int)d.getWidth(), (int)d.getHeight());
        return pane;
    }

    private ActionListener createDateChoiceActionListener() {
        ActionListener listener = e -> {
            this.m_dateAdjust = this.m_dateChooser.getSelectedIndex();
            this.setFileNameTxtField();
        };
        return listener;
    }

    private ItemListener createIsDebugFileItemListener() {
        ItemListener listener = e -> this.setFileNameTxtField();
        return listener;
    }

    private void setFileNameTxtField() {
        String fileName;
        if (this.m_debugFileCheckBox.isSelected()) {
            fileName = this.getDebugLogFileName(this.m_dateAdjust, 0);
            this.m_singleFileButton.setVisible(true);
            this.m_batchFileButton.setVisible(true);
        } else {
            fileName = this.getLogFileName(this.m_dateAdjust);
            this.m_singleFileButton.setVisible(false);
            this.m_batchFileButton.setVisible(false);
        }
        this.m_fileNameTxtField.setText(fileName);
    }

    protected boolean okCalled() {
        this.m_fileList = new ArrayList();
        this.m_isTodayDebug = false;
        String filetxt = this.m_fileNameTxtField.getText();
        String fileName = new File(filetxt).getName();
        LogFileName debugFileP = this.getPrefix(fileName);
        boolean isDebugFile = debugFileP != null;
        boolean isBatchFile = false;
        if (isDebugFile) {
            isBatchFile = this.m_batchFileButton.isSelected();
            if (fileName.equals(LOG_TODAY_DEBUG_FILE_NAME)) {
                this.m_isTodayDebug = true;
            }
            this.loadLocalFile(debugFileP.name, isDebugFile, debugFileP.index, isBatchFile);
        } else {
            this.loadLocalFile(fileName, isDebugFile, -1, isBatchFile);
        }
        return true;
    }

    private void loadLocalFile(String fileName, boolean isDebugFile, int index, boolean isBatchFile) {
        block8: {
            String localFilePath = this.m_localPath + File.separator + fileName;
            if (isDebugFile) {
                localFilePath = this.m_localPath + File.separator + fileName + "." + index + LOG_FILE_SUFFIX;
            }
            m_logger.debug("loadLocalFile path ={}", (Object)localFilePath);
            File localFile = new File(localFilePath);
            if (localFile.isFile()) {
                try {
                    BasicFileAttributes attr = Files.readAttributes(localFile.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    Long createTime = attr.creationTime().toMillis();
                    LocalDate fileCreateDate = Instant.ofEpochMilli(createTime).atZone(ZoneId.systemDefault()).toLocalDate();
                    LocalDate logNextDate = this.getDateInFileName(fileName).plusDays(1L);
                    if (fileCreateDate.isAfter(logNextDate)) {
                        m_logger.debug("local File later retrived ok ={}", (Object)localFile.getName());
                        this.m_fileList.add(localFile);
                        if (isDebugFile && isBatchFile) {
                            this.addLocalFile(fileName, ++index);
                        }
                        this.createLogParserDialog(this.m_fileList);
                        return;
                    }
                    if (isBatchFile) {
                        int debugIndex = this.addLocalFile(fileName, index);
                        m_logger.debug("####less than 1 day, debug not today, index to retrieve {}", (Object)debugIndex);
                        this.retriveFile(fileName, isDebugFile, debugIndex, true);
                        break block8;
                    }
                    m_logger.debug("####less than 1 day, index to retrieve {}", (Object)index);
                    this.retriveFile(fileName, isDebugFile, index, false);
                }
                catch (Exception anyE) {
                    m_logger.debug("Exception when loadLocalFile(){}  ", (Object)anyE.getMessage());
                    this.retriveFile(fileName, isDebugFile, index, isBatchFile);
                }
            } else {
                this.retriveFile(fileName, isDebugFile, index, isBatchFile);
            }
        }
    }

    private int addLocalFile(String fileName, int index) {
        while (true) {
            String localFilePath = this.m_localPath + File.separator + fileName + "." + index + LOG_FILE_SUFFIX;
            m_logger.debug("loadLocalFile path ={}", (Object)localFilePath);
            File localFile = new File(localFilePath);
            if (!localFile.isFile()) break;
            m_logger.debug("local File later retrived ok ={}", (Object)localFile.getName());
            this.m_fileList.add(localFile);
            ++index;
        }
        return index;
    }

    private void retriveFile(final String fileName, final boolean isIndexUseful, final int index, final boolean isBatchFile) {
        m_logger.debug("retrive file: {}, isDebugFile={}, index ={}", new Object[]{fileName, isIndexUseful, index});
        if (this.m_isTodayDebug && !isBatchFile && index == 0) {
            this.retriveFile(LOG_TODAY_DEBUG_FILE_NAME, false, -1, false);
            return;
        }
        String remoteFilePath = LOG_REMOTE_PATH + fileName;
        String localFilePath = this.m_localPath + File.separator + fileName;
        if (isIndexUseful) {
            remoteFilePath = LOG_REMOTE_PATH + fileName + "." + index + LOG_FILE_SUFFIX;
            localFilePath = this.m_localPath + File.separator + fileName + "." + index + LOG_FILE_SUFFIX;
        }
        final File localFile = new File(localFilePath);
        AbstractJMSCallback callback = new AbstractJMSCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success) {
                String notExistMsg = "The file does not exist, perhaps there are no log for the selected day.";
                if (!isIndexUseful) {
                    if (success) {
                        m_logger.debug("Retrieving file \"" + localFile.getName() + "\" from server succes.");
                        ServerLogFileNameDialog.this.m_fileList.add(localFile);
                        ServerLogFileNameDialog.this.createLogParserDialog(ServerLogFileNameDialog.this.m_fileList);
                    } else {
                        JOptionPane.showMessageDialog(ServerLogFileNameDialog.this.rootPane, "Retrieving  File \"" + localFile.getName() + "\"has failed.\n" + notExistMsg);
                    }
                } else if (success) {
                    m_logger.debug("Retrieving file \"" + localFile.getName() + "\" from server succes.");
                    ServerLogFileNameDialog.this.m_fileList.add(localFile);
                    if (isBatchFile) {
                        int next = index + 1;
                        ServerLogFileNameDialog.this.retriveFile(fileName, isIndexUseful, next, isBatchFile);
                    } else {
                        ServerLogFileNameDialog.this.createLogParserDialog(ServerLogFileNameDialog.this.m_fileList);
                    }
                } else if (!isBatchFile) {
                    JOptionPane.showMessageDialog(ServerLogFileNameDialog.this.rootPane, "Retrive File \"" + localFile.getName() + "\" failed.\n" + notExistMsg);
                } else if (index == 0 && !ServerLogFileNameDialog.this.m_isTodayDebug) {
                    JOptionPane.showMessageDialog(ServerLogFileNameDialog.this.rootPane, "Retrive File \"" + localFile.getName() + "\" failed.\n" + notExistMsg);
                } else if (ServerLogFileNameDialog.this.m_isTodayDebug) {
                    ServerLogFileNameDialog.this.retriveFile(ServerLogFileNameDialog.LOG_TODAY_DEBUG_FILE_NAME, !isIndexUseful, index, !isBatchFile);
                } else {
                    m_logger.debug("retrive multi file end");
                    ServerLogFileNameDialog.this.createLogParserDialog(ServerLogFileNameDialog.this.m_fileList);
                }
            }
        };
        DownloadFileTask task = null;
        task = new DownloadFileTask(callback, remoteFilePath, localFile, false);
        AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
    }

    private String getLogFileName(int ajuste) {
        return "proline_cortex_log." + this.getDateInFileName(ajuste) + LOG_FILE_SUFFIX;
    }

    private String getDebugLogFileName(int dateAjuste, int cutIndex) {
        if (dateAjuste <= 0) {
            return LOG_TODAY_DEBUG_FILE_NAME;
        }
        return "proline_cortex_debug_." + this.getDateInFileName(dateAjuste) + "." + cutIndex + LOG_FILE_SUFFIX;
    }

    private LogFileName getPrefix(String text) {
        LogFileName result = new LogFileName();
        if (text.contains(LOG_DEBUG_FILE_NAME)) {
            if (text.contains(LOG_TODAY_DEBUG_FILE_NAME)) {
                result.name = "proline_cortex_debug_." + this.getDateInFileName(0);
                result.index = 0;
            } else {
                String regex = "(proline_cortex_debug_.\\d\\d\\d\\d-\\d\\d-\\d\\d).(\\d+).txt";
                Pattern pattern = Pattern.compile("(proline_cortex_debug_.\\d\\d\\d\\d-\\d\\d-\\d\\d).(\\d+).txt", 8);
                Matcher matcher = pattern.matcher(text);
                if (matcher.find()) {
                    result.name = matcher.group(1);
                    result.index = Integer.parseInt(matcher.group(2));
                } else {
                    result = null;
                }
            }
            return result;
        }
        return null;
    }

    private String getDateInFileName(int ajuste) {
        Calendar cal = Calendar.getInstance();
        if (ajuste > 0) {
            cal.add(5, ajuste * -1);
        }
        return String.format("%tY-%tm-%td", cal, cal, cal);
    }

    private LocalDate getDateInFileName(String fileName) {
        String regex = "(2\\d\\d\\d)-([0-1]\\d)-([0-3]\\d)";
        Pattern pattern = Pattern.compile("(2\\d\\d\\d)-([0-1]\\d)-([0-3]\\d)", 8);
        Matcher matcher = pattern.matcher(fileName);
        if (matcher.find()) {
            LocalDate date = LocalDate.parse(matcher.group(0), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            return date;
        }
        return null;
    }

    class LogFileName {
        String name = "proline_cortex_debug";
        int index = -1;
    }
}

