/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.tasklog;

import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.utils.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;

public class TaskDescriptionPanel
extends HourglassPanel
implements DataBoxPanelInterface {
    private AbstractDataBox m_dataBox;
    private JTextField m_taskTextfield;
    private JTextField m_askTimeTextfield;
    private JTextField m_startTimeTextfield;
    private JTextField m_deltaStartTimeTextfield;
    private JTextField m_endTimeTextfield;
    private JTextField m_deltaEndTimeTextfield;
    private JTextArea m_errorTextArea;
    private JButton m_requestButton;
    private String m_content;
    private String m_requestURL;
    private static final SimpleDateFormat m_timestampFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final DecimalFormat m_decimalFormat = new DecimalFormat("####0.00");

    public TaskDescriptionPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel taskLabel = new JLabel("Task:");
        this.m_taskTextfield = new JTextField();
        this.m_taskTextfield.setEditable(false);
        this.m_taskTextfield.setBackground(Color.white);
        JPanel timePanel = this.createTimePanel();
        JPanel errorPanel = this.createErrorPanel();
        this.m_requestButton = new JButton("...");
        this.m_requestButton.setMargin(new Insets(0, 5, 0, 5));
        this.m_requestButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RequestContentDialog dialog = RequestContentDialog.getSingleton(TaskDescriptionPanel.this.m_content, TaskDescriptionPanel.this.m_requestURL);
                dialog.setVisible(true);
            }
        });
        this.m_requestButton.setEnabled(false);
        c.gridx = 0;
        c.gridy = 0;
        this.add(taskLabel, c);
        c.weightx = 1.0;
        ++c.gridx;
        this.add(this.m_taskTextfield, c);
        c.weightx = 0.0;
        ++c.gridx;
        this.add(this.m_requestButton, c);
        c.weightx = 1.0;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        this.add(timePanel, c);
        ++c.gridy;
        c.weighty = 1.0;
        this.add(errorPanel, c);
    }

    public JPanel createTimePanel() {
        JPanel timePanel = new JPanel(new GridBagLayout());
        timePanel.setBorder(BorderFactory.createTitledBorder(" Timestamp "));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel askTimeLabel = new JLabel("Ask Time:");
        this.m_askTimeTextfield = new JTextField();
        this.m_askTimeTextfield.setEditable(false);
        this.m_askTimeTextfield.setBackground(Color.white);
        JLabel startTimeLabel = new JLabel("Start Time:");
        this.m_startTimeTextfield = new JTextField();
        this.m_startTimeTextfield.setEditable(false);
        this.m_startTimeTextfield.setBackground(Color.white);
        JLabel startDelayLabel = new JLabel("Start Delay:");
        this.m_deltaStartTimeTextfield = new JTextField();
        this.m_deltaStartTimeTextfield.setEditable(false);
        this.m_deltaStartTimeTextfield.setBackground(Color.white);
        JLabel durationLabel = new JLabel("Duration:");
        JLabel endTimeLabel = new JLabel("End Time:");
        this.m_endTimeTextfield = new JTextField();
        this.m_endTimeTextfield.setEditable(false);
        this.m_endTimeTextfield.setBackground(Color.white);
        this.m_deltaEndTimeTextfield = new JTextField();
        this.m_deltaEndTimeTextfield.setEditable(false);
        this.m_deltaEndTimeTextfield.setBackground(Color.white);
        c.gridx = 0;
        c.gridy = 0;
        timePanel.add((Component)askTimeLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        timePanel.add((Component)this.m_askTimeTextfield, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        timePanel.add((Component)startTimeLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        timePanel.add((Component)this.m_startTimeTextfield, c);
        ++c.gridx;
        c.weightx = 0.0;
        timePanel.add((Component)startDelayLabel, c);
        ++c.gridx;
        c.weightx = 0.3;
        timePanel.add((Component)this.m_deltaStartTimeTextfield, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        timePanel.add((Component)endTimeLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        timePanel.add((Component)this.m_endTimeTextfield, c);
        ++c.gridx;
        c.weightx = 0.0;
        timePanel.add((Component)durationLabel, c);
        ++c.gridx;
        c.weightx = 0.3;
        timePanel.add((Component)this.m_deltaEndTimeTextfield, c);
        return timePanel;
    }

    public JPanel createErrorPanel() {
        JPanel errorPanel = new JPanel(new GridBagLayout());
        errorPanel.setBorder(BorderFactory.createTitledBorder(" Error Message "));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_errorTextArea = new JTextArea();
        this.m_errorTextArea.setEditable(false);
        JScrollPane scrollpane = new JScrollPane(this.m_errorTextArea);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        errorPanel.add((Component)scrollpane, c);
        return errorPanel;
    }

    public void setTaskInfo(TaskInfo taskInfo) {
        if (taskInfo == null) {
            this.reinit();
            return;
        }
        this.m_taskTextfield.setText(taskInfo.getTaskDescription());
        TaskError taskError = taskInfo.getTaskError();
        String errorString = taskError != null ? taskError.toString() : (taskInfo.isAborted() ? "Task stopped by the User." : "");
        this.m_errorTextArea.setText(errorString);
        this.m_askTimeTextfield.setText(this.formatTime(taskInfo.getAskTimestamp()));
        this.m_startTimeTextfield.setText(this.formatTime(taskInfo.getStartTimestamp()));
        this.m_deltaStartTimeTextfield.setText(this.formatDeltaTime(taskInfo.getDelay()));
        this.m_endTimeTextfield.setText(this.formatTime(taskInfo.getEndTimestamp()));
        this.m_deltaEndTimeTextfield.setText(this.formatDeltaTime(taskInfo.getDuration()));
        this.m_content = taskInfo.getRequestContent();
        this.m_requestURL = taskInfo.getRequestURL();
        this.m_requestButton.setEnabled(this.m_requestURL != null && !this.m_requestURL.isEmpty());
        this.repaint();
    }

    private void reinit() {
        this.m_taskTextfield.setText("");
        this.m_errorTextArea.setText("");
        this.m_askTimeTextfield.setText("");
        this.m_startTimeTextfield.setText("");
        this.m_deltaStartTimeTextfield.setText("");
        this.m_endTimeTextfield.setText("");
        this.m_deltaEndTimeTextfield.setText("");
        this.m_requestURL = null;
        this.m_requestButton.setEnabled(false);
    }

    private String formatTime(long timestamp) {
        if (timestamp == -1L) {
            return "N/A";
        }
        return m_timestampFormat.format(new Date(timestamp));
    }

    private String formatDeltaTime(long delta) {
        if (delta == -1L) {
            return "";
        }
        double deltaSeconds = (double)delta / 1000.0;
        return "+" + m_decimalFormat.format(deltaSeconds) + "s";
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    private static class RequestContentDialog
    extends DefaultDialog {
        private JTextArea _requestDialogContentTextarea;
        private JSplitPane _requestDialogContentPane;
        private JTree _requestContentTree;
        private String _requestContent = "";
        private boolean m_firstDisplay = true;
        private static RequestContentDialog m_singleton = null;

        private RequestContentDialog() {
            super((Window)WindowManager.getDefault().getMainWindow());
            this.setTitle("Request details");
            this.setButtonVisible(1, false);
            this.setButtonVisible(5, false);
        }

        public static RequestContentDialog getSingleton(String content, String requestURL) {
            if (m_singleton == null) {
                m_singleton = new RequestContentDialog();
            }
            m_singleton.setContent(content, requestURL);
            return m_singleton;
        }

        public void setVisible(boolean v) {
            if (this.m_firstDisplay) {
                m_singleton.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
                this.m_firstDisplay = false;
            }
            super.setVisible(v);
        }

        private void setContent(String content, String requestURL) {
            this._requestContent = content;
            this._requestContentTree = StringUtils.createExpandedTreeFromJson((String)content, (String)"content");
            JPanel requestPanel = new JPanel(new GridBagLayout());
            requestPanel.setPreferredSize(new Dimension(600, 400));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(5, 5, 5, 5);
            JTextField requestURLTextfield = new JTextField();
            requestURLTextfield.setText(requestURL);
            this._requestDialogContentTextarea = new JTextArea();
            this._requestDialogContentTextarea.setText(this._requestContent);
            this._requestDialogContentTextarea.setCaretPosition(0);
            this._requestDialogContentTextarea.setEditable(false);
            this._requestDialogContentTextarea.setLineWrap(true);
            c.gridx = 0;
            c.gridy = 0;
            requestPanel.add((Component)new JLabel("URL:"), c);
            ++c.gridx;
            c.weightx = 1.0;
            requestPanel.add((Component)requestURLTextfield, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            requestPanel.add((Component)new JLabel("Content:"), c);
            ++c.gridx;
            c.weightx = 1.0;
            c.weighty = 1.0;
            JScrollPane top = new JScrollPane(this._requestDialogContentTextarea);
            JScrollPane bottom = new JScrollPane(this._requestContentTree);
            this._requestDialogContentPane = new JSplitPane(0, top, bottom);
            this._requestDialogContentPane.setDividerLocation(60);
            requestPanel.add((Component)this._requestDialogContentPane, c);
            this.replaceInternalComponent(requestPanel);
            this.pack();
        }
    }
}

